import type { QRCodeErrorCorrectionLevel, QRCodeSegment, QRCodeToDataURLOptions } from 'qrcode';
import type { PropType } from 'vue-demi';
export declare const LEVELS: readonly ["low", "medium", "quartile", "high", "L", "M", "Q", "H"];
export declare const MASK_PATTERNS: readonly [0, 1, 2, 3, 4, 5, 6, 7];
export declare type MaskPattern = typeof MASK_PATTERNS[number];
export declare const MODES: readonly ["alphanumeric", "numeric", "kanji", "byte"];
export { QRCodeSegment };
export declare type QRCodeValue = QRCodeSegment[] | string;
export declare const TYPES: readonly ["image/png", "image/jpeg", "image/webp"];
export declare type QRCodeProps = Omit<QRCodeToDataURLOptions, 'renderOptions'> & QRCodeToDataURLOptions['rendererOpts'] & {
    value: QRCodeSegment[] | string;
};
declare const _default: import("vue-demi").DefineComponent<{
    version: {
        type: NumberConstructor;
        validator: (version: number) => boolean;
    };
    errorCorrectionLevel: {
        type: PropType<QRCodeErrorCorrectionLevel>;
        validator: (level: QRCodeErrorCorrectionLevel) => boolean;
    };
    maskPattern: {
        type: NumberConstructor;
        validator: (maskPattern: MaskPattern) => boolean;
    };
    toSJISFunc: PropType<((codePoint: string) => number) | undefined>;
    margin: NumberConstructor;
    scale: NumberConstructor;
    width: NumberConstructor;
    color: {
        type: ObjectConstructor;
        validator: (color: QRCodeProps['color']) => boolean;
        required: true;
    };
    type: {
        type: PropType<"image/png" | "image/jpeg" | "image/webp" | undefined>;
        validator: (type: QRCodeProps['type']) => boolean;
        required: true;
    };
    quality: {
        type: NumberConstructor;
        validator: (quality: number) => boolean;
        required: true;
    };
    value: {
        type: PropType<string | QRCodeSegment[]>;
        required: true;
        validator(value: QRCodeSegment[] | string): boolean;
    };
}, () => import("vue-demi").VNode<import("vue-demi").RendererNode, import("vue-demi").RendererElement, {
    [key: string]: any;
}>, unknown, {}, {}, import("vue-demi").ComponentOptionsMixin, import("vue-demi").ComponentOptionsMixin, Record<string, any>, string, import("vue-demi").VNodeProps & import("vue-demi").AllowedComponentProps & import("vue-demi").ComponentCustomProps, Readonly<import("vue-demi").ExtractPropTypes<{
    version: {
        type: NumberConstructor;
        validator: (version: number) => boolean;
    };
    errorCorrectionLevel: {
        type: PropType<QRCodeErrorCorrectionLevel>;
        validator: (level: QRCodeErrorCorrectionLevel) => boolean;
    };
    maskPattern: {
        type: NumberConstructor;
        validator: (maskPattern: MaskPattern) => boolean;
    };
    toSJISFunc: PropType<((codePoint: string) => number) | undefined>;
    margin: NumberConstructor;
    scale: NumberConstructor;
    width: NumberConstructor;
    color: {
        type: ObjectConstructor;
        validator: (color: QRCodeProps['color']) => boolean;
        required: true;
    };
    type: {
        type: PropType<"image/png" | "image/jpeg" | "image/webp" | undefined>;
        validator: (type: QRCodeProps['type']) => boolean;
        required: true;
    };
    quality: {
        type: NumberConstructor;
        validator: (quality: number) => boolean;
        required: true;
    };
    value: {
        type: PropType<string | QRCodeSegment[]>;
        required: true;
        validator(value: QRCodeSegment[] | string): boolean;
    };
}>>, {}>;
export default _default;
