'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var QRCode = require('qrcode');
var vue = require('vue');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var QRCode__default = /*#__PURE__*/_interopDefaultLegacy(QRCode);

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const LEVELS = [
  "low",
  "medium",
  "quartile",
  "high",
  "L",
  "M",
  "Q",
  "H"
];
const MASK_PATTERNS = [0, 1, 2, 3, 4, 5, 6, 7];
const MODES = ["alphanumeric", "numeric", "kanji", "byte"];
const TYPES = ["image/png", "image/jpeg", "image/webp"];
const MAX_QR_VERSION = 40;
var index = vue.defineComponent({
  props: {
    version: {
      type: Number,
      validator: (version) => version === Number.parseInt(String(version), 10) && version >= 1 && version <= MAX_QR_VERSION
    },
    errorCorrectionLevel: {
      type: String,
      validator: (level) => LEVELS.includes(level)
    },
    maskPattern: {
      type: Number,
      validator: (maskPattern) => MASK_PATTERNS.includes(maskPattern)
    },
    toSJISFunc: Function,
    margin: Number,
    scale: Number,
    width: Number,
    color: {
      type: Object,
      validator: (color) => ["dark", "light"].every((c) => ["string", "undefined"].includes(typeof color[c])),
      required: true
    },
    type: {
      type: String,
      validator: (type) => TYPES.includes(type),
      required: true
    },
    quality: {
      type: Number,
      validator: (quality) => quality === Number.parseFloat(String(quality)) && quality >= 0 && quality <= 1,
      required: true
    },
    value: {
      type: [String, Array],
      required: true,
      validator(value) {
        if (typeof value === "string") {
          return true;
        }
        return value.every(({ data, mode }) => typeof data === "string" && MODES.includes(mode));
      }
    }
  },
  setup(props, { attrs, emit }) {
    const dataUrlRef = vue.ref();
    const toDataURL = () => {
      const _a = props || {}, { quality, value } = _a, rest = __objRest(_a, ["quality", "value"]);
      QRCode__default["default"].toDataURL(value, Object.assign(rest, quality == null || {
        renderOptions: {
          quality
        }
      })).then((dataUrl) => {
        dataUrlRef.value = dataUrl;
      }).catch((err) => emit("error", err));
    };
    vue.watch(props, toDataURL, { immediate: true });
    return () => vue.h("img", __spreadProps(__spreadValues({}, attrs), {
      src: dataUrlRef.value
    }));
  }
});

exports.LEVELS = LEVELS;
exports.MASK_PATTERNS = MASK_PATTERNS;
exports.MODES = MODES;
exports.TYPES = TYPES;
exports["default"] = index;
