import './styles.css';
export interface EditorProps {
    lineNumbers: boolean;
    autoStyleLineNumbers: boolean;
    readonly: boolean;
    value: string;
    highlight: () => string;
    tabSize: number;
    insertSpaces: boolean;
    ignoreTabKey: boolean;
    placeholder: string;
}
export interface Record {
    value: string;
    selectionStart: number;
    selectionEnd: number;
}
export interface History {
    stack: Array<Record & {
        timestamp: number;
    }>;
    offset: number;
}
export declare const PrismEditor: import("vue").DefineComponent<{
    lineNumbers: {
        type: BooleanConstructor;
        default: boolean;
    };
    autoStyleLineNumbers: {
        type: BooleanConstructor;
        default: boolean;
    };
    readonly: {
        type: BooleanConstructor;
        default: boolean;
    };
    modelValue: {
        type: StringConstructor;
        default: string;
    };
    highlight: {
        type: FunctionConstructor;
        required: true;
    };
    tabSize: {
        type: NumberConstructor;
        default: number;
    };
    insertSpaces: {
        type: BooleanConstructor;
        default: boolean;
    };
    ignoreTabKey: {
        type: BooleanConstructor;
        default: boolean;
    };
    placeholder: {
        type: StringConstructor;
        default: string;
    };
}, unknown, {
    capture: boolean;
    history: History;
    lineNumbersHeight: string;
    codeData: string;
}, {
    isEmpty(): boolean;
    content(): string;
    lineNumbersCount(): number;
}, {
    setLineNumbersHeight(): void;
    styleLineNumbers(): void;
    _recordCurrentState(): void;
    _getLines(text: string, position: number): Array<string>;
    _applyEdits(record: Record): void;
    _recordChange(record: Record, overwrite?: boolean): void;
    _updateInput(record: Record): void;
    handleChange(e: KeyboardEvent): void;
    _undoEdit(): void;
    _redoEdit(): void;
    handleKeyDown(e: KeyboardEvent): void;
}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, globalThis.Record<string, any>, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<{
    lineNumbers: boolean;
    autoStyleLineNumbers: boolean;
    readonly: boolean;
    modelValue: string;
    highlight: Function;
    tabSize: number;
    insertSpaces: boolean;
    ignoreTabKey: boolean;
    placeholder: string;
} & {}>, {
    lineNumbers: boolean;
    autoStyleLineNumbers: boolean;
    readonly: boolean;
    modelValue: string;
    tabSize: number;
    insertSpaces: boolean;
    ignoreTabKey: boolean;
    placeholder: string;
}>;
