"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _bl = _interopRequireDefault(require("bl"));
var _stream = require("stream");
var _packet = require("./packet");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
class OutgoingMessageStream extends _stream.Duplex {
  constructor(debug, {
    packetSize
  }) {
    super({
      writableObjectMode: true
    });
    this.packetSize = packetSize;
    this.debug = debug;
    this.bl = new _bl.default();

    // When the writable side is ended, push `null`
    // to also end the readable side.
    this.on('finish', () => {
      this.push(null);
    });
  }
  _write(message, _encoding, callback) {
    const length = this.packetSize - _packet.HEADER_LENGTH;
    let packetNumber = 0;
    this.currentMessage = message;
    this.currentMessage.on('data', data => {
      if (message.ignore) {
        return;
      }
      this.bl.append(data);
      while (this.bl.length > length) {
        const data = this.bl.slice(0, length);
        this.bl.consume(length);

        // TODO: Get rid of creating `Packet` instances here.
        const packet = new _packet.Packet(message.type);
        packet.packetId(packetNumber += 1);
        packet.resetConnection(message.resetConnection);
        packet.addData(data);
        this.debug.packet('Sent', packet);
        this.debug.data(packet);
        if (this.push(packet.buffer) === false) {
          message.pause();
        }
      }
    });
    this.currentMessage.on('end', () => {
      const data = this.bl.slice();
      this.bl.consume(data.length);

      // TODO: Get rid of creating `Packet` instances here.
      const packet = new _packet.Packet(message.type);
      packet.packetId(packetNumber += 1);
      packet.resetConnection(message.resetConnection);
      packet.last(true);
      packet.ignore(message.ignore);
      packet.addData(data);
      this.debug.packet('Sent', packet);
      this.debug.data(packet);
      this.push(packet.buffer);
      this.currentMessage = undefined;
      callback();
    });
  }
  _read(_size) {
    // If we do have a message, resume it and get data flowing.
    // Otherwise, there is nothing to do.
    if (this.currentMessage) {
      this.currentMessage.resume();
    }
  }
}
var _default = exports.default = OutgoingMessageStream;
module.exports = OutgoingMessageStream;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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