"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _decimaln = _interopRequireDefault(require("./decimaln"));
var _writableTrackingBuffer = _interopRequireDefault(require("../tracking-buffer/writable-tracking-buffer"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NULL_LENGTH = Buffer.from([0x00]);
const Decimal = {
  id: 0x37,
  type: 'DECIMAL',
  name: 'Decimal',
  declaration: function (parameter) {
    return 'decimal(' + this.resolvePrecision(parameter) + ', ' + this.resolveScale(parameter) + ')';
  },
  resolvePrecision: function (parameter) {
    if (parameter.precision != null) {
      return parameter.precision;
    } else if (parameter.value === null) {
      return 1;
    } else {
      return 18;
    }
  },
  resolveScale: function (parameter) {
    if (parameter.scale != null) {
      return parameter.scale;
    } else {
      return 0;
    }
  },
  generateTypeInfo(parameter, _options) {
    let precision;
    if (parameter.precision <= 9) {
      precision = 0x05;
    } else if (parameter.precision <= 19) {
      precision = 0x09;
    } else if (parameter.precision <= 28) {
      precision = 0x0D;
    } else {
      precision = 0x11;
    }
    return Buffer.from([_decimaln.default.id, precision, parameter.precision, parameter.scale]);
  },
  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }
    const precision = parameter.precision;
    if (precision <= 9) {
      return Buffer.from([0x05]);
    } else if (precision <= 19) {
      return Buffer.from([0x09]);
    } else if (precision <= 28) {
      return Buffer.from([0x0D]);
    } else {
      return Buffer.from([0x11]);
    }
  },
  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }
    const sign = parameter.value < 0 ? 0 : 1;
    const value = Math.round(Math.abs(parameter.value * Math.pow(10, parameter.scale)));
    const precision = parameter.precision;
    if (precision <= 9) {
      const buffer = Buffer.alloc(5);
      buffer.writeUInt8(sign, 0);
      buffer.writeUInt32LE(value, 1);
      yield buffer;
    } else if (precision <= 19) {
      const buffer = new _writableTrackingBuffer.default(9);
      buffer.writeUInt8(sign);
      buffer.writeUInt64LE(value);
      yield buffer.data;
    } else if (precision <= 28) {
      const buffer = new _writableTrackingBuffer.default(13);
      buffer.writeUInt8(sign);
      buffer.writeUInt64LE(value);
      buffer.writeUInt32LE(0x00000000);
      yield buffer.data;
    } else {
      const buffer = new _writableTrackingBuffer.default(17);
      buffer.writeUInt8(sign);
      buffer.writeUInt64LE(value);
      buffer.writeUInt32LE(0x00000000);
      buffer.writeUInt32LE(0x00000000);
      yield buffer.data;
    }
  },
  validate: function (value) {
    if (value == null) {
      return null;
    }
    value = parseFloat(value);
    if (isNaN(value)) {
      throw new TypeError('Invalid number.');
    }
    return value;
  }
};
var _default = exports.default = Decimal;
module.exports = Decimal;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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