"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.keySize = exports.generateKeySalt = exports.deriveKey = exports.AeadAes256CbcHmac256EncryptionKey = void 0;
var _crypto = require("crypto");
var _symmetricKey = _interopRequireDefault(require("./symmetric-key"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// This code is based on the `mssql-jdbc` library published under the conditions of MIT license.
// Copyright (c) 2019 Microsoft Corporation

const keySize = exports.keySize = 256;
const keySizeInBytes = keySize / 8;
const deriveKey = (rootKey, salt) => {
  const hmac = (0, _crypto.createHmac)('sha256', rootKey);
  hmac.update(Buffer.from(salt, 'utf16le'));
  return hmac.digest();
};
exports.deriveKey = deriveKey;
const generateKeySalt = (keyType, algorithmName, keySize) => `Microsoft SQL Server cell ${keyType} key ` + `with encryption algorithm:${algorithmName} and key length:${keySize}`;
exports.generateKeySalt = generateKeySalt;
class AeadAes256CbcHmac256EncryptionKey extends _symmetricKey.default {
  constructor(rootKey, algorithmName) {
    super(rootKey);
    this.algorithmName = algorithmName;
    this.encryptionKeySaltFormat = generateKeySalt('encryption', this.algorithmName, keySize);
    this.macKeySaltFormat = generateKeySalt('MAC', this.algorithmName, keySize);
    this.ivKeySaltFormat = generateKeySalt('IV', this.algorithmName, keySize);
    if (rootKey.length !== keySizeInBytes) {
      throw new Error(`The column encryption key has been successfully decrypted but it's length: ${rootKey.length} does not match the length: ${keySizeInBytes} for algorithm "${this.algorithmName}". Verify the encrypted value of the column encryption key in the database.`);
    }
    try {
      const encKeyBuff = deriveKey(rootKey, this.encryptionKeySaltFormat);
      this.encryptionKey = new _symmetricKey.default(encKeyBuff);
      const macKeyBuff = deriveKey(rootKey, this.macKeySaltFormat);
      this.macKey = new _symmetricKey.default(macKeyBuff);
      const ivKeyBuff = deriveKey(rootKey, this.ivKeySaltFormat);
      this.ivKey = new _symmetricKey.default(ivKeyBuff);
    } catch (error) {
      throw new Error(`Key extraction failed : ${error.message}.`);
    }
  }
  getEncryptionKey() {
    return this.encryptionKey.rootKey;
  }
  getMacKey() {
    return this.macKey.rootKey;
  }
  getIvKey() {
    return this.ivKey.rootKey;
  }
}
exports.AeadAes256CbcHmac256EncryptionKey = AeadAes256CbcHmac256EncryptionKey;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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