# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/)
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [v1.0.11](https://github.com/es-shims/String.prototype.replaceAll/compare/v1.0.10...v1.0.11) - 2025-09-11

### Commits

- [Deps] update `call-bind`, `es-abstract`, `es-object-atoms`, `get-intrinsic`, `has-symbols`, `is-regex` [`42093cf`](https://github.com/es-shims/String.prototype.replaceAll/commit/42093cf783e701698bc248eac64ba24dbeed1556)
- [Dev Deps] update `@es-shims/api`, `@ljharb/eslint-config`, `auto-changelog`, `tape` [`ead7f09`](https://github.com/es-shims/String.prototype.replaceAll/commit/ead7f0907c36bc66cc35b9409785555bbd6bc591)
- [Tests] replace `aud` with `npm audit` [`12907f6`](https://github.com/es-shims/String.prototype.replaceAll/commit/12907f67c1725fcf397a7922f38e5f85732c7731)
- [Dev Deps] add missing peer dep [`8c69aa5`](https://github.com/es-shims/String.prototype.replaceAll/commit/8c69aa5aac0f4acd0148c15d168ebc8d82065d23)

## [v1.0.10](https://github.com/es-shims/String.prototype.replaceAll/compare/v1.0.9...v1.0.10) - 2024-03-19

### Commits

- [Deps] update `call-bind`, `es-abstract`, `es-errors`, `get-intrinsic` [`769d1cf`](https://github.com/es-shims/String.prototype.replaceAll/commit/769d1cf2ee05915f9a666f7ad55dbd60eebf99e0)
- [actions] remove redundant finisher [`74bfab2`](https://github.com/es-shims/String.prototype.replaceAll/commit/74bfab2b3b63b406677b725b685e0b62e1ae6914)
- [Refactor] use `es-object-atoms` where possible [`6696151`](https://github.com/es-shims/String.prototype.replaceAll/commit/6696151c0b5ffd8374a0f8fcc5872ddc7eff894e)
- [meta] add missing `engines.node` [`e38cb2b`](https://github.com/es-shims/String.prototype.replaceAll/commit/e38cb2b68328349e689a0ac996298e027ec4570d)
- [Dev Deps] update `tape` [`784df8c`](https://github.com/es-shims/String.prototype.replaceAll/commit/784df8c7f611a1f09db5b59e4cc2beaa1b0cfb3d)

## [v1.0.9](https://github.com/es-shims/String.prototype.replaceAll/compare/v1.0.8...v1.0.9) - 2024-02-04

### Commits

- [Deps] update `call-bind`, `define-properties`, `es-abstract`, `get-intrinsic` [`9afaf70`](https://github.com/es-shims/String.prototype.replaceAll/commit/9afaf709ff8d2d43378fc8772dfc1bc7e17a99c3)
- [Dev Deps] update `aud`, `npmignore`, `tape` [`ca2421a`](https://github.com/es-shims/String.prototype.replaceAll/commit/ca2421a9c7f3d62fac38d19066fb7a2e68de96bc)
- [Refactor] use `es-errors` where possible, so things that only need those do not need `get-intrinsic` [`fdad745`](https://github.com/es-shims/String.prototype.replaceAll/commit/fdad74599d52fab1745033767aa27772f60d846a)

## [v1.0.8](https://github.com/es-shims/String.prototype.replaceAll/compare/v1.0.7...v1.0.8) - 2023-09-03

### Commits

- [Deps] update `define-properties`, `es-abstract`, `get-intrinsic` [`23e1d04`](https://github.com/es-shims/String.prototype.replaceAll/commit/23e1d04429bbca36ae41050fdd4b8a188b9b9e1e)
- [Dev Deps] update `@es-shims/api`, `@ljharb/eslint-config`, `aud`, `es6-shim`, `tape` [`5ee9858`](https://github.com/es-shims/String.prototype.replaceAll/commit/5ee9858c60e0f354a70aebfd30013ac5dcac0da6)
- [meta] fix `npmignore` integration [`4e1e8a0`](https://github.com/es-shims/String.prototype.replaceAll/commit/4e1e8a0d4c844c24a31e5c4efbd381cddcfe4846)

## [v1.0.7](https://github.com/es-shims/String.prototype.replaceAll/compare/v1.0.6...v1.0.7) - 2022-11-07

### Commits

- [actions] reuse common workflows [`4bbf1bc`](https://github.com/es-shims/String.prototype.replaceAll/commit/4bbf1bc8d095ef7ee1c64300eb2c3b516efb8d41)
- [meta] use `npmignore` to autogenerate an npmignore file [`c9a5e01`](https://github.com/es-shims/String.prototype.replaceAll/commit/c9a5e0107cab4ec0c611e5ce0312dffe5805653d)
- [Deps] update `define-properties`, `es-abstract`, `get-intrinsic`, `has-symbols` [`6a559a7`](https://github.com/es-shims/String.prototype.replaceAll/commit/6a559a7ebd926c3756076a65bfdfb8dd50e62dbe)
- [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `@es-shims/api`, `safe-publish-latest`, `tape` [`02e98d1`](https://github.com/es-shims/String.prototype.replaceAll/commit/02e98d1b9b8a170b6753e6e4004aea0ca841bc43)
- [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `aud`, `auto-changelog`, `es5-shim`, `functions-have-names`, `tape` [`bf0084f`](https://github.com/es-shims/String.prototype.replaceAll/commit/bf0084fa414f9930a87f7e178a1cf2ca0f38c220)
- [actions] update rebase action to use reusable workflow [`ce0e8b7`](https://github.com/es-shims/String.prototype.replaceAll/commit/ce0e8b7f61220e12557e3997c1e30f5d4413c01d)
- [actions] update codecov uploader [`952e5b3`](https://github.com/es-shims/String.prototype.replaceAll/commit/952e5b3209e1b1ac0cad06e1385ae0e823fb4e01)

## [v1.0.6](https://github.com/es-shims/String.prototype.replaceAll/compare/v1.0.5...v1.0.6) - 2021-10-04

### Commits

- [Deps] update `es-abstract` [`823d403`](https://github.com/es-shims/String.prototype.replaceAll/commit/823d403d0226e0a6eee4426e9daabdc27ef287af)
- [actions] use `node/install` instead of `node/run`; use `codecov` action [`23b0615`](https://github.com/es-shims/String.prototype.replaceAll/commit/23b06153625f70ec9f11b7fec938d97aabd93304)
- [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `@es-shims/api`, `aud`, `auto-changelog`, `es5-shim`, `tape` [`f0f4be9`](https://github.com/es-shims/String.prototype.replaceAll/commit/f0f4be9ea715eeb24e8f53e2666505198de4eca4)
- [meta] add FUNDING.yml [`392afd7`](https://github.com/es-shims/String.prototype.replaceAll/commit/392afd7c543da9da3da18302e16ac1152baac298)
- [readme] add github actions/codecov badges [`e01952a`](https://github.com/es-shims/String.prototype.replaceAll/commit/e01952adde43f1f9ef4a62fae110b0bd267902f3)
- [Deps] update `es-abstract`, `is-regex` [`f763b3b`](https://github.com/es-shims/String.prototype.replaceAll/commit/f763b3b221a16e378df4f0155e59dcf292adbe5c)
- [Deps] update `es-abstract`, `has-symbols` [`35cfd7a`](https://github.com/es-shims/String.prototype.replaceAll/commit/35cfd7a57236ea86a54aa8679c5c513d65f40be3)
- [Dev Deps] update `eslint`, `tape` [`d066e34`](https://github.com/es-shims/String.prototype.replaceAll/commit/d066e342cc87266cb933d48001ed0051e74aac5a)
- [actions] update workflows [`c592b5d`](https://github.com/es-shims/String.prototype.replaceAll/commit/c592b5d690ebcfc755aeab647914817faaab5703)
- [meta] use `prepublishOnly` script for npm 7+ [`bb345fd`](https://github.com/es-shims/String.prototype.replaceAll/commit/bb345fd8b2f9a4f6a0a494f2ec07da5b69cd0811)
- [Dev Deps] update `@es-shims/api` [`4050d23`](https://github.com/es-shims/String.prototype.replaceAll/commit/4050d237e6bc4123c1dda4efc925334521d75ea7)

## [v1.0.5](https://github.com/es-shims/String.prototype.replaceAll/compare/v1.0.4...v1.0.5) - 2021-02-22

### Commits

- [meta] do not publish github action workflow files [`5bc61a7`](https://github.com/es-shims/String.prototype.replaceAll/commit/5bc61a7765dc78afd3a63b66321dd45a14b2b717)
- [Refactor] use an explicit step for an empty string searchValue [`5c0a89a`](https://github.com/es-shims/String.prototype.replaceAll/commit/5c0a89afdeb3ef722fc81e5a83ee0768ad88b3fa)
- [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `aud`, `es5-shim`, `functions-have-names`, `tape` [`42c1125`](https://github.com/es-shims/String.prototype.replaceAll/commit/42c1125240eea2b2b9f3d49c3de765dee36d1758)
- [readme] remove travis badge [`ee72ded`](https://github.com/es-shims/String.prototype.replaceAll/commit/ee72dede50a46c03c1e6634fcb0e01f5fe1474f1)
- [Deps] update `call-bind`, `es-abstract`, `get-intrinsic`, `is-regex` [`d79e8fc`](https://github.com/es-shims/String.prototype.replaceAll/commit/d79e8fcab0e82d28d27934c47a84134831d4de00)
- [actions] update workflows [`54098df`](https://github.com/es-shims/String.prototype.replaceAll/commit/54098df89d03c5f91d23427ea9bc530012668f4e)
- [Tests] increase coverage [`e9e96b6`](https://github.com/es-shims/String.prototype.replaceAll/commit/e9e96b6355c9416a2fc48d98ade934996ce8fb33)

## [v1.0.4](https://github.com/es-shims/String.prototype.replaceAll/compare/v1.0.3...v1.0.4) - 2020-11-21

### Commits

- [Tests] migrate tests to Github Actions [`a3561c7`](https://github.com/es-shims/String.prototype.replaceAll/commit/a3561c7bcbe2e88bbd5d0d648f7ffb79634fad78)
- [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `aud`, `auto-changelog`, `es6-shim`, `tape` [`80dfacb`](https://github.com/es-shims/String.prototype.replaceAll/commit/80dfacb9694d9227d8c59138cf908c5909001d86)
- [Deps] update `es-abstract`, `is-regex`; use `get-intrinsic` and `call-bind` where applicable [`a956402`](https://github.com/es-shims/String.prototype.replaceAll/commit/a956402c4f9ee6127962acea0ac86d9e9a8531d5)
- [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `tape`, `functions-have-names`; add `safe-publish-latest` [`5e469fd`](https://github.com/es-shims/String.prototype.replaceAll/commit/5e469fda0c48702efc3f816e4be8bdf99cf44ee6)
- [Tests] run `nyc` on all tests [`b5d1eeb`](https://github.com/es-shims/String.prototype.replaceAll/commit/b5d1eebe06414a87b49d01b61755dee8f628685e)
- [actions] add "Allow Edits" workflow [`03f0140`](https://github.com/es-shims/String.prototype.replaceAll/commit/03f0140a2c6a64e8c6c10a06eaedaadf980dc700)
- [Deps] update `es-abstract`, `is-regex`; refactor away from `function-bind` [`dadd98c`](https://github.com/es-shims/String.prototype.replaceAll/commit/dadd98c7b156f9572123520416ee3d73081d16de)
- [Dev Deps] update `es5-shim`, `tape` [`1740467`](https://github.com/es-shims/String.prototype.replaceAll/commit/174046765a0ae2e55eb9eae0f6564f58cefa62e7)
- [Dev Deps] update `auto-changelog`; add `aud` [`41ce396`](https://github.com/es-shims/String.prototype.replaceAll/commit/41ce39649906b98522226fc27ffbc5fa876b1f6e)
- [actions] switch Automatic Rebase workflow to `pull_request_target` event [`77ce2cd`](https://github.com/es-shims/String.prototype.replaceAll/commit/77ce2cd20f0f1b4d5f1ca94c826b11b083fac16f)
- [Dev Deps] update `auto-changelog`, `tape` [`a13336c`](https://github.com/es-shims/String.prototype.replaceAll/commit/a13336c38bb6c35c68a49bac90e34dd0c41bdd66)
- [Tests] only audit prod deps [`c122c88`](https://github.com/es-shims/String.prototype.replaceAll/commit/c122c885a34af4da75f414f7aeb10e2ab0601b51)
- [Deps] update `es-abstract` [`f6b0048`](https://github.com/es-shims/String.prototype.replaceAll/commit/f6b0048e5e1371ee2e599bc25952cdfec8b94445)

## [v1.0.3](https://github.com/es-shims/String.prototype.replaceAll/compare/v1.0.2...v1.0.3) - 2019-12-14

### Commits

- [Tests] use shared travis-ci configs [`410a2f8`](https://github.com/es-shims/String.prototype.replaceAll/commit/410a2f88ae5ab038f58fa77d00760a0d74257b99)
- [meta] rerun `auto-changelog` [`de4a904`](https://github.com/es-shims/String.prototype.replaceAll/commit/de4a904e8d530091db510b31598c46da71bd12f1)
- [Refactor] use split-up `es-abstract` (71% bundle size decrease) [`dd62b57`](https://github.com/es-shims/String.prototype.replaceAll/commit/dd62b57c7f51147ac13b401c86bd47f9a16ee767)
- [actions] add automatic rebasing / merge commit blocking [`f390fa7`](https://github.com/es-shims/String.prototype.replaceAll/commit/f390fa70f019a290f6be9b2daa9f38895a0f13f4)
- [Deps] update `es-abstract`, `has-symbols` [`ff7ab0c`](https://github.com/es-shims/String.prototype.replaceAll/commit/ff7ab0c7ec18f3eca5cdcc6e49d54e61be453dc5)
- [Dev Deps] update `eslint`, `@ljharb/eslint-config` [`5945afc`](https://github.com/es-shims/String.prototype.replaceAll/commit/5945afccb80b8b4750f8b2b9173c1265a53846d1)
- [meta] add `funding` field [`f0fdbf1`](https://github.com/es-shims/String.prototype.replaceAll/commit/f0fdbf1f23b8f474c0e427a565be37c62faf07cd)

## [v1.0.2](https://github.com/es-shims/String.prototype.replaceAll/compare/v1.0.1...v1.0.2) - 2019-10-31

### Fixed

- [Deps] add missing `define-properties` [`#2`](https://github.com/es-shims/String.prototype.replaceAll/issues/2)

## [v1.0.1](https://github.com/es-shims/String.prototype.replaceAll/compare/v1.0.0...v1.0.1) - 2019-10-26

### Fixed

- [Fix] handle an empty string searchValue [`#1`](https://github.com/es-shims/String.prototype.replaceAll/issues/1)

### Commits

- [Deps] update `es-abstract` [`2ab3464`](https://github.com/es-shims/String.prototype.replaceAll/commit/2ab346486859f0f1448f53547740df5274af00c5)
- [Tests] up to `node` `v13.0`, `v12.13`, `v10.17` [`be6a236`](https://github.com/es-shims/String.prototype.replaceAll/commit/be6a2366fd8f57a87af8aaa98ef6b72d66852392)
- [meta] use keepachangelog format [`f5248bb`](https://github.com/es-shims/String.prototype.replaceAll/commit/f5248bb1aea82b6d9c3ca9d250f1b45d540b3d0f)
- [Dev Deps] update `eslint`, `functions-have-names`, `auto-changelog` [`5be4a77`](https://github.com/es-shims/String.prototype.replaceAll/commit/5be4a77a7cf593055f57b8a50147e5868f922f27)
- [Dev Deps] update `eslint` [`376879f`](https://github.com/es-shims/String.prototype.replaceAll/commit/376879f87bd75b1939620bf866af35b15582ad5c)

## v1.0.0 - 2019-09-03

### Commits

- tests [`0d23a9b`](https://github.com/es-shims/String.prototype.replaceAll/commit/0d23a9b46f4c0d10f4fe41fcf644e729b73dccf8)
- implementation [`d44c2e9`](https://github.com/es-shims/String.prototype.replaceAll/commit/d44c2e96b823997c669879a6f7de1ac894a35634)
- Initial commit [`6dc47f9`](https://github.com/es-shims/String.prototype.replaceAll/commit/6dc47f9a516f4881b451129936c3275168cf5405)
- readme [`08c5710`](https://github.com/es-shims/String.prototype.replaceAll/commit/08c571056a42d9820f403035796e74172e68ca3d)
- npm init [`f666051`](https://github.com/es-shims/String.prototype.replaceAll/commit/f666051cb7d2d3392d2ba30dfad952048ff47d5b)
- non-global regexes throw, pending web compatibility data [`fbd9a60`](https://github.com/es-shims/String.prototype.replaceAll/commit/fbd9a60c929575111721f9c71d5638804614ba21)
- [fix] add fallback for pre-Symbol.replace engines [`57b33d3`](https://github.com/es-shims/String.prototype.replaceAll/commit/57b33d3dbb8348f2b9e83a652a1771c447e953e8)
- [Tests] add `npm run lint` [`a979c0f`](https://github.com/es-shims/String.prototype.replaceAll/commit/a979c0fc27735abb3a710ae80be5c5c564a5d1fe)
- [meta] add auto-changelog [`f780972`](https://github.com/es-shims/String.prototype.replaceAll/commit/f78097211dcc9a22f805f4198026ee87a41d14e1)
- Only apps should have lockfiles [`b9dc48f`](https://github.com/es-shims/String.prototype.replaceAll/commit/b9dc48f43711a8d38515aeafdd0ffc6a985465bc)
