import { Buffer } from 'buffer';
import type { Response as NodeFetchResponseType, ResponseInit as NodeFetchResponseInit } from 'node-fetch';
import { NFCResponseMetadata } from '../types.js';
declare function createNFCResponseClass(): Promise<{
    new (bodyStream: NodeJS.ReadableStream, metaData: Omit<NodeFetchResponseInit, "headers"> & {
        url: string;
        size: number;
        counter: number;
        headers: Record<string, string[]>;
    }, ejectFromCache: () => Promise<unknown>, returnedFromCache: boolean, isCacheMiss?: boolean): {
        readonly ejectFromCache: () => Promise<unknown>;
        readonly returnedFromCache: boolean;
        readonly isCacheMiss: boolean;
        readonly headers: import("node-fetch").Headers;
        readonly ok: boolean;
        readonly redirected: boolean;
        readonly status: number;
        readonly statusText: string;
        readonly type: "default" | "error" | "basic" | "cors" | "opaque" | "opaqueredirect";
        readonly url: string;
        clone(): NodeFetchResponseType;
        readonly body: NodeJS.ReadableStream | null;
        readonly bodyUsed: boolean;
        readonly size: number;
        buffer(): Promise<Buffer>;
        arrayBuffer(): Promise<ArrayBuffer>;
        formData(): Promise<FormData>;
        blob(): Promise<Blob>;
        json(): Promise<unknown>;
        text(): Promise<string>;
    };
    serializeMetaFromNodeFetchResponse(response: NodeFetchResponseType): NFCResponseMetadata;
    cacheMissResponse(url: string): {
        readonly ejectFromCache: () => Promise<unknown>;
        readonly returnedFromCache: boolean;
        readonly isCacheMiss: boolean;
        readonly headers: import("node-fetch").Headers;
        readonly ok: boolean;
        readonly redirected: boolean;
        readonly status: number;
        readonly statusText: string;
        readonly type: "default" | "error" | "basic" | "cors" | "opaque" | "opaqueredirect";
        readonly url: string;
        clone(): NodeFetchResponseType;
        readonly body: NodeJS.ReadableStream | null;
        readonly bodyUsed: boolean;
        readonly size: number;
        buffer(): Promise<Buffer>;
        arrayBuffer(): Promise<ArrayBuffer>;
        formData(): Promise<FormData>;
        blob(): Promise<Blob>;
        json(): Promise<unknown>;
        text(): Promise<string>;
    };
    error(): NodeFetchResponseType;
    redirect(url: string, status?: number): NodeFetchResponseType;
    json(data: any, init?: NodeFetchResponseInit): NodeFetchResponseType;
}>;
export type NFCResponseClass = Awaited<ReturnType<typeof createNFCResponseClass>>;
export type NFCResponse = InstanceType<NFCResponseClass>;
export declare function getNFCResponseClass(): Promise<{
    new (bodyStream: NodeJS.ReadableStream, metaData: Omit<NodeFetchResponseInit, "headers"> & {
        url: string;
        size: number;
        counter: number;
        headers: Record<string, string[]>;
    }, ejectFromCache: () => Promise<unknown>, returnedFromCache: boolean, isCacheMiss?: boolean): {
        readonly ejectFromCache: () => Promise<unknown>;
        readonly returnedFromCache: boolean;
        readonly isCacheMiss: boolean;
        readonly headers: import("node-fetch").Headers;
        readonly ok: boolean;
        readonly redirected: boolean;
        readonly status: number;
        readonly statusText: string;
        readonly type: "default" | "error" | "basic" | "cors" | "opaque" | "opaqueredirect";
        readonly url: string;
        clone(): NodeFetchResponseType;
        readonly body: NodeJS.ReadableStream | null;
        readonly bodyUsed: boolean;
        readonly size: number;
        buffer(): Promise<Buffer>;
        arrayBuffer(): Promise<ArrayBuffer>;
        formData(): Promise<FormData>;
        blob(): Promise<Blob>;
        json(): Promise<unknown>;
        text(): Promise<string>;
    };
    serializeMetaFromNodeFetchResponse(response: NodeFetchResponseType): NFCResponseMetadata;
    cacheMissResponse(url: string): {
        readonly ejectFromCache: () => Promise<unknown>;
        readonly returnedFromCache: boolean;
        readonly isCacheMiss: boolean;
        readonly headers: import("node-fetch").Headers;
        readonly ok: boolean;
        readonly redirected: boolean;
        readonly status: number;
        readonly statusText: string;
        readonly type: "default" | "error" | "basic" | "cors" | "opaque" | "opaqueredirect";
        readonly url: string;
        clone(): NodeFetchResponseType;
        readonly body: NodeJS.ReadableStream | null;
        readonly bodyUsed: boolean;
        readonly size: number;
        buffer(): Promise<Buffer>;
        arrayBuffer(): Promise<ArrayBuffer>;
        formData(): Promise<FormData>;
        blob(): Promise<Blob>;
        json(): Promise<unknown>;
        text(): Promise<string>;
    };
    error(): NodeFetchResponseType;
    redirect(url: string, status?: number): NodeFetchResponseType;
    json(data: any, init?: NodeFetchResponseInit): NodeFetchResponseType;
}>;
export {};
