declare namespace _default {
    export { comparePaths };
    export { dropPathSegmentQuotes };
    export { enforcedContexts };
    export { exemptSpeciaMethods };
    export { flattenRoots };
    export { getAllTags };
    export { getContextObject };
    export { getFunctionParameterNames };
    export { getIndent };
    export { getJsdocTagsDeep };
    export { getPreferredTagName };
    export { getRegexFromString };
    export { getTagsByType };
    export { getTagStructureForMode };
    export { hasATag };
    export { hasParams };
    export { hasReturnValue };
    export { hasTag };
    export { hasThrowValue };
    export { hasValueOrExecutorHasNonEmptyResolveValue };
    export { hasYieldValue };
    export { isConstructor };
    export { isGetter };
    export { isNamepathDefiningTag };
    export { isNamepathOrUrlReferencingTag };
    export { isNamepathReferencingTag };
    export { isSetter };
    export { isValidTag };
    export { mayBeUndefinedTypeTag };
    export { overrideTagStructure };
    export { parseClosureTemplateTag };
    export { pathDoesNotBeginWith };
    export { setTagStructure };
    export { tagMightHaveEitherTypeOrNamePosition };
    export { tagMightHaveNamepath };
    export { tagMightHaveNamePosition };
    export { tagMightHaveTypePosition };
    export { tagMissingRequiredTypeOrNamepath };
    export { tagMustHaveNamePosition };
    export { tagMustHaveTypePosition };
}
export default _default;
export type Integer = number;
export type ESTreeOrTypeScriptNode = import('./utils/hasReturnValue.js').ESTreeOrTypeScriptNode;
export type ParserMode = "jsdoc" | "typescript" | "closure" | "permissive";
export type ParamCommon = undefined | string | {
    name: Integer;
    restElement: boolean;
} | {
    isRestProperty: boolean | undefined;
    name: string;
    restElement: boolean;
} | {
    name: string;
    restElement: boolean;
};
export type ParamNameInfo = ParamCommon | [
    string | undefined,
    (FlattendRootInfo & {
        annotationParamName?: string;
    })
] | [string, string[] | ParamInfo[]];
export type FlattendRootInfo = {
    hasPropertyRest: boolean;
    hasRestElement: boolean;
    names: string[];
    rests: boolean[];
};
export type NestedParamInfo = [string, (string[] | ParamInfo[])];
export type ParamInfo = ParamCommon | [
    string | undefined,
    (FlattendRootInfo & {
        annotationParamName?: string;
    })
] | [string, string[] | ParamInfo[]];
/**
 * Given a nested array of property names, reduce them to a single array,
 * appending the name of the root element along the way if present.
 */
export type FlattenRoots = (params: ParamInfo[], root?: string | undefined) => FlattendRootInfo;
export type DefaultContexts = true | string[];
export type TagNamePreference = {
    [key: string]: string | false | {
        message: string;
        replacement?: string | undefined;
    };
};
export type PathDoesNotBeginWith = (name: string, otherPathName: string) => boolean;
/**
 * @param {string} name
 * @returns {(otherPathName: string) => boolean}
 */
declare function comparePaths(name: string): (otherPathName: string) => boolean;
/**
 * Since path segments may be unquoted (if matching a reserved word,
 * identifier or numeric literal) or single or double quoted, in either
 * the `@param` or in source, we need to strip the quotes to give a fair
 * comparison.
 * @param {string} str
 * @returns {string}
 */
declare function dropPathSegmentQuotes(str: string): string;
/**
 * @typedef {true|string[]} DefaultContexts
 */
/**
 * Checks user option for `contexts` array, defaulting to
 * contexts designated by the rule. Returns an array of
 * ESTree AST types, indicating allowable contexts.
 * @param {import('eslint').Rule.RuleContext} context
 * @param {DefaultContexts|undefined} defaultContexts
 * @param {{
 *   contexts?: import('./iterateJsdoc.js').Context[]
 * }} settings
 * @returns {string[]}
 */
declare function enforcedContexts(context: import('eslint').Rule.RuleContext, defaultContexts: DefaultContexts | undefined, settings: {
    contexts?: import("./iterateJsdoc.js").Context[] | undefined;
}): string[];
/**
 * @param {import('./iterateJsdoc.js').JsdocBlockWithInline} jsdoc
 * @param {import('eslint').Rule.Node|null} node
 * @param {import('eslint').Rule.RuleContext} context
 * @param {import('json-schema').JSONSchema4} schema
 * @returns {boolean}
 */
declare function exemptSpeciaMethods(jsdoc: import('./iterateJsdoc.js').JsdocBlockWithInline, node: import('eslint').Rule.Node | null, context: import('eslint').Rule.RuleContext, schema: any): boolean;
/**
 * @typedef {undefined|string|{
 *   name: Integer,
 *   restElement: boolean
 * }|{
 *   isRestProperty: boolean|undefined,
 *   name: string,
 *   restElement: boolean
 * }|{
 *   name: string,
 *   restElement: boolean
 * }} ParamCommon
 */
/**
 * @typedef {ParamCommon|[string|undefined, (FlattendRootInfo & {
 *   annotationParamName?: string,
 * })]|NestedParamInfo} ParamNameInfo
 */
/**
 * @typedef {{
 *   hasPropertyRest: boolean,
 *   hasRestElement: boolean,
 *   names: string[],
 *   rests: boolean[],
 * }} FlattendRootInfo
 */
/**
 * @typedef {[string, (string[]|ParamInfo[])]} NestedParamInfo
 */
/**
 * @typedef {ParamCommon|
 * [string|undefined, (FlattendRootInfo & {
 *   annotationParamName?: string
 * })]|
 * NestedParamInfo} ParamInfo
 */
/**
 * Given a nested array of property names, reduce them to a single array,
 * appending the name of the root element along the way if present.
 * @callback FlattenRoots
 * @param {ParamInfo[]} params
 * @param {string} [root]
 * @returns {FlattendRootInfo}
 */
/** @type {FlattenRoots} */
declare const flattenRoots: FlattenRoots;
/**
 * Get all tags, inline tags and inline tags in tags
 * @param {import('./iterateJsdoc.js').JsdocBlockWithInline} jsdoc
 * @returns {(import('comment-parser').Spec|
 *   import('@es-joy/jsdoccomment').JsdocInlineTagNoType)[]}
 */
declare function getAllTags(jsdoc: import('./iterateJsdoc.js').JsdocBlockWithInline): (import('comment-parser').Spec | import('@es-joy/jsdoccomment').JsdocInlineTagNoType)[];
/**
 * @param {import('./iterateJsdoc.js').Context[]} contexts
 * @param {import('./iterateJsdoc.js').CheckJsdoc} checkJsdoc
 * @param {import('@es-joy/jsdoccomment').CommentHandler} [handler]
 * @returns {import('eslint').Rule.RuleListener}
 */
declare function getContextObject(contexts: import('./iterateJsdoc.js').Context[], checkJsdoc: import('./iterateJsdoc.js').CheckJsdoc, handler?: import("@es-joy/jsdoccomment").CommentHandler | undefined): import('eslint').Rule.RuleListener;
/**
 * @param {ESTreeOrTypeScriptNode|null} functionNode
 * @param {boolean} [checkDefaultObjects]
 * @throws {Error}
 * @returns {ParamNameInfo[]}
 */
declare function getFunctionParameterNames(functionNode: ESTreeOrTypeScriptNode | null, checkDefaultObjects?: boolean | undefined): ParamNameInfo[];
/**
 * @param {import('eslint').SourceCode|{
 *   text: string
 * }} sourceCode
 * @returns {string}
 */
declare function getIndent(sourceCode: import('eslint').SourceCode | {
    text: string;
}): string;
/**
 * Gets all names of the target type, including those that refer to a path, e.g.
 * `foo` or `foo.bar`.
 * @param {import('comment-parser').Block} jsdoc
 * @param {string} targetTagName
 * @returns {{
 *   idx: Integer,
 *   name: string,
 *   type: string
 * }[]}
 */
declare function getJsdocTagsDeep(jsdoc: import('comment-parser').Block, targetTagName: string): {
    idx: Integer;
    name: string;
    type: string;
}[];
/**
 * @param {import('eslint').Rule.RuleContext} context
 * @param {ParserMode|undefined} mode
 * @param {string} name
 * @param {TagNamePreference} tagPreference
 * @returns {string|false|{
 *   message: string;
 *   replacement?: string|undefined;
 * }}
 */
declare function getPreferredTagName(context: import('eslint').Rule.RuleContext, mode: ParserMode | undefined, name: string, tagPreference?: TagNamePreference): string | false | {
    message: string;
    replacement?: string | undefined;
};
/**
 * @param {string} regexString
 * @param {string} [requiredFlags]
 * @returns {RegExp}
 */
declare function getRegexFromString(regexString: string, requiredFlags?: string | undefined): RegExp;
/**
 * @typedef {{
 *   [key: string]: false|string|
 *     {message: string, replacement?: string}
 * }} TagNamePreference
 */
/**
 * @param {import('eslint').Rule.RuleContext} context
 * @param {ParserMode|undefined} mode
 * @param {import('comment-parser').Spec[]} tags
 * @returns {{
 *   tagsWithNames: import('comment-parser').Spec[],
 *   tagsWithoutNames: import('comment-parser').Spec[]
 * }}
 */
declare function getTagsByType(context: import('eslint').Rule.RuleContext, mode: ParserMode | undefined, tags: import('comment-parser').Spec[]): {
    tagsWithNames: import('comment-parser').Spec[];
    tagsWithoutNames: import('comment-parser').Spec[];
};
/**
 * @param {ParserMode} mode
 * @param {import('./iterateJsdoc.js').StructuredTags} structuredTags
 * @returns {import('./getDefaultTagStructureForMode.js').TagStructure}
 */
declare function getTagStructureForMode(mode: ParserMode, structuredTags: import('./iterateJsdoc.js').StructuredTags): import('./getDefaultTagStructureForMode.js').TagStructure;
/**
 * @param {import('./iterateJsdoc.js').JsdocBlockWithInline} jsdoc
 * @param {string[]} targetTagNames
 * @returns {boolean}
 */
declare function hasATag(jsdoc: import('./iterateJsdoc.js').JsdocBlockWithInline, targetTagNames: string[]): boolean;
/**
 * @param {ESTreeOrTypeScriptNode} functionNode
 * @returns {Integer}
 */
declare function hasParams(functionNode: ESTreeOrTypeScriptNode): Integer;
import { hasReturnValue } from './utils/hasReturnValue.js';
/**
 * @param {import('./iterateJsdoc.js').JsdocBlockWithInline} jsdoc
 * @param {string} targetTagName
 * @returns {boolean}
 */
declare function hasTag(jsdoc: import('./iterateJsdoc.js').JsdocBlockWithInline, targetTagName: string): boolean;
/**
 * Checks if a node has a throws statement.
 * @param {ESTreeOrTypeScriptNode|null|undefined} node
 * @param {boolean} [innerFunction]
 * @returns {boolean}
 */
declare function hasThrowValue(node: ESTreeOrTypeScriptNode | null | undefined, innerFunction?: boolean | undefined): boolean;
import { hasValueOrExecutorHasNonEmptyResolveValue } from './utils/hasReturnValue.js';
/**
 * Checks if a node has a return statement. Void return does not count.
 * @param {ESTreeOrTypeScriptNode} node
 * @param {boolean} [checkYieldReturnValue]
 * @returns {boolean}
 */
declare function hasYieldValue(node: ESTreeOrTypeScriptNode, checkYieldReturnValue?: boolean | undefined): boolean;
/**
 * @param {import('eslint').Rule.Node|null} node
 * @returns {boolean}
 */
declare function isConstructor(node: import('eslint').Rule.Node | null): boolean;
/**
 * @param {import('eslint').Rule.Node|null} node
 * @returns {boolean}
 */
declare function isGetter(node: import('eslint').Rule.Node | null): boolean;
/**
 * @param {string} tag
 * @param {import('./getDefaultTagStructureForMode.js').TagStructure} tagMap
 * @returns {boolean}
 */
declare function isNamepathDefiningTag(tag: string, tagMap?: import('./getDefaultTagStructureForMode.js').TagStructure): boolean;
/**
 * @param {string} tag
 * @param {import('./getDefaultTagStructureForMode.js').TagStructure} tagMap
 * @returns {boolean}
 */
declare function isNamepathOrUrlReferencingTag(tag: string, tagMap?: import('./getDefaultTagStructureForMode.js').TagStructure): boolean;
/**
 * @param {string} tag
 * @param {import('./getDefaultTagStructureForMode.js').TagStructure} tagMap
 * @returns {boolean}
 */
declare function isNamepathReferencingTag(tag: string, tagMap?: import('./getDefaultTagStructureForMode.js').TagStructure): boolean;
/**
 * @param {import('eslint').Rule.Node|null} node
 * @returns {boolean}
 */
declare function isSetter(node: import('eslint').Rule.Node | null): boolean;
/**
 * @param {import('eslint').Rule.RuleContext} context
 * @param {ParserMode|undefined} mode
 * @param {string} name
 * @param {string[]} definedTags
 * @returns {boolean}
 */
declare function isValidTag(context: import('eslint').Rule.RuleContext, mode: ParserMode | undefined, name: string, definedTags: string[]): boolean;
/**
 * Checks if the JSDoc comment has an undefined type.
 * @param {import('comment-parser').Spec|null|undefined} tag
 *   the tag which should be checked.
 * @param {ParserMode} mode
 * @returns {boolean}
 *   true in case a defined type is undeclared; otherwise false.
 */
declare function mayBeUndefinedTypeTag(tag: import('comment-parser').Spec | null | undefined, mode: ParserMode): boolean;
/**
 * @param {import('./iterateJsdoc.js').StructuredTags} structuredTags
 * @param {import('./getDefaultTagStructureForMode.js').TagStructure} tagMap
 * @returns {void}
 */
declare function overrideTagStructure(structuredTags: import('./iterateJsdoc.js').StructuredTags, tagMap?: import('./getDefaultTagStructureForMode.js').TagStructure): void;
/**
 * @param {string} tag
 */
/**
 * Parses GCC Generic/Template types
 * @see {@link https://github.com/google/closure-compiler/wiki/Generic-Types}
 * @see {@link https://www.typescriptlang.org/docs/handbook/jsdoc-supported-types.html#template}
 * @param {import('comment-parser').Spec} tag
 * @returns {string[]}
 */
declare function parseClosureTemplateTag(tag: import('comment-parser').Spec): string[];
/**
 * @callback PathDoesNotBeginWith
 * @param {string} name
 * @param {string} otherPathName
 * @returns {boolean}
 */
/** @type {PathDoesNotBeginWith} */
declare const pathDoesNotBeginWith: PathDoesNotBeginWith;
/**
 * @param {ParserMode} mode
 * @returns {void}
 */
declare function setTagStructure(mode: ParserMode): void;
/**
 * @param {string} tag
 * @param {import('./getDefaultTagStructureForMode.js').TagStructure} tagMap
 * @returns {boolean}
 */
declare function tagMightHaveEitherTypeOrNamePosition(tag: string, tagMap: import('./getDefaultTagStructureForMode.js').TagStructure): boolean;
/**
 * @param {string} tag
 * @param {import('./getDefaultTagStructureForMode.js').TagStructure} tagMap
 * @returns {boolean}
 */
declare function tagMightHaveNamepath(tag: string, tagMap?: import('./getDefaultTagStructureForMode.js').TagStructure): boolean;
/**
 * @param {string} tag
 * @param {import('./getDefaultTagStructureForMode.js').TagStructure} tagMap
 * @returns {boolean}
 */
declare function tagMightHaveNamePosition(tag: string, tagMap?: import('./getDefaultTagStructureForMode.js').TagStructure): boolean;
/**
 * @param {string} tag
 * @param {import('./getDefaultTagStructureForMode.js').TagStructure} tagMap
 * @returns {boolean|string}
 */
declare function tagMightHaveTypePosition(tag: string, tagMap?: import('./getDefaultTagStructureForMode.js').TagStructure): boolean | string;
/**
 * @param {import('comment-parser').Spec} tag
 * @param {import('./getDefaultTagStructureForMode.js').TagStructure} tagMap
 * @returns {boolean|undefined}
 */
declare function tagMissingRequiredTypeOrNamepath(tag: import('comment-parser').Spec, tagMap?: import('./getDefaultTagStructureForMode.js').TagStructure): boolean | undefined;
/**
 * @param {string} tag
 * @param {import('./getDefaultTagStructureForMode.js').TagStructure} tagMap
 * @returns {boolean|undefined}
 */
declare function tagMustHaveNamePosition(tag: string, tagMap?: import('./getDefaultTagStructureForMode.js').TagStructure): boolean | undefined;
/**
 * @param {string} tag
 * @param {import('./getDefaultTagStructureForMode.js').TagStructure} tagMap
 * @returns {boolean|undefined}
 */
declare function tagMustHaveTypePosition(tag: string, tagMap?: import('./getDefaultTagStructureForMode.js').TagStructure): boolean | undefined;
//# sourceMappingURL=jsdocUtils.d.ts.map