/**
 * @param {JsdocVisitor} iterator
 * @param {RuleConfig} ruleConfig
 * @returns {import('eslint').Rule.RuleModule}
 */
export default function iterateJsdoc(iterator: JsdocVisitor, ruleConfig: RuleConfig): import('eslint').Rule.RuleModule;
export type Integer = number;
export type JsdocBlockWithInline = import('@es-joy/jsdoccomment').JsdocBlockWithInline;
export type ContextObject = {
    disallowName?: string;
    allowName?: string;
    context?: string;
    comment?: string;
    tags?: string[];
    replacement?: string;
    minimum?: Integer;
    message?: string;
    forceRequireReturn?: boolean;
};
export type Context = string | ContextObject;
export type CheckJsdoc = (info: {
    lastIndex?: Integer;
    isFunctionContext?: boolean;
    selector?: string;
    comment?: string;
}, handler: ((jsdoc: import('@es-joy/jsdoccomment').JsdocBlockWithInline) => boolean | undefined) | null, node: import('eslint').Rule.Node) => void;
export type ForEachPreferredTag = (tagName: string, arrayHandler: (matchingJsdocTag: import('@es-joy/jsdoccomment').JsdocTagWithInline, targetTagName: string) => void, skipReportingBlockedTag?: boolean | undefined) => void;
export type ReportSettings = (message: string) => void;
export type ParseClosureTemplateTag = (tag: import('comment-parser').Spec) => string[];
export type GetPreferredTagNameObject = (cfg: {
    tagName: string;
}) => string | false | {
    message: string;
    replacement?: string | undefined;
} | {
    blocked: true;
    tagName: string;
};
export type BasicUtils = {
    forEachPreferredTag: ForEachPreferredTag;
    reportSettings: ReportSettings;
    parseClosureTemplateTag: ParseClosureTemplateTag;
    getPreferredTagNameObject: GetPreferredTagNameObject;
    pathDoesNotBeginWith: import('./jsdocUtils.js').PathDoesNotBeginWith;
};
export type IsIteratingFunction = () => boolean;
export type IsVirtualFunction = () => boolean;
export type Stringify = (tagBlock: import('comment-parser').Block, specRewire?: boolean | undefined) => string;
export type ReportJSDoc = (msg: string, tag?: import("comment-parser").Spec | {
    line: Integer;
    column?: number | undefined;
} | null | undefined, handler?: (() => void) | null | undefined, specRewire?: boolean | undefined, data?: {
    [key: string]: string;
} | undefined) => any;
export type GetRegexFromString = (str: string, requiredFlags?: string | undefined) => RegExp;
export type GetTagDescription = (tg: import('comment-parser').Spec, returnArray?: boolean | undefined) => string[] | string;
export type SetTagDescription = (tg: import('comment-parser').Spec, matcher: RegExp, setter: (description: string) => string) => Integer;
export type GetDescription = () => {
    description: string;
    descriptions: string[];
    lastDescriptionLine: Integer;
};
export type SetBlockDescription = (setter: (info: {
    delimiter: string;
    postDelimiter: string;
    start: string;
}, seedTokens: (tokens?: Partial<import('comment-parser').Tokens>) => import('comment-parser').Tokens, descLines: string[]) => import('comment-parser').Line[]) => void;
export type SetDescriptionLines = (matcher: RegExp, setter: (description: string) => string) => Integer;
export type ChangeTag = (tag: import('comment-parser').Spec, ...tokens: Partial<import('comment-parser').Tokens>[]) => void;
export type SetTag = (tag: import('comment-parser').Spec & {
    line: Integer;
}, tokens?: Partial<import("comment-parser").Tokens> | undefined) => void;
export type RemoveTag = (tagIndex: Integer, cfg?: {
    removeEmptyBlock?: boolean | undefined;
    tagSourceOffset?: number | undefined;
} | undefined) => void;
export type AddTag = (targetTagName: string, number?: number | undefined, tokens?: {} | import("comment-parser").Tokens | undefined) => void;
export type GetFirstLine = () => Integer | undefined;
export type SeedTokens = (tokens?: Partial<import('comment-parser').Tokens> | undefined) => import('comment-parser').Tokens;
/**
 * Sets tokens to empty string.
 */
export type EmptyTokens = (tokens: import('comment-parser').Tokens) => void;
export type AddLine = (sourceIndex: Integer, tokens: Partial<import('comment-parser').Tokens>) => void;
export type AddLines = (tagIndex: Integer, tagSourceOffset: Integer, numLines: Integer) => void;
export type MakeMultiline = () => void;
export type GetFunctionParameterNames = (useDefaultObjectProperties?: boolean | undefined) => import('./jsdocUtils.js').ParamNameInfo[];
export type HasParams = () => Integer;
export type IsGenerator = () => boolean;
export type IsConstructor = () => boolean;
export type GetJsdocTagsDeep = (tagName: string) => false | {
    idx: Integer;
    name: string;
    type: string;
}[];
export type GetPreferredTagName = (cfg: {
    tagName: string;
    skipReportingBlockedTag?: boolean;
    allowObjectReturn?: boolean;
    defaultMessage?: string;
}) => string | undefined | false | {
    message: string;
    replacement?: string | undefined;
} | {
    blocked: true;
    tagName: string;
};
export type IsValidTag = (name: string, definedTags: string[]) => boolean;
export type HasATag = (names: string[]) => boolean;
export type HasTag = (name: string) => boolean;
export type ComparePaths = (name: string) => (otherPathName: string) => boolean;
export type DropPathSegmentQuotes = (name: string) => string;
export type AvoidDocs = () => boolean;
export type TagMightHaveNamePositionTypePosition = (tagName: string, otherModeMaps?: import("./getDefaultTagStructureForMode.js").TagStructure[] | undefined) => boolean | {
    otherMode: true;
};
export type TagMustHave = (tagName: string, otherModeMaps: import('./getDefaultTagStructureForMode.js').TagStructure[]) => boolean | {
    otherMode: false;
};
export type TagMissingRequiredTypeOrNamepath = (tag: import('comment-parser').Spec, otherModeMaps: import('./getDefaultTagStructureForMode.js').TagStructure[]) => boolean | {
    otherMode: false;
};
export type IsNamepathX = (tagName: string) => boolean;
export type GetTagStructureForMode = (mde: import('./jsdocUtils.js').ParserMode) => import('./getDefaultTagStructureForMode.js').TagStructure;
export type MayBeUndefinedTypeTag = (tag: import('comment-parser').Spec) => boolean;
export type HasValueOrExecutorHasNonEmptyResolveValue = (anyPromiseAsReturn: boolean, allBranches?: boolean | undefined) => boolean;
export type HasYieldValue = () => boolean;
export type HasYieldReturnValue = () => boolean;
export type HasThrowValue = () => boolean;
export type IsAsync = () => boolean | undefined;
export type GetTags = (tagName: string) => import('comment-parser').Spec[];
export type GetPresentTags = (tagList: string[]) => import('@es-joy/jsdoccomment').JsdocTagWithInline[];
export type FilterTags = (filter: (tag: import('@es-joy/jsdoccomment').JsdocTagWithInline) => boolean) => import('@es-joy/jsdoccomment').JsdocTagWithInline[];
export type FilterAllTags = (filter: (tag: (import('comment-parser').Spec | import('@es-joy/jsdoccomment').JsdocInlineTagNoType)) => boolean) => (import('comment-parser').Spec | import('@es-joy/jsdoccomment').JsdocInlineTagNoType)[];
export type GetTagsByType = (tags: import('comment-parser').Spec[]) => {
    tagsWithNames: import('comment-parser').Spec[];
    tagsWithoutNames: import('comment-parser').Spec[];
};
export type HasOptionTag = (tagName: string) => boolean;
export type GetClassNode = () => Node | null;
export type GetClassJsdoc = () => null | JsdocBlockWithInline;
export type ClassHasTag = (tagName: string) => boolean;
export type FindContext = (contexts: Context[], comment: string | undefined) => {
    foundContext: Context | undefined;
    contextStr: string;
};
export type Utils = BasicUtils & {
    isIteratingFunction: IsIteratingFunction;
    isVirtualFunction: IsVirtualFunction;
    stringify: Stringify;
    reportJSDoc: ReportJSDoc;
    getRegexFromString: GetRegexFromString;
    getTagDescription: GetTagDescription;
    setTagDescription: SetTagDescription;
    getDescription: GetDescription;
    setBlockDescription: SetBlockDescription;
    setDescriptionLines: SetDescriptionLines;
    changeTag: ChangeTag;
    setTag: SetTag;
    removeTag: RemoveTag;
    addTag: AddTag;
    getFirstLine: GetFirstLine;
    seedTokens: SeedTokens;
    emptyTokens: EmptyTokens;
    addLine: AddLine;
    addLines: AddLines;
    makeMultiline: MakeMultiline;
    flattenRoots: import('./jsdocUtils.js').FlattenRoots;
    getFunctionParameterNames: GetFunctionParameterNames;
    hasParams: HasParams;
    isGenerator: IsGenerator;
    isConstructor: IsConstructor;
    getJsdocTagsDeep: GetJsdocTagsDeep;
    getPreferredTagName: GetPreferredTagName;
    isValidTag: IsValidTag;
    hasATag: HasATag;
    hasTag: HasTag;
    comparePaths: ComparePaths;
    dropPathSegmentQuotes: DropPathSegmentQuotes;
    avoidDocs: AvoidDocs;
    tagMightHaveNamePosition: TagMightHaveNamePositionTypePosition;
    tagMightHaveTypePosition: TagMightHaveNamePositionTypePosition;
    tagMustHaveNamePosition: TagMustHave;
    tagMustHaveTypePosition: TagMustHave;
    tagMissingRequiredTypeOrNamepath: TagMissingRequiredTypeOrNamepath;
    isNamepathDefiningTag: IsNamepathX;
    isNamepathReferencingTag: IsNamepathX;
    isNamepathOrUrlReferencingTag: IsNamepathX;
    tagMightHaveNamepath: IsNamepathX;
    getTagStructureForMode: GetTagStructureForMode;
    mayBeUndefinedTypeTag: MayBeUndefinedTypeTag;
    hasValueOrExecutorHasNonEmptyResolveValue: HasValueOrExecutorHasNonEmptyResolveValue;
    hasYieldValue: HasYieldValue;
    hasYieldReturnValue: HasYieldReturnValue;
    hasThrowValue: HasThrowValue;
    isAsync: IsAsync;
    getTags: GetTags;
    getPresentTags: GetPresentTags;
    filterTags: FilterTags;
    filterAllTags: FilterAllTags;
    getTagsByType: GetTagsByType;
    hasOptionTag: HasOptionTag;
    getClassNode: GetClassNode;
    getClassJsdoc: GetClassJsdoc;
    classHasTag: ClassHasTag;
    findContext: FindContext;
};
/**
 * Should use ESLint rule's typing.
 */
export type EslintRuleMeta = import('eslint').Rule.RuleMetaData;
/**
 * A plain object for tracking state as needed by rules across iterations.
 */
export type StateObject = {
    globalTags: {};
    hasDuplicates: {
        [key: string]: boolean;
    };
    selectorMap: {
        [selector: string]: {
            [comment: string]: number;
        };
    };
    hasTag: {
        [key: string]: boolean;
    };
    hasNonComment: number;
    hasNonCommentBeforeTag: {
        [key: string]: number | boolean;
    };
};
/**
 * The Node AST as supplied by the parser.
 */
export type Node = import('eslint').Rule.Node;
export type Report = (message: string, fix?: import("eslint").Rule.ReportFixer | null | undefined, jsdocLoc?: {
    line?: number | undefined;
    column?: number | undefined;
} | (import("comment-parser").Spec & {
    line?: number | undefined;
}) | null | undefined, data?: {
    [key: string]: string;
} | undefined) => void;
export type PreferredTypes = {
    [key: string]: string | false | {
        message: string;
        replacement?: string | false | undefined;
        skipRootChecking?: boolean | undefined;
    };
};
export type StructuredTags = {
    [key: string]: {
        name?: false | "namepath-defining" | "namepath-referencing" | "text" | undefined;
        type?: boolean | string[] | undefined;
        required?: ("name" | "type" | "typeOrNameRequired")[] | undefined;
    };
};
/**
 * Settings from ESLint types.
 */
export type Settings = {
    [name: string]: any;
    maxLines: Integer;
    minLines: Integer;
    tagNamePreference: import('./jsdocUtils.js').TagNamePreference;
    mode: import('./jsdocUtils.js').ParserMode;
    preferredTypes: PreferredTypes;
    structuredTags: StructuredTags;
    contexts?: Context[] | undefined;
};
/**
 * Create the report function
 */
export type MakeReport = (context: import('eslint').Rule.RuleContext, commentNode: import('estree').Node) => Report;
export type JsdocVisitorBasic = (arg: {
    context: import('eslint').Rule.RuleContext;
    sourceCode: import('eslint').SourceCode;
    indent?: string;
    info?: {
        comment?: string | undefined;
        lastIndex?: Integer | undefined;
    };
    state?: StateObject;
    globalState?: Map<string, Map<string, string>>;
    jsdoc?: JsdocBlockWithInline;
    jsdocNode?: import('eslint').Rule.Node & {
        range: [number, number];
    };
    node?: Node;
    allComments?: import('estree').Node[];
    report?: Report;
    makeReport?: MakeReport;
    settings: Settings;
    utils: BasicUtils;
}) => any;
export type JsdocVisitor = (arg: {
    context: import('eslint').Rule.RuleContext;
    sourceCode: import('eslint').SourceCode;
    indent: string;
    info: {
        comment?: string | undefined;
        lastIndex?: Integer | undefined;
    };
    state: StateObject;
    globalState: Map<string, Map<string, string>>;
    jsdoc: JsdocBlockWithInline;
    jsdocNode: import('eslint').Rule.Node & {
        range: [number, number];
    };
    node: Node | null;
    allComments?: import('estree').Node[];
    report: Report;
    makeReport?: MakeReport;
    settings: Settings;
    utils: Utils;
}) => any;
export type NonCommentArgs = {
    node: Node & {
        range: [number, number];
    };
    state: StateObject;
};
export type RuleConfig = {
    /**
     * ESLint rule meta
     */
    meta: EslintRuleMeta;
    /**
     * Any default contexts
     */
    contextDefaults?: import("./jsdocUtils.js").DefaultContexts | undefined;
    /**
     * Whether to force a `contexts` check
     */
    contextSelected?: true | undefined;
    /**
     * Whether to iterate all JSDoc blocks by default
     * regardless of context
     */
    iterateAllJsdocs?: true | undefined;
    /**
     * Whether to check `@private` blocks (normally exempted)
     */
    checkPrivate?: true | undefined;
    /**
     * Whether to check `@internal` blocks (normally exempted)
     */
    checkInternal?: true | undefined;
    /**
     * Whether to iterates over all JSDoc blocks regardless of attachment
     */
    checkFile?: true | undefined;
    /**
     * Whether to avoid relying on settings for global contexts
     */
    nonGlobalSettings?: true | undefined;
    /**
     * Whether to disable the tracking of visited comment nodes (as
     * non-tracked may conduct further actions)
     */
    noTracking?: true | undefined;
    /**
     * Whether the rule expects contexts to be based on a match option
     */
    matchContext?: true | undefined;
    /**
     * Handler to be executed upon exiting iteration of program AST
     */
    exit?: ((args: {
        context: import('eslint').Rule.RuleContext;
        state: StateObject;
        settings: Settings;
        utils: BasicUtils;
    }) => void) | undefined;
    /**
     * Handler to be executed if rule wishes
     * to be supplied nodes without comments
     */
    nonComment?: ((nca: NonCommentArgs) => void) | undefined;
};
/**
 * @typedef {{
 *   [key: string]: false|string|{
 *     message: string,
 *     replacement?: false|string
 *     skipRootChecking?: boolean
 *   }
 * }} PreferredTypes
 */
/**
 * @typedef {{
 *   [key: string]: {
 *     name?: "text"|"namepath-defining"|"namepath-referencing"|false,
 *     type?: boolean|string[],
 *     required?: ("name"|"type"|"typeOrNameRequired")[]
 *   }
 * }} StructuredTags
 */
/**
 * Settings from ESLint types.
 * @typedef {{
 *   maxLines: Integer,
 *   minLines: Integer,
 *   tagNamePreference: import('./jsdocUtils.js').TagNamePreference,
 *   mode: import('./jsdocUtils.js').ParserMode,
 *   preferredTypes: PreferredTypes,
 *   structuredTags: StructuredTags,
 *   [name: string]: any,
 *   contexts?: Context[]
 * }} Settings
 */
/**
 * @param {import('eslint').Rule.RuleContext} context
 * @returns {Settings|false}
 */
export function getSettings(context: import('eslint').Rule.RuleContext): Settings | false;
import { parseComment } from '@es-joy/jsdoccomment';
declare const seedTokens: typeof import("comment-parser/lib/util.js").seedTokens;
/**
 * Should use ESLint rule's typing.
 * @typedef {import('eslint').Rule.RuleMetaData} EslintRuleMeta
 */
/**
 * A plain object for tracking state as needed by rules across iterations.
 * @typedef {{
 *   globalTags: {},
 *   hasDuplicates: {
 *     [key: string]: boolean
 *   },
 *   selectorMap: {
 *     [selector: string]: {
 *       [comment: string]: Integer
 *     }
 *   },
 *   hasTag: {
 *     [key: string]: boolean
 *   },
 *   hasNonComment: number,
 *   hasNonCommentBeforeTag: {
 *     [key: string]: boolean|number
 *   }
 * }} StateObject
 */
/**
 * The Node AST as supplied by the parser.
 * @typedef {import('eslint').Rule.Node} Node
 */
declare const globalState: Map<any, any>;
/**
 * Create the report function
 * @callback MakeReport
 * @param {import('eslint').Rule.RuleContext} context
 * @param {import('estree').Node} commentNode
 * @returns {Report}
 */
/** @type {MakeReport} */
declare const makeReport: MakeReport;
export { parseComment };
//# sourceMappingURL=iterateJsdoc.d.ts.map