"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StartedRabbitMQContainer = exports.RabbitMQContainer = void 0;
const testcontainers_1 = require("testcontainers");
const AMQP_PORT = 5672;
const AMQPS_PORT = 5671;
const HTTPS_PORT = 15671;
const HTTP_PORT = 15672;
const RABBITMQ_DEFAULT_USER = "guest";
const RABBITMQ_DEFAULT_PASS = "guest";
class RabbitMQContainer extends testcontainers_1.GenericContainer {
    constructor(image = "rabbitmq:3.12.11-management-alpine") {
        super(image);
        this.withExposedPorts(AMQP_PORT, AMQPS_PORT, HTTPS_PORT, HTTP_PORT)
            .withEnvironment({
            RABBITMQ_DEFAULT_USER,
            RABBITMQ_DEFAULT_PASS,
        })
            .withWaitStrategy(testcontainers_1.Wait.forLogMessage("Server startup complete"))
            .withStartupTimeout(30000);
    }
    async start() {
        return new StartedRabbitMQContainer(await super.start());
    }
}
exports.RabbitMQContainer = RabbitMQContainer;
class StartedRabbitMQContainer extends testcontainers_1.AbstractStartedContainer {
    constructor(startedTestContainer) {
        super(startedTestContainer);
    }
    getAmqpUrl() {
        return `amqp://${this.getHost()}:${this.getMappedPort(AMQP_PORT)}`;
    }
    getAmqpsUrl() {
        return `amqps://${this.getHost()}:${this.getMappedPort(AMQPS_PORT)}`;
    }
}
exports.StartedRabbitMQContainer = StartedRabbitMQContainer;
//# sourceMappingURL=rabbitmq-container.js.map