"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StartedMSSQLServerContainer = exports.MSSQLServerContainer = void 0;
const testcontainers_1 = require("testcontainers");
const MSSQL_PORT = 1433;
class MSSQLServerContainer extends testcontainers_1.GenericContainer {
    database = "master";
    username = "sa";
    password = "Passw0rd";
    acceptEula = "N";
    message = /.*Recovery is complete.*/;
    constructor(image = "mcr.microsoft.com/mssql/server:2022-CU13-ubuntu-22.04") {
        super(image);
        this.withExposedPorts(MSSQL_PORT).withWaitStrategy(testcontainers_1.Wait.forLogMessage(this.message, 1)).withStartupTimeout(120000);
    }
    acceptLicense() {
        this.acceptEula = "Y";
        return this;
    }
    withDatabase(database) {
        this.database = database;
        return this;
    }
    withPassword(password) {
        this.password = password;
        return this;
    }
    withWaitForMessage(message) {
        this.message = message;
        return this;
    }
    async start() {
        this.withEnvironment({
            ACCEPT_EULA: this.acceptEula,
            MSSQL_SA_PASSWORD: this.password,
            MSSQL_TCP_PORT: String(MSSQL_PORT),
        });
        return new StartedMSSQLServerContainer(await super.start(), this.database, this.username, this.password);
    }
}
exports.MSSQLServerContainer = MSSQLServerContainer;
class StartedMSSQLServerContainer extends testcontainers_1.AbstractStartedContainer {
    database;
    username;
    password;
    constructor(startedTestContainer, database, username, password) {
        super(startedTestContainer);
        this.database = database;
        this.username = username;
        this.password = password;
    }
    getPort() {
        return this.getMappedPort(MSSQL_PORT);
    }
    getDatabase() {
        return this.database;
    }
    getUsername() {
        return this.username;
    }
    getPassword() {
        return this.password;
    }
    /**
     * @param {boolean} secure use secure connection?
     * @returns A connection URI in the form of `Server=<host>,1433;Database=<database>;User Id=<username>;Password=<password>;Encrypt=false`
     */
    getConnectionUri(secure = false) {
        return `Server=${this.getHost()},${this.getPort()};Database=${this.getDatabase()};User Id=${this.getUsername()};Password=${this.getPassword()};Encrypt=${secure}`;
    }
}
exports.StartedMSSQLServerContainer = StartedMSSQLServerContainer;
//# sourceMappingURL=mssqlserver-container.js.map