import { AbstractStartedContainer, GenericContainer, StartedTestContainer } from "testcontainers";
export declare class MSSQLServerContainer extends GenericContainer {
    private database;
    private username;
    private password;
    private acceptEula;
    private message;
    constructor(image?: string);
    acceptLicense(): this;
    withDatabase(database: string): this;
    withPassword(password: string): this;
    withWaitForMessage(message: string | RegExp): this;
    start(): Promise<StartedMSSQLServerContainer>;
}
export declare class StartedMSSQLServerContainer extends AbstractStartedContainer {
    private readonly database;
    private readonly username;
    private readonly password;
    constructor(startedTestContainer: StartedTestContainer, database: string, username: string, password: string);
    getPort(): number;
    getDatabase(): string;
    getUsername(): string;
    getPassword(): string;
    /**
     * @param {boolean} secure use secure connection?
     * @returns A connection URI in the form of `Server=<host>,1433;Database=<database>;User Id=<username>;Password=<password>;Encrypt=false`
     */
    getConnectionUri(secure?: boolean): string;
}
