"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StartedMariaDbContainer = exports.MariaDbContainer = void 0;
const testcontainers_1 = require("testcontainers");
const MARIADB_PORT = 3306;
class MariaDbContainer extends testcontainers_1.GenericContainer {
    database = "test";
    username = "test";
    userPassword = "test";
    rootPassword = "test";
    constructor(image = "mariadb:11.5.2") {
        super(image);
        this.withExposedPorts(MARIADB_PORT).withStartupTimeout(120000);
    }
    withDatabase(database) {
        this.database = database;
        return this;
    }
    withUsername(username) {
        this.username = username;
        return this;
    }
    withRootPassword(rootPassword) {
        this.rootPassword = rootPassword;
        return this;
    }
    withUserPassword(userPassword) {
        this.userPassword = userPassword;
        return this;
    }
    async start() {
        this.withEnvironment({
            MARIADB_DATABASE: this.database,
            MARIADB_ROOT_PASSWORD: this.rootPassword,
            MARIADB_USER: this.username,
            MARIADB_PASSWORD: this.userPassword,
        });
        return new StartedMariaDbContainer(await super.start(), this.database, this.username, this.userPassword, this.rootPassword);
    }
}
exports.MariaDbContainer = MariaDbContainer;
class StartedMariaDbContainer extends testcontainers_1.AbstractStartedContainer {
    database;
    username;
    userPassword;
    rootPassword;
    constructor(startedTestContainer, database, username, userPassword, rootPassword) {
        super(startedTestContainer);
        this.database = database;
        this.username = username;
        this.userPassword = userPassword;
        this.rootPassword = rootPassword;
    }
    getPort() {
        return this.startedTestContainer.getMappedPort(MARIADB_PORT);
    }
    getDatabase() {
        return this.database;
    }
    getUsername() {
        return this.username;
    }
    getUserPassword() {
        return this.userPassword;
    }
    getRootPassword() {
        return this.rootPassword;
    }
    getConnectionUri(isRoot = false) {
        const url = new URL("", "mariadb://");
        url.hostname = this.getHost();
        url.port = this.getPort().toString();
        url.pathname = this.getDatabase();
        url.username = isRoot ? "root" : this.getUsername();
        url.password = isRoot ? this.getRootPassword() : this.getUserPassword();
        return url.toString();
    }
}
exports.StartedMariaDbContainer = StartedMariaDbContainer;
//# sourceMappingURL=mariadb-container.js.map