import { AbstractStartedContainer, GenericContainer, StartedTestContainer } from "testcontainers";
export declare class MariaDbContainer extends GenericContainer {
    private database;
    private username;
    private userPassword;
    private rootPassword;
    constructor(image?: string);
    withDatabase(database: string): this;
    withUsername(username: string): this;
    withRootPassword(rootPassword: string): this;
    withUserPassword(userPassword: string): this;
    start(): Promise<StartedMariaDbContainer>;
}
export declare class StartedMariaDbContainer extends AbstractStartedContainer {
    private readonly database;
    private readonly username;
    private readonly userPassword;
    private readonly rootPassword;
    constructor(startedTestContainer: StartedTestContainer, database: string, username: string, userPassword: string, rootPassword: string);
    getPort(): number;
    getDatabase(): string;
    getUsername(): string;
    getUserPassword(): string;
    getRootPassword(): string;
    getConnectionUri(isRoot?: boolean): string;
}
