"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StartedHiveMQContainer = exports.HiveMQContainer = void 0;
const path_1 = __importDefault(require("path"));
const testcontainers_1 = require("testcontainers");
const START_LOG_MESSAGE_REGEX = /(.*)Started HiveMQ in(.*)/i;
const HIVEMQ_BASE_PATH = "/opt/hivemq";
const MQTT_PORT = 1883;
class HiveMQContainer extends testcontainers_1.GenericContainer {
    constructor(image = "hivemq/hivemq-ce:2023.5") {
        super(image);
        this.withExposedPorts(MQTT_PORT)
            .withWaitStrategy(testcontainers_1.Wait.forLogMessage(START_LOG_MESSAGE_REGEX))
            .withTmpFs({
            [path_1.default.join(HIVEMQ_BASE_PATH, "log")]: "rw",
            [path_1.default.join(HIVEMQ_BASE_PATH, "data")]: "rw",
        })
            .withStartupTimeout(120000);
    }
    async start() {
        return new StartedHiveMQContainer(await super.start());
    }
}
exports.HiveMQContainer = HiveMQContainer;
class StartedHiveMQContainer extends testcontainers_1.AbstractStartedContainer {
    port;
    constructor(startedTestContainer) {
        super(startedTestContainer);
        this.port = startedTestContainer.getMappedPort(MQTT_PORT);
    }
    getPort() {
        return this.port;
    }
    getConnectionString() {
        return `mqtt://${this.getHost()}:${this.getPort()}`;
    }
}
exports.StartedHiveMQContainer = StartedHiveMQContainer;
//# sourceMappingURL=hivemq-container.js.map