import { AuthError } from "./AuthError.js";
/**
 * Error class for MSAL Runtime errors that preserves detailed broker information
 */
export declare class PlatformBrokerError extends AuthError {
    /**
     * Numeric error code from MSAL Runtime
     */
    statusCode: number;
    /**
     * Error tag from MSAL Runtime
     */
    tag: string;
    constructor(errorStatus: string, errorContext: string, errorCode: number, errorTag: number);
}
//# sourceMappingURL=PlatformBrokerError.d.ts.map