/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */

import { SignInContinuationState } from "../../../sign_in/auth_flow/state/SignInContinuationState.js";
import { SIGN_UP_COMPLETED_STATE_TYPE } from "../../../core/auth_flow/AuthFlowStateTypes.js";

/**
 * Represents the state of a sign-up operation that has been completed successfully.
 */
export class SignUpCompletedState extends SignInContinuationState {
    /**
     * The type of the state.
     */
    stateType = SIGN_UP_COMPLETED_STATE_TYPE;
}
