import "./chunk-Q6FN7YAG.js";
import {
  Fragment,
  Teleport,
  Transition,
  computed,
  createBaseVNode,
  createBlock,
  createCommentVNode,
  createElementBlock,
  createSlots,
  createTextVNode,
  createVNode,
  defineComponent,
  getCurrentScope,
  guardReactiveProps,
  inject,
  isRef,
  mergeProps,
  nextTick,
  normalizeClass,
  normalizeProps,
  normalizeStyle,
  onBeforeUpdate,
  onMounted,
  onScopeDispose,
  onUnmounted,
  openBlock,
  provide,
  reactive,
  ref,
  renderList,
  renderSlot,
  resolveDynamicComponent,
  toDisplayString,
  toRef,
  unref,
  useSlots,
  vShow,
  watch,
  withCtx,
  withDirectives,
  withKeys,
  withModifiers
} from "./chunk-55FS5HVF.js";
import "./chunk-LK32TJAX.js";

// node_modules/@babel/runtime/helpers/esm/typeof.js
function _typeof(o) {
  "@babel/helpers - typeof";
  return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(o2) {
    return typeof o2;
  } : function(o2) {
    return o2 && "function" == typeof Symbol && o2.constructor === Symbol && o2 !== Symbol.prototype ? "symbol" : typeof o2;
  }, _typeof(o);
}

// node_modules/date-fns/esm/_lib/toInteger/index.js
function toInteger(dirtyNumber) {
  if (dirtyNumber === null || dirtyNumber === true || dirtyNumber === false) {
    return NaN;
  }
  var number = Number(dirtyNumber);
  if (isNaN(number)) {
    return number;
  }
  return number < 0 ? Math.ceil(number) : Math.floor(number);
}

// node_modules/date-fns/esm/_lib/requiredArgs/index.js
function requiredArgs(required, args) {
  if (args.length < required) {
    throw new TypeError(required + " argument" + (required > 1 ? "s" : "") + " required, but only " + args.length + " present");
  }
}

// node_modules/date-fns/esm/toDate/index.js
function toDate(argument) {
  requiredArgs(1, arguments);
  var argStr = Object.prototype.toString.call(argument);
  if (argument instanceof Date || _typeof(argument) === "object" && argStr === "[object Date]") {
    return new Date(argument.getTime());
  } else if (typeof argument === "number" || argStr === "[object Number]") {
    return new Date(argument);
  } else {
    if ((typeof argument === "string" || argStr === "[object String]") && typeof console !== "undefined") {
      console.warn("Starting with v2.0.0-beta.1 date-fns doesn't accept strings as date arguments. Please use `parseISO` to parse strings. See: https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#string-arguments");
      console.warn(new Error().stack);
    }
    return /* @__PURE__ */ new Date(NaN);
  }
}

// node_modules/date-fns/esm/addDays/index.js
function addDays(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var amount = toInteger(dirtyAmount);
  if (isNaN(amount)) {
    return /* @__PURE__ */ new Date(NaN);
  }
  if (!amount) {
    return date;
  }
  date.setDate(date.getDate() + amount);
  return date;
}

// node_modules/date-fns/esm/addMonths/index.js
function addMonths(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var amount = toInteger(dirtyAmount);
  if (isNaN(amount)) {
    return /* @__PURE__ */ new Date(NaN);
  }
  if (!amount) {
    return date;
  }
  var dayOfMonth = date.getDate();
  var endOfDesiredMonth = new Date(date.getTime());
  endOfDesiredMonth.setMonth(date.getMonth() + amount + 1, 0);
  var daysInMonth = endOfDesiredMonth.getDate();
  if (dayOfMonth >= daysInMonth) {
    return endOfDesiredMonth;
  } else {
    date.setFullYear(endOfDesiredMonth.getFullYear(), endOfDesiredMonth.getMonth(), dayOfMonth);
    return date;
  }
}

// node_modules/date-fns/esm/add/index.js
function add(dirtyDate, duration) {
  requiredArgs(2, arguments);
  if (!duration || _typeof(duration) !== "object") return /* @__PURE__ */ new Date(NaN);
  var years = duration.years ? toInteger(duration.years) : 0;
  var months = duration.months ? toInteger(duration.months) : 0;
  var weeks = duration.weeks ? toInteger(duration.weeks) : 0;
  var days = duration.days ? toInteger(duration.days) : 0;
  var hours = duration.hours ? toInteger(duration.hours) : 0;
  var minutes = duration.minutes ? toInteger(duration.minutes) : 0;
  var seconds = duration.seconds ? toInteger(duration.seconds) : 0;
  var date = toDate(dirtyDate);
  var dateWithMonths = months || years ? addMonths(date, months + years * 12) : date;
  var dateWithDays = days || weeks ? addDays(dateWithMonths, days + weeks * 7) : dateWithMonths;
  var minutesToAdd = minutes + hours * 60;
  var secondsToAdd = seconds + minutesToAdd * 60;
  var msToAdd = secondsToAdd * 1e3;
  var finalDate = new Date(dateWithDays.getTime() + msToAdd);
  return finalDate;
}

// node_modules/date-fns/esm/addMilliseconds/index.js
function addMilliseconds(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var timestamp = toDate(dirtyDate).getTime();
  var amount = toInteger(dirtyAmount);
  return new Date(timestamp + amount);
}

// node_modules/date-fns/esm/_lib/defaultOptions/index.js
var defaultOptions = {};
function getDefaultOptions() {
  return defaultOptions;
}

// node_modules/date-fns/esm/startOfWeek/index.js
function startOfWeek(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var defaultOptions2 = getDefaultOptions();
  var weekStartsOn = toInteger((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  var date = toDate(dirtyDate);
  var day = date.getDay();
  var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
  date.setDate(date.getDate() - diff);
  date.setHours(0, 0, 0, 0);
  return date;
}

// node_modules/date-fns/esm/startOfISOWeek/index.js
function startOfISOWeek(dirtyDate) {
  requiredArgs(1, arguments);
  return startOfWeek(dirtyDate, {
    weekStartsOn: 1
  });
}

// node_modules/date-fns/esm/getISOWeekYear/index.js
function getISOWeekYear(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var year = date.getFullYear();
  var fourthOfJanuaryOfNextYear = /* @__PURE__ */ new Date(0);
  fourthOfJanuaryOfNextYear.setFullYear(year + 1, 0, 4);
  fourthOfJanuaryOfNextYear.setHours(0, 0, 0, 0);
  var startOfNextYear = startOfISOWeek(fourthOfJanuaryOfNextYear);
  var fourthOfJanuaryOfThisYear = /* @__PURE__ */ new Date(0);
  fourthOfJanuaryOfThisYear.setFullYear(year, 0, 4);
  fourthOfJanuaryOfThisYear.setHours(0, 0, 0, 0);
  var startOfThisYear = startOfISOWeek(fourthOfJanuaryOfThisYear);
  if (date.getTime() >= startOfNextYear.getTime()) {
    return year + 1;
  } else if (date.getTime() >= startOfThisYear.getTime()) {
    return year;
  } else {
    return year - 1;
  }
}

// node_modules/date-fns/esm/startOfISOWeekYear/index.js
function startOfISOWeekYear(dirtyDate) {
  requiredArgs(1, arguments);
  var year = getISOWeekYear(dirtyDate);
  var fourthOfJanuary = /* @__PURE__ */ new Date(0);
  fourthOfJanuary.setFullYear(year, 0, 4);
  fourthOfJanuary.setHours(0, 0, 0, 0);
  var date = startOfISOWeek(fourthOfJanuary);
  return date;
}

// node_modules/date-fns/esm/_lib/getTimezoneOffsetInMilliseconds/index.js
function getTimezoneOffsetInMilliseconds(date) {
  var utcDate = new Date(Date.UTC(date.getFullYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds(), date.getMilliseconds()));
  utcDate.setUTCFullYear(date.getFullYear());
  return date.getTime() - utcDate.getTime();
}

// node_modules/date-fns/esm/startOfDay/index.js
function startOfDay(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  date.setHours(0, 0, 0, 0);
  return date;
}

// node_modules/date-fns/esm/differenceInCalendarDays/index.js
var MILLISECONDS_IN_DAY = 864e5;
function differenceInCalendarDays(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var startOfDayLeft = startOfDay(dirtyDateLeft);
  var startOfDayRight = startOfDay(dirtyDateRight);
  var timestampLeft = startOfDayLeft.getTime() - getTimezoneOffsetInMilliseconds(startOfDayLeft);
  var timestampRight = startOfDayRight.getTime() - getTimezoneOffsetInMilliseconds(startOfDayRight);
  return Math.round((timestampLeft - timestampRight) / MILLISECONDS_IN_DAY);
}

// node_modules/date-fns/esm/addYears/index.js
function addYears(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var amount = toInteger(dirtyAmount);
  return addMonths(dirtyDate, amount * 12);
}

// node_modules/date-fns/esm/constants/index.js
var daysInYear = 365.2425;
var maxTime = Math.pow(10, 8) * 24 * 60 * 60 * 1e3;
var millisecondsInMinute = 6e4;
var millisecondsInHour = 36e5;
var millisecondsInSecond = 1e3;
var minTime = -maxTime;
var secondsInHour = 3600;
var secondsInDay = secondsInHour * 24;
var secondsInWeek = secondsInDay * 7;
var secondsInYear = secondsInDay * daysInYear;
var secondsInMonth = secondsInYear / 12;
var secondsInQuarter = secondsInMonth * 3;

// node_modules/date-fns/esm/isDate/index.js
function isDate(value) {
  requiredArgs(1, arguments);
  return value instanceof Date || _typeof(value) === "object" && Object.prototype.toString.call(value) === "[object Date]";
}

// node_modules/date-fns/esm/isValid/index.js
function isValid(dirtyDate) {
  requiredArgs(1, arguments);
  if (!isDate(dirtyDate) && typeof dirtyDate !== "number") {
    return false;
  }
  var date = toDate(dirtyDate);
  return !isNaN(Number(date));
}

// node_modules/date-fns/esm/eachDayOfInterval/index.js
function eachDayOfInterval(dirtyInterval, options) {
  var _options$step;
  requiredArgs(1, arguments);
  var interval = dirtyInterval || {};
  var startDate = toDate(interval.start);
  var endDate = toDate(interval.end);
  var endTime = endDate.getTime();
  if (!(startDate.getTime() <= endTime)) {
    throw new RangeError("Invalid interval");
  }
  var dates = [];
  var currentDate = startDate;
  currentDate.setHours(0, 0, 0, 0);
  var step = Number((_options$step = options === null || options === void 0 ? void 0 : options.step) !== null && _options$step !== void 0 ? _options$step : 1);
  if (step < 1 || isNaN(step)) throw new RangeError("`options.step` must be a number greater than 1");
  while (currentDate.getTime() <= endTime) {
    dates.push(toDate(currentDate));
    currentDate.setDate(currentDate.getDate() + step);
    currentDate.setHours(0, 0, 0, 0);
  }
  return dates;
}

// node_modules/date-fns/esm/endOfWeek/index.js
function endOfWeek(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var defaultOptions2 = getDefaultOptions();
  var weekStartsOn = toInteger((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  var date = toDate(dirtyDate);
  var day = date.getDay();
  var diff = (day < weekStartsOn ? -7 : 0) + 6 - (day - weekStartsOn);
  date.setDate(date.getDate() + diff);
  date.setHours(23, 59, 59, 999);
  return date;
}

// node_modules/date-fns/esm/subMilliseconds/index.js
function subMilliseconds(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var amount = toInteger(dirtyAmount);
  return addMilliseconds(dirtyDate, -amount);
}

// node_modules/date-fns/esm/_lib/getUTCDayOfYear/index.js
var MILLISECONDS_IN_DAY2 = 864e5;
function getUTCDayOfYear(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var timestamp = date.getTime();
  date.setUTCMonth(0, 1);
  date.setUTCHours(0, 0, 0, 0);
  var startOfYearTimestamp = date.getTime();
  var difference = timestamp - startOfYearTimestamp;
  return Math.floor(difference / MILLISECONDS_IN_DAY2) + 1;
}

// node_modules/date-fns/esm/_lib/startOfUTCISOWeek/index.js
function startOfUTCISOWeek(dirtyDate) {
  requiredArgs(1, arguments);
  var weekStartsOn = 1;
  var date = toDate(dirtyDate);
  var day = date.getUTCDay();
  var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
  date.setUTCDate(date.getUTCDate() - diff);
  date.setUTCHours(0, 0, 0, 0);
  return date;
}

// node_modules/date-fns/esm/_lib/getUTCISOWeekYear/index.js
function getUTCISOWeekYear(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var year = date.getUTCFullYear();
  var fourthOfJanuaryOfNextYear = /* @__PURE__ */ new Date(0);
  fourthOfJanuaryOfNextYear.setUTCFullYear(year + 1, 0, 4);
  fourthOfJanuaryOfNextYear.setUTCHours(0, 0, 0, 0);
  var startOfNextYear = startOfUTCISOWeek(fourthOfJanuaryOfNextYear);
  var fourthOfJanuaryOfThisYear = /* @__PURE__ */ new Date(0);
  fourthOfJanuaryOfThisYear.setUTCFullYear(year, 0, 4);
  fourthOfJanuaryOfThisYear.setUTCHours(0, 0, 0, 0);
  var startOfThisYear = startOfUTCISOWeek(fourthOfJanuaryOfThisYear);
  if (date.getTime() >= startOfNextYear.getTime()) {
    return year + 1;
  } else if (date.getTime() >= startOfThisYear.getTime()) {
    return year;
  } else {
    return year - 1;
  }
}

// node_modules/date-fns/esm/_lib/startOfUTCISOWeekYear/index.js
function startOfUTCISOWeekYear(dirtyDate) {
  requiredArgs(1, arguments);
  var year = getUTCISOWeekYear(dirtyDate);
  var fourthOfJanuary = /* @__PURE__ */ new Date(0);
  fourthOfJanuary.setUTCFullYear(year, 0, 4);
  fourthOfJanuary.setUTCHours(0, 0, 0, 0);
  var date = startOfUTCISOWeek(fourthOfJanuary);
  return date;
}

// node_modules/date-fns/esm/_lib/getUTCISOWeek/index.js
var MILLISECONDS_IN_WEEK = 6048e5;
function getUTCISOWeek(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var diff = startOfUTCISOWeek(date).getTime() - startOfUTCISOWeekYear(date).getTime();
  return Math.round(diff / MILLISECONDS_IN_WEEK) + 1;
}

// node_modules/date-fns/esm/_lib/startOfUTCWeek/index.js
function startOfUTCWeek(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var defaultOptions2 = getDefaultOptions();
  var weekStartsOn = toInteger((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  var date = toDate(dirtyDate);
  var day = date.getUTCDay();
  var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
  date.setUTCDate(date.getUTCDate() - diff);
  date.setUTCHours(0, 0, 0, 0);
  return date;
}

// node_modules/date-fns/esm/_lib/getUTCWeekYear/index.js
function getUTCWeekYear(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$firstWeekCon, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var year = date.getUTCFullYear();
  var defaultOptions2 = getDefaultOptions();
  var firstWeekContainsDate = toInteger((_ref = (_ref2 = (_ref3 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref !== void 0 ? _ref : 1);
  if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
    throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
  }
  var firstWeekOfNextYear = /* @__PURE__ */ new Date(0);
  firstWeekOfNextYear.setUTCFullYear(year + 1, 0, firstWeekContainsDate);
  firstWeekOfNextYear.setUTCHours(0, 0, 0, 0);
  var startOfNextYear = startOfUTCWeek(firstWeekOfNextYear, options);
  var firstWeekOfThisYear = /* @__PURE__ */ new Date(0);
  firstWeekOfThisYear.setUTCFullYear(year, 0, firstWeekContainsDate);
  firstWeekOfThisYear.setUTCHours(0, 0, 0, 0);
  var startOfThisYear = startOfUTCWeek(firstWeekOfThisYear, options);
  if (date.getTime() >= startOfNextYear.getTime()) {
    return year + 1;
  } else if (date.getTime() >= startOfThisYear.getTime()) {
    return year;
  } else {
    return year - 1;
  }
}

// node_modules/date-fns/esm/_lib/startOfUTCWeekYear/index.js
function startOfUTCWeekYear(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$firstWeekCon, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var defaultOptions2 = getDefaultOptions();
  var firstWeekContainsDate = toInteger((_ref = (_ref2 = (_ref3 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref !== void 0 ? _ref : 1);
  var year = getUTCWeekYear(dirtyDate, options);
  var firstWeek = /* @__PURE__ */ new Date(0);
  firstWeek.setUTCFullYear(year, 0, firstWeekContainsDate);
  firstWeek.setUTCHours(0, 0, 0, 0);
  var date = startOfUTCWeek(firstWeek, options);
  return date;
}

// node_modules/date-fns/esm/_lib/getUTCWeek/index.js
var MILLISECONDS_IN_WEEK2 = 6048e5;
function getUTCWeek(dirtyDate, options) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var diff = startOfUTCWeek(date, options).getTime() - startOfUTCWeekYear(date, options).getTime();
  return Math.round(diff / MILLISECONDS_IN_WEEK2) + 1;
}

// node_modules/date-fns/esm/_lib/addLeadingZeros/index.js
function addLeadingZeros(number, targetLength) {
  var sign = number < 0 ? "-" : "";
  var output = Math.abs(number).toString();
  while (output.length < targetLength) {
    output = "0" + output;
  }
  return sign + output;
}

// node_modules/date-fns/esm/_lib/format/lightFormatters/index.js
var formatters = {
  // Year
  y: function y(date, token) {
    var signedYear = date.getUTCFullYear();
    var year = signedYear > 0 ? signedYear : 1 - signedYear;
    return addLeadingZeros(token === "yy" ? year % 100 : year, token.length);
  },
  // Month
  M: function M(date, token) {
    var month = date.getUTCMonth();
    return token === "M" ? String(month + 1) : addLeadingZeros(month + 1, 2);
  },
  // Day of the month
  d: function d(date, token) {
    return addLeadingZeros(date.getUTCDate(), token.length);
  },
  // AM or PM
  a: function a(date, token) {
    var dayPeriodEnumValue = date.getUTCHours() / 12 >= 1 ? "pm" : "am";
    switch (token) {
      case "a":
      case "aa":
        return dayPeriodEnumValue.toUpperCase();
      case "aaa":
        return dayPeriodEnumValue;
      case "aaaaa":
        return dayPeriodEnumValue[0];
      case "aaaa":
      default:
        return dayPeriodEnumValue === "am" ? "a.m." : "p.m.";
    }
  },
  // Hour [1-12]
  h: function h(date, token) {
    return addLeadingZeros(date.getUTCHours() % 12 || 12, token.length);
  },
  // Hour [0-23]
  H: function H(date, token) {
    return addLeadingZeros(date.getUTCHours(), token.length);
  },
  // Minute
  m: function m(date, token) {
    return addLeadingZeros(date.getUTCMinutes(), token.length);
  },
  // Second
  s: function s(date, token) {
    return addLeadingZeros(date.getUTCSeconds(), token.length);
  },
  // Fraction of second
  S: function S(date, token) {
    var numberOfDigits = token.length;
    var milliseconds2 = date.getUTCMilliseconds();
    var fractionalSeconds = Math.floor(milliseconds2 * Math.pow(10, numberOfDigits - 3));
    return addLeadingZeros(fractionalSeconds, token.length);
  }
};
var lightFormatters_default = formatters;

// node_modules/date-fns/esm/_lib/format/formatters/index.js
var dayPeriodEnum = {
  am: "am",
  pm: "pm",
  midnight: "midnight",
  noon: "noon",
  morning: "morning",
  afternoon: "afternoon",
  evening: "evening",
  night: "night"
};
var formatters2 = {
  // Era
  G: function G(date, token, localize2) {
    var era = date.getUTCFullYear() > 0 ? 1 : 0;
    switch (token) {
      case "G":
      case "GG":
      case "GGG":
        return localize2.era(era, {
          width: "abbreviated"
        });
      case "GGGGG":
        return localize2.era(era, {
          width: "narrow"
        });
      case "GGGG":
      default:
        return localize2.era(era, {
          width: "wide"
        });
    }
  },
  // Year
  y: function y2(date, token, localize2) {
    if (token === "yo") {
      var signedYear = date.getUTCFullYear();
      var year = signedYear > 0 ? signedYear : 1 - signedYear;
      return localize2.ordinalNumber(year, {
        unit: "year"
      });
    }
    return lightFormatters_default.y(date, token);
  },
  // Local week-numbering year
  Y: function Y(date, token, localize2, options) {
    var signedWeekYear = getUTCWeekYear(date, options);
    var weekYear = signedWeekYear > 0 ? signedWeekYear : 1 - signedWeekYear;
    if (token === "YY") {
      var twoDigitYear = weekYear % 100;
      return addLeadingZeros(twoDigitYear, 2);
    }
    if (token === "Yo") {
      return localize2.ordinalNumber(weekYear, {
        unit: "year"
      });
    }
    return addLeadingZeros(weekYear, token.length);
  },
  // ISO week-numbering year
  R: function R(date, token) {
    var isoWeekYear = getUTCISOWeekYear(date);
    return addLeadingZeros(isoWeekYear, token.length);
  },
  // Extended year. This is a single number designating the year of this calendar system.
  // The main difference between `y` and `u` localizers are B.C. years:
  // | Year | `y` | `u` |
  // |------|-----|-----|
  // | AC 1 |   1 |   1 |
  // | BC 1 |   1 |   0 |
  // | BC 2 |   2 |  -1 |
  // Also `yy` always returns the last two digits of a year,
  // while `uu` pads single digit years to 2 characters and returns other years unchanged.
  u: function u(date, token) {
    var year = date.getUTCFullYear();
    return addLeadingZeros(year, token.length);
  },
  // Quarter
  Q: function Q(date, token, localize2) {
    var quarter = Math.ceil((date.getUTCMonth() + 1) / 3);
    switch (token) {
      case "Q":
        return String(quarter);
      case "QQ":
        return addLeadingZeros(quarter, 2);
      case "Qo":
        return localize2.ordinalNumber(quarter, {
          unit: "quarter"
        });
      case "QQQ":
        return localize2.quarter(quarter, {
          width: "abbreviated",
          context: "formatting"
        });
      case "QQQQQ":
        return localize2.quarter(quarter, {
          width: "narrow",
          context: "formatting"
        });
      case "QQQQ":
      default:
        return localize2.quarter(quarter, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Stand-alone quarter
  q: function q(date, token, localize2) {
    var quarter = Math.ceil((date.getUTCMonth() + 1) / 3);
    switch (token) {
      case "q":
        return String(quarter);
      case "qq":
        return addLeadingZeros(quarter, 2);
      case "qo":
        return localize2.ordinalNumber(quarter, {
          unit: "quarter"
        });
      case "qqq":
        return localize2.quarter(quarter, {
          width: "abbreviated",
          context: "standalone"
        });
      case "qqqqq":
        return localize2.quarter(quarter, {
          width: "narrow",
          context: "standalone"
        });
      case "qqqq":
      default:
        return localize2.quarter(quarter, {
          width: "wide",
          context: "standalone"
        });
    }
  },
  // Month
  M: function M2(date, token, localize2) {
    var month = date.getUTCMonth();
    switch (token) {
      case "M":
      case "MM":
        return lightFormatters_default.M(date, token);
      case "Mo":
        return localize2.ordinalNumber(month + 1, {
          unit: "month"
        });
      case "MMM":
        return localize2.month(month, {
          width: "abbreviated",
          context: "formatting"
        });
      case "MMMMM":
        return localize2.month(month, {
          width: "narrow",
          context: "formatting"
        });
      case "MMMM":
      default:
        return localize2.month(month, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Stand-alone month
  L: function L(date, token, localize2) {
    var month = date.getUTCMonth();
    switch (token) {
      case "L":
        return String(month + 1);
      case "LL":
        return addLeadingZeros(month + 1, 2);
      case "Lo":
        return localize2.ordinalNumber(month + 1, {
          unit: "month"
        });
      case "LLL":
        return localize2.month(month, {
          width: "abbreviated",
          context: "standalone"
        });
      case "LLLLL":
        return localize2.month(month, {
          width: "narrow",
          context: "standalone"
        });
      case "LLLL":
      default:
        return localize2.month(month, {
          width: "wide",
          context: "standalone"
        });
    }
  },
  // Local week of year
  w: function w(date, token, localize2, options) {
    var week = getUTCWeek(date, options);
    if (token === "wo") {
      return localize2.ordinalNumber(week, {
        unit: "week"
      });
    }
    return addLeadingZeros(week, token.length);
  },
  // ISO week of year
  I: function I(date, token, localize2) {
    var isoWeek = getUTCISOWeek(date);
    if (token === "Io") {
      return localize2.ordinalNumber(isoWeek, {
        unit: "week"
      });
    }
    return addLeadingZeros(isoWeek, token.length);
  },
  // Day of the month
  d: function d2(date, token, localize2) {
    if (token === "do") {
      return localize2.ordinalNumber(date.getUTCDate(), {
        unit: "date"
      });
    }
    return lightFormatters_default.d(date, token);
  },
  // Day of year
  D: function D(date, token, localize2) {
    var dayOfYear = getUTCDayOfYear(date);
    if (token === "Do") {
      return localize2.ordinalNumber(dayOfYear, {
        unit: "dayOfYear"
      });
    }
    return addLeadingZeros(dayOfYear, token.length);
  },
  // Day of week
  E: function E(date, token, localize2) {
    var dayOfWeek = date.getUTCDay();
    switch (token) {
      case "E":
      case "EE":
      case "EEE":
        return localize2.day(dayOfWeek, {
          width: "abbreviated",
          context: "formatting"
        });
      case "EEEEE":
        return localize2.day(dayOfWeek, {
          width: "narrow",
          context: "formatting"
        });
      case "EEEEEE":
        return localize2.day(dayOfWeek, {
          width: "short",
          context: "formatting"
        });
      case "EEEE":
      default:
        return localize2.day(dayOfWeek, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Local day of week
  e: function e(date, token, localize2, options) {
    var dayOfWeek = date.getUTCDay();
    var localDayOfWeek = (dayOfWeek - options.weekStartsOn + 8) % 7 || 7;
    switch (token) {
      case "e":
        return String(localDayOfWeek);
      case "ee":
        return addLeadingZeros(localDayOfWeek, 2);
      case "eo":
        return localize2.ordinalNumber(localDayOfWeek, {
          unit: "day"
        });
      case "eee":
        return localize2.day(dayOfWeek, {
          width: "abbreviated",
          context: "formatting"
        });
      case "eeeee":
        return localize2.day(dayOfWeek, {
          width: "narrow",
          context: "formatting"
        });
      case "eeeeee":
        return localize2.day(dayOfWeek, {
          width: "short",
          context: "formatting"
        });
      case "eeee":
      default:
        return localize2.day(dayOfWeek, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Stand-alone local day of week
  c: function c(date, token, localize2, options) {
    var dayOfWeek = date.getUTCDay();
    var localDayOfWeek = (dayOfWeek - options.weekStartsOn + 8) % 7 || 7;
    switch (token) {
      case "c":
        return String(localDayOfWeek);
      case "cc":
        return addLeadingZeros(localDayOfWeek, token.length);
      case "co":
        return localize2.ordinalNumber(localDayOfWeek, {
          unit: "day"
        });
      case "ccc":
        return localize2.day(dayOfWeek, {
          width: "abbreviated",
          context: "standalone"
        });
      case "ccccc":
        return localize2.day(dayOfWeek, {
          width: "narrow",
          context: "standalone"
        });
      case "cccccc":
        return localize2.day(dayOfWeek, {
          width: "short",
          context: "standalone"
        });
      case "cccc":
      default:
        return localize2.day(dayOfWeek, {
          width: "wide",
          context: "standalone"
        });
    }
  },
  // ISO day of week
  i: function i(date, token, localize2) {
    var dayOfWeek = date.getUTCDay();
    var isoDayOfWeek = dayOfWeek === 0 ? 7 : dayOfWeek;
    switch (token) {
      case "i":
        return String(isoDayOfWeek);
      case "ii":
        return addLeadingZeros(isoDayOfWeek, token.length);
      case "io":
        return localize2.ordinalNumber(isoDayOfWeek, {
          unit: "day"
        });
      case "iii":
        return localize2.day(dayOfWeek, {
          width: "abbreviated",
          context: "formatting"
        });
      case "iiiii":
        return localize2.day(dayOfWeek, {
          width: "narrow",
          context: "formatting"
        });
      case "iiiiii":
        return localize2.day(dayOfWeek, {
          width: "short",
          context: "formatting"
        });
      case "iiii":
      default:
        return localize2.day(dayOfWeek, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // AM or PM
  a: function a2(date, token, localize2) {
    var hours = date.getUTCHours();
    var dayPeriodEnumValue = hours / 12 >= 1 ? "pm" : "am";
    switch (token) {
      case "a":
      case "aa":
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        });
      case "aaa":
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        }).toLowerCase();
      case "aaaaa":
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "narrow",
          context: "formatting"
        });
      case "aaaa":
      default:
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // AM, PM, midnight, noon
  b: function b(date, token, localize2) {
    var hours = date.getUTCHours();
    var dayPeriodEnumValue;
    if (hours === 12) {
      dayPeriodEnumValue = dayPeriodEnum.noon;
    } else if (hours === 0) {
      dayPeriodEnumValue = dayPeriodEnum.midnight;
    } else {
      dayPeriodEnumValue = hours / 12 >= 1 ? "pm" : "am";
    }
    switch (token) {
      case "b":
      case "bb":
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        });
      case "bbb":
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        }).toLowerCase();
      case "bbbbb":
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "narrow",
          context: "formatting"
        });
      case "bbbb":
      default:
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // in the morning, in the afternoon, in the evening, at night
  B: function B(date, token, localize2) {
    var hours = date.getUTCHours();
    var dayPeriodEnumValue;
    if (hours >= 17) {
      dayPeriodEnumValue = dayPeriodEnum.evening;
    } else if (hours >= 12) {
      dayPeriodEnumValue = dayPeriodEnum.afternoon;
    } else if (hours >= 4) {
      dayPeriodEnumValue = dayPeriodEnum.morning;
    } else {
      dayPeriodEnumValue = dayPeriodEnum.night;
    }
    switch (token) {
      case "B":
      case "BB":
      case "BBB":
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        });
      case "BBBBB":
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "narrow",
          context: "formatting"
        });
      case "BBBB":
      default:
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Hour [1-12]
  h: function h2(date, token, localize2) {
    if (token === "ho") {
      var hours = date.getUTCHours() % 12;
      if (hours === 0) hours = 12;
      return localize2.ordinalNumber(hours, {
        unit: "hour"
      });
    }
    return lightFormatters_default.h(date, token);
  },
  // Hour [0-23]
  H: function H2(date, token, localize2) {
    if (token === "Ho") {
      return localize2.ordinalNumber(date.getUTCHours(), {
        unit: "hour"
      });
    }
    return lightFormatters_default.H(date, token);
  },
  // Hour [0-11]
  K: function K(date, token, localize2) {
    var hours = date.getUTCHours() % 12;
    if (token === "Ko") {
      return localize2.ordinalNumber(hours, {
        unit: "hour"
      });
    }
    return addLeadingZeros(hours, token.length);
  },
  // Hour [1-24]
  k: function k(date, token, localize2) {
    var hours = date.getUTCHours();
    if (hours === 0) hours = 24;
    if (token === "ko") {
      return localize2.ordinalNumber(hours, {
        unit: "hour"
      });
    }
    return addLeadingZeros(hours, token.length);
  },
  // Minute
  m: function m2(date, token, localize2) {
    if (token === "mo") {
      return localize2.ordinalNumber(date.getUTCMinutes(), {
        unit: "minute"
      });
    }
    return lightFormatters_default.m(date, token);
  },
  // Second
  s: function s2(date, token, localize2) {
    if (token === "so") {
      return localize2.ordinalNumber(date.getUTCSeconds(), {
        unit: "second"
      });
    }
    return lightFormatters_default.s(date, token);
  },
  // Fraction of second
  S: function S2(date, token) {
    return lightFormatters_default.S(date, token);
  },
  // Timezone (ISO-8601. If offset is 0, output is always `'Z'`)
  X: function X(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timezoneOffset = originalDate.getTimezoneOffset();
    if (timezoneOffset === 0) {
      return "Z";
    }
    switch (token) {
      case "X":
        return formatTimezoneWithOptionalMinutes(timezoneOffset);
      case "XXXX":
      case "XX":
        return formatTimezone(timezoneOffset);
      case "XXXXX":
      case "XXX":
      default:
        return formatTimezone(timezoneOffset, ":");
    }
  },
  // Timezone (ISO-8601. If offset is 0, output is `'+00:00'` or equivalent)
  x: function x(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timezoneOffset = originalDate.getTimezoneOffset();
    switch (token) {
      case "x":
        return formatTimezoneWithOptionalMinutes(timezoneOffset);
      case "xxxx":
      case "xx":
        return formatTimezone(timezoneOffset);
      case "xxxxx":
      case "xxx":
      default:
        return formatTimezone(timezoneOffset, ":");
    }
  },
  // Timezone (GMT)
  O: function O(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timezoneOffset = originalDate.getTimezoneOffset();
    switch (token) {
      case "O":
      case "OO":
      case "OOO":
        return "GMT" + formatTimezoneShort(timezoneOffset, ":");
      case "OOOO":
      default:
        return "GMT" + formatTimezone(timezoneOffset, ":");
    }
  },
  // Timezone (specific non-location)
  z: function z(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timezoneOffset = originalDate.getTimezoneOffset();
    switch (token) {
      case "z":
      case "zz":
      case "zzz":
        return "GMT" + formatTimezoneShort(timezoneOffset, ":");
      case "zzzz":
      default:
        return "GMT" + formatTimezone(timezoneOffset, ":");
    }
  },
  // Seconds timestamp
  t: function t(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timestamp = Math.floor(originalDate.getTime() / 1e3);
    return addLeadingZeros(timestamp, token.length);
  },
  // Milliseconds timestamp
  T: function T(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timestamp = originalDate.getTime();
    return addLeadingZeros(timestamp, token.length);
  }
};
function formatTimezoneShort(offset, dirtyDelimiter) {
  var sign = offset > 0 ? "-" : "+";
  var absOffset = Math.abs(offset);
  var hours = Math.floor(absOffset / 60);
  var minutes = absOffset % 60;
  if (minutes === 0) {
    return sign + String(hours);
  }
  var delimiter = dirtyDelimiter || "";
  return sign + String(hours) + delimiter + addLeadingZeros(minutes, 2);
}
function formatTimezoneWithOptionalMinutes(offset, dirtyDelimiter) {
  if (offset % 60 === 0) {
    var sign = offset > 0 ? "-" : "+";
    return sign + addLeadingZeros(Math.abs(offset) / 60, 2);
  }
  return formatTimezone(offset, dirtyDelimiter);
}
function formatTimezone(offset, dirtyDelimiter) {
  var delimiter = dirtyDelimiter || "";
  var sign = offset > 0 ? "-" : "+";
  var absOffset = Math.abs(offset);
  var hours = addLeadingZeros(Math.floor(absOffset / 60), 2);
  var minutes = addLeadingZeros(absOffset % 60, 2);
  return sign + hours + delimiter + minutes;
}
var formatters_default = formatters2;

// node_modules/date-fns/esm/_lib/format/longFormatters/index.js
var dateLongFormatter = function dateLongFormatter2(pattern, formatLong2) {
  switch (pattern) {
    case "P":
      return formatLong2.date({
        width: "short"
      });
    case "PP":
      return formatLong2.date({
        width: "medium"
      });
    case "PPP":
      return formatLong2.date({
        width: "long"
      });
    case "PPPP":
    default:
      return formatLong2.date({
        width: "full"
      });
  }
};
var timeLongFormatter = function timeLongFormatter2(pattern, formatLong2) {
  switch (pattern) {
    case "p":
      return formatLong2.time({
        width: "short"
      });
    case "pp":
      return formatLong2.time({
        width: "medium"
      });
    case "ppp":
      return formatLong2.time({
        width: "long"
      });
    case "pppp":
    default:
      return formatLong2.time({
        width: "full"
      });
  }
};
var dateTimeLongFormatter = function dateTimeLongFormatter2(pattern, formatLong2) {
  var matchResult = pattern.match(/(P+)(p+)?/) || [];
  var datePattern = matchResult[1];
  var timePattern = matchResult[2];
  if (!timePattern) {
    return dateLongFormatter(pattern, formatLong2);
  }
  var dateTimeFormat;
  switch (datePattern) {
    case "P":
      dateTimeFormat = formatLong2.dateTime({
        width: "short"
      });
      break;
    case "PP":
      dateTimeFormat = formatLong2.dateTime({
        width: "medium"
      });
      break;
    case "PPP":
      dateTimeFormat = formatLong2.dateTime({
        width: "long"
      });
      break;
    case "PPPP":
    default:
      dateTimeFormat = formatLong2.dateTime({
        width: "full"
      });
      break;
  }
  return dateTimeFormat.replace("{{date}}", dateLongFormatter(datePattern, formatLong2)).replace("{{time}}", timeLongFormatter(timePattern, formatLong2));
};
var longFormatters = {
  p: timeLongFormatter,
  P: dateTimeLongFormatter
};
var longFormatters_default = longFormatters;

// node_modules/date-fns/esm/_lib/protectedTokens/index.js
var protectedDayOfYearTokens = ["D", "DD"];
var protectedWeekYearTokens = ["YY", "YYYY"];
function isProtectedDayOfYearToken(token) {
  return protectedDayOfYearTokens.indexOf(token) !== -1;
}
function isProtectedWeekYearToken(token) {
  return protectedWeekYearTokens.indexOf(token) !== -1;
}
function throwProtectedError(token, format2, input) {
  if (token === "YYYY") {
    throw new RangeError("Use `yyyy` instead of `YYYY` (in `".concat(format2, "`) for formatting years to the input `").concat(input, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
  } else if (token === "YY") {
    throw new RangeError("Use `yy` instead of `YY` (in `".concat(format2, "`) for formatting years to the input `").concat(input, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
  } else if (token === "D") {
    throw new RangeError("Use `d` instead of `D` (in `".concat(format2, "`) for formatting days of the month to the input `").concat(input, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
  } else if (token === "DD") {
    throw new RangeError("Use `dd` instead of `DD` (in `".concat(format2, "`) for formatting days of the month to the input `").concat(input, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
  }
}

// node_modules/date-fns/esm/locale/en-US/_lib/formatDistance/index.js
var formatDistanceLocale = {
  lessThanXSeconds: {
    one: "less than a second",
    other: "less than {{count}} seconds"
  },
  xSeconds: {
    one: "1 second",
    other: "{{count}} seconds"
  },
  halfAMinute: "half a minute",
  lessThanXMinutes: {
    one: "less than a minute",
    other: "less than {{count}} minutes"
  },
  xMinutes: {
    one: "1 minute",
    other: "{{count}} minutes"
  },
  aboutXHours: {
    one: "about 1 hour",
    other: "about {{count}} hours"
  },
  xHours: {
    one: "1 hour",
    other: "{{count}} hours"
  },
  xDays: {
    one: "1 day",
    other: "{{count}} days"
  },
  aboutXWeeks: {
    one: "about 1 week",
    other: "about {{count}} weeks"
  },
  xWeeks: {
    one: "1 week",
    other: "{{count}} weeks"
  },
  aboutXMonths: {
    one: "about 1 month",
    other: "about {{count}} months"
  },
  xMonths: {
    one: "1 month",
    other: "{{count}} months"
  },
  aboutXYears: {
    one: "about 1 year",
    other: "about {{count}} years"
  },
  xYears: {
    one: "1 year",
    other: "{{count}} years"
  },
  overXYears: {
    one: "over 1 year",
    other: "over {{count}} years"
  },
  almostXYears: {
    one: "almost 1 year",
    other: "almost {{count}} years"
  }
};
var formatDistance = function formatDistance2(token, count, options) {
  var result;
  var tokenValue = formatDistanceLocale[token];
  if (typeof tokenValue === "string") {
    result = tokenValue;
  } else if (count === 1) {
    result = tokenValue.one;
  } else {
    result = tokenValue.other.replace("{{count}}", count.toString());
  }
  if (options !== null && options !== void 0 && options.addSuffix) {
    if (options.comparison && options.comparison > 0) {
      return "in " + result;
    } else {
      return result + " ago";
    }
  }
  return result;
};
var formatDistance_default = formatDistance;

// node_modules/date-fns/esm/locale/_lib/buildFormatLongFn/index.js
function buildFormatLongFn(args) {
  return function() {
    var options = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
    var width = options.width ? String(options.width) : args.defaultWidth;
    var format2 = args.formats[width] || args.formats[args.defaultWidth];
    return format2;
  };
}

// node_modules/date-fns/esm/locale/en-US/_lib/formatLong/index.js
var dateFormats = {
  full: "EEEE, MMMM do, y",
  long: "MMMM do, y",
  medium: "MMM d, y",
  short: "MM/dd/yyyy"
};
var timeFormats = {
  full: "h:mm:ss a zzzz",
  long: "h:mm:ss a z",
  medium: "h:mm:ss a",
  short: "h:mm a"
};
var dateTimeFormats = {
  full: "{{date}} 'at' {{time}}",
  long: "{{date}} 'at' {{time}}",
  medium: "{{date}}, {{time}}",
  short: "{{date}}, {{time}}"
};
var formatLong = {
  date: buildFormatLongFn({
    formats: dateFormats,
    defaultWidth: "full"
  }),
  time: buildFormatLongFn({
    formats: timeFormats,
    defaultWidth: "full"
  }),
  dateTime: buildFormatLongFn({
    formats: dateTimeFormats,
    defaultWidth: "full"
  })
};
var formatLong_default = formatLong;

// node_modules/date-fns/esm/locale/en-US/_lib/formatRelative/index.js
var formatRelativeLocale = {
  lastWeek: "'last' eeee 'at' p",
  yesterday: "'yesterday at' p",
  today: "'today at' p",
  tomorrow: "'tomorrow at' p",
  nextWeek: "eeee 'at' p",
  other: "P"
};
var formatRelative = function formatRelative2(token, _date, _baseDate, _options) {
  return formatRelativeLocale[token];
};
var formatRelative_default = formatRelative;

// node_modules/date-fns/esm/locale/_lib/buildLocalizeFn/index.js
function buildLocalizeFn(args) {
  return function(dirtyIndex, options) {
    var context = options !== null && options !== void 0 && options.context ? String(options.context) : "standalone";
    var valuesArray;
    if (context === "formatting" && args.formattingValues) {
      var defaultWidth = args.defaultFormattingWidth || args.defaultWidth;
      var width = options !== null && options !== void 0 && options.width ? String(options.width) : defaultWidth;
      valuesArray = args.formattingValues[width] || args.formattingValues[defaultWidth];
    } else {
      var _defaultWidth = args.defaultWidth;
      var _width = options !== null && options !== void 0 && options.width ? String(options.width) : args.defaultWidth;
      valuesArray = args.values[_width] || args.values[_defaultWidth];
    }
    var index = args.argumentCallback ? args.argumentCallback(dirtyIndex) : dirtyIndex;
    return valuesArray[index];
  };
}

// node_modules/date-fns/esm/locale/en-US/_lib/localize/index.js
var eraValues = {
  narrow: ["B", "A"],
  abbreviated: ["BC", "AD"],
  wide: ["Before Christ", "Anno Domini"]
};
var quarterValues = {
  narrow: ["1", "2", "3", "4"],
  abbreviated: ["Q1", "Q2", "Q3", "Q4"],
  wide: ["1st quarter", "2nd quarter", "3rd quarter", "4th quarter"]
};
var monthValues = {
  narrow: ["J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"],
  abbreviated: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
  wide: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]
};
var dayValues = {
  narrow: ["S", "M", "T", "W", "T", "F", "S"],
  short: ["Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"],
  abbreviated: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
  wide: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]
};
var dayPeriodValues = {
  narrow: {
    am: "a",
    pm: "p",
    midnight: "mi",
    noon: "n",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night"
  },
  abbreviated: {
    am: "AM",
    pm: "PM",
    midnight: "midnight",
    noon: "noon",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night"
  },
  wide: {
    am: "a.m.",
    pm: "p.m.",
    midnight: "midnight",
    noon: "noon",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night"
  }
};
var formattingDayPeriodValues = {
  narrow: {
    am: "a",
    pm: "p",
    midnight: "mi",
    noon: "n",
    morning: "in the morning",
    afternoon: "in the afternoon",
    evening: "in the evening",
    night: "at night"
  },
  abbreviated: {
    am: "AM",
    pm: "PM",
    midnight: "midnight",
    noon: "noon",
    morning: "in the morning",
    afternoon: "in the afternoon",
    evening: "in the evening",
    night: "at night"
  },
  wide: {
    am: "a.m.",
    pm: "p.m.",
    midnight: "midnight",
    noon: "noon",
    morning: "in the morning",
    afternoon: "in the afternoon",
    evening: "in the evening",
    night: "at night"
  }
};
var ordinalNumber = function ordinalNumber2(dirtyNumber, _options) {
  var number = Number(dirtyNumber);
  var rem100 = number % 100;
  if (rem100 > 20 || rem100 < 10) {
    switch (rem100 % 10) {
      case 1:
        return number + "st";
      case 2:
        return number + "nd";
      case 3:
        return number + "rd";
    }
  }
  return number + "th";
};
var localize = {
  ordinalNumber,
  era: buildLocalizeFn({
    values: eraValues,
    defaultWidth: "wide"
  }),
  quarter: buildLocalizeFn({
    values: quarterValues,
    defaultWidth: "wide",
    argumentCallback: function argumentCallback(quarter) {
      return quarter - 1;
    }
  }),
  month: buildLocalizeFn({
    values: monthValues,
    defaultWidth: "wide"
  }),
  day: buildLocalizeFn({
    values: dayValues,
    defaultWidth: "wide"
  }),
  dayPeriod: buildLocalizeFn({
    values: dayPeriodValues,
    defaultWidth: "wide",
    formattingValues: formattingDayPeriodValues,
    defaultFormattingWidth: "wide"
  })
};
var localize_default = localize;

// node_modules/date-fns/esm/locale/_lib/buildMatchFn/index.js
function buildMatchFn(args) {
  return function(string) {
    var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    var width = options.width;
    var matchPattern = width && args.matchPatterns[width] || args.matchPatterns[args.defaultMatchWidth];
    var matchResult = string.match(matchPattern);
    if (!matchResult) {
      return null;
    }
    var matchedString = matchResult[0];
    var parsePatterns = width && args.parsePatterns[width] || args.parsePatterns[args.defaultParseWidth];
    var key = Array.isArray(parsePatterns) ? findIndex(parsePatterns, function(pattern) {
      return pattern.test(matchedString);
    }) : findKey(parsePatterns, function(pattern) {
      return pattern.test(matchedString);
    });
    var value;
    value = args.valueCallback ? args.valueCallback(key) : key;
    value = options.valueCallback ? options.valueCallback(value) : value;
    var rest = string.slice(matchedString.length);
    return {
      value,
      rest
    };
  };
}
function findKey(object, predicate) {
  for (var key in object) {
    if (object.hasOwnProperty(key) && predicate(object[key])) {
      return key;
    }
  }
  return void 0;
}
function findIndex(array, predicate) {
  for (var key = 0; key < array.length; key++) {
    if (predicate(array[key])) {
      return key;
    }
  }
  return void 0;
}

// node_modules/date-fns/esm/locale/_lib/buildMatchPatternFn/index.js
function buildMatchPatternFn(args) {
  return function(string) {
    var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    var matchResult = string.match(args.matchPattern);
    if (!matchResult) return null;
    var matchedString = matchResult[0];
    var parseResult = string.match(args.parsePattern);
    if (!parseResult) return null;
    var value = args.valueCallback ? args.valueCallback(parseResult[0]) : parseResult[0];
    value = options.valueCallback ? options.valueCallback(value) : value;
    var rest = string.slice(matchedString.length);
    return {
      value,
      rest
    };
  };
}

// node_modules/date-fns/esm/locale/en-US/_lib/match/index.js
var matchOrdinalNumberPattern = /^(\d+)(th|st|nd|rd)?/i;
var parseOrdinalNumberPattern = /\d+/i;
var matchEraPatterns = {
  narrow: /^(b|a)/i,
  abbreviated: /^(b\.?\s?c\.?|b\.?\s?c\.?\s?e\.?|a\.?\s?d\.?|c\.?\s?e\.?)/i,
  wide: /^(before christ|before common era|anno domini|common era)/i
};
var parseEraPatterns = {
  any: [/^b/i, /^(a|c)/i]
};
var matchQuarterPatterns = {
  narrow: /^[1234]/i,
  abbreviated: /^q[1234]/i,
  wide: /^[1234](th|st|nd|rd)? quarter/i
};
var parseQuarterPatterns = {
  any: [/1/i, /2/i, /3/i, /4/i]
};
var matchMonthPatterns = {
  narrow: /^[jfmasond]/i,
  abbreviated: /^(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/i,
  wide: /^(january|february|march|april|may|june|july|august|september|october|november|december)/i
};
var parseMonthPatterns = {
  narrow: [/^j/i, /^f/i, /^m/i, /^a/i, /^m/i, /^j/i, /^j/i, /^a/i, /^s/i, /^o/i, /^n/i, /^d/i],
  any: [/^ja/i, /^f/i, /^mar/i, /^ap/i, /^may/i, /^jun/i, /^jul/i, /^au/i, /^s/i, /^o/i, /^n/i, /^d/i]
};
var matchDayPatterns = {
  narrow: /^[smtwf]/i,
  short: /^(su|mo|tu|we|th|fr|sa)/i,
  abbreviated: /^(sun|mon|tue|wed|thu|fri|sat)/i,
  wide: /^(sunday|monday|tuesday|wednesday|thursday|friday|saturday)/i
};
var parseDayPatterns = {
  narrow: [/^s/i, /^m/i, /^t/i, /^w/i, /^t/i, /^f/i, /^s/i],
  any: [/^su/i, /^m/i, /^tu/i, /^w/i, /^th/i, /^f/i, /^sa/i]
};
var matchDayPeriodPatterns = {
  narrow: /^(a|p|mi|n|(in the|at) (morning|afternoon|evening|night))/i,
  any: /^([ap]\.?\s?m\.?|midnight|noon|(in the|at) (morning|afternoon|evening|night))/i
};
var parseDayPeriodPatterns = {
  any: {
    am: /^a/i,
    pm: /^p/i,
    midnight: /^mi/i,
    noon: /^no/i,
    morning: /morning/i,
    afternoon: /afternoon/i,
    evening: /evening/i,
    night: /night/i
  }
};
var match = {
  ordinalNumber: buildMatchPatternFn({
    matchPattern: matchOrdinalNumberPattern,
    parsePattern: parseOrdinalNumberPattern,
    valueCallback: function valueCallback(value) {
      return parseInt(value, 10);
    }
  }),
  era: buildMatchFn({
    matchPatterns: matchEraPatterns,
    defaultMatchWidth: "wide",
    parsePatterns: parseEraPatterns,
    defaultParseWidth: "any"
  }),
  quarter: buildMatchFn({
    matchPatterns: matchQuarterPatterns,
    defaultMatchWidth: "wide",
    parsePatterns: parseQuarterPatterns,
    defaultParseWidth: "any",
    valueCallback: function valueCallback2(index) {
      return index + 1;
    }
  }),
  month: buildMatchFn({
    matchPatterns: matchMonthPatterns,
    defaultMatchWidth: "wide",
    parsePatterns: parseMonthPatterns,
    defaultParseWidth: "any"
  }),
  day: buildMatchFn({
    matchPatterns: matchDayPatterns,
    defaultMatchWidth: "wide",
    parsePatterns: parseDayPatterns,
    defaultParseWidth: "any"
  }),
  dayPeriod: buildMatchFn({
    matchPatterns: matchDayPeriodPatterns,
    defaultMatchWidth: "any",
    parsePatterns: parseDayPeriodPatterns,
    defaultParseWidth: "any"
  })
};
var match_default = match;

// node_modules/date-fns/esm/locale/en-US/index.js
var locale = {
  code: "en-US",
  formatDistance: formatDistance_default,
  formatLong: formatLong_default,
  formatRelative: formatRelative_default,
  localize: localize_default,
  match: match_default,
  options: {
    weekStartsOn: 0,
    firstWeekContainsDate: 1
  }
};
var en_US_default = locale;

// node_modules/date-fns/esm/_lib/defaultLocale/index.js
var defaultLocale_default = en_US_default;

// node_modules/date-fns/esm/format/index.js
var formattingTokensRegExp = /[yYQqMLwIdDecihHKkms]o|(\w)\1*|''|'(''|[^'])+('|$)|./g;
var longFormattingTokensRegExp = /P+p+|P+|p+|''|'(''|[^'])+('|$)|./g;
var escapedStringRegExp = /^'([^]*?)'?$/;
var doubleQuoteRegExp = /''/g;
var unescapedLatinCharacterRegExp = /[a-zA-Z]/;
function format(dirtyDate, dirtyFormatStr, options) {
  var _ref, _options$locale, _ref2, _ref3, _ref4, _options$firstWeekCon, _options$locale2, _options$locale2$opti, _defaultOptions$local, _defaultOptions$local2, _ref5, _ref6, _ref7, _options$weekStartsOn, _options$locale3, _options$locale3$opti, _defaultOptions$local3, _defaultOptions$local4;
  requiredArgs(2, arguments);
  var formatStr = String(dirtyFormatStr);
  var defaultOptions2 = getDefaultOptions();
  var locale2 = (_ref = (_options$locale = options === null || options === void 0 ? void 0 : options.locale) !== null && _options$locale !== void 0 ? _options$locale : defaultOptions2.locale) !== null && _ref !== void 0 ? _ref : defaultLocale_default;
  var firstWeekContainsDate = toInteger((_ref2 = (_ref3 = (_ref4 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale2 = options.locale) === null || _options$locale2 === void 0 ? void 0 : (_options$locale2$opti = _options$locale2.options) === null || _options$locale2$opti === void 0 ? void 0 : _options$locale2$opti.firstWeekContainsDate) !== null && _ref4 !== void 0 ? _ref4 : defaultOptions2.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : 1);
  if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
    throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
  }
  var weekStartsOn = toInteger((_ref5 = (_ref6 = (_ref7 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale3 = options.locale) === null || _options$locale3 === void 0 ? void 0 : (_options$locale3$opti = _options$locale3.options) === null || _options$locale3$opti === void 0 ? void 0 : _options$locale3$opti.weekStartsOn) !== null && _ref7 !== void 0 ? _ref7 : defaultOptions2.weekStartsOn) !== null && _ref6 !== void 0 ? _ref6 : (_defaultOptions$local3 = defaultOptions2.locale) === null || _defaultOptions$local3 === void 0 ? void 0 : (_defaultOptions$local4 = _defaultOptions$local3.options) === null || _defaultOptions$local4 === void 0 ? void 0 : _defaultOptions$local4.weekStartsOn) !== null && _ref5 !== void 0 ? _ref5 : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  if (!locale2.localize) {
    throw new RangeError("locale must contain localize property");
  }
  if (!locale2.formatLong) {
    throw new RangeError("locale must contain formatLong property");
  }
  var originalDate = toDate(dirtyDate);
  if (!isValid(originalDate)) {
    throw new RangeError("Invalid time value");
  }
  var timezoneOffset = getTimezoneOffsetInMilliseconds(originalDate);
  var utcDate = subMilliseconds(originalDate, timezoneOffset);
  var formatterOptions = {
    firstWeekContainsDate,
    weekStartsOn,
    locale: locale2,
    _originalDate: originalDate
  };
  var result = formatStr.match(longFormattingTokensRegExp).map(function(substring) {
    var firstCharacter = substring[0];
    if (firstCharacter === "p" || firstCharacter === "P") {
      var longFormatter = longFormatters_default[firstCharacter];
      return longFormatter(substring, locale2.formatLong);
    }
    return substring;
  }).join("").match(formattingTokensRegExp).map(function(substring) {
    if (substring === "''") {
      return "'";
    }
    var firstCharacter = substring[0];
    if (firstCharacter === "'") {
      return cleanEscapedString(substring);
    }
    var formatter = formatters_default[firstCharacter];
    if (formatter) {
      if (!(options !== null && options !== void 0 && options.useAdditionalWeekYearTokens) && isProtectedWeekYearToken(substring)) {
        throwProtectedError(substring, dirtyFormatStr, String(dirtyDate));
      }
      if (!(options !== null && options !== void 0 && options.useAdditionalDayOfYearTokens) && isProtectedDayOfYearToken(substring)) {
        throwProtectedError(substring, dirtyFormatStr, String(dirtyDate));
      }
      return formatter(utcDate, substring, locale2.localize, formatterOptions);
    }
    if (firstCharacter.match(unescapedLatinCharacterRegExp)) {
      throw new RangeError("Format string contains an unescaped latin alphabet character `" + firstCharacter + "`");
    }
    return substring;
  }).join("");
  return result;
}
function cleanEscapedString(input) {
  var matched = input.match(escapedStringRegExp);
  if (!matched) {
    return input;
  }
  return matched[1].replace(doubleQuoteRegExp, "'");
}

// node_modules/date-fns/esm/_lib/assign/index.js
function assign(target, object) {
  if (target == null) {
    throw new TypeError("assign requires that input parameter not be null or undefined");
  }
  for (var property in object) {
    if (Object.prototype.hasOwnProperty.call(object, property)) {
      ;
      target[property] = object[property];
    }
  }
  return target;
}

// node_modules/date-fns/esm/formatDistanceStrict/index.js
var MILLISECONDS_IN_MINUTE = 1e3 * 60;
var MINUTES_IN_DAY = 60 * 24;
var MINUTES_IN_MONTH = MINUTES_IN_DAY * 30;
var MINUTES_IN_YEAR = MINUTES_IN_DAY * 365;

// node_modules/date-fns/esm/getDay/index.js
function getDay(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var day = date.getDay();
  return day;
}

// node_modules/date-fns/esm/getDaysInMonth/index.js
function getDaysInMonth(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var year = date.getFullYear();
  var monthIndex = date.getMonth();
  var lastDayOfMonth2 = /* @__PURE__ */ new Date(0);
  lastDayOfMonth2.setFullYear(year, monthIndex + 1, 0);
  lastDayOfMonth2.setHours(0, 0, 0, 0);
  return lastDayOfMonth2.getDate();
}

// node_modules/date-fns/esm/getHours/index.js
function getHours(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var hours = date.getHours();
  return hours;
}

// node_modules/date-fns/esm/getISOWeek/index.js
var MILLISECONDS_IN_WEEK3 = 6048e5;
function getISOWeek(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var diff = startOfISOWeek(date).getTime() - startOfISOWeekYear(date).getTime();
  return Math.round(diff / MILLISECONDS_IN_WEEK3) + 1;
}

// node_modules/date-fns/esm/getMinutes/index.js
function getMinutes(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var minutes = date.getMinutes();
  return minutes;
}

// node_modules/date-fns/esm/getMonth/index.js
function getMonth(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var month = date.getMonth();
  return month;
}

// node_modules/date-fns/esm/getOverlappingDaysInIntervals/index.js
var MILLISECONDS_IN_DAY3 = 24 * 60 * 60 * 1e3;

// node_modules/date-fns/esm/getSeconds/index.js
function getSeconds(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var seconds = date.getSeconds();
  return seconds;
}

// node_modules/date-fns/esm/getYear/index.js
function getYear(dirtyDate) {
  requiredArgs(1, arguments);
  return toDate(dirtyDate).getFullYear();
}

// node_modules/date-fns/esm/isAfter/index.js
function isAfter(dirtyDate, dirtyDateToCompare) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var dateToCompare = toDate(dirtyDateToCompare);
  return date.getTime() > dateToCompare.getTime();
}

// node_modules/date-fns/esm/isBefore/index.js
function isBefore(dirtyDate, dirtyDateToCompare) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var dateToCompare = toDate(dirtyDateToCompare);
  return date.getTime() < dateToCompare.getTime();
}

// node_modules/date-fns/esm/isEqual/index.js
function isEqual(dirtyLeftDate, dirtyRightDate) {
  requiredArgs(2, arguments);
  var dateLeft = toDate(dirtyLeftDate);
  var dateRight = toDate(dirtyRightDate);
  return dateLeft.getTime() === dateRight.getTime();
}

// node_modules/@babel/runtime/helpers/esm/arrayLikeToArray.js
function _arrayLikeToArray(r, a3) {
  (null == a3 || a3 > r.length) && (a3 = r.length);
  for (var e2 = 0, n = Array(a3); e2 < a3; e2++) n[e2] = r[e2];
  return n;
}

// node_modules/@babel/runtime/helpers/esm/unsupportedIterableToArray.js
function _unsupportedIterableToArray(r, a3) {
  if (r) {
    if ("string" == typeof r) return _arrayLikeToArray(r, a3);
    var t2 = {}.toString.call(r).slice(8, -1);
    return "Object" === t2 && r.constructor && (t2 = r.constructor.name), "Map" === t2 || "Set" === t2 ? Array.from(r) : "Arguments" === t2 || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t2) ? _arrayLikeToArray(r, a3) : void 0;
  }
}

// node_modules/@babel/runtime/helpers/esm/createForOfIteratorHelper.js
function _createForOfIteratorHelper(r, e2) {
  var t2 = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"];
  if (!t2) {
    if (Array.isArray(r) || (t2 = _unsupportedIterableToArray(r)) || e2 && r && "number" == typeof r.length) {
      t2 && (r = t2);
      var _n2 = 0, F = function F2() {
      };
      return {
        s: F,
        n: function n() {
          return _n2 >= r.length ? {
            done: true
          } : {
            done: false,
            value: r[_n2++]
          };
        },
        e: function e3(r2) {
          throw r2;
        },
        f: F
      };
    }
    throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  var o, a3 = true, u2 = false;
  return {
    s: function s3() {
      t2 = t2.call(r);
    },
    n: function n() {
      var r2 = t2.next();
      return a3 = r2.done, r2;
    },
    e: function e3(r2) {
      u2 = true, o = r2;
    },
    f: function f() {
      try {
        a3 || null == t2["return"] || t2["return"]();
      } finally {
        if (u2) throw o;
      }
    }
  };
}

// node_modules/@babel/runtime/helpers/esm/assertThisInitialized.js
function _assertThisInitialized(e2) {
  if (void 0 === e2) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  return e2;
}

// node_modules/@babel/runtime/helpers/esm/setPrototypeOf.js
function _setPrototypeOf(t2, e2) {
  return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(t3, e3) {
    return t3.__proto__ = e3, t3;
  }, _setPrototypeOf(t2, e2);
}

// node_modules/@babel/runtime/helpers/esm/inherits.js
function _inherits(t2, e2) {
  if ("function" != typeof e2 && null !== e2) throw new TypeError("Super expression must either be null or a function");
  t2.prototype = Object.create(e2 && e2.prototype, {
    constructor: {
      value: t2,
      writable: true,
      configurable: true
    }
  }), Object.defineProperty(t2, "prototype", {
    writable: false
  }), e2 && _setPrototypeOf(t2, e2);
}

// node_modules/@babel/runtime/helpers/esm/getPrototypeOf.js
function _getPrototypeOf(t2) {
  return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function(t3) {
    return t3.__proto__ || Object.getPrototypeOf(t3);
  }, _getPrototypeOf(t2);
}

// node_modules/@babel/runtime/helpers/esm/isNativeReflectConstruct.js
function _isNativeReflectConstruct() {
  try {
    var t2 = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
  } catch (t3) {
  }
  return (_isNativeReflectConstruct = function _isNativeReflectConstruct2() {
    return !!t2;
  })();
}

// node_modules/@babel/runtime/helpers/esm/possibleConstructorReturn.js
function _possibleConstructorReturn(t2, e2) {
  if (e2 && ("object" == _typeof(e2) || "function" == typeof e2)) return e2;
  if (void 0 !== e2) throw new TypeError("Derived constructors may only return object or undefined");
  return _assertThisInitialized(t2);
}

// node_modules/@babel/runtime/helpers/esm/createSuper.js
function _createSuper(t2) {
  var r = _isNativeReflectConstruct();
  return function() {
    var e2, o = _getPrototypeOf(t2);
    if (r) {
      var s3 = _getPrototypeOf(this).constructor;
      e2 = Reflect.construct(o, arguments, s3);
    } else e2 = o.apply(this, arguments);
    return _possibleConstructorReturn(this, e2);
  };
}

// node_modules/@babel/runtime/helpers/esm/classCallCheck.js
function _classCallCheck(a3, n) {
  if (!(a3 instanceof n)) throw new TypeError("Cannot call a class as a function");
}

// node_modules/@babel/runtime/helpers/esm/toPrimitive.js
function toPrimitive(t2, r) {
  if ("object" != _typeof(t2) || !t2) return t2;
  var e2 = t2[Symbol.toPrimitive];
  if (void 0 !== e2) {
    var i2 = e2.call(t2, r || "default");
    if ("object" != _typeof(i2)) return i2;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return ("string" === r ? String : Number)(t2);
}

// node_modules/@babel/runtime/helpers/esm/toPropertyKey.js
function toPropertyKey(t2) {
  var i2 = toPrimitive(t2, "string");
  return "symbol" == _typeof(i2) ? i2 : i2 + "";
}

// node_modules/@babel/runtime/helpers/esm/createClass.js
function _defineProperties(e2, r) {
  for (var t2 = 0; t2 < r.length; t2++) {
    var o = r[t2];
    o.enumerable = o.enumerable || false, o.configurable = true, "value" in o && (o.writable = true), Object.defineProperty(e2, toPropertyKey(o.key), o);
  }
}
function _createClass(e2, r, t2) {
  return r && _defineProperties(e2.prototype, r), t2 && _defineProperties(e2, t2), Object.defineProperty(e2, "prototype", {
    writable: false
  }), e2;
}

// node_modules/@babel/runtime/helpers/esm/defineProperty.js
function _defineProperty(e2, r, t2) {
  return (r = toPropertyKey(r)) in e2 ? Object.defineProperty(e2, r, {
    value: t2,
    enumerable: true,
    configurable: true,
    writable: true
  }) : e2[r] = t2, e2;
}

// node_modules/date-fns/esm/parse/_lib/Setter.js
var TIMEZONE_UNIT_PRIORITY = 10;
var Setter = function() {
  function Setter2() {
    _classCallCheck(this, Setter2);
    _defineProperty(this, "priority", void 0);
    _defineProperty(this, "subPriority", 0);
  }
  _createClass(Setter2, [{
    key: "validate",
    value: function validate(_utcDate, _options) {
      return true;
    }
  }]);
  return Setter2;
}();
var ValueSetter = function(_Setter) {
  _inherits(ValueSetter2, _Setter);
  var _super = _createSuper(ValueSetter2);
  function ValueSetter2(value, validateValue, setValue, priority, subPriority) {
    var _this;
    _classCallCheck(this, ValueSetter2);
    _this = _super.call(this);
    _this.value = value;
    _this.validateValue = validateValue;
    _this.setValue = setValue;
    _this.priority = priority;
    if (subPriority) {
      _this.subPriority = subPriority;
    }
    return _this;
  }
  _createClass(ValueSetter2, [{
    key: "validate",
    value: function validate(utcDate, options) {
      return this.validateValue(utcDate, this.value, options);
    }
  }, {
    key: "set",
    value: function set2(utcDate, flags, options) {
      return this.setValue(utcDate, flags, this.value, options);
    }
  }]);
  return ValueSetter2;
}(Setter);
var DateToSystemTimezoneSetter = function(_Setter2) {
  _inherits(DateToSystemTimezoneSetter2, _Setter2);
  var _super2 = _createSuper(DateToSystemTimezoneSetter2);
  function DateToSystemTimezoneSetter2() {
    var _this2;
    _classCallCheck(this, DateToSystemTimezoneSetter2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this2 = _super2.call.apply(_super2, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this2), "priority", TIMEZONE_UNIT_PRIORITY);
    _defineProperty(_assertThisInitialized(_this2), "subPriority", -1);
    return _this2;
  }
  _createClass(DateToSystemTimezoneSetter2, [{
    key: "set",
    value: function set2(date, flags) {
      if (flags.timestampIsSet) {
        return date;
      }
      var convertedDate = /* @__PURE__ */ new Date(0);
      convertedDate.setFullYear(date.getUTCFullYear(), date.getUTCMonth(), date.getUTCDate());
      convertedDate.setHours(date.getUTCHours(), date.getUTCMinutes(), date.getUTCSeconds(), date.getUTCMilliseconds());
      return convertedDate;
    }
  }]);
  return DateToSystemTimezoneSetter2;
}(Setter);

// node_modules/date-fns/esm/parse/_lib/Parser.js
var Parser = function() {
  function Parser2() {
    _classCallCheck(this, Parser2);
    _defineProperty(this, "incompatibleTokens", void 0);
    _defineProperty(this, "priority", void 0);
    _defineProperty(this, "subPriority", void 0);
  }
  _createClass(Parser2, [{
    key: "run",
    value: function run(dateString, token, match2, options) {
      var result = this.parse(dateString, token, match2, options);
      if (!result) {
        return null;
      }
      return {
        setter: new ValueSetter(result.value, this.validate, this.set, this.priority, this.subPriority),
        rest: result.rest
      };
    }
  }, {
    key: "validate",
    value: function validate(_utcDate, _value, _options) {
      return true;
    }
  }]);
  return Parser2;
}();

// node_modules/date-fns/esm/parse/_lib/parsers/EraParser.js
var EraParser = function(_Parser) {
  _inherits(EraParser2, _Parser);
  var _super = _createSuper(EraParser2);
  function EraParser2() {
    var _this;
    _classCallCheck(this, EraParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 140);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["R", "u", "t", "T"]);
    return _this;
  }
  _createClass(EraParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "G":
        case "GG":
        case "GGG":
          return match2.era(dateString, {
            width: "abbreviated"
          }) || match2.era(dateString, {
            width: "narrow"
          });
        case "GGGGG":
          return match2.era(dateString, {
            width: "narrow"
          });
        case "GGGG":
        default:
          return match2.era(dateString, {
            width: "wide"
          }) || match2.era(dateString, {
            width: "abbreviated"
          }) || match2.era(dateString, {
            width: "narrow"
          });
      }
    }
  }, {
    key: "set",
    value: function set2(date, flags, value) {
      flags.era = value;
      date.setUTCFullYear(value, 0, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return EraParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/constants.js
var numericPatterns = {
  month: /^(1[0-2]|0?\d)/,
  // 0 to 12
  date: /^(3[0-1]|[0-2]?\d)/,
  // 0 to 31
  dayOfYear: /^(36[0-6]|3[0-5]\d|[0-2]?\d?\d)/,
  // 0 to 366
  week: /^(5[0-3]|[0-4]?\d)/,
  // 0 to 53
  hour23h: /^(2[0-3]|[0-1]?\d)/,
  // 0 to 23
  hour24h: /^(2[0-4]|[0-1]?\d)/,
  // 0 to 24
  hour11h: /^(1[0-1]|0?\d)/,
  // 0 to 11
  hour12h: /^(1[0-2]|0?\d)/,
  // 0 to 12
  minute: /^[0-5]?\d/,
  // 0 to 59
  second: /^[0-5]?\d/,
  // 0 to 59
  singleDigit: /^\d/,
  // 0 to 9
  twoDigits: /^\d{1,2}/,
  // 0 to 99
  threeDigits: /^\d{1,3}/,
  // 0 to 999
  fourDigits: /^\d{1,4}/,
  // 0 to 9999
  anyDigitsSigned: /^-?\d+/,
  singleDigitSigned: /^-?\d/,
  // 0 to 9, -0 to -9
  twoDigitsSigned: /^-?\d{1,2}/,
  // 0 to 99, -0 to -99
  threeDigitsSigned: /^-?\d{1,3}/,
  // 0 to 999, -0 to -999
  fourDigitsSigned: /^-?\d{1,4}/
  // 0 to 9999, -0 to -9999
};
var timezonePatterns = {
  basicOptionalMinutes: /^([+-])(\d{2})(\d{2})?|Z/,
  basic: /^([+-])(\d{2})(\d{2})|Z/,
  basicOptionalSeconds: /^([+-])(\d{2})(\d{2})((\d{2}))?|Z/,
  extended: /^([+-])(\d{2}):(\d{2})|Z/,
  extendedOptionalSeconds: /^([+-])(\d{2}):(\d{2})(:(\d{2}))?|Z/
};

// node_modules/date-fns/esm/parse/_lib/utils.js
function mapValue(parseFnResult, mapFn) {
  if (!parseFnResult) {
    return parseFnResult;
  }
  return {
    value: mapFn(parseFnResult.value),
    rest: parseFnResult.rest
  };
}
function parseNumericPattern(pattern, dateString) {
  var matchResult = dateString.match(pattern);
  if (!matchResult) {
    return null;
  }
  return {
    value: parseInt(matchResult[0], 10),
    rest: dateString.slice(matchResult[0].length)
  };
}
function parseTimezonePattern(pattern, dateString) {
  var matchResult = dateString.match(pattern);
  if (!matchResult) {
    return null;
  }
  if (matchResult[0] === "Z") {
    return {
      value: 0,
      rest: dateString.slice(1)
    };
  }
  var sign = matchResult[1] === "+" ? 1 : -1;
  var hours = matchResult[2] ? parseInt(matchResult[2], 10) : 0;
  var minutes = matchResult[3] ? parseInt(matchResult[3], 10) : 0;
  var seconds = matchResult[5] ? parseInt(matchResult[5], 10) : 0;
  return {
    value: sign * (hours * millisecondsInHour + minutes * millisecondsInMinute + seconds * millisecondsInSecond),
    rest: dateString.slice(matchResult[0].length)
  };
}
function parseAnyDigitsSigned(dateString) {
  return parseNumericPattern(numericPatterns.anyDigitsSigned, dateString);
}
function parseNDigits(n, dateString) {
  switch (n) {
    case 1:
      return parseNumericPattern(numericPatterns.singleDigit, dateString);
    case 2:
      return parseNumericPattern(numericPatterns.twoDigits, dateString);
    case 3:
      return parseNumericPattern(numericPatterns.threeDigits, dateString);
    case 4:
      return parseNumericPattern(numericPatterns.fourDigits, dateString);
    default:
      return parseNumericPattern(new RegExp("^\\d{1," + n + "}"), dateString);
  }
}
function parseNDigitsSigned(n, dateString) {
  switch (n) {
    case 1:
      return parseNumericPattern(numericPatterns.singleDigitSigned, dateString);
    case 2:
      return parseNumericPattern(numericPatterns.twoDigitsSigned, dateString);
    case 3:
      return parseNumericPattern(numericPatterns.threeDigitsSigned, dateString);
    case 4:
      return parseNumericPattern(numericPatterns.fourDigitsSigned, dateString);
    default:
      return parseNumericPattern(new RegExp("^-?\\d{1," + n + "}"), dateString);
  }
}
function dayPeriodEnumToHours(dayPeriod) {
  switch (dayPeriod) {
    case "morning":
      return 4;
    case "evening":
      return 17;
    case "pm":
    case "noon":
    case "afternoon":
      return 12;
    case "am":
    case "midnight":
    case "night":
    default:
      return 0;
  }
}
function normalizeTwoDigitYear(twoDigitYear, currentYear) {
  var isCommonEra = currentYear > 0;
  var absCurrentYear = isCommonEra ? currentYear : 1 - currentYear;
  var result;
  if (absCurrentYear <= 50) {
    result = twoDigitYear || 100;
  } else {
    var rangeEnd = absCurrentYear + 50;
    var rangeEndCentury = Math.floor(rangeEnd / 100) * 100;
    var isPreviousCentury = twoDigitYear >= rangeEnd % 100;
    result = twoDigitYear + rangeEndCentury - (isPreviousCentury ? 100 : 0);
  }
  return isCommonEra ? result : 1 - result;
}
function isLeapYearIndex(year) {
  return year % 400 === 0 || year % 4 === 0 && year % 100 !== 0;
}

// node_modules/date-fns/esm/parse/_lib/parsers/YearParser.js
var YearParser = function(_Parser) {
  _inherits(YearParser2, _Parser);
  var _super = _createSuper(YearParser2);
  function YearParser2() {
    var _this;
    _classCallCheck(this, YearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 130);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["Y", "R", "u", "w", "I", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass(YearParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      var valueCallback3 = function valueCallback4(year) {
        return {
          year,
          isTwoDigitYear: token === "yy"
        };
      };
      switch (token) {
        case "y":
          return mapValue(parseNDigits(4, dateString), valueCallback3);
        case "yo":
          return mapValue(match2.ordinalNumber(dateString, {
            unit: "year"
          }), valueCallback3);
        default:
          return mapValue(parseNDigits(token.length, dateString), valueCallback3);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value.isTwoDigitYear || value.year > 0;
    }
  }, {
    key: "set",
    value: function set2(date, flags, value) {
      var currentYear = date.getUTCFullYear();
      if (value.isTwoDigitYear) {
        var normalizedTwoDigitYear = normalizeTwoDigitYear(value.year, currentYear);
        date.setUTCFullYear(normalizedTwoDigitYear, 0, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      }
      var year = !("era" in flags) || flags.era === 1 ? value.year : 1 - value.year;
      date.setUTCFullYear(year, 0, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return YearParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/LocalWeekYearParser.js
var LocalWeekYearParser = function(_Parser) {
  _inherits(LocalWeekYearParser2, _Parser);
  var _super = _createSuper(LocalWeekYearParser2);
  function LocalWeekYearParser2() {
    var _this;
    _classCallCheck(this, LocalWeekYearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 130);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["y", "R", "u", "Q", "q", "M", "L", "I", "d", "D", "i", "t", "T"]);
    return _this;
  }
  _createClass(LocalWeekYearParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      var valueCallback3 = function valueCallback4(year) {
        return {
          year,
          isTwoDigitYear: token === "YY"
        };
      };
      switch (token) {
        case "Y":
          return mapValue(parseNDigits(4, dateString), valueCallback3);
        case "Yo":
          return mapValue(match2.ordinalNumber(dateString, {
            unit: "year"
          }), valueCallback3);
        default:
          return mapValue(parseNDigits(token.length, dateString), valueCallback3);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value.isTwoDigitYear || value.year > 0;
    }
  }, {
    key: "set",
    value: function set2(date, flags, value, options) {
      var currentYear = getUTCWeekYear(date, options);
      if (value.isTwoDigitYear) {
        var normalizedTwoDigitYear = normalizeTwoDigitYear(value.year, currentYear);
        date.setUTCFullYear(normalizedTwoDigitYear, 0, options.firstWeekContainsDate);
        date.setUTCHours(0, 0, 0, 0);
        return startOfUTCWeek(date, options);
      }
      var year = !("era" in flags) || flags.era === 1 ? value.year : 1 - value.year;
      date.setUTCFullYear(year, 0, options.firstWeekContainsDate);
      date.setUTCHours(0, 0, 0, 0);
      return startOfUTCWeek(date, options);
    }
  }]);
  return LocalWeekYearParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/ISOWeekYearParser.js
var ISOWeekYearParser = function(_Parser) {
  _inherits(ISOWeekYearParser2, _Parser);
  var _super = _createSuper(ISOWeekYearParser2);
  function ISOWeekYearParser2() {
    var _this;
    _classCallCheck(this, ISOWeekYearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 130);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["G", "y", "Y", "u", "Q", "q", "M", "L", "w", "d", "D", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass(ISOWeekYearParser2, [{
    key: "parse",
    value: function parse2(dateString, token) {
      if (token === "R") {
        return parseNDigitsSigned(4, dateString);
      }
      return parseNDigitsSigned(token.length, dateString);
    }
  }, {
    key: "set",
    value: function set2(_date, _flags, value) {
      var firstWeekOfYear = /* @__PURE__ */ new Date(0);
      firstWeekOfYear.setUTCFullYear(value, 0, 4);
      firstWeekOfYear.setUTCHours(0, 0, 0, 0);
      return startOfUTCISOWeek(firstWeekOfYear);
    }
  }]);
  return ISOWeekYearParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/ExtendedYearParser.js
var ExtendedYearParser = function(_Parser) {
  _inherits(ExtendedYearParser2, _Parser);
  var _super = _createSuper(ExtendedYearParser2);
  function ExtendedYearParser2() {
    var _this;
    _classCallCheck(this, ExtendedYearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 130);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["G", "y", "Y", "R", "w", "I", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass(ExtendedYearParser2, [{
    key: "parse",
    value: function parse2(dateString, token) {
      if (token === "u") {
        return parseNDigitsSigned(4, dateString);
      }
      return parseNDigitsSigned(token.length, dateString);
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCFullYear(value, 0, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return ExtendedYearParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/QuarterParser.js
var QuarterParser = function(_Parser) {
  _inherits(QuarterParser2, _Parser);
  var _super = _createSuper(QuarterParser2);
  function QuarterParser2() {
    var _this;
    _classCallCheck(this, QuarterParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 120);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["Y", "R", "q", "M", "L", "w", "I", "d", "D", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass(QuarterParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "Q":
        case "QQ":
          return parseNDigits(token.length, dateString);
        case "Qo":
          return match2.ordinalNumber(dateString, {
            unit: "quarter"
          });
        case "QQQ":
          return match2.quarter(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.quarter(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "QQQQQ":
          return match2.quarter(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "QQQQ":
        default:
          return match2.quarter(dateString, {
            width: "wide",
            context: "formatting"
          }) || match2.quarter(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.quarter(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 4;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCMonth((value - 1) * 3, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return QuarterParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/StandAloneQuarterParser.js
var StandAloneQuarterParser = function(_Parser) {
  _inherits(StandAloneQuarterParser2, _Parser);
  var _super = _createSuper(StandAloneQuarterParser2);
  function StandAloneQuarterParser2() {
    var _this;
    _classCallCheck(this, StandAloneQuarterParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 120);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["Y", "R", "Q", "M", "L", "w", "I", "d", "D", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass(StandAloneQuarterParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "q":
        case "qq":
          return parseNDigits(token.length, dateString);
        case "qo":
          return match2.ordinalNumber(dateString, {
            unit: "quarter"
          });
        case "qqq":
          return match2.quarter(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match2.quarter(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "qqqqq":
          return match2.quarter(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "qqqq":
        default:
          return match2.quarter(dateString, {
            width: "wide",
            context: "standalone"
          }) || match2.quarter(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match2.quarter(dateString, {
            width: "narrow",
            context: "standalone"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 4;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCMonth((value - 1) * 3, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return StandAloneQuarterParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/MonthParser.js
var MonthParser = function(_Parser) {
  _inherits(MonthParser2, _Parser);
  var _super = _createSuper(MonthParser2);
  function MonthParser2() {
    var _this;
    _classCallCheck(this, MonthParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["Y", "R", "q", "Q", "L", "w", "I", "D", "i", "e", "c", "t", "T"]);
    _defineProperty(_assertThisInitialized(_this), "priority", 110);
    return _this;
  }
  _createClass(MonthParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      var valueCallback3 = function valueCallback4(value) {
        return value - 1;
      };
      switch (token) {
        case "M":
          return mapValue(parseNumericPattern(numericPatterns.month, dateString), valueCallback3);
        case "MM":
          return mapValue(parseNDigits(2, dateString), valueCallback3);
        case "Mo":
          return mapValue(match2.ordinalNumber(dateString, {
            unit: "month"
          }), valueCallback3);
        case "MMM":
          return match2.month(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.month(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "MMMMM":
          return match2.month(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "MMMM":
        default:
          return match2.month(dateString, {
            width: "wide",
            context: "formatting"
          }) || match2.month(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.month(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 11;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCMonth(value, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return MonthParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/StandAloneMonthParser.js
var StandAloneMonthParser = function(_Parser) {
  _inherits(StandAloneMonthParser2, _Parser);
  var _super = _createSuper(StandAloneMonthParser2);
  function StandAloneMonthParser2() {
    var _this;
    _classCallCheck(this, StandAloneMonthParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 110);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["Y", "R", "q", "Q", "M", "w", "I", "D", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass(StandAloneMonthParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      var valueCallback3 = function valueCallback4(value) {
        return value - 1;
      };
      switch (token) {
        case "L":
          return mapValue(parseNumericPattern(numericPatterns.month, dateString), valueCallback3);
        case "LL":
          return mapValue(parseNDigits(2, dateString), valueCallback3);
        case "Lo":
          return mapValue(match2.ordinalNumber(dateString, {
            unit: "month"
          }), valueCallback3);
        case "LLL":
          return match2.month(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match2.month(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "LLLLL":
          return match2.month(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "LLLL":
        default:
          return match2.month(dateString, {
            width: "wide",
            context: "standalone"
          }) || match2.month(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match2.month(dateString, {
            width: "narrow",
            context: "standalone"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 11;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCMonth(value, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return StandAloneMonthParser2;
}(Parser);

// node_modules/date-fns/esm/_lib/setUTCWeek/index.js
function setUTCWeek(dirtyDate, dirtyWeek, options) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var week = toInteger(dirtyWeek);
  var diff = getUTCWeek(date, options) - week;
  date.setUTCDate(date.getUTCDate() - diff * 7);
  return date;
}

// node_modules/date-fns/esm/parse/_lib/parsers/LocalWeekParser.js
var LocalWeekParser = function(_Parser) {
  _inherits(LocalWeekParser2, _Parser);
  var _super = _createSuper(LocalWeekParser2);
  function LocalWeekParser2() {
    var _this;
    _classCallCheck(this, LocalWeekParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 100);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["y", "R", "u", "q", "Q", "M", "L", "I", "d", "D", "i", "t", "T"]);
    return _this;
  }
  _createClass(LocalWeekParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "w":
          return parseNumericPattern(numericPatterns.week, dateString);
        case "wo":
          return match2.ordinalNumber(dateString, {
            unit: "week"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 53;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value, options) {
      return startOfUTCWeek(setUTCWeek(date, value, options), options);
    }
  }]);
  return LocalWeekParser2;
}(Parser);

// node_modules/date-fns/esm/_lib/setUTCISOWeek/index.js
function setUTCISOWeek(dirtyDate, dirtyISOWeek) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var isoWeek = toInteger(dirtyISOWeek);
  var diff = getUTCISOWeek(date) - isoWeek;
  date.setUTCDate(date.getUTCDate() - diff * 7);
  return date;
}

// node_modules/date-fns/esm/parse/_lib/parsers/ISOWeekParser.js
var ISOWeekParser = function(_Parser) {
  _inherits(ISOWeekParser2, _Parser);
  var _super = _createSuper(ISOWeekParser2);
  function ISOWeekParser2() {
    var _this;
    _classCallCheck(this, ISOWeekParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 100);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["y", "Y", "u", "q", "Q", "M", "L", "w", "d", "D", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass(ISOWeekParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "I":
          return parseNumericPattern(numericPatterns.week, dateString);
        case "Io":
          return match2.ordinalNumber(dateString, {
            unit: "week"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 53;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      return startOfUTCISOWeek(setUTCISOWeek(date, value));
    }
  }]);
  return ISOWeekParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/DateParser.js
var DAYS_IN_MONTH = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
var DAYS_IN_MONTH_LEAP_YEAR = [31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
var DateParser = function(_Parser) {
  _inherits(DateParser2, _Parser);
  var _super = _createSuper(DateParser2);
  function DateParser2() {
    var _this;
    _classCallCheck(this, DateParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 90);
    _defineProperty(_assertThisInitialized(_this), "subPriority", 1);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["Y", "R", "q", "Q", "w", "I", "D", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass(DateParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "d":
          return parseNumericPattern(numericPatterns.date, dateString);
        case "do":
          return match2.ordinalNumber(dateString, {
            unit: "date"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(date, value) {
      var year = date.getUTCFullYear();
      var isLeapYear2 = isLeapYearIndex(year);
      var month = date.getUTCMonth();
      if (isLeapYear2) {
        return value >= 1 && value <= DAYS_IN_MONTH_LEAP_YEAR[month];
      } else {
        return value >= 1 && value <= DAYS_IN_MONTH[month];
      }
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCDate(value);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return DateParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/DayOfYearParser.js
var DayOfYearParser = function(_Parser) {
  _inherits(DayOfYearParser2, _Parser);
  var _super = _createSuper(DayOfYearParser2);
  function DayOfYearParser2() {
    var _this;
    _classCallCheck(this, DayOfYearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 90);
    _defineProperty(_assertThisInitialized(_this), "subpriority", 1);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["Y", "R", "q", "Q", "M", "L", "w", "I", "d", "E", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass(DayOfYearParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "D":
        case "DD":
          return parseNumericPattern(numericPatterns.dayOfYear, dateString);
        case "Do":
          return match2.ordinalNumber(dateString, {
            unit: "date"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(date, value) {
      var year = date.getUTCFullYear();
      var isLeapYear2 = isLeapYearIndex(year);
      if (isLeapYear2) {
        return value >= 1 && value <= 366;
      } else {
        return value >= 1 && value <= 365;
      }
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCMonth(0, value);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return DayOfYearParser2;
}(Parser);

// node_modules/date-fns/esm/_lib/setUTCDay/index.js
function setUTCDay(dirtyDate, dirtyDay, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(2, arguments);
  var defaultOptions2 = getDefaultOptions();
  var weekStartsOn = toInteger((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  var date = toDate(dirtyDate);
  var day = toInteger(dirtyDay);
  var currentDay = date.getUTCDay();
  var remainder = day % 7;
  var dayIndex = (remainder + 7) % 7;
  var diff = (dayIndex < weekStartsOn ? 7 : 0) + day - currentDay;
  date.setUTCDate(date.getUTCDate() + diff);
  return date;
}

// node_modules/date-fns/esm/parse/_lib/parsers/DayParser.js
var DayParser = function(_Parser) {
  _inherits(DayParser2, _Parser);
  var _super = _createSuper(DayParser2);
  function DayParser2() {
    var _this;
    _classCallCheck(this, DayParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 90);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["D", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass(DayParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "E":
        case "EE":
        case "EEE":
          return match2.day(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "EEEEE":
          return match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "EEEEEE":
          return match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "EEEE":
        default:
          return match2.day(dateString, {
            width: "wide",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 6;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value, options) {
      date = setUTCDay(date, value, options);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return DayParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/LocalDayParser.js
var LocalDayParser = function(_Parser) {
  _inherits(LocalDayParser2, _Parser);
  var _super = _createSuper(LocalDayParser2);
  function LocalDayParser2() {
    var _this;
    _classCallCheck(this, LocalDayParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 90);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["y", "R", "u", "q", "Q", "M", "L", "I", "d", "D", "E", "i", "c", "t", "T"]);
    return _this;
  }
  _createClass(LocalDayParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2, options) {
      var valueCallback3 = function valueCallback4(value) {
        var wholeWeekDays = Math.floor((value - 1) / 7) * 7;
        return (value + options.weekStartsOn + 6) % 7 + wholeWeekDays;
      };
      switch (token) {
        case "e":
        case "ee":
          return mapValue(parseNDigits(token.length, dateString), valueCallback3);
        case "eo":
          return mapValue(match2.ordinalNumber(dateString, {
            unit: "day"
          }), valueCallback3);
        case "eee":
          return match2.day(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "eeeee":
          return match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "eeeeee":
          return match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "eeee":
        default:
          return match2.day(dateString, {
            width: "wide",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 6;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value, options) {
      date = setUTCDay(date, value, options);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return LocalDayParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/StandAloneLocalDayParser.js
var StandAloneLocalDayParser = function(_Parser) {
  _inherits(StandAloneLocalDayParser2, _Parser);
  var _super = _createSuper(StandAloneLocalDayParser2);
  function StandAloneLocalDayParser2() {
    var _this;
    _classCallCheck(this, StandAloneLocalDayParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 90);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["y", "R", "u", "q", "Q", "M", "L", "I", "d", "D", "E", "i", "e", "t", "T"]);
    return _this;
  }
  _createClass(StandAloneLocalDayParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2, options) {
      var valueCallback3 = function valueCallback4(value) {
        var wholeWeekDays = Math.floor((value - 1) / 7) * 7;
        return (value + options.weekStartsOn + 6) % 7 + wholeWeekDays;
      };
      switch (token) {
        case "c":
        case "cc":
          return mapValue(parseNDigits(token.length, dateString), valueCallback3);
        case "co":
          return mapValue(match2.ordinalNumber(dateString, {
            unit: "day"
          }), valueCallback3);
        case "ccc":
          return match2.day(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match2.day(dateString, {
            width: "short",
            context: "standalone"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "ccccc":
          return match2.day(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "cccccc":
          return match2.day(dateString, {
            width: "short",
            context: "standalone"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "cccc":
        default:
          return match2.day(dateString, {
            width: "wide",
            context: "standalone"
          }) || match2.day(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match2.day(dateString, {
            width: "short",
            context: "standalone"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "standalone"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 6;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value, options) {
      date = setUTCDay(date, value, options);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return StandAloneLocalDayParser2;
}(Parser);

// node_modules/date-fns/esm/_lib/setUTCISODay/index.js
function setUTCISODay(dirtyDate, dirtyDay) {
  requiredArgs(2, arguments);
  var day = toInteger(dirtyDay);
  if (day % 7 === 0) {
    day = day - 7;
  }
  var weekStartsOn = 1;
  var date = toDate(dirtyDate);
  var currentDay = date.getUTCDay();
  var remainder = day % 7;
  var dayIndex = (remainder + 7) % 7;
  var diff = (dayIndex < weekStartsOn ? 7 : 0) + day - currentDay;
  date.setUTCDate(date.getUTCDate() + diff);
  return date;
}

// node_modules/date-fns/esm/parse/_lib/parsers/ISODayParser.js
var ISODayParser = function(_Parser) {
  _inherits(ISODayParser2, _Parser);
  var _super = _createSuper(ISODayParser2);
  function ISODayParser2() {
    var _this;
    _classCallCheck(this, ISODayParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 90);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["y", "Y", "u", "q", "Q", "M", "L", "w", "d", "D", "E", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass(ISODayParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      var valueCallback3 = function valueCallback4(value) {
        if (value === 0) {
          return 7;
        }
        return value;
      };
      switch (token) {
        case "i":
        case "ii":
          return parseNDigits(token.length, dateString);
        case "io":
          return match2.ordinalNumber(dateString, {
            unit: "day"
          });
        case "iii":
          return mapValue(match2.day(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          }), valueCallback3);
        case "iiiii":
          return mapValue(match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          }), valueCallback3);
        case "iiiiii":
          return mapValue(match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          }), valueCallback3);
        case "iiii":
        default:
          return mapValue(match2.day(dateString, {
            width: "wide",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          }), valueCallback3);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 7;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date = setUTCISODay(date, value);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return ISODayParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/AMPMParser.js
var AMPMParser = function(_Parser) {
  _inherits(AMPMParser2, _Parser);
  var _super = _createSuper(AMPMParser2);
  function AMPMParser2() {
    var _this;
    _classCallCheck(this, AMPMParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 80);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["b", "B", "H", "k", "t", "T"]);
    return _this;
  }
  _createClass(AMPMParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "a":
        case "aa":
        case "aaa":
          return match2.dayPeriod(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "aaaaa":
          return match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "aaaa":
        default:
          return match2.dayPeriod(dateString, {
            width: "wide",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCHours(dayPeriodEnumToHours(value), 0, 0, 0);
      return date;
    }
  }]);
  return AMPMParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/AMPMMidnightParser.js
var AMPMMidnightParser = function(_Parser) {
  _inherits(AMPMMidnightParser2, _Parser);
  var _super = _createSuper(AMPMMidnightParser2);
  function AMPMMidnightParser2() {
    var _this;
    _classCallCheck(this, AMPMMidnightParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 80);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["a", "B", "H", "k", "t", "T"]);
    return _this;
  }
  _createClass(AMPMMidnightParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "b":
        case "bb":
        case "bbb":
          return match2.dayPeriod(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "bbbbb":
          return match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "bbbb":
        default:
          return match2.dayPeriod(dateString, {
            width: "wide",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCHours(dayPeriodEnumToHours(value), 0, 0, 0);
      return date;
    }
  }]);
  return AMPMMidnightParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/DayPeriodParser.js
var DayPeriodParser = function(_Parser) {
  _inherits(DayPeriodParser2, _Parser);
  var _super = _createSuper(DayPeriodParser2);
  function DayPeriodParser2() {
    var _this;
    _classCallCheck(this, DayPeriodParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 80);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["a", "b", "t", "T"]);
    return _this;
  }
  _createClass(DayPeriodParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "B":
        case "BB":
        case "BBB":
          return match2.dayPeriod(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "BBBBB":
          return match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "BBBB":
        default:
          return match2.dayPeriod(dateString, {
            width: "wide",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCHours(dayPeriodEnumToHours(value), 0, 0, 0);
      return date;
    }
  }]);
  return DayPeriodParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/Hour1to12Parser.js
var Hour1to12Parser = function(_Parser) {
  _inherits(Hour1to12Parser2, _Parser);
  var _super = _createSuper(Hour1to12Parser2);
  function Hour1to12Parser2() {
    var _this;
    _classCallCheck(this, Hour1to12Parser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 70);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["H", "K", "k", "t", "T"]);
    return _this;
  }
  _createClass(Hour1to12Parser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "h":
          return parseNumericPattern(numericPatterns.hour12h, dateString);
        case "ho":
          return match2.ordinalNumber(dateString, {
            unit: "hour"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 12;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      var isPM = date.getUTCHours() >= 12;
      if (isPM && value < 12) {
        date.setUTCHours(value + 12, 0, 0, 0);
      } else if (!isPM && value === 12) {
        date.setUTCHours(0, 0, 0, 0);
      } else {
        date.setUTCHours(value, 0, 0, 0);
      }
      return date;
    }
  }]);
  return Hour1to12Parser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/Hour0to23Parser.js
var Hour0to23Parser = function(_Parser) {
  _inherits(Hour0to23Parser2, _Parser);
  var _super = _createSuper(Hour0to23Parser2);
  function Hour0to23Parser2() {
    var _this;
    _classCallCheck(this, Hour0to23Parser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 70);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["a", "b", "h", "K", "k", "t", "T"]);
    return _this;
  }
  _createClass(Hour0to23Parser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "H":
          return parseNumericPattern(numericPatterns.hour23h, dateString);
        case "Ho":
          return match2.ordinalNumber(dateString, {
            unit: "hour"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 23;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCHours(value, 0, 0, 0);
      return date;
    }
  }]);
  return Hour0to23Parser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/Hour0To11Parser.js
var Hour0To11Parser = function(_Parser) {
  _inherits(Hour0To11Parser2, _Parser);
  var _super = _createSuper(Hour0To11Parser2);
  function Hour0To11Parser2() {
    var _this;
    _classCallCheck(this, Hour0To11Parser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 70);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["h", "H", "k", "t", "T"]);
    return _this;
  }
  _createClass(Hour0To11Parser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "K":
          return parseNumericPattern(numericPatterns.hour11h, dateString);
        case "Ko":
          return match2.ordinalNumber(dateString, {
            unit: "hour"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 11;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      var isPM = date.getUTCHours() >= 12;
      if (isPM && value < 12) {
        date.setUTCHours(value + 12, 0, 0, 0);
      } else {
        date.setUTCHours(value, 0, 0, 0);
      }
      return date;
    }
  }]);
  return Hour0To11Parser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/Hour1To24Parser.js
var Hour1To24Parser = function(_Parser) {
  _inherits(Hour1To24Parser2, _Parser);
  var _super = _createSuper(Hour1To24Parser2);
  function Hour1To24Parser2() {
    var _this;
    _classCallCheck(this, Hour1To24Parser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 70);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["a", "b", "h", "H", "K", "t", "T"]);
    return _this;
  }
  _createClass(Hour1To24Parser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "k":
          return parseNumericPattern(numericPatterns.hour24h, dateString);
        case "ko":
          return match2.ordinalNumber(dateString, {
            unit: "hour"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 24;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      var hours = value <= 24 ? value % 24 : value;
      date.setUTCHours(hours, 0, 0, 0);
      return date;
    }
  }]);
  return Hour1To24Parser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/MinuteParser.js
var MinuteParser = function(_Parser) {
  _inherits(MinuteParser2, _Parser);
  var _super = _createSuper(MinuteParser2);
  function MinuteParser2() {
    var _this;
    _classCallCheck(this, MinuteParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 60);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["t", "T"]);
    return _this;
  }
  _createClass(MinuteParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "m":
          return parseNumericPattern(numericPatterns.minute, dateString);
        case "mo":
          return match2.ordinalNumber(dateString, {
            unit: "minute"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 59;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCMinutes(value, 0, 0);
      return date;
    }
  }]);
  return MinuteParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/SecondParser.js
var SecondParser = function(_Parser) {
  _inherits(SecondParser2, _Parser);
  var _super = _createSuper(SecondParser2);
  function SecondParser2() {
    var _this;
    _classCallCheck(this, SecondParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 50);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["t", "T"]);
    return _this;
  }
  _createClass(SecondParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "s":
          return parseNumericPattern(numericPatterns.second, dateString);
        case "so":
          return match2.ordinalNumber(dateString, {
            unit: "second"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 59;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCSeconds(value, 0);
      return date;
    }
  }]);
  return SecondParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/FractionOfSecondParser.js
var FractionOfSecondParser = function(_Parser) {
  _inherits(FractionOfSecondParser2, _Parser);
  var _super = _createSuper(FractionOfSecondParser2);
  function FractionOfSecondParser2() {
    var _this;
    _classCallCheck(this, FractionOfSecondParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 30);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["t", "T"]);
    return _this;
  }
  _createClass(FractionOfSecondParser2, [{
    key: "parse",
    value: function parse2(dateString, token) {
      var valueCallback3 = function valueCallback4(value) {
        return Math.floor(value * Math.pow(10, -token.length + 3));
      };
      return mapValue(parseNDigits(token.length, dateString), valueCallback3);
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCMilliseconds(value);
      return date;
    }
  }]);
  return FractionOfSecondParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/ISOTimezoneWithZParser.js
var ISOTimezoneWithZParser = function(_Parser) {
  _inherits(ISOTimezoneWithZParser2, _Parser);
  var _super = _createSuper(ISOTimezoneWithZParser2);
  function ISOTimezoneWithZParser2() {
    var _this;
    _classCallCheck(this, ISOTimezoneWithZParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 10);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["t", "T", "x"]);
    return _this;
  }
  _createClass(ISOTimezoneWithZParser2, [{
    key: "parse",
    value: function parse2(dateString, token) {
      switch (token) {
        case "X":
          return parseTimezonePattern(timezonePatterns.basicOptionalMinutes, dateString);
        case "XX":
          return parseTimezonePattern(timezonePatterns.basic, dateString);
        case "XXXX":
          return parseTimezonePattern(timezonePatterns.basicOptionalSeconds, dateString);
        case "XXXXX":
          return parseTimezonePattern(timezonePatterns.extendedOptionalSeconds, dateString);
        case "XXX":
        default:
          return parseTimezonePattern(timezonePatterns.extended, dateString);
      }
    }
  }, {
    key: "set",
    value: function set2(date, flags, value) {
      if (flags.timestampIsSet) {
        return date;
      }
      return new Date(date.getTime() - value);
    }
  }]);
  return ISOTimezoneWithZParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/ISOTimezoneParser.js
var ISOTimezoneParser = function(_Parser) {
  _inherits(ISOTimezoneParser2, _Parser);
  var _super = _createSuper(ISOTimezoneParser2);
  function ISOTimezoneParser2() {
    var _this;
    _classCallCheck(this, ISOTimezoneParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 10);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["t", "T", "X"]);
    return _this;
  }
  _createClass(ISOTimezoneParser2, [{
    key: "parse",
    value: function parse2(dateString, token) {
      switch (token) {
        case "x":
          return parseTimezonePattern(timezonePatterns.basicOptionalMinutes, dateString);
        case "xx":
          return parseTimezonePattern(timezonePatterns.basic, dateString);
        case "xxxx":
          return parseTimezonePattern(timezonePatterns.basicOptionalSeconds, dateString);
        case "xxxxx":
          return parseTimezonePattern(timezonePatterns.extendedOptionalSeconds, dateString);
        case "xxx":
        default:
          return parseTimezonePattern(timezonePatterns.extended, dateString);
      }
    }
  }, {
    key: "set",
    value: function set2(date, flags, value) {
      if (flags.timestampIsSet) {
        return date;
      }
      return new Date(date.getTime() - value);
    }
  }]);
  return ISOTimezoneParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/TimestampSecondsParser.js
var TimestampSecondsParser = function(_Parser) {
  _inherits(TimestampSecondsParser2, _Parser);
  var _super = _createSuper(TimestampSecondsParser2);
  function TimestampSecondsParser2() {
    var _this;
    _classCallCheck(this, TimestampSecondsParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 40);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", "*");
    return _this;
  }
  _createClass(TimestampSecondsParser2, [{
    key: "parse",
    value: function parse2(dateString) {
      return parseAnyDigitsSigned(dateString);
    }
  }, {
    key: "set",
    value: function set2(_date, _flags, value) {
      return [new Date(value * 1e3), {
        timestampIsSet: true
      }];
    }
  }]);
  return TimestampSecondsParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/TimestampMillisecondsParser.js
var TimestampMillisecondsParser = function(_Parser) {
  _inherits(TimestampMillisecondsParser2, _Parser);
  var _super = _createSuper(TimestampMillisecondsParser2);
  function TimestampMillisecondsParser2() {
    var _this;
    _classCallCheck(this, TimestampMillisecondsParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 20);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", "*");
    return _this;
  }
  _createClass(TimestampMillisecondsParser2, [{
    key: "parse",
    value: function parse2(dateString) {
      return parseAnyDigitsSigned(dateString);
    }
  }, {
    key: "set",
    value: function set2(_date, _flags, value) {
      return [new Date(value), {
        timestampIsSet: true
      }];
    }
  }]);
  return TimestampMillisecondsParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/index.js
var parsers = {
  G: new EraParser(),
  y: new YearParser(),
  Y: new LocalWeekYearParser(),
  R: new ISOWeekYearParser(),
  u: new ExtendedYearParser(),
  Q: new QuarterParser(),
  q: new StandAloneQuarterParser(),
  M: new MonthParser(),
  L: new StandAloneMonthParser(),
  w: new LocalWeekParser(),
  I: new ISOWeekParser(),
  d: new DateParser(),
  D: new DayOfYearParser(),
  E: new DayParser(),
  e: new LocalDayParser(),
  c: new StandAloneLocalDayParser(),
  i: new ISODayParser(),
  a: new AMPMParser(),
  b: new AMPMMidnightParser(),
  B: new DayPeriodParser(),
  h: new Hour1to12Parser(),
  H: new Hour0to23Parser(),
  K: new Hour0To11Parser(),
  k: new Hour1To24Parser(),
  m: new MinuteParser(),
  s: new SecondParser(),
  S: new FractionOfSecondParser(),
  X: new ISOTimezoneWithZParser(),
  x: new ISOTimezoneParser(),
  t: new TimestampSecondsParser(),
  T: new TimestampMillisecondsParser()
};

// node_modules/date-fns/esm/parse/index.js
var formattingTokensRegExp2 = /[yYQqMLwIdDecihHKkms]o|(\w)\1*|''|'(''|[^'])+('|$)|./g;
var longFormattingTokensRegExp2 = /P+p+|P+|p+|''|'(''|[^'])+('|$)|./g;
var escapedStringRegExp2 = /^'([^]*?)'?$/;
var doubleQuoteRegExp2 = /''/g;
var notWhitespaceRegExp = /\S/;
var unescapedLatinCharacterRegExp2 = /[a-zA-Z]/;
function parse(dirtyDateString, dirtyFormatString, dirtyReferenceDate, options) {
  var _ref, _options$locale, _ref2, _ref3, _ref4, _options$firstWeekCon, _options$locale2, _options$locale2$opti, _defaultOptions$local, _defaultOptions$local2, _ref5, _ref6, _ref7, _options$weekStartsOn, _options$locale3, _options$locale3$opti, _defaultOptions$local3, _defaultOptions$local4;
  requiredArgs(3, arguments);
  var dateString = String(dirtyDateString);
  var formatString = String(dirtyFormatString);
  var defaultOptions2 = getDefaultOptions();
  var locale2 = (_ref = (_options$locale = options === null || options === void 0 ? void 0 : options.locale) !== null && _options$locale !== void 0 ? _options$locale : defaultOptions2.locale) !== null && _ref !== void 0 ? _ref : defaultLocale_default;
  if (!locale2.match) {
    throw new RangeError("locale must contain match property");
  }
  var firstWeekContainsDate = toInteger((_ref2 = (_ref3 = (_ref4 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale2 = options.locale) === null || _options$locale2 === void 0 ? void 0 : (_options$locale2$opti = _options$locale2.options) === null || _options$locale2$opti === void 0 ? void 0 : _options$locale2$opti.firstWeekContainsDate) !== null && _ref4 !== void 0 ? _ref4 : defaultOptions2.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : 1);
  if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
    throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
  }
  var weekStartsOn = toInteger((_ref5 = (_ref6 = (_ref7 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale3 = options.locale) === null || _options$locale3 === void 0 ? void 0 : (_options$locale3$opti = _options$locale3.options) === null || _options$locale3$opti === void 0 ? void 0 : _options$locale3$opti.weekStartsOn) !== null && _ref7 !== void 0 ? _ref7 : defaultOptions2.weekStartsOn) !== null && _ref6 !== void 0 ? _ref6 : (_defaultOptions$local3 = defaultOptions2.locale) === null || _defaultOptions$local3 === void 0 ? void 0 : (_defaultOptions$local4 = _defaultOptions$local3.options) === null || _defaultOptions$local4 === void 0 ? void 0 : _defaultOptions$local4.weekStartsOn) !== null && _ref5 !== void 0 ? _ref5 : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  if (formatString === "") {
    if (dateString === "") {
      return toDate(dirtyReferenceDate);
    } else {
      return /* @__PURE__ */ new Date(NaN);
    }
  }
  var subFnOptions = {
    firstWeekContainsDate,
    weekStartsOn,
    locale: locale2
  };
  var setters = [new DateToSystemTimezoneSetter()];
  var tokens = formatString.match(longFormattingTokensRegExp2).map(function(substring) {
    var firstCharacter = substring[0];
    if (firstCharacter in longFormatters_default) {
      var longFormatter = longFormatters_default[firstCharacter];
      return longFormatter(substring, locale2.formatLong);
    }
    return substring;
  }).join("").match(formattingTokensRegExp2);
  var usedTokens = [];
  var _iterator = _createForOfIteratorHelper(tokens), _step;
  try {
    var _loop = function _loop2() {
      var token = _step.value;
      if (!(options !== null && options !== void 0 && options.useAdditionalWeekYearTokens) && isProtectedWeekYearToken(token)) {
        throwProtectedError(token, formatString, dirtyDateString);
      }
      if (!(options !== null && options !== void 0 && options.useAdditionalDayOfYearTokens) && isProtectedDayOfYearToken(token)) {
        throwProtectedError(token, formatString, dirtyDateString);
      }
      var firstCharacter = token[0];
      var parser = parsers[firstCharacter];
      if (parser) {
        var incompatibleTokens = parser.incompatibleTokens;
        if (Array.isArray(incompatibleTokens)) {
          var incompatibleToken = usedTokens.find(function(usedToken) {
            return incompatibleTokens.includes(usedToken.token) || usedToken.token === firstCharacter;
          });
          if (incompatibleToken) {
            throw new RangeError("The format string mustn't contain `".concat(incompatibleToken.fullToken, "` and `").concat(token, "` at the same time"));
          }
        } else if (parser.incompatibleTokens === "*" && usedTokens.length > 0) {
          throw new RangeError("The format string mustn't contain `".concat(token, "` and any other token at the same time"));
        }
        usedTokens.push({
          token: firstCharacter,
          fullToken: token
        });
        var parseResult = parser.run(dateString, token, locale2.match, subFnOptions);
        if (!parseResult) {
          return {
            v: /* @__PURE__ */ new Date(NaN)
          };
        }
        setters.push(parseResult.setter);
        dateString = parseResult.rest;
      } else {
        if (firstCharacter.match(unescapedLatinCharacterRegExp2)) {
          throw new RangeError("Format string contains an unescaped latin alphabet character `" + firstCharacter + "`");
        }
        if (token === "''") {
          token = "'";
        } else if (firstCharacter === "'") {
          token = cleanEscapedString2(token);
        }
        if (dateString.indexOf(token) === 0) {
          dateString = dateString.slice(token.length);
        } else {
          return {
            v: /* @__PURE__ */ new Date(NaN)
          };
        }
      }
    };
    for (_iterator.s(); !(_step = _iterator.n()).done; ) {
      var _ret = _loop();
      if (_typeof(_ret) === "object") return _ret.v;
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
  if (dateString.length > 0 && notWhitespaceRegExp.test(dateString)) {
    return /* @__PURE__ */ new Date(NaN);
  }
  var uniquePrioritySetters = setters.map(function(setter2) {
    return setter2.priority;
  }).sort(function(a3, b2) {
    return b2 - a3;
  }).filter(function(priority, index, array) {
    return array.indexOf(priority) === index;
  }).map(function(priority) {
    return setters.filter(function(setter2) {
      return setter2.priority === priority;
    }).sort(function(a3, b2) {
      return b2.subPriority - a3.subPriority;
    });
  }).map(function(setterArray) {
    return setterArray[0];
  });
  var date = toDate(dirtyReferenceDate);
  if (isNaN(date.getTime())) {
    return /* @__PURE__ */ new Date(NaN);
  }
  var utcDate = subMilliseconds(date, getTimezoneOffsetInMilliseconds(date));
  var flags = {};
  var _iterator2 = _createForOfIteratorHelper(uniquePrioritySetters), _step2;
  try {
    for (_iterator2.s(); !(_step2 = _iterator2.n()).done; ) {
      var setter = _step2.value;
      if (!setter.validate(utcDate, subFnOptions)) {
        return /* @__PURE__ */ new Date(NaN);
      }
      var result = setter.set(utcDate, flags, subFnOptions);
      if (Array.isArray(result)) {
        utcDate = result[0];
        assign(flags, result[1]);
      } else {
        utcDate = result;
      }
    }
  } catch (err) {
    _iterator2.e(err);
  } finally {
    _iterator2.f();
  }
  return utcDate;
}
function cleanEscapedString2(input) {
  return input.match(escapedStringRegExp2)[1].replace(doubleQuoteRegExp2, "'");
}

// node_modules/date-fns/esm/subDays/index.js
function subDays(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var amount = toInteger(dirtyAmount);
  return addDays(dirtyDate, -amount);
}

// node_modules/date-fns/esm/parseISO/index.js
function parseISO(argument, options) {
  var _options$additionalDi;
  requiredArgs(1, arguments);
  var additionalDigits = toInteger((_options$additionalDi = options === null || options === void 0 ? void 0 : options.additionalDigits) !== null && _options$additionalDi !== void 0 ? _options$additionalDi : 2);
  if (additionalDigits !== 2 && additionalDigits !== 1 && additionalDigits !== 0) {
    throw new RangeError("additionalDigits must be 0, 1 or 2");
  }
  if (!(typeof argument === "string" || Object.prototype.toString.call(argument) === "[object String]")) {
    return /* @__PURE__ */ new Date(NaN);
  }
  var dateStrings = splitDateString(argument);
  var date;
  if (dateStrings.date) {
    var parseYearResult = parseYear(dateStrings.date, additionalDigits);
    date = parseDate(parseYearResult.restDateString, parseYearResult.year);
  }
  if (!date || isNaN(date.getTime())) {
    return /* @__PURE__ */ new Date(NaN);
  }
  var timestamp = date.getTime();
  var time = 0;
  var offset;
  if (dateStrings.time) {
    time = parseTime(dateStrings.time);
    if (isNaN(time)) {
      return /* @__PURE__ */ new Date(NaN);
    }
  }
  if (dateStrings.timezone) {
    offset = parseTimezone(dateStrings.timezone);
    if (isNaN(offset)) {
      return /* @__PURE__ */ new Date(NaN);
    }
  } else {
    var dirtyDate = new Date(timestamp + time);
    var result = /* @__PURE__ */ new Date(0);
    result.setFullYear(dirtyDate.getUTCFullYear(), dirtyDate.getUTCMonth(), dirtyDate.getUTCDate());
    result.setHours(dirtyDate.getUTCHours(), dirtyDate.getUTCMinutes(), dirtyDate.getUTCSeconds(), dirtyDate.getUTCMilliseconds());
    return result;
  }
  return new Date(timestamp + time + offset);
}
var patterns = {
  dateTimeDelimiter: /[T ]/,
  timeZoneDelimiter: /[Z ]/i,
  timezone: /([Z+-].*)$/
};
var dateRegex = /^-?(?:(\d{3})|(\d{2})(?:-?(\d{2}))?|W(\d{2})(?:-?(\d{1}))?|)$/;
var timeRegex = /^(\d{2}(?:[.,]\d*)?)(?::?(\d{2}(?:[.,]\d*)?))?(?::?(\d{2}(?:[.,]\d*)?))?$/;
var timezoneRegex = /^([+-])(\d{2})(?::?(\d{2}))?$/;
function splitDateString(dateString) {
  var dateStrings = {};
  var array = dateString.split(patterns.dateTimeDelimiter);
  var timeString;
  if (array.length > 2) {
    return dateStrings;
  }
  if (/:/.test(array[0])) {
    timeString = array[0];
  } else {
    dateStrings.date = array[0];
    timeString = array[1];
    if (patterns.timeZoneDelimiter.test(dateStrings.date)) {
      dateStrings.date = dateString.split(patterns.timeZoneDelimiter)[0];
      timeString = dateString.substr(dateStrings.date.length, dateString.length);
    }
  }
  if (timeString) {
    var token = patterns.timezone.exec(timeString);
    if (token) {
      dateStrings.time = timeString.replace(token[1], "");
      dateStrings.timezone = token[1];
    } else {
      dateStrings.time = timeString;
    }
  }
  return dateStrings;
}
function parseYear(dateString, additionalDigits) {
  var regex = new RegExp("^(?:(\\d{4}|[+-]\\d{" + (4 + additionalDigits) + "})|(\\d{2}|[+-]\\d{" + (2 + additionalDigits) + "})$)");
  var captures = dateString.match(regex);
  if (!captures) return {
    year: NaN,
    restDateString: ""
  };
  var year = captures[1] ? parseInt(captures[1]) : null;
  var century = captures[2] ? parseInt(captures[2]) : null;
  return {
    year: century === null ? year : century * 100,
    restDateString: dateString.slice((captures[1] || captures[2]).length)
  };
}
function parseDate(dateString, year) {
  if (year === null) return /* @__PURE__ */ new Date(NaN);
  var captures = dateString.match(dateRegex);
  if (!captures) return /* @__PURE__ */ new Date(NaN);
  var isWeekDate = !!captures[4];
  var dayOfYear = parseDateUnit(captures[1]);
  var month = parseDateUnit(captures[2]) - 1;
  var day = parseDateUnit(captures[3]);
  var week = parseDateUnit(captures[4]);
  var dayOfWeek = parseDateUnit(captures[5]) - 1;
  if (isWeekDate) {
    if (!validateWeekDate(year, week, dayOfWeek)) {
      return /* @__PURE__ */ new Date(NaN);
    }
    return dayOfISOWeekYear(year, week, dayOfWeek);
  } else {
    var date = /* @__PURE__ */ new Date(0);
    if (!validateDate(year, month, day) || !validateDayOfYearDate(year, dayOfYear)) {
      return /* @__PURE__ */ new Date(NaN);
    }
    date.setUTCFullYear(year, month, Math.max(dayOfYear, day));
    return date;
  }
}
function parseDateUnit(value) {
  return value ? parseInt(value) : 1;
}
function parseTime(timeString) {
  var captures = timeString.match(timeRegex);
  if (!captures) return NaN;
  var hours = parseTimeUnit(captures[1]);
  var minutes = parseTimeUnit(captures[2]);
  var seconds = parseTimeUnit(captures[3]);
  if (!validateTime(hours, minutes, seconds)) {
    return NaN;
  }
  return hours * millisecondsInHour + minutes * millisecondsInMinute + seconds * 1e3;
}
function parseTimeUnit(value) {
  return value && parseFloat(value.replace(",", ".")) || 0;
}
function parseTimezone(timezoneString) {
  if (timezoneString === "Z") return 0;
  var captures = timezoneString.match(timezoneRegex);
  if (!captures) return 0;
  var sign = captures[1] === "+" ? -1 : 1;
  var hours = parseInt(captures[2]);
  var minutes = captures[3] && parseInt(captures[3]) || 0;
  if (!validateTimezone(hours, minutes)) {
    return NaN;
  }
  return sign * (hours * millisecondsInHour + minutes * millisecondsInMinute);
}
function dayOfISOWeekYear(isoWeekYear, week, day) {
  var date = /* @__PURE__ */ new Date(0);
  date.setUTCFullYear(isoWeekYear, 0, 4);
  var fourthOfJanuaryDay = date.getUTCDay() || 7;
  var diff = (week - 1) * 7 + day + 1 - fourthOfJanuaryDay;
  date.setUTCDate(date.getUTCDate() + diff);
  return date;
}
var daysInMonths = [31, null, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
function isLeapYearIndex2(year) {
  return year % 400 === 0 || year % 4 === 0 && year % 100 !== 0;
}
function validateDate(year, month, date) {
  return month >= 0 && month <= 11 && date >= 1 && date <= (daysInMonths[month] || (isLeapYearIndex2(year) ? 29 : 28));
}
function validateDayOfYearDate(year, dayOfYear) {
  return dayOfYear >= 1 && dayOfYear <= (isLeapYearIndex2(year) ? 366 : 365);
}
function validateWeekDate(_year, week, day) {
  return week >= 1 && week <= 53 && day >= 0 && day <= 6;
}
function validateTime(hours, minutes, seconds) {
  if (hours === 24) {
    return minutes === 0 && seconds === 0;
  }
  return seconds >= 0 && seconds < 60 && minutes >= 0 && minutes < 60 && hours >= 0 && hours < 25;
}
function validateTimezone(_hours, minutes) {
  return minutes >= 0 && minutes <= 59;
}

// node_modules/date-fns/esm/setMonth/index.js
function setMonth(dirtyDate, dirtyMonth) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var month = toInteger(dirtyMonth);
  var year = date.getFullYear();
  var day = date.getDate();
  var dateWithDesiredMonth = /* @__PURE__ */ new Date(0);
  dateWithDesiredMonth.setFullYear(year, month, 15);
  dateWithDesiredMonth.setHours(0, 0, 0, 0);
  var daysInMonth = getDaysInMonth(dateWithDesiredMonth);
  date.setMonth(month, Math.min(day, daysInMonth));
  return date;
}

// node_modules/date-fns/esm/set/index.js
function set(dirtyDate, values) {
  requiredArgs(2, arguments);
  if (_typeof(values) !== "object" || values === null) {
    throw new RangeError("values parameter must be an object");
  }
  var date = toDate(dirtyDate);
  if (isNaN(date.getTime())) {
    return /* @__PURE__ */ new Date(NaN);
  }
  if (values.year != null) {
    date.setFullYear(values.year);
  }
  if (values.month != null) {
    date = setMonth(date, values.month);
  }
  if (values.date != null) {
    date.setDate(toInteger(values.date));
  }
  if (values.hours != null) {
    date.setHours(toInteger(values.hours));
  }
  if (values.minutes != null) {
    date.setMinutes(toInteger(values.minutes));
  }
  if (values.seconds != null) {
    date.setSeconds(toInteger(values.seconds));
  }
  if (values.milliseconds != null) {
    date.setMilliseconds(toInteger(values.milliseconds));
  }
  return date;
}

// node_modules/date-fns/esm/setHours/index.js
function setHours(dirtyDate, dirtyHours) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var hours = toInteger(dirtyHours);
  date.setHours(hours);
  return date;
}

// node_modules/date-fns/esm/setMilliseconds/index.js
function setMilliseconds(dirtyDate, dirtyMilliseconds) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var milliseconds2 = toInteger(dirtyMilliseconds);
  date.setMilliseconds(milliseconds2);
  return date;
}

// node_modules/date-fns/esm/setMinutes/index.js
function setMinutes(dirtyDate, dirtyMinutes) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var minutes = toInteger(dirtyMinutes);
  date.setMinutes(minutes);
  return date;
}

// node_modules/date-fns/esm/setSeconds/index.js
function setSeconds(dirtyDate, dirtySeconds) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var seconds = toInteger(dirtySeconds);
  date.setSeconds(seconds);
  return date;
}

// node_modules/date-fns/esm/setYear/index.js
function setYear(dirtyDate, dirtyYear) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var year = toInteger(dirtyYear);
  if (isNaN(date.getTime())) {
    return /* @__PURE__ */ new Date(NaN);
  }
  date.setFullYear(year);
  return date;
}

// node_modules/date-fns/esm/subMonths/index.js
function subMonths(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var amount = toInteger(dirtyAmount);
  return addMonths(dirtyDate, -amount);
}

// node_modules/date-fns/esm/sub/index.js
function sub(date, duration) {
  requiredArgs(2, arguments);
  if (!duration || _typeof(duration) !== "object") return /* @__PURE__ */ new Date(NaN);
  var years = duration.years ? toInteger(duration.years) : 0;
  var months = duration.months ? toInteger(duration.months) : 0;
  var weeks = duration.weeks ? toInteger(duration.weeks) : 0;
  var days = duration.days ? toInteger(duration.days) : 0;
  var hours = duration.hours ? toInteger(duration.hours) : 0;
  var minutes = duration.minutes ? toInteger(duration.minutes) : 0;
  var seconds = duration.seconds ? toInteger(duration.seconds) : 0;
  var dateWithoutMonths = subMonths(date, months + years * 12);
  var dateWithoutDays = subDays(dateWithoutMonths, days + weeks * 7);
  var minutestoSub = minutes + hours * 60;
  var secondstoSub = seconds + minutestoSub * 60;
  var mstoSub = secondstoSub * 1e3;
  var finalDate = new Date(dateWithoutDays.getTime() - mstoSub);
  return finalDate;
}

// node_modules/date-fns/esm/subYears/index.js
function subYears(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var amount = toInteger(dirtyAmount);
  return addYears(dirtyDate, -amount);
}

// node_modules/@vuepic/vue-datepicker/dist/vue-datepicker.js
var ot = (e2, a3) => {
  const n = e2.__vccOpts || e2;
  for (const [t2, d3] of a3)
    n[t2] = d3;
  return n;
};
var Ya = {};
var Ea = {
  version: "1.1",
  xmlns: "http://www.w3.org/2000/svg",
  width: "32",
  height: "32",
  viewBox: "0 0 32 32",
  class: "dp__icon"
};
var Fa = createBaseVNode("path", { d: "M29.333 8c0-2.208-1.792-4-4-4h-18.667c-2.208 0-4 1.792-4 4v18.667c0 2.208 1.792 4 4 4h18.667c2.208 0 4-1.792 4-4v-18.667zM26.667 8v18.667c0 0.736-0.597 1.333-1.333 1.333 0 0-18.667 0-18.667 0-0.736 0-1.333-0.597-1.333-1.333 0 0 0-18.667 0-18.667 0-0.736 0.597-1.333 1.333-1.333 0 0 18.667 0 18.667 0 0.736 0 1.333 0.597 1.333 1.333z" }, null, -1);
var Ha = createBaseVNode("path", { d: "M20 2.667v5.333c0 0.736 0.597 1.333 1.333 1.333s1.333-0.597 1.333-1.333v-5.333c0-0.736-0.597-1.333-1.333-1.333s-1.333 0.597-1.333 1.333z" }, null, -1);
var Wa = createBaseVNode("path", { d: "M9.333 2.667v5.333c0 0.736 0.597 1.333 1.333 1.333s1.333-0.597 1.333-1.333v-5.333c0-0.736-0.597-1.333-1.333-1.333s-1.333 0.597-1.333 1.333z" }, null, -1);
var Ka = createBaseVNode("path", { d: "M4 14.667h24c0.736 0 1.333-0.597 1.333-1.333s-0.597-1.333-1.333-1.333h-24c-0.736 0-1.333 0.597-1.333 1.333s0.597 1.333 1.333 1.333z" }, null, -1);
var Ua = [
  Fa,
  Ha,
  Wa,
  Ka
];
function La(e2, a3) {
  return openBlock(), createElementBlock("svg", Ea, Ua);
}
var Wt = ot(Ya, [["render", La]]);
var Ga = {};
var ja = {
  version: "1.1",
  xmlns: "http://www.w3.org/2000/svg",
  width: "32",
  height: "32",
  viewBox: "0 0 32 32",
  class: "dp__icon"
};
var za = createBaseVNode("path", { d: "M23.057 7.057l-16 16c-0.52 0.52-0.52 1.365 0 1.885s1.365 0.52 1.885 0l16-16c0.52-0.52 0.52-1.365 0-1.885s-1.365-0.52-1.885 0z" }, null, -1);
var Xa = createBaseVNode("path", { d: "M7.057 8.943l16 16c0.52 0.52 1.365 0.52 1.885 0s0.52-1.365 0-1.885l-16-16c-0.52-0.52-1.365-0.52-1.885 0s-0.52 1.365 0 1.885z" }, null, -1);
var qa = [
  za,
  Xa
];
function Ja(e2, a3) {
  return openBlock(), createElementBlock("svg", ja, qa);
}
var Za = ot(Ga, [["render", Ja]]);
var Qa = {};
var xa = {
  version: "1.1",
  xmlns: "http://www.w3.org/2000/svg",
  width: "32",
  height: "32",
  viewBox: "0 0 32 32",
  class: "dp__icon"
};
var el = createBaseVNode("path", { d: "M20.943 23.057l-7.057-7.057c0 0 7.057-7.057 7.057-7.057 0.52-0.52 0.52-1.365 0-1.885s-1.365-0.52-1.885 0l-8 8c-0.521 0.521-0.521 1.365 0 1.885l8 8c0.52 0.52 1.365 0.52 1.885 0s0.52-1.365 0-1.885z" }, null, -1);
var tl = [
  el
];
function nl(e2, a3) {
  return openBlock(), createElementBlock("svg", xa, tl);
}
var Pn = ot(Qa, [["render", nl]]);
var al = {};
var ll = {
  version: "1.1",
  xmlns: "http://www.w3.org/2000/svg",
  width: "32",
  height: "32",
  viewBox: "0 0 32 32",
  class: "dp__icon"
};
var rl = createBaseVNode("path", { d: "M12.943 24.943l8-8c0.521-0.521 0.521-1.365 0-1.885l-8-8c-0.52-0.52-1.365-0.52-1.885 0s-0.52 1.365 0 1.885l7.057 7.057c0 0-7.057 7.057-7.057 7.057-0.52 0.52-0.52 1.365 0 1.885s1.365 0.52 1.885 0z" }, null, -1);
var sl = [
  rl
];
function ol(e2, a3) {
  return openBlock(), createElementBlock("svg", ll, sl);
}
var Cn = ot(al, [["render", ol]]);
var il = {};
var ul = {
  version: "1.1",
  xmlns: "http://www.w3.org/2000/svg",
  width: "32",
  height: "32",
  viewBox: "0 0 32 32",
  class: "dp__icon"
};
var dl = createBaseVNode("path", { d: "M16 1.333c-8.095 0-14.667 6.572-14.667 14.667s6.572 14.667 14.667 14.667c8.095 0 14.667-6.572 14.667-14.667s-6.572-14.667-14.667-14.667zM16 4c6.623 0 12 5.377 12 12s-5.377 12-12 12c-6.623 0-12-5.377-12-12s5.377-12 12-12z" }, null, -1);
var cl = createBaseVNode("path", { d: "M14.667 8v8c0 0.505 0.285 0.967 0.737 1.193l5.333 2.667c0.658 0.329 1.46 0.062 1.789-0.596s0.062-1.46-0.596-1.789l-4.596-2.298c0 0 0-7.176 0-7.176 0-0.736-0.597-1.333-1.333-1.333s-1.333 0.597-1.333 1.333z" }, null, -1);
var fl = [
  dl,
  cl
];
function ml(e2, a3) {
  return openBlock(), createElementBlock("svg", ul, fl);
}
var Un = ot(il, [["render", ml]]);
var vl = {};
var yl = {
  version: "1.1",
  xmlns: "http://www.w3.org/2000/svg",
  width: "32",
  height: "32",
  viewBox: "0 0 32 32",
  class: "dp__icon"
};
var pl = createBaseVNode("path", { d: "M24.943 19.057l-8-8c-0.521-0.521-1.365-0.521-1.885 0l-8 8c-0.52 0.52-0.52 1.365 0 1.885s1.365 0.52 1.885 0l7.057-7.057c0 0 7.057 7.057 7.057 7.057 0.52 0.52 1.365 0.52 1.885 0s0.52-1.365 0-1.885z" }, null, -1);
var hl = [
  pl
];
function gl(e2, a3) {
  return openBlock(), createElementBlock("svg", yl, hl);
}
var Ln = ot(vl, [["render", gl]]);
var kl = {};
var wl = {
  version: "1.1",
  xmlns: "http://www.w3.org/2000/svg",
  width: "32",
  height: "32",
  viewBox: "0 0 32 32",
  class: "dp__icon"
};
var bl = createBaseVNode("path", { d: "M7.057 12.943l8 8c0.521 0.521 1.365 0.521 1.885 0l8-8c0.52-0.52 0.52-1.365 0-1.885s-1.365-0.52-1.885 0l-7.057 7.057c0 0-7.057-7.057-7.057-7.057-0.52-0.52-1.365-0.52-1.885 0s-0.52 1.365 0 1.885z" }, null, -1);
var $l = [
  bl
];
function Dl(e2, a3) {
  return openBlock(), createElementBlock("svg", wl, $l);
}
var Gn = ot(kl, [["render", Dl]]);
var Tn = (e2, a3) => {
  const n = parse(e2, a3.slice(0, e2.length), /* @__PURE__ */ new Date());
  return isValid(n) && isDate(n) ? n : null;
};
var zt = (e2, a3) => {
  if (typeof a3 == "string")
    return Tn(e2, a3);
  if (Array.isArray(a3)) {
    let n = null;
    for (let t2 = 0; t2 < a3.length && (n = Tn(e2, a3[t2]), !n); t2++)
      ;
    return n;
  }
  return typeof a3 == "function" ? a3(e2) : null;
};
var Fe = (e2) => {
  let a3 = new Date(JSON.parse(JSON.stringify(e2)));
  return a3 = setHours(a3, 0), a3 = setMinutes(a3, 0), a3 = setSeconds(a3, 0), a3 = setMilliseconds(a3, 0), a3;
};
var rn = (e2) => Array.isArray(e2) ? isValid(e2[0]) && (e2[1] ? isValid(e2[1]) : true) : e2 ? isValid(e2) : false;
var Ae = (e2, a3, n, t2) => {
  let d3 = e2 ? new Date(e2) : /* @__PURE__ */ new Date();
  return (a3 || a3 === 0) && (d3 = setHours(d3, +a3)), (n || n === 0) && (d3 = setMinutes(d3, +n)), (t2 || t2 === 0) && (d3 = setSeconds(d3, +t2)), setMilliseconds(d3, 0);
};
var Ml = (e2) => {
  const a3 = addMonths(e2, 1);
  return { month: getMonth(a3), year: getYear(a3) };
};
var st = (e2, a3, n) => {
  let t2 = e2 ? new Date(e2) : /* @__PURE__ */ new Date();
  return (a3 || a3 === 0) && (t2 = setMonth(t2, a3)), n && (t2 = setYear(t2, n)), t2;
};
var Rn = (e2, a3) => e2 ? `HH:mm${a3 ? ":ss" : ""}` : `hh:mm${a3 ? ":ss" : ""} aa`;
var jn = (e2, a3, n, t2, d3, m3, p, v) => e2 || (t2 ? "MM/yyyy" : d3 ? Rn(a3, n) : m3 ? "MM/dd/yyyy" : p ? "yyyy" : v ? `MM/dd/yyyy, ${Rn(a3, n)}` : "MM/dd/yyyy");
var Xt = (e2) => {
  const a3 = e2 || /* @__PURE__ */ new Date();
  return {
    hours: getHours(a3),
    minutes: getMinutes(a3),
    seconds: getSeconds(a3)
  };
};
var It = (e2) => ({ month: getMonth(e2), year: getYear(e2) });
var Vn = (e2) => Array.isArray(e2) ? [It(e2[0]), e2[1] ? It(e2[1]) : null] : It(e2);
var sn = (e2) => Array.isArray(e2) ? [Xt(e2[0]), Xt(e2[1])] : Xt(e2);
var qt = (e2, a3, n) => n ? format(e2, a3, { locale: n }) : format(e2, a3);
var vt = (e2, a3, n, t2, d3) => Array.isArray(e2) ? `${qt(e2[0], a3, n)} ${d3 && !e2[1] ? "" : t2 || "-"} ${e2[1] ? qt(e2[1], a3, n) : ""}` : qt(e2, a3, n);
var De = (e2, a3) => !e2 || !a3 ? false : isAfter(Fe(e2), Fe(a3));
var we = (e2, a3) => !e2 || !a3 ? false : isBefore(Fe(e2), Fe(a3));
var ce = (e2, a3) => !e2 || !a3 ? false : isEqual(Fe(e2), Fe(a3));
var Sl = (e2, a3) => add(set(/* @__PURE__ */ new Date(), e2), a3);
var Al = (e2, a3) => sub(set(/* @__PURE__ */ new Date(), e2), a3);
var Jt = (e2) => set(/* @__PURE__ */ new Date(), { hours: getHours(e2), minutes: getMinutes(e2), seconds: getSeconds(e2) });
var _n = (e2) => set(/* @__PURE__ */ new Date(), {
  hours: +e2.hours || 0,
  minutes: +e2.minutes || 0,
  seconds: +e2.seconds || 0
});
var ft = (e2, a3, n, t2) => {
  if (!e2)
    return true;
  if (t2) {
    const d3 = n === "max" ? isBefore(e2, a3) : isAfter(e2, a3), m3 = { seconds: 0, milliseconds: 0 };
    return d3 || isEqual(set(e2, m3), set(a3, m3));
  }
  return n === "max" ? e2.getTime() <= a3.getTime() : e2.getTime() >= a3.getTime();
};
var on = (e2, a3, n, t2, d3) => {
  let m3 = true;
  if (!e2)
    return true;
  const p = !d3 && !t2 ? Array.isArray(e2) ? [e2[0] ? Jt(e2[0]) : null, e2[1] ? Jt(e2[1]) : null] : Jt(e2) : e2;
  if (a3 || t2) {
    const v = a3 ? _n(a3) : new Date(t2);
    Array.isArray(p) ? m3 = ft(p[0], v, "max", !!t2) && ft(p[1], v, "max", !!t2) : m3 = ft(p, v, "max", !!t2);
  }
  if (n || d3) {
    const v = n ? _n(n) : new Date(d3);
    Array.isArray(p) ? m3 = ft(p[0], v, "min", !!d3) && ft(p[1], v, "min", !!d3) && m3 : m3 = ft(p, v, "min", !!d3) && m3;
  }
  return m3;
};
var Pl = (e2, a3, n) => {
  let t2 = true;
  return a3 && n && (t2 = De(new Date(e2), new Date(a3)) && we(new Date(e2), new Date(n))), a3 && (t2 = De(new Date(e2), new Date(a3))), n && (t2 = we(new Date(e2), new Date(n))), t2;
};
var Ee = (e2) => e2 instanceof Date ? e2 : parseISO(e2);
var Zt = (e2, a3) => {
  if (a3) {
    const t2 = (/* @__PURE__ */ new Date()).getTimezoneOffset() * 6e4;
    return new Date(e2.getTime() - t2).toISOString();
  }
  const n = Date.UTC(
    e2.getUTCFullYear(),
    e2.getUTCMonth(),
    e2.getUTCDate(),
    e2.getUTCHours(),
    e2.getUTCMinutes(),
    e2.getUTCSeconds()
  );
  return new Date(n).toISOString();
};
var zn = (e2, a3, n) => e2 && e2[0] && e2[1] ? De(n, e2[0]) && we(n, e2[1]) : e2 && e2[0] && a3 ? De(n, e2[0]) && we(n, a3) || we(n, e2[0]) && De(n, a3) : false;
var Rt = (e2, a3) => {
  const n = startOfWeek(e2, { weekStartsOn: a3 }), t2 = endOfWeek(e2, { weekStartsOn: a3 });
  return [n, t2];
};
var Xn = (e2, a3) => Array.isArray(a3) ? a3.some((n) => ce(Ee(new Date(n)), Ee(e2))) : a3(e2);
var Cl = (e2, a3, n, t2, d3, m3, p, v) => {
  const g = n ? De(Ee(e2), Ee(n)) : false, w2 = a3 ? we(Ee(e2), Ee(a3)) : false, V = Xn(e2, t2), E2 = (m3.months.length ? m3.months.map((l) => +l) : []).includes(getMonth(e2)), N = p.length ? p.some((l) => +l === getDay(e2)) : false, G2 = d3.length ? !d3.some((l) => ce(Ee(l), Ee(e2))) : false, T2 = getYear(e2), x2 = T2 < +v[0] || T2 > +v[1];
  return !(g || w2 || V || E2 || x2 || N || G2);
};
var qn = (e2, a3, n, t2, d3, m3, p) => ({
  validate: (g) => Cl(g, e2, a3, n, t2, d3, m3, p)
});
var Xe = Symbol();
var Kt = Symbol();
var pn = Symbol();
var Jn = Symbol();
var Zn = Symbol();
var qe = Symbol();
var hn = {
  disabled: { type: Boolean, default: false },
  readonly: { type: Boolean, default: false },
  autoApply: { type: Boolean, default: false },
  inline: { type: Boolean, default: false },
  textInput: { type: Boolean, default: false }
};
var gn = {
  range: { type: Boolean, default: false },
  uid: { type: String, default: null }
};
var Qn = {
  enableSeconds: { type: Boolean, default: false },
  is24: { type: Boolean, default: true },
  noHoursOverlay: { type: Boolean, default: false },
  noMinutesOverlay: { type: Boolean, default: false },
  noSecondsOverlay: { type: Boolean, default: false },
  hoursGridIncrement: { type: [String, Number], default: 1 },
  minutesGridIncrement: { type: [String, Number], default: 5 },
  secondsGridIncrement: { type: [String, Number], default: 5 },
  hoursIncrement: { type: [Number, String], default: 1 },
  minutesIncrement: { type: [Number, String], default: 1 },
  secondsIncrement: { type: [Number, String], default: 1 }
};
var xn = {
  ...Qn,
  fixedStart: { type: Boolean, default: false },
  fixedEnd: { type: Boolean, default: false },
  timePicker: { type: Boolean, default: false }
};
var ea = {
  name: { type: String, default: null },
  placeholder: { type: String, default: "" },
  hideInputIcon: { type: Boolean, default: false },
  clearable: { type: Boolean, default: true },
  state: { type: Boolean, default: null },
  required: { type: Boolean, default: false },
  autocomplete: { type: String, default: "off" },
  inputClassName: { type: String, default: null },
  inlineWithInput: { type: Boolean, default: false },
  textInputOptions: { type: Object, default: () => null }
};
var ta = {
  minTime: { type: Object, default: null },
  maxTime: { type: Object, default: null }
};
var kn = {
  minDate: { type: [Date, String], default: null },
  maxDate: { type: [Date, String], default: null }
};
var na = {
  selectText: { type: String, default: "Select" },
  cancelText: { type: String, default: "Cancel" },
  previewFormat: {
    type: [String, Function],
    default: () => ""
  },
  multiDates: { type: Boolean, default: false },
  partialRange: { type: Boolean, default: true },
  ignoreTimeValidation: { type: Boolean, default: false },
  ...ta
};
var wn = {
  monthPicker: { type: Boolean, default: false },
  customProps: { type: Object, default: null },
  yearPicker: { type: Boolean, default: false },
  modelAuto: { type: Boolean, default: false }
};
var aa = {
  locale: { type: String, default: "en-Us" },
  weekNumName: { type: String, default: "W" },
  weekStart: { type: [Number, String], default: 1 },
  weekNumbers: { type: Boolean, default: false },
  calendarClassName: { type: String, default: null },
  noSwipe: { type: Boolean, default: false },
  monthChangeOnScroll: { type: [Boolean, String], default: true },
  dayNames: {
    type: [Function, Array],
    default: null
  }
};
var la = {
  ...xn,
  ...na,
  ...wn,
  ...kn,
  ...aa,
  ...gn,
  vertical: { type: Boolean, default: false },
  disableMonthYearSelect: { type: Boolean, default: false },
  menuClassName: { type: String, default: null },
  yearRange: { type: Array, default: () => [1900, 2100] },
  multiCalendarsSolo: { type: Boolean, default: false },
  calendarCellClassName: { type: String, default: null },
  enableTimePicker: { type: Boolean, default: true },
  autoApply: { type: Boolean, default: false },
  disabledDates: { type: [Array, Function], default: () => [] },
  monthNameFormat: { type: String, default: "short" },
  startDate: { type: [Date, String], default: null },
  startTime: { type: [Object, Array], default: null },
  monthYearComponent: { type: Object, default: null },
  timePickerComponent: { type: Object, default: null },
  actionRowComponent: { type: Object, default: null },
  hideOffsetDates: { type: Boolean, default: false },
  autoRange: { type: [Number, String], default: null },
  noToday: { type: Boolean, default: false },
  disabledWeekDays: { type: Array, default: () => [] },
  allowedDates: { type: Array, default: () => [] },
  showNowButton: { type: Boolean, default: false },
  nowButtonLabel: { type: String, default: "Now" },
  markers: { type: Array, default: () => [] },
  modeHeight: { type: [Number, String], default: 255 },
  escClose: { type: Boolean, default: true },
  spaceConfirm: { type: Boolean, default: true },
  monthChangeOnArrows: { type: Boolean, default: true },
  presetRanges: { type: Array, default: () => [] },
  flow: { type: Array, default: () => [] },
  preventMinMaxNavigation: { type: Boolean, default: false },
  minRange: { type: [Number, String], default: null },
  maxRange: { type: [Number, String], default: null },
  multiDatesLimit: { type: [Number, String], default: null },
  reverseYears: { type: Boolean, default: false },
  keepActionRow: { type: Boolean, default: false },
  weekPicker: { type: Boolean, default: false },
  filters: { type: Object, default: () => ({}) },
  arrowNavigation: { type: Boolean, default: false },
  multiStatic: { type: Boolean, default: true },
  disableTimeRangeValidation: { type: Boolean, default: false },
  highlight: {
    type: [Array, Function],
    default: null
  },
  highlightWeekDays: {
    type: Array,
    default: null
  },
  teleportCenter: { type: Boolean, default: false }
};
var Tl = {
  ...ea,
  ...hn,
  ...la,
  multiCalendars: { type: [Boolean, Number, String], default: null },
  modelValue: { type: [String, Date, Array, Object, Number], default: null },
  modelType: { type: String, default: null },
  position: { type: String, default: "center" },
  dark: { type: Boolean, default: false },
  format: {
    type: [String, Function],
    default: () => null
  },
  closeOnScroll: { type: Boolean, default: false },
  autoPosition: { type: Boolean, default: true },
  closeOnAutoApply: { type: Boolean, default: true },
  teleport: { type: [String, Object], default: "body" },
  altPosition: { type: [Boolean, Function], default: false },
  transitions: { type: [Boolean, Object], default: true },
  formatLocale: { type: Object, default: null },
  utc: { type: [Boolean, String], default: false },
  ariaLabels: { type: Object, default: () => ({}) },
  offset: { type: [Number, String], default: 10 }
};
var ra = {
  range: { type: Boolean, default: false },
  multiCalendars: { type: Number, default: 0 },
  internalModelValue: { type: [Date, Array], default: null }
};
var sa = {
  ...wn,
  ...ra,
  vertical: { type: Boolean, default: false },
  month: { type: Number, default: 0 },
  year: { type: Number, default: 0 },
  instance: { type: Number, default: 1 }
};
var Rl = ["aria-label", "aria-disabled", "aria-readonly"];
var Vl = {
  key: 1,
  class: "dp__input_wrap"
};
var _l = ["id", "name", "inputmode", "placeholder", "disabled", "readonly", "required", "value", "autocomplete", "onKeydown"];
var Bl = {
  key: 2,
  class: "dp__input_icon"
};
var Ol = {
  key: 4,
  class: "dp__clear_icon"
};
var Nl = defineComponent({
  __name: "DatepickerInput",
  props: {
    ...ea,
    ...hn,
    ...gn,
    inputValue: { type: String, default: "" },
    inline: { type: Boolean, default: false },
    isMenuOpen: { type: Boolean, default: false },
    pattern: { type: String, default: "" }
  },
  emits: [
    "clear",
    "open",
    "update:inputValue",
    "setInputDate",
    "close",
    "selectDate",
    "setEmptyDate",
    "toggle",
    "focus-prev",
    "focus",
    "blur"
  ],
  setup(e2, { expose: a3, emit: n }) {
    const t2 = e2, d3 = ref(), m3 = ref(null), p = ref(false), v = inject(Xe), g = computed(
      () => ({
        dp__pointer: !t2.disabled && !t2.readonly && !t2.textInput,
        dp__disabled: t2.disabled,
        dp__input_readonly: !t2.textInput,
        dp__input: true,
        dp__input_icon_pad: !t2.hideInputIcon,
        dp__input_valid: t2.state,
        dp__input_invalid: t2.state === false,
        dp__input_focus: p.value || t2.isMenuOpen,
        dp__input_reg: !t2.textInput,
        [t2.inputClassName]: !!t2.inputClassName
      })
    ), w2 = (i2) => {
      var K2;
      const { value: Y2 } = i2.target, { format: z2, rangeSeparator: P } = t2.textInputOptions;
      if (Y2 !== "") {
        if (((K2 = t2.textInputOptions) == null ? void 0 : K2.openMenu) && !t2.isMenuOpen && n("open"), t2.range) {
          const [X2, ee] = Y2.split(`${P}`);
          if (X2 && ee) {
            const Z = zt(X2.trim(), z2 || t2.pattern), j = zt(ee.trim(), z2 || t2.pattern);
            d3.value = Z && j ? [Z, j] : null;
          }
        } else
          d3.value = zt(Y2, z2 || t2.pattern);
        n("setInputDate", d3.value);
      } else
        n("setInputDate", null), t2.autoApply && (n("setEmptyDate"), d3.value = null);
      n("update:inputValue", Y2);
    }, V = () => {
      var i2, Y2;
      ((i2 = t2.textInputOptions) == null ? void 0 : i2.enterSubmit) && rn(d3.value) && t2.inputValue !== "" ? (n("setInputDate", d3.value, true), d3.value = null) : ((Y2 = t2.textInputOptions) == null ? void 0 : Y2.enterSubmit) && t2.inputValue === "" && (d3.value = null, n("clear"));
    }, R2 = () => {
      var i2, Y2;
      ((i2 = t2.textInputOptions) == null ? void 0 : i2.tabSubmit) && rn(d3.value) && t2.inputValue !== "" ? (n("setInputDate", d3.value, true), d3.value = null) : ((Y2 = t2.textInputOptions) == null ? void 0 : Y2.tabSubmit) && t2.inputValue === "" && (d3.value = null, n("clear"));
    }, E2 = () => {
      p.value = true, n("focus");
    }, N = (i2) => {
      var Y2;
      i2.preventDefault(), i2.stopImmediatePropagation(), i2.stopPropagation(), t2.textInput && ((Y2 = t2.textInputOptions) == null ? void 0 : Y2.openMenu) ? t2.isMenuOpen ? t2.textInputOptions.enterSubmit && n("selectDate") : n("open") : t2.textInput || n("toggle");
    }, G2 = () => {
      p.value = false, t2.isMenuOpen || n("blur"), t2.autoApply && t2.textInput && d3.value && (n("setInputDate", d3.value), n("selectDate"), d3.value = null);
    }, T2 = () => {
      n("clear");
    }, x2 = (i2) => {
      t2.textInput || i2.preventDefault();
    };
    return a3({
      focusInput: () => {
        m3.value && m3.value.focus({ preventScroll: true });
      }
    }), (i2, Y2) => (openBlock(), createElementBlock("div", {
      onClick: N,
      "aria-label": unref(v).input,
      role: "textbox",
      "aria-multiline": "false",
      "aria-disabled": i2.disabled,
      "aria-readonly": i2.readonly
    }, [
      i2.$slots.trigger && !i2.$slots["dp-input"] && !e2.inline ? renderSlot(i2.$slots, "trigger", { key: 0 }) : createCommentVNode("", true),
      !i2.$slots.trigger && (!e2.inline || i2.inlineWithInput) ? (openBlock(), createElementBlock("div", Vl, [
        i2.$slots["dp-input"] && !i2.$slots.trigger && !e2.inline ? renderSlot(i2.$slots, "dp-input", {
          key: 0,
          value: e2.inputValue,
          onInput: w2,
          onEnter: V,
          onTab: R2,
          onClear: T2
        }) : createCommentVNode("", true),
        i2.$slots["dp-input"] ? createCommentVNode("", true) : (openBlock(), createElementBlock("input", {
          key: 1,
          ref_key: "inputRef",
          ref: m3,
          id: i2.uid ? `dp-input-${i2.uid}` : void 0,
          name: i2.name,
          class: normalizeClass(unref(g)),
          inputmode: i2.textInput ? "text" : "none",
          placeholder: i2.placeholder,
          disabled: i2.disabled,
          readonly: i2.readonly,
          required: i2.required,
          value: e2.inputValue,
          autocomplete: i2.autocomplete,
          onInput: w2,
          onKeydown: [
            withKeys(N, ["enter"]),
            withKeys(R2, ["tab"])
          ],
          onBlur: G2,
          onFocus: E2,
          onKeypress: x2
        }, null, 42, _l)),
        i2.$slots["input-icon"] && !i2.hideInputIcon ? (openBlock(), createElementBlock("span", Bl, [
          renderSlot(i2.$slots, "input-icon")
        ])) : createCommentVNode("", true),
        !i2.$slots["input-icon"] && !i2.hideInputIcon && !i2.$slots["dp-input"] ? (openBlock(), createBlock(unref(Wt), {
          key: 3,
          class: "dp__input_icon dp__input_icons"
        })) : createCommentVNode("", true),
        i2.$slots["clear-icon"] && e2.inputValue && i2.clearable && !i2.disabled && !i2.readonly ? (openBlock(), createElementBlock("span", Ol, [
          renderSlot(i2.$slots, "clear-icon", { clear: T2 })
        ])) : createCommentVNode("", true),
        i2.clearable && !i2.$slots["clear-icon"] && e2.inputValue && !i2.disabled && !i2.readonly ? (openBlock(), createBlock(unref(Za), {
          key: 5,
          class: "dp__clear_icon dp__input_icons",
          onClick: withModifiers(T2, ["stop", "prevent"])
        }, null, 8, ["onClick"])) : createCommentVNode("", true)
      ])) : createCommentVNode("", true)
    ], 8, Rl));
  }
});
var Il = (e2) => typeof e2 == "object";
var Bn = (e2, a3) => a3;
var Yl = (e2) => Array.isArray(e2) && e2.length === 2;
var El = (e2) => Array.isArray(e2);
var Fl = (e2) => typeof e2 == "object";
var bt = (e2) => Array.isArray(e2);
var Ve = (e2) => Array.isArray(e2);
var Yt = (e2) => Array.isArray(e2) && e2.length === 2;
var Hl = (e2, a3) => a3 ? Array.isArray(e2) : Yt(e2);
var Wl = (e2) => Array.isArray(e2);
var Kl = (e2) => typeof e2 == "string" || typeof e2 == "object" || typeof e2 == "number";
var On = (e2) => typeof e2 == "string";
var de = reactive({
  monthYear: [],
  calendar: [],
  time: [],
  actionRow: [],
  selectionGrid: [],
  timePicker: {
    0: [],
    1: []
  },
  monthPicker: []
});
var Qt = ref(null);
var Vt = ref(false);
var xt = ref(false);
var en = ref(false);
var tn = ref(false);
var $e = ref(0);
var he = ref(0);
var Je = () => {
  const e2 = computed(() => Vt.value ? [...de.selectionGrid, de.actionRow].filter((l) => l.length) : xt.value ? [
    ...de.timePicker[0],
    ...de.timePicker[1],
    tn.value ? [] : [Qt.value],
    de.actionRow
  ].filter((l) => l.length) : en.value ? [...de.monthPicker, de.actionRow] : [de.monthYear, ...de.calendar, de.time, de.actionRow].filter((l) => l.length)), a3 = (l) => {
    $e.value = l ? $e.value + 1 : $e.value - 1;
    let i2 = null;
    e2.value[he.value] && (i2 = e2.value[he.value][$e.value]), i2 || ($e.value = l ? $e.value - 1 : $e.value + 1);
  }, n = (l) => {
    if (he.value === 0 && !l || he.value === e2.value.length && l)
      return;
    he.value = l ? he.value + 1 : he.value - 1, e2.value[he.value] ? e2.value[he.value] && !e2.value[he.value][$e.value] && $e.value !== 0 && ($e.value = e2.value[he.value].length - 1) : he.value = l ? he.value - 1 : he.value + 1;
  }, t2 = (l) => {
    let i2 = null;
    e2.value[he.value] && (i2 = e2.value[he.value][$e.value]), i2 ? i2.focus({ preventScroll: !Vt.value }) : $e.value = l ? $e.value - 1 : $e.value + 1;
  }, d3 = () => {
    a3(true), t2(true);
  }, m3 = () => {
    a3(false), t2(false);
  }, p = () => {
    n(false), t2(true);
  }, v = () => {
    n(true), t2(true);
  }, g = (l, i2) => {
    de[i2] = l;
  }, w2 = (l, i2) => {
    de[i2] = l;
  }, V = () => {
    $e.value = 0, he.value = 0;
  };
  return {
    buildMatrix: g,
    buildMultiLevelMatrix: w2,
    setTimePickerBackRef: (l) => {
      Qt.value = l;
    },
    setSelectionGrid: (l) => {
      Vt.value = l, V(), l || (de.selectionGrid = []);
    },
    setTimePicker: (l, i2 = false) => {
      xt.value = l, tn.value = i2, V(), l || (de.timePicker[0] = [], de.timePicker[1] = []);
    },
    setTimePickerElements: (l, i2 = 0) => {
      de.timePicker[i2] = l;
    },
    arrowRight: d3,
    arrowLeft: m3,
    arrowUp: p,
    arrowDown: v,
    clearArrowNav: () => {
      de.monthYear = [], de.calendar = [], de.time = [], de.actionRow = [], de.selectionGrid = [], de.timePicker[0] = [], de.timePicker[1] = [], Vt.value = false, xt.value = false, tn.value = false, en.value = false, V(), Qt.value = null;
    },
    setMonthPicker: (l) => {
      en.value = l, V();
    }
  };
};
var Ul = (e2, a3, n) => {
  const t2 = new Date(JSON.parse(JSON.stringify(e2))), d3 = [];
  for (let m3 = 0; m3 < 7; m3++) {
    const p = addDays(t2, m3), v = getMonth(p) !== a3;
    d3.push({
      text: n && v ? "" : p.getDate(),
      value: p,
      current: !v
    });
  }
  return d3;
};
var Ll = (e2, a3, n, t2) => {
  const d3 = [], m3 = new Date(a3, e2), p = new Date(a3, e2 + 1, 0), v = startOfWeek(m3, { weekStartsOn: n }), g = (w2) => {
    const V = Ul(w2, e2, t2);
    if (d3.push({ days: V }), !d3[d3.length - 1].days.some((R2) => ce(Fe(R2.value), Fe(p)))) {
      const R2 = addDays(w2, 7);
      g(R2);
    }
  };
  return g(v), d3;
};
var Gl = (e2, a3 = 3) => {
  const n = [];
  for (let t2 = 0; t2 < e2.length; t2 += a3)
    n.push([e2[t2], e2[t2 + 1], e2[t2 + 2]]);
  return n;
};
var jl = (e2, a3) => {
  const n = [1, 2, 3, 4, 5, 6, 7].map((m3) => new Intl.DateTimeFormat(e2, { weekday: "short", timeZone: "UTC" }).format(/* @__PURE__ */ new Date(`2017-01-0${m3}T00:00:00+00:00`)).slice(0, 2)), t2 = n.slice(0, a3), d3 = n.slice(a3 + 1, n.length);
  return [n[a3]].concat(...d3).concat(...t2);
};
var zl = (e2) => {
  const a3 = [];
  for (let n = +e2[0]; n <= +e2[1]; n++)
    a3.push({ value: +n, text: `${n}` });
  return a3;
};
var Xl = (e2, a3) => {
  const n = new Intl.DateTimeFormat(e2, { month: a3, timeZone: "UTC" });
  return [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12].map((d3) => {
    const m3 = d3 < 10 ? `0${d3}` : d3;
    return /* @__PURE__ */ new Date(`2017-${m3}-01T00:00:00+00:00`);
  }).map((d3, m3) => ({
    text: n.format(d3),
    value: m3
  }));
};
var ql = (e2) => [12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11][e2];
var Jl = () => ({
  enterSubmit: true,
  tabSubmit: true,
  openMenu: true,
  rangeSeparator: " - "
});
var Zl = (e2) => Object.assign({ months: [], years: [], times: { hours: [], minutes: [], seconds: [] } }, e2);
var Ql = (e2) => {
  function n(t2) {
    let d3 = "";
    const m3 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", p = m3.length;
    for (let v = 0; v < t2; v++)
      d3 += m3.charAt(Math.floor(Math.random() * p));
    return d3 + e2;
  }
  return n(5);
};
var ke = (e2) => {
  var n;
  const a3 = unref(e2);
  return (n = a3 == null ? void 0 : a3.$el) != null ? n : a3;
};
var xl = (e2) => Object.assign({ type: "dot" }, e2);
var Nn = (e2) => Object.assign(
  {
    menuAppear: "dp-menu-appear",
    open: "dp-slide-down",
    close: "dp-slide-up",
    next: "calendar-next",
    previous: "calendar-prev",
    vNext: "dp-slide-up",
    vPrevious: "dp-slide-down"
  },
  e2
);
var er = (e2) => Object.assign(
  {
    toggleOverlay: "Toggle overlay",
    menu: "Datepicker menu",
    input: "Datepicker input",
    calendarWrap: "Calendar wrapper",
    calendarDays: "Calendar days",
    openTimePicker: "Open time picker",
    closeTimePicker: "Close time Picker",
    incrementValue: (a3) => `Increment ${a3}`,
    decrementValue: (a3) => `Decrement ${a3}`,
    openTpOverlay: (a3) => `Open ${a3} overlay`,
    amPmButton: "Switch AM/PM mode",
    openYearsOverlay: "Open years overlay",
    openMonthsOverlay: "Open months overlay",
    nextMonth: "Next month",
    prevMonth: "Previous month"
  },
  e2
);
var oa = (e2) => Array.isArray(e2) ? !!e2[0] && !!e2[1] : false;
var tr = { class: "dp__selection_preview" };
var nr = { class: "dp__action_buttons" };
var ar = ["onKeydown"];
var lr = defineComponent({
  __name: "ActionRow",
  props: {
    ...na,
    ...kn,
    ...ta,
    ...wn,
    ...ra,
    inline: { type: Boolean, default: false },
    timePicker: { type: Boolean, default: false },
    calendarWidth: { type: Number, default: 0 },
    menuMount: { type: Boolean, default: false },
    enableTimePicker: { type: Boolean, default: true }
  },
  emits: ["closePicker", "selectDate", "invalid-select"],
  setup(e2, { emit: a3 }) {
    const n = e2, { buildMatrix: t2 } = Je(), d3 = inject(Zn), m3 = inject(qe), p = ref(null), v = ref(null);
    onMounted(() => {
      m3 != null && m3.value && t2([ke(p), ke(v)], "actionRow");
    });
    const g = computed(() => n.range && !n.partialRange && n.internalModelValue ? n.internalModelValue.length === 2 : true), w2 = computed(() => ({
      dp__action: true,
      dp__select: true,
      dp__action_disabled: !V.value || !R2.value || !g.value
    })), V = computed(() => !n.enableTimePicker || n.ignoreTimeValidation ? true : on(n.internalModelValue, n.maxTime, n.minTime, n.maxDate, n.minDate)), R2 = computed(() => n.monthPicker ? Pl(n.internalModelValue, n.minDate, n.maxDate) : true), E2 = (T2) => vt(T2, n.previewFormat, d3 == null ? void 0 : d3.value), N = computed(() => !n.internalModelValue || !n.menuMount ? "" : typeof n.previewFormat == "string" ? bt(n.internalModelValue) ? n.internalModelValue.length === 2 && n.internalModelValue[1] ? n.multiCalendars > 0 ? `${E2(n.internalModelValue[0])} - ${E2(
      n.internalModelValue[1]
    )}` : [E2(n.internalModelValue[0]), E2(n.internalModelValue[1])] : n.multiDates ? n.internalModelValue.map((T2) => `${E2(T2)}`) : n.modelAuto ? `${E2(n.internalModelValue[0])}` : `${E2(n.internalModelValue[0])} -` : vt(n.internalModelValue, n.previewFormat, d3 == null ? void 0 : d3.value) : n.timePicker ? n.previewFormat(sn(n.internalModelValue)) : n.monthPicker ? n.previewFormat(It(n.internalModelValue)) : n.previewFormat(n.internalModelValue)), G2 = () => {
      V.value && R2.value && g.value ? a3("selectDate") : a3("invalid-select");
    };
    return (T2, x2) => (openBlock(), createElementBlock("div", {
      class: "dp__action_row",
      style: normalizeStyle(e2.calendarWidth ? { width: `${e2.calendarWidth}px` } : {})
    }, [
      createBaseVNode("div", tr, [
        T2.$slots["action-preview"] ? renderSlot(T2.$slots, "action-preview", {
          key: 0,
          value: T2.internalModelValue
        }) : createCommentVNode("", true),
        T2.$slots["action-preview"] ? createCommentVNode("", true) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
          Array.isArray(unref(N)) ? createCommentVNode("", true) : (openBlock(), createElementBlock(Fragment, { key: 0 }, [
            createTextVNode(toDisplayString(unref(N)), 1)
          ], 64)),
          Array.isArray(unref(N)) ? (openBlock(true), createElementBlock(Fragment, { key: 1 }, renderList(unref(N), (l, i2) => (openBlock(), createElementBlock("div", { key: i2 }, toDisplayString(l), 1))), 128)) : createCommentVNode("", true)
        ], 64))
      ]),
      createBaseVNode("div", nr, [
        T2.$slots["action-select"] ? renderSlot(T2.$slots, "action-select", {
          key: 0,
          value: T2.internalModelValue
        }) : createCommentVNode("", true),
        T2.$slots["action-select"] ? createCommentVNode("", true) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
          e2.inline ? createCommentVNode("", true) : (openBlock(), createElementBlock("span", {
            key: 0,
            class: "dp__action dp__cancel",
            ref_key: "cancelButtonRef",
            ref: p,
            tabindex: "0",
            onClick: x2[0] || (x2[0] = (l) => T2.$emit("closePicker")),
            onKeydown: [
              x2[1] || (x2[1] = withKeys((l) => T2.$emit("closePicker"), ["enter"])),
              x2[2] || (x2[2] = withKeys((l) => T2.$emit("closePicker"), ["space"]))
            ]
          }, toDisplayString(T2.cancelText), 545)),
          createBaseVNode("span", {
            class: normalizeClass(unref(w2)),
            tabindex: "0",
            onKeydown: [
              withKeys(G2, ["enter"]),
              withKeys(G2, ["space"])
            ],
            onClick: G2,
            ref_key: "selectButtonRef",
            ref: v
          }, toDisplayString(T2.selectText), 43, ar)
        ], 64))
      ])
    ], 4));
  }
});
var rr = ["aria-label"];
var sr = {
  class: "dp__calendar_header",
  role: "row"
};
var or = {
  key: 0,
  class: "dp__calendar_header_item",
  role: "gridcell"
};
var ir = createBaseVNode("div", { class: "dp__calendar_header_separator" }, null, -1);
var ur = ["aria-label"];
var dr = {
  key: 0,
  role: "gridcell",
  class: "dp__calendar_item dp__week_num"
};
var cr = { class: "dp__cell_inner" };
var fr = ["aria-selected", "aria-disabled", "onClick", "onKeydown", "onMouseover"];
var mr = createBaseVNode("div", { class: "dp__arrow_bottom_tp" }, null, -1);
var vr = defineComponent({
  __name: "Calendar",
  props: {
    ...sa,
    ...aa,
    mappedDates: { type: Array, default: () => [] },
    getWeekNum: {
      type: Function,
      default: () => ""
    },
    modeHeight: { type: [Number, String], default: 255 },
    specificMode: { type: Boolean, default: false }
  },
  emits: ["selectDate", "setHoverDate", "handleScroll", "mount", "handleSwipe", "handleSpace"],
  setup(e2, { expose: a3, emit: n }) {
    const t2 = e2, d3 = ref(null), m3 = ref({ bottom: "", left: "", transform: "" }), p = ref([]), v = ref(null), g = ref(true), w2 = inject(Kt), V = inject(Xe), R2 = inject(qe), E2 = ref(""), N = ref({ startX: 0, endX: 0, startY: 0, endY: 0 }), G2 = computed(() => t2.dayNames ? Array.isArray(t2.dayNames) ? t2.dayNames : t2.dayNames(t2.locale, +t2.weekStart) : jl(t2.locale, +t2.weekStart)), { buildMultiLevelMatrix: T2 } = Je();
    onMounted(() => {
      n("mount", { cmp: "calendar", refs: p }), t2.noSwipe || v.value && (v.value.addEventListener("touchstart", ee, { passive: false }), v.value.addEventListener("touchend", Z, { passive: false }), v.value.addEventListener("touchmove", j, { passive: false })), t2.monthChangeOnScroll && v.value && v.value.addEventListener("wheel", u2, { passive: false });
    });
    const x2 = (s3, h3) => {
      if (w2 != null && w2.value) {
        const F = Fe(st(/* @__PURE__ */ new Date(), t2.month, t2.year));
        E2.value = De(Fe(st(/* @__PURE__ */ new Date(), s3, h3)), F) ? w2.value[t2.vertical ? "vNext" : "next"] : w2.value[t2.vertical ? "vPrevious" : "previous"], g.value = false, nextTick(() => {
          g.value = true;
        });
      }
    }, l = computed(
      () => ({
        dp__calendar_wrap: true,
        [t2.calendarClassName]: !!t2.calendarClassName
      })
    ), i2 = computed(() => (s3) => {
      const h3 = xl(s3);
      return {
        dp__marker_dot: h3.type === "dot",
        dp__marker_line: h3.type === "line"
      };
    }), Y2 = computed(() => (s3) => ce(s3, d3.value)), z2 = computed(() => ({
      dp__calendar: true,
      dp__calendar_next: t2.multiCalendars > 0 && t2.instance !== 0
    })), P = computed(() => t2.specificMode ? { height: `${t2.modeHeight}px` } : null), K2 = (s3, h3, F) => {
      var J, I2;
      if (n("setHoverDate", s3), (I2 = (J = s3.marker) == null ? void 0 : J.tooltip) != null && I2.length) {
        const oe = ke(p.value[h3][F]);
        if (oe) {
          const { width: te, height: k2 } = oe.getBoundingClientRect();
          m3.value = {
            bottom: `${k2}px`,
            left: `${te / 2}px`,
            transform: "translateX(-50%)"
          }, d3.value = s3.value;
        }
      }
    }, X2 = () => {
      d3.value = null;
    }, ee = (s3) => {
      N.value.startX = s3.changedTouches[0].screenX, N.value.startY = s3.changedTouches[0].screenY;
    }, Z = (s3) => {
      N.value.endX = s3.changedTouches[0].screenX, N.value.endY = s3.changedTouches[0].screenY, M3();
    }, j = (s3) => {
      s3.preventDefault();
    }, M3 = () => {
      const s3 = t2.vertical ? "Y" : "X";
      Math.abs(N.value[`start${s3}`] - N.value[`end${s3}`]) > 10 && n("handleSwipe", N.value[`start${s3}`] > N.value[`end${s3}`] ? "right" : "left");
    }, D2 = (s3, h3, F) => {
      s3 && (Array.isArray(p.value[h3]) ? p.value[h3][F] = s3 : p.value[h3] = [s3]), R2 != null && R2.value && T2(p.value, "calendar");
    }, u2 = (s3) => {
      t2.monthChangeOnScroll && (s3.preventDefault(), n("handleScroll", s3));
    };
    return a3({ triggerTransition: x2 }), (s3, h3) => (openBlock(), createElementBlock("div", {
      class: normalizeClass(unref(z2))
    }, [
      createBaseVNode("div", {
        style: normalizeStyle(unref(P))
      }, [
        e2.specificMode ? createCommentVNode("", true) : (openBlock(), createElementBlock("div", {
          key: 0,
          ref_key: "calendarWrapRef",
          ref: v,
          class: normalizeClass(unref(l)),
          role: "grid",
          "aria-label": unref(V).calendarWrap
        }, [
          createBaseVNode("div", sr, [
            s3.weekNumbers ? (openBlock(), createElementBlock("div", or, toDisplayString(s3.weekNumName), 1)) : createCommentVNode("", true),
            (openBlock(true), createElementBlock(Fragment, null, renderList(unref(G2), (F, J) => (openBlock(), createElementBlock("div", {
              class: "dp__calendar_header_item",
              role: "gridcell",
              key: J
            }, [
              s3.$slots["calendar-header"] ? renderSlot(s3.$slots, "calendar-header", {
                key: 0,
                day: F,
                index: J
              }) : createCommentVNode("", true),
              s3.$slots["calendar-header"] ? createCommentVNode("", true) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                createTextVNode(toDisplayString(F), 1)
              ], 64))
            ]))), 128))
          ]),
          ir,
          createVNode(Transition, {
            name: E2.value,
            css: !!unref(w2)
          }, {
            default: withCtx(() => [
              g.value ? (openBlock(), createElementBlock("div", {
                key: 0,
                class: "dp__calendar",
                role: "grid",
                "aria-label": unref(V).calendarDays
              }, [
                (openBlock(true), createElementBlock(Fragment, null, renderList(e2.mappedDates, (F, J) => (openBlock(), createElementBlock("div", {
                  class: "dp__calendar_row",
                  role: "row",
                  key: J
                }, [
                  s3.weekNumbers ? (openBlock(), createElementBlock("div", dr, [
                    createBaseVNode("div", cr, toDisplayString(e2.getWeekNum(F.days)), 1)
                  ])) : createCommentVNode("", true),
                  (openBlock(true), createElementBlock(Fragment, null, renderList(F.days, (I2, oe) => (openBlock(), createElementBlock("div", {
                    role: "gridcell",
                    class: "dp__calendar_item",
                    ref_for: true,
                    ref: (te) => D2(te, J, oe),
                    key: oe + J,
                    "aria-selected": I2.classData.dp__active_date || I2.classData.dp__range_start || I2.classData.dp__range_start,
                    "aria-disabled": I2.classData.dp__cell_disabled,
                    tabindex: "0",
                    onClick: withModifiers((te) => s3.$emit("selectDate", I2), ["stop", "prevent"]),
                    onKeydown: [
                      withKeys((te) => s3.$emit("selectDate", I2), ["enter"]),
                      withKeys((te) => s3.$emit("handleSpace", I2), ["space"])
                    ],
                    onMouseover: (te) => K2(I2, J, oe),
                    onMouseleave: X2
                  }, [
                    createBaseVNode("div", {
                      class: normalizeClass(["dp__cell_inner", I2.classData])
                    }, [
                      s3.$slots.day ? renderSlot(s3.$slots, "day", {
                        key: 0,
                        day: +I2.text,
                        date: I2.value
                      }) : createCommentVNode("", true),
                      s3.$slots.day ? createCommentVNode("", true) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                        createTextVNode(toDisplayString(I2.text), 1)
                      ], 64)),
                      I2.marker ? (openBlock(), createElementBlock("div", {
                        key: 2,
                        class: normalizeClass(unref(i2)(I2.marker)),
                        style: normalizeStyle(I2.marker.color ? { backgroundColor: I2.marker.color } : {})
                      }, null, 6)) : createCommentVNode("", true),
                      unref(Y2)(I2.value) ? (openBlock(), createElementBlock("div", {
                        key: 3,
                        class: "dp__marker_tooltip",
                        style: normalizeStyle(m3.value)
                      }, [
                        createBaseVNode("div", {
                          class: "dp__tooltip_content",
                          onClick: h3[0] || (h3[0] = withModifiers(() => {
                          }, ["stop"]))
                        }, [
                          (openBlock(true), createElementBlock(Fragment, null, renderList(I2.marker.tooltip, (te, k2) => (openBlock(), createElementBlock("div", {
                            key: k2,
                            class: "dp__tooltip_text"
                          }, [
                            s3.$slots["marker-tooltip"] ? renderSlot(s3.$slots, "marker-tooltip", {
                              key: 0,
                              tooltop: te,
                              day: I2.value
                            }) : createCommentVNode("", true),
                            s3.$slots["marker-tooltip"] ? createCommentVNode("", true) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                              createBaseVNode("div", {
                                class: "dp__tooltip_mark",
                                style: normalizeStyle(te.color ? { backgroundColor: te.color } : {})
                              }, null, 4),
                              createBaseVNode("div", null, toDisplayString(te.text), 1)
                            ], 64))
                          ]))), 128)),
                          mr
                        ])
                      ], 4)) : createCommentVNode("", true)
                    ], 2)
                  ], 40, fr))), 128))
                ]))), 128))
              ], 8, ur)) : createCommentVNode("", true)
            ]),
            _: 3
          }, 8, ["name", "css"])
        ], 10, rr))
      ], 4)
    ], 2));
  }
});
var yr = ["aria-label", "aria-disabled"];
var nn = defineComponent({
  __name: "ActionIcon",
  props: {
    ariaLabel: { type: String, default: "" },
    disabled: { type: Boolean, default: false }
  },
  emits: ["activate", "setRef"],
  setup(e2, { emit: a3 }) {
    const n = ref(null);
    return onMounted(() => a3("setRef", n)), (t2, d3) => (openBlock(), createElementBlock("div", {
      class: "dp__month_year_col_nav",
      onClick: d3[0] || (d3[0] = (m3) => t2.$emit("activate")),
      onKeydown: [
        d3[1] || (d3[1] = withKeys((m3) => t2.$emit("activate"), ["enter"])),
        d3[2] || (d3[2] = withKeys((m3) => t2.$emit("activate"), ["space"]))
      ],
      tabindex: "0",
      role: "button",
      "aria-label": e2.ariaLabel,
      "aria-disabled": e2.disabled,
      ref_key: "elRef",
      ref: n
    }, [
      createBaseVNode("div", {
        class: normalizeClass(["dp__inner_nav", { dp__inner_nav_disabled: e2.disabled }])
      }, [
        renderSlot(t2.$slots, "default")
      ], 2)
    ], 40, yr));
  }
});
var pr = { class: "dp__selection_grid_header" };
var hr = ["aria-selected", "aria-disabled", "onClick", "onKeydown", "onMouseover"];
var gr = ["aria-label", "onKeydown"];
var Mt = defineComponent({
  __name: "SelectionGrid",
  props: {
    items: { type: Array, default: () => [] },
    modelValue: { type: [String, Number], default: null },
    multiModelValue: { type: Array, default: () => [] },
    disabledValues: { type: Array, default: () => [] },
    minValue: { type: [Number, String], default: null },
    maxValue: { type: [Number, String], default: null },
    year: { type: Number, default: 0 },
    skipActive: { type: Boolean, default: false },
    headerRefs: { type: Array, default: () => [] },
    skipButtonRef: { type: Boolean, default: false },
    monthPicker: { type: Boolean, default: false },
    yearPicker: { type: Boolean, default: false }
  },
  emits: ["update:modelValue", "selected", "toggle", "reset-flow"],
  setup(e2, { expose: a3, emit: n }) {
    const t2 = e2, d3 = ref(false), m3 = ref(null), p = ref(null), v = ref([]), g = inject(pn, false), w2 = inject(Jn, ref(false)), V = inject(Xe), R2 = inject(qe), E2 = ref(), N = ref(), { setSelectionGrid: G2, buildMultiLevelMatrix: T2, setMonthPicker: x2 } = Je();
    onBeforeUpdate(() => {
      m3.value = null;
    }), onMounted(() => {
      nextTick().then(() => Z()), i2(), l(true);
    }), onUnmounted(() => l(false));
    const l = (s3) => {
      var h3;
      R2 != null && R2.value && ((h3 = t2.headerRefs) != null && h3.length ? x2(s3) : G2(s3));
    }, i2 = () => {
      const s3 = ke(p);
      s3 && (w2.value || s3.focus({ preventScroll: true }), d3.value = s3.clientHeight < s3.scrollHeight);
    }, Y2 = computed(
      () => ({
        dp__overlay: true
      })
    ), z2 = computed(() => ({
      dp__overlay_col: true
    })), P = computed(() => t2.items.map((s3) => s3.filter((h3) => h3).map((h3) => {
      var I2, oe, te;
      const F = t2.disabledValues.some((k2) => k2 === h3.value) || ee(h3.value), J = (I2 = t2.multiModelValue) != null && I2.length ? (oe = t2.multiModelValue) == null ? void 0 : oe.some(
        (k2) => ce(
          k2,
          setYear(
            t2.monthPicker ? setMonth(/* @__PURE__ */ new Date(), h3.value) : /* @__PURE__ */ new Date(),
            t2.monthPicker ? t2.year : h3.value
          )
        )
      ) : t2.skipActive ? false : h3.value === t2.modelValue;
      return {
        ...h3,
        className: {
          dp__overlay_cell_active: J,
          dp__overlay_cell: !J,
          dp__overlay_cell_disabled: F,
          dp__overlay_cell_active_disabled: F && J,
          dp__overlay_cell_pad: true,
          dp__cell_in_between: (te = t2.multiModelValue) != null && te.length ? M3(h3.value) : false
        }
      };
    }))), K2 = computed(
      () => ({
        dp__button: true,
        dp__overlay_action: true,
        dp__over_action_scroll: d3.value,
        dp__button_bottom: g
      })
    ), X2 = computed(() => {
      var s3, h3;
      return {
        dp__overlay_container: true,
        dp__container_flex: ((s3 = t2.items) == null ? void 0 : s3.length) <= 6,
        dp__container_block: ((h3 = t2.items) == null ? void 0 : h3.length) > 6
      };
    }), ee = (s3) => {
      const h3 = t2.maxValue || t2.maxValue === 0, F = t2.minValue || t2.minValue === 0;
      return !h3 && !F ? false : h3 && F ? +s3 > +t2.maxValue || +s3 < +t2.minValue : h3 ? +s3 > +t2.maxValue : F ? +s3 < +t2.minValue : false;
    }, Z = () => {
      const s3 = ke(m3);
      if (s3) {
        const h3 = ke(p);
        h3 && (h3.scrollTop = s3.offsetTop - h3.offsetTop - (h3.getBoundingClientRect().height / 2 - s3.getBoundingClientRect().height));
      }
    }, j = (s3) => {
      !t2.disabledValues.some((h3) => h3 === s3) && !ee(s3) && (n("update:modelValue", s3), n("selected"));
    }, M3 = (s3) => {
      const h3 = t2.monthPicker ? t2.year : s3;
      return zn(
        t2.multiModelValue,
        setYear(
          t2.monthPicker ? setMonth(/* @__PURE__ */ new Date(), E2.value || 0) : /* @__PURE__ */ new Date(),
          t2.monthPicker ? h3 : E2.value || h3
        ),
        setYear(t2.monthPicker ? setMonth(/* @__PURE__ */ new Date(), s3) : /* @__PURE__ */ new Date(), h3)
      );
    }, D2 = () => {
      n("toggle"), n("reset-flow");
    }, u2 = (s3, h3, F, J) => {
      var I2, oe;
      if (s3 && (h3.value === +t2.modelValue && !t2.disabledValues.includes(h3.value) && (m3.value = s3), R2 != null && R2.value)) {
        Array.isArray(v.value[F]) ? v.value[F][J] = s3 : v.value[F] = [s3];
        const te = (I2 = t2.headerRefs) != null && I2.length ? [t2.headerRefs].concat(v.value) : v.value.concat([t2.skipButtonRef ? [] : [N.value]]);
        T2(te, (oe = t2.headerRefs) != null && oe.length ? "monthPicker" : "selectionGrid");
      }
    };
    return a3({ focusGrid: i2 }), (s3, h3) => (openBlock(), createElementBlock("div", {
      ref_key: "gridWrapRef",
      ref: p,
      class: normalizeClass(unref(Y2)),
      role: "dialog",
      tabindex: "0"
    }, [
      createBaseVNode("div", {
        class: normalizeClass(unref(X2)),
        role: "grid"
      }, [
        createBaseVNode("div", pr, [
          renderSlot(s3.$slots, "header")
        ]),
        (openBlock(true), createElementBlock(Fragment, null, renderList(unref(P), (F, J) => (openBlock(), createElementBlock("div", {
          class: "dp__overlay_row",
          key: unref(Ql)(J),
          role: "row"
        }, [
          (openBlock(true), createElementBlock(Fragment, null, renderList(F, (I2, oe) => (openBlock(), createElementBlock("div", {
            role: "gridcell",
            class: normalizeClass(unref(z2)),
            key: I2.value,
            "aria-selected": I2.value === e2.modelValue && !e2.disabledValues.includes(I2.value),
            "aria-disabled": I2.className.dp__overlay_cell_disabled,
            ref_for: true,
            ref: (te) => u2(te, I2, J, oe),
            tabindex: "0",
            onClick: (te) => j(I2.value),
            onKeydown: [
              withKeys((te) => j(I2.value), ["enter"]),
              withKeys((te) => j(I2.value), ["space"])
            ],
            onMouseover: (te) => E2.value = I2.value
          }, [
            createBaseVNode("div", {
              class: normalizeClass(I2.className)
            }, [
              s3.$slots.item ? renderSlot(s3.$slots, "item", {
                key: 0,
                item: I2
              }) : createCommentVNode("", true),
              s3.$slots.item ? createCommentVNode("", true) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                createTextVNode(toDisplayString(I2.text), 1)
              ], 64))
            ], 2)
          ], 42, hr))), 128))
        ]))), 128)),
        s3.$slots["button-icon"] ? (openBlock(), createElementBlock("div", {
          key: 0,
          role: "button",
          "aria-label": unref(V).toggleOverlay,
          class: normalizeClass(unref(K2)),
          tabindex: "0",
          ref_key: "toggleButton",
          ref: N,
          onClick: D2,
          onKeydown: withKeys(D2, ["enter"])
        }, [
          renderSlot(s3.$slots, "button-icon")
        ], 42, gr)) : createCommentVNode("", true)
      ], 2)
    ], 2));
  }
});
var Ut = () => {
  const e2 = inject(Kt);
  return { transitionName: computed(() => (n) => e2 != null && e2.value ? n ? e2.value.open : e2.value.close : ""), showTransition: !!(e2 != null && e2.value) };
};
var kr = ["aria-label"];
var In = defineComponent({
  __name: "RegularPicker",
  props: {
    ariaLabel: { type: String, default: "" },
    showSelectionGrid: { type: Boolean, default: false },
    modelValue: { type: Number, default: null },
    items: { type: Array, default: () => [] },
    disabledValues: { type: Array, default: () => [] },
    minValue: { type: Number, default: null },
    maxValue: { type: Number, default: null },
    slotName: { type: String, default: "" },
    headerRefs: { type: Array, default: () => [] }
  },
  emits: ["update:model-value", "toggle", "setRef"],
  setup(e2, { emit: a3 }) {
    const { transitionName: n, showTransition: t2 } = Ut(), d3 = ref(null);
    return onMounted(() => a3("setRef", d3)), (m3, p) => (openBlock(), createElementBlock(Fragment, null, [
      createBaseVNode("div", {
        class: "dp__month_year_select",
        onClick: p[0] || (p[0] = (v) => m3.$emit("toggle")),
        onKeydown: [
          p[1] || (p[1] = withKeys((v) => m3.$emit("toggle"), ["enter"])),
          p[2] || (p[2] = withKeys((v) => m3.$emit("toggle"), ["space"]))
        ],
        role: "button",
        "aria-label": e2.ariaLabel,
        tabindex: "0",
        ref_key: "elRef",
        ref: d3
      }, [
        renderSlot(m3.$slots, "default")
      ], 40, kr),
      createVNode(Transition, {
        name: unref(n)(e2.showSelectionGrid),
        css: unref(t2)
      }, {
        default: withCtx(() => [
          e2.showSelectionGrid ? (openBlock(), createBlock(Mt, mergeProps({ key: 0 }, {
            modelValue: e2.modelValue,
            items: e2.items,
            disabledValues: e2.disabledValues,
            minValue: e2.minValue,
            maxValue: e2.maxValue
          }, {
            "header-refs": [],
            "onUpdate:modelValue": p[3] || (p[3] = (v) => m3.$emit("update:model-value", v)),
            onToggle: p[4] || (p[4] = (v) => m3.$emit("toggle"))
          }), createSlots({
            "button-icon": withCtx(() => [
              m3.$slots["calendar-icon"] ? renderSlot(m3.$slots, "calendar-icon", { key: 0 }) : createCommentVNode("", true),
              m3.$slots["calendar-icon"] ? createCommentVNode("", true) : (openBlock(), createBlock(unref(Wt), { key: 1 }))
            ]),
            _: 2
          }, [
            m3.$slots[e2.slotName] ? {
              name: "item",
              fn: withCtx(({ item: v }) => [
                renderSlot(m3.$slots, e2.slotName, { item: v })
              ]),
              key: "0"
            } : void 0
          ]), 1040)) : createCommentVNode("", true)
        ]),
        _: 3
      }, 8, ["name", "css"])
    ], 64));
  }
});
var Ft = (e2, a3, n) => [set(new Date(e2), { date: 1 }), set(/* @__PURE__ */ new Date(), { month: a3, year: n, date: 1 })];
var un = (e2, a3, n) => we(...Ft(e2, a3, n)) || ce(...Ft(e2, a3, n));
var dn = (e2, a3, n) => De(...Ft(e2, a3, n)) || ce(...Ft(e2, a3, n));
var ia = (e2, a3, n, t2, d3, m3) => {
  let p = false;
  return m3 ? e2 && a3 ? (a3 && d3 && dn(a3, n, t2) && (p = true), e2 && !d3 && un(e2, n, t2) && (p = true)) : (e2 && un(e2, n, t2) || a3 && dn(a3, n, t2)) && (p = true) : p = true, p;
};
var wr = (e2, a3) => {
  const n = (v, g) => {
    let w2 = v;
    return e2.filters.months.includes(getMonth(w2)) ? (w2 = g ? addMonths(v, 1) : subMonths(v, 1), n(w2, g)) : w2;
  }, t2 = (v, g) => {
    let w2 = v;
    return e2.filters.years.includes(getYear(w2)) ? (w2 = g ? addYears(v, 1) : subYears(v, 1), t2(w2, g)) : w2;
  }, d3 = (v) => {
    const g = set(/* @__PURE__ */ new Date(), { month: e2.month, year: e2.year });
    let w2 = v ? addMonths(g, 1) : subMonths(g, 1), V = getMonth(w2), R2 = getYear(w2);
    e2.filters.months.includes(V) && (w2 = n(w2, v), V = getMonth(w2), R2 = getYear(w2)), e2.filters.years.includes(R2) && (w2 = t2(w2, v), R2 = getYear(w2)), ia(e2.minDate, e2.maxDate, V, R2, v, e2.preventMinMaxNavigation) && m3(V, R2);
  }, m3 = (v, g) => {
    a3("update-month-year", { month: v, year: g });
  }, p = computed(() => (v) => {
    if (!e2.preventMinMaxNavigation || v && !e2.maxDate || !v && !e2.minDate)
      return false;
    const g = set(/* @__PURE__ */ new Date(), { month: e2.month, year: e2.year }), w2 = v ? addMonths(g, 1) : subMonths(g, 1), V = [getMonth(w2), getYear(w2)];
    return v ? !dn(e2.maxDate, ...V) : !un(e2.minDate, ...V);
  });
  return { handleMonthYearChange: d3, isDisabled: p };
};
var br = { class: "dp__month_year_row" };
var $r = { class: "dp__month_picker_header" };
var Dr = ["aria-label"];
var Mr = ["aria-label", "onKeydown"];
var Sr = ["aria-label"];
var Ar = defineComponent({
  __name: "MonthYearPicker",
  props: {
    ...sa,
    ...kn,
    preventMinMaxNavigation: { type: Boolean, default: false },
    reverseYears: { type: Boolean, default: false },
    years: { type: Array, default: () => [] },
    months: { type: Array, default: () => [] },
    filters: { type: Object, default: () => ({}) },
    multiCalendarsSolo: { type: Boolean, default: false },
    yearPicker: { type: Boolean, default: false }
  },
  emits: ["update-month-year", "monthYearSelect", "mount", "reset-flow", "overlay-closed"],
  setup(e2, { expose: a3, emit: n }) {
    const t2 = e2, { transitionName: d3, showTransition: m3 } = Ut(), { buildMatrix: p } = Je(), v = ref(false), g = ref(false), w2 = ref([null, null, null, null]), V = ref(null), R2 = ref(null), E2 = ref(null), N = inject(Xe), G2 = inject(qe), { handleMonthYearChange: T2, isDisabled: x2 } = wr(t2, n);
    onMounted(() => {
      n("mount");
    });
    const l = (k2) => ({
      get: () => t2[k2],
      set: (_) => {
        const O2 = k2 === "month" ? "year" : "month";
        n("update-month-year", { [k2]: _, [O2]: t2[O2] }), n("monthYearSelect", k2 === "year"), k2 === "month" ? F(true) : J(true);
      }
    }), i2 = computed(l("month")), Y2 = computed(l("year")), z2 = computed(() => (k2) => {
      const _ = k2 === "month";
      return {
        showSelectionGrid: (_ ? v : g).value,
        items: (_ ? D2 : u2).value,
        disabledValues: t2.filters[_ ? "months" : "years"],
        minValue: (_ ? X2 : P).value,
        maxValue: (_ ? ee : K2).value,
        headerRefs: _ && t2.monthPicker ? [V.value, R2.value, E2.value] : []
      };
    }), P = computed(() => t2.minDate ? getYear(new Date(t2.minDate)) : null), K2 = computed(() => t2.maxDate ? getYear(new Date(t2.maxDate)) : null), X2 = computed(() => {
      if (t2.minDate && P.value) {
        if (P.value > t2.year)
          return 12;
        if (P.value === t2.year)
          return getMonth(new Date(t2.minDate));
      }
      return null;
    }), ee = computed(() => t2.maxDate && K2.value ? K2.value < t2.year ? -1 : K2.value === t2.year ? getMonth(new Date(t2.maxDate)) : null : null), Z = computed(() => t2.range && t2.internalModelValue && (t2.monthPicker || t2.yearPicker) ? t2.internalModelValue : []), j = (k2, _ = false) => {
      const O2 = [];
      for (let Re = 0; Re < k2.length; Re += 3) {
        const Ie = [k2[Re], k2[Re + 1], k2[Re + 2]];
        O2.push(_ ? Ie.reverse() : Ie);
      }
      return _ ? O2.reverse() : O2;
    }, M3 = computed(() => {
      const k2 = t2.months.find((_) => _.value === t2.month);
      return k2 || { text: "", value: 0 };
    }), D2 = computed(() => j(t2.months)), u2 = computed(() => j(t2.years, t2.reverseYears)), s3 = computed(() => t2.multiCalendars ? t2.multiCalendarsSolo ? true : t2.instance === 0 : true), h3 = computed(() => t2.multiCalendars ? t2.multiCalendarsSolo ? true : t2.instance === t2.multiCalendars - 1 : true), F = (k2 = false) => {
      I2(k2), v.value = !v.value, v.value || n("overlay-closed");
    }, J = (k2 = false) => {
      I2(k2), g.value = !g.value, g.value || n("overlay-closed");
    }, I2 = (k2) => {
      k2 || n("reset-flow");
    }, oe = (k2 = false) => {
      n("update-month-year", { year: k2 ? t2.year + 1 : t2.year - 1, month: t2.month });
    }, te = (k2, _) => {
      G2 != null && G2.value && (w2.value[_] = ke(k2), p(w2.value, "monthYear"));
    };
    return a3({
      toggleMonthPicker: F,
      toggleYearPicker: J
    }), (k2, _) => (openBlock(), createElementBlock("div", br, [
      !k2.monthPicker && !e2.yearPicker ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
        unref(s3) && !k2.vertical ? (openBlock(), createBlock(nn, {
          key: 0,
          "aria-label": unref(N).prevMonth,
          disabled: unref(x2)(false),
          onActivate: _[0] || (_[0] = (O2) => unref(T2)(false)),
          onSetRef: _[1] || (_[1] = (O2) => te(O2, 0))
        }, {
          default: withCtx(() => [
            k2.$slots["arrow-left"] ? renderSlot(k2.$slots, "arrow-left", { key: 0 }) : createCommentVNode("", true),
            k2.$slots["arrow-left"] ? createCommentVNode("", true) : (openBlock(), createBlock(unref(Pn), { key: 1 }))
          ]),
          _: 3
        }, 8, ["aria-label", "disabled"])) : createCommentVNode("", true),
        createVNode(In, mergeProps({
          "aria-label": unref(N).openMonthsOverlay,
          "slot-name": "month-overlay",
          modelValue: unref(i2),
          "onUpdate:modelValue": _[2] || (_[2] = (O2) => isRef(i2) ? i2.value = O2 : null)
        }, unref(z2)("month"), {
          onToggle: F,
          onSetRef: _[3] || (_[3] = (O2) => te(O2, 1))
        }), createSlots({
          default: withCtx(() => [
            k2.$slots.month ? renderSlot(k2.$slots, "month", normalizeProps(mergeProps({ key: 0 }, unref(M3)))) : createCommentVNode("", true),
            k2.$slots.month ? createCommentVNode("", true) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
              createTextVNode(toDisplayString(unref(M3).text), 1)
            ], 64))
          ]),
          _: 2
        }, [
          k2.$slots["calendar-icon"] ? {
            name: "calendar-icon",
            fn: withCtx(() => [
              renderSlot(k2.$slots, "calendar-icon")
            ]),
            key: "0"
          } : void 0,
          k2.$slots["month-overlay"] ? {
            name: "month-overlay",
            fn: withCtx(({ item: O2 }) => [
              renderSlot(k2.$slots, "month-overlay", {
                text: O2.text,
                value: O2.value
              })
            ]),
            key: "1"
          } : void 0
        ]), 1040, ["aria-label", "modelValue"]),
        createVNode(In, mergeProps({
          "aria-label": unref(N).openYearsOverlay,
          "slot-name": "year-overlay",
          modelValue: unref(Y2),
          "onUpdate:modelValue": _[4] || (_[4] = (O2) => isRef(Y2) ? Y2.value = O2 : null)
        }, unref(z2)("year"), {
          onToggle: J,
          onSetRef: _[5] || (_[5] = (O2) => te(O2, 2))
        }), createSlots({
          default: withCtx(() => [
            k2.$slots.year ? renderSlot(k2.$slots, "year", {
              key: 0,
              year: k2.year
            }) : createCommentVNode("", true),
            k2.$slots.year ? createCommentVNode("", true) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
              createTextVNode(toDisplayString(k2.year), 1)
            ], 64))
          ]),
          _: 2
        }, [
          k2.$slots["calendar-icon"] ? {
            name: "calendar-icon",
            fn: withCtx(() => [
              renderSlot(k2.$slots, "calendar-icon")
            ]),
            key: "0"
          } : void 0,
          k2.$slots["year-overlay"] ? {
            name: "year-overlay",
            fn: withCtx(({ item: O2 }) => [
              renderSlot(k2.$slots, "year-overlay", {
                text: O2.text,
                value: O2.value
              })
            ]),
            key: "1"
          } : void 0
        ]), 1040, ["aria-label", "modelValue"]),
        unref(s3) && k2.vertical ? (openBlock(), createBlock(nn, {
          key: 1,
          "aria-label": unref(N).prevMonth,
          disabled: unref(x2)(false),
          onActivate: _[6] || (_[6] = (O2) => unref(T2)(false))
        }, {
          default: withCtx(() => [
            k2.$slots["arrow-up"] ? renderSlot(k2.$slots, "arrow-up", { key: 0 }) : createCommentVNode("", true),
            k2.$slots["arrow-up"] ? createCommentVNode("", true) : (openBlock(), createBlock(unref(Ln), { key: 1 }))
          ]),
          _: 3
        }, 8, ["aria-label", "disabled"])) : createCommentVNode("", true),
        unref(h3) ? (openBlock(), createBlock(nn, {
          key: 2,
          disabled: unref(x2)(true),
          "aria-label": unref(N).nextMonth,
          onActivate: _[7] || (_[7] = (O2) => unref(T2)(true)),
          ref: "rightIcon",
          onSetRef: _[8] || (_[8] = (O2) => te(O2, 3))
        }, {
          default: withCtx(() => [
            k2.$slots[k2.vertical ? "arrow-down" : "arrow-right"] ? renderSlot(k2.$slots, k2.vertical ? "arrow-down" : "arrow-right", { key: 0 }) : createCommentVNode("", true),
            k2.$slots[k2.vertical ? "arrow-down" : "arrow-right"] ? createCommentVNode("", true) : (openBlock(), createBlock(resolveDynamicComponent(k2.vertical ? unref(Gn) : unref(Cn)), { key: 1 }))
          ]),
          _: 3
        }, 8, ["disabled", "aria-label"])) : createCommentVNode("", true)
      ], 64)) : createCommentVNode("", true),
      k2.monthPicker ? (openBlock(), createBlock(Mt, mergeProps({ key: 1 }, unref(z2)("month"), {
        "skip-active": t2.range,
        year: k2.year,
        "multi-model-value": unref(Z),
        "month-picker": "",
        modelValue: unref(i2),
        "onUpdate:modelValue": _[15] || (_[15] = (O2) => isRef(i2) ? i2.value = O2 : null),
        onToggle: F,
        onSelected: _[16] || (_[16] = (O2) => k2.$emit("overlay-closed"))
      }), createSlots({
        header: withCtx(() => [
          createBaseVNode("div", $r, [
            createBaseVNode("div", {
              class: "dp__month_year_col_nav",
              tabindex: "0",
              ref_key: "mpPrevIconRef",
              ref: V,
              onClick: _[9] || (_[9] = (O2) => oe(false)),
              onKeydown: _[10] || (_[10] = withKeys((O2) => oe(false), ["enter"]))
            }, [
              createBaseVNode("div", {
                class: "dp__inner_nav",
                role: "button",
                "aria-label": unref(N).prevMonth
              }, [
                k2.$slots["arrow-left"] ? renderSlot(k2.$slots, "arrow-left", { key: 0 }) : createCommentVNode("", true),
                k2.$slots["arrow-left"] ? createCommentVNode("", true) : (openBlock(), createBlock(unref(Pn), { key: 1 }))
              ], 8, Dr)
            ], 544),
            createBaseVNode("div", {
              class: "dp__pointer",
              role: "button",
              ref_key: "mpYearButtonRef",
              ref: R2,
              "aria-label": unref(N).openYearsOverlay,
              tabindex: "0",
              onClick: J,
              onKeydown: withKeys(J, ["enter"])
            }, [
              k2.$slots.year ? renderSlot(k2.$slots, "year", {
                key: 0,
                year: k2.year
              }) : createCommentVNode("", true),
              k2.$slots.year ? createCommentVNode("", true) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                createTextVNode(toDisplayString(k2.year), 1)
              ], 64))
            ], 40, Mr),
            createBaseVNode("div", {
              class: "dp__month_year_col_nav",
              tabindex: "0",
              ref_key: "mpNextIconRef",
              ref: E2,
              onClick: _[11] || (_[11] = (O2) => oe(true)),
              onKeydown: _[12] || (_[12] = withKeys((O2) => oe(true), ["enter"]))
            }, [
              createBaseVNode("div", {
                class: "dp__inner_nav",
                role: "button",
                "aria-label": unref(N).nextMonth
              }, [
                k2.$slots["arrow-right"] ? renderSlot(k2.$slots, "arrow-right", { key: 0 }) : createCommentVNode("", true),
                k2.$slots["arrow-right"] ? createCommentVNode("", true) : (openBlock(), createBlock(unref(Cn), { key: 1 }))
              ], 8, Sr)
            ], 544)
          ]),
          createVNode(Transition, {
            name: unref(d3)(g.value),
            css: unref(m3)
          }, {
            default: withCtx(() => [
              g.value ? (openBlock(), createBlock(Mt, mergeProps({ key: 0 }, unref(z2)("year"), {
                modelValue: unref(Y2),
                "onUpdate:modelValue": _[13] || (_[13] = (O2) => isRef(Y2) ? Y2.value = O2 : null),
                onToggle: J,
                onSelected: _[14] || (_[14] = (O2) => k2.$emit("overlay-closed"))
              }), createSlots({
                "button-icon": withCtx(() => [
                  k2.$slots["calendar-icon"] ? renderSlot(k2.$slots, "calendar-icon", { key: 0 }) : createCommentVNode("", true),
                  k2.$slots["calendar-icon"] ? createCommentVNode("", true) : (openBlock(), createBlock(unref(Wt), { key: 1 }))
                ]),
                _: 2
              }, [
                k2.$slots["year-overlay"] ? {
                  name: "item",
                  fn: withCtx(({ item: O2 }) => [
                    renderSlot(k2.$slots, "year-overlay", {
                      text: O2.text,
                      value: O2.value
                    })
                  ]),
                  key: "0"
                } : void 0
              ]), 1040, ["modelValue"])) : createCommentVNode("", true)
            ]),
            _: 3
          }, 8, ["name", "css"])
        ]),
        _: 2
      }, [
        k2.$slots["month-overlay"] ? {
          name: "item",
          fn: withCtx(({ item: O2 }) => [
            renderSlot(k2.$slots, "month-overlay", {
              text: O2.text,
              value: O2.value
            })
          ]),
          key: "0"
        } : void 0
      ]), 1040, ["skip-active", "year", "multi-model-value", "modelValue"])) : createCommentVNode("", true),
      e2.yearPicker ? (openBlock(), createBlock(Mt, mergeProps({ key: 2 }, unref(z2)("year"), {
        modelValue: unref(Y2),
        "onUpdate:modelValue": _[17] || (_[17] = (O2) => isRef(Y2) ? Y2.value = O2 : null),
        "multi-model-value": unref(Z),
        "skip-active": t2.range,
        "skip-button-ref": "",
        "year-picker": "",
        onToggle: J,
        onSelected: _[18] || (_[18] = (O2) => k2.$emit("overlay-closed"))
      }), createSlots({ _: 2 }, [
        k2.$slots["year-overlay"] ? {
          name: "item",
          fn: withCtx(({ item: O2 }) => [
            renderSlot(k2.$slots, "year-overlay", {
              text: O2.text,
              value: O2.value
            })
          ]),
          key: "0"
        } : void 0
      ]), 1040, ["modelValue", "multi-model-value", "skip-active"])) : createCommentVNode("", true)
    ]));
  }
});
var Pr = {
  key: 0,
  class: "dp__time_input"
};
var Cr = createTextVNode(" : ");
var Tr = ["aria-label", "onKeydown", "onClick"];
var Rr = ["aria-label", "onKeydown", "onClick"];
var Vr = ["aria-label", "onKeydown", "onClick"];
var _r = { key: 0 };
var Br = ["aria-label", "onKeydown"];
var Or = defineComponent({
  __name: "TimeInput",
  props: {
    ...Qn,
    hours: { type: Number, default: 0 },
    minutes: { type: Number, default: 0 },
    seconds: { type: Number, default: 0 },
    filters: { type: Object, default: () => ({}) },
    disabled: { type: Boolean, default: false },
    closeTimePickerBtn: { type: Object, default: null },
    order: { type: Number, default: 0 }
  },
  emits: [
    "setHours",
    "setMinutes",
    "update:hours",
    "update:minutes",
    "update:seconds",
    "reset-flow",
    "mounted",
    "overlay-closed"
  ],
  setup(e2, { expose: a3, emit: n }) {
    const t2 = e2, d3 = reactive({
      hours: false,
      minutes: false,
      seconds: false
    }), m3 = ref("AM"), p = ref(null), v = inject(Xe), g = inject(qe), w2 = ref([]), { transitionName: V, showTransition: R2 } = Ut(), { setTimePickerElements: E2, setTimePickerBackRef: N } = Je();
    onMounted(() => {
      n("mounted");
    });
    const G2 = computed(
      () => ({
        dp__time_col: true,
        dp__time_col_reg: !t2.enableSeconds && t2.is24,
        dp__time_col_reg_with_button: !t2.enableSeconds && !t2.is24,
        dp__time_col_sec: t2.enableSeconds && t2.is24,
        dp__time_col_sec_with_button: t2.enableSeconds && !t2.is24
      })
    ), T2 = computed(() => {
      const M3 = [{ type: "hours" }, "separator", { type: "minutes" }];
      return t2.enableSeconds ? M3.concat(["separator", { type: "seconds" }]) : M3;
    }), x2 = computed(() => T2.value.filter((M3) => typeof M3 != "string")), l = computed(() => (M3) => {
      if (M3 === "hours") {
        const D2 = K2(t2.hours);
        return { text: D2 < 10 ? `0${D2}` : `${D2}`, value: D2 };
      }
      return { text: t2[M3] < 10 ? `0${t2[M3]}` : `${t2[M3]}`, value: t2[M3] };
    }), i2 = (M3) => {
      const D2 = M3 === "hours" ? t2.is24 ? 24 : 12 : 60, u2 = +t2[`${M3}GridIncrement`], s3 = [];
      for (let h3 = 0; h3 < D2; h3 += u2)
        s3.push({ value: h3, text: h3 < 10 ? `0${h3}` : `${h3}` });
      return Gl(s3);
    }, Y2 = (M3) => t2[`no${M3[0].toUpperCase() + M3.slice(1)}Overlay`], z2 = (M3) => {
      Y2(M3) || (d3[M3] = !d3[M3], d3[M3] || n("overlay-closed"));
    }, P = (M3, D2 = true) => {
      const u2 = M3 === "hours" ? getHours : M3 === "minutes" ? getMinutes : getSeconds, s3 = D2 ? Sl : Al;
      n(`update:${M3}`, u2(s3({ [M3]: +t2[M3] }, { [M3]: +t2[`${M3}Increment`] })));
    }, K2 = (M3) => t2.is24 ? M3 : (M3 >= 12 ? m3.value = "PM" : m3.value = "AM", ql(M3)), X2 = () => {
      m3.value === "PM" ? (m3.value = "AM", n("update:hours", t2.hours - 12)) : (m3.value = "PM", n("update:hours", t2.hours + 12));
    }, ee = (M3) => {
      d3[M3] = true;
    }, Z = (M3, D2, u2) => {
      if (M3 && (g == null ? void 0 : g.value)) {
        Array.isArray(w2.value[D2]) ? w2.value[D2][u2] = M3 : w2.value[D2] = [M3];
        const s3 = w2.value.reduce(
          (h3, F) => F.map((J, I2) => [...h3[I2] || [], F[I2]]),
          []
        );
        N(t2.closeTimePickerBtn), p.value && (s3[1] = s3[1].concat(p.value)), E2(s3, t2.order);
      }
    }, j = (M3, D2) => M3 === "hours" && !t2.is24 ? n(`update:${M3}`, m3.value === "PM" ? D2 + 12 : D2) : n(`update:${M3}`, D2);
    return a3({ openChildCmp: ee }), (M3, D2) => e2.disabled ? createCommentVNode("", true) : (openBlock(), createElementBlock("div", Pr, [
      (openBlock(true), createElementBlock(Fragment, null, renderList(unref(T2), (u2, s3) => (openBlock(), createElementBlock("div", {
        key: s3,
        class: normalizeClass(unref(G2))
      }, [
        u2 === "separator" ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
          Cr
        ], 64)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
          createBaseVNode("div", {
            class: "dp__inc_dec_button",
            role: "button",
            "aria-label": unref(v).incrementValue(u2.type),
            tabindex: "0",
            onKeydown: [
              withKeys((h3) => P(u2.type), ["enter"]),
              withKeys((h3) => P(u2.type), ["space"])
            ],
            onClick: (h3) => P(u2.type),
            ref_for: true,
            ref: (h3) => Z(h3, s3, 0)
          }, [
            M3.$slots["arrow-up"] ? renderSlot(M3.$slots, "arrow-up", { key: 0 }) : createCommentVNode("", true),
            M3.$slots["arrow-up"] ? createCommentVNode("", true) : (openBlock(), createBlock(unref(Ln), { key: 1 }))
          ], 40, Tr),
          createBaseVNode("div", {
            role: "button",
            "aria-label": unref(v).openTpOverlay(u2.type),
            class: normalizeClass(Y2(u2.type) ? "" : "dp__time_display"),
            tabindex: "0",
            onKeydown: [
              withKeys((h3) => z2(u2.type), ["enter"]),
              withKeys((h3) => z2(u2.type), ["space"])
            ],
            onClick: (h3) => z2(u2.type),
            ref_for: true,
            ref: (h3) => Z(h3, s3, 1)
          }, [
            M3.$slots[u2.type] ? renderSlot(M3.$slots, u2.type, {
              key: 0,
              text: unref(l)(u2.type).text,
              value: unref(l)(u2.type).value
            }) : createCommentVNode("", true),
            M3.$slots[u2.type] ? createCommentVNode("", true) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
              createTextVNode(toDisplayString(unref(l)(u2.type).text), 1)
            ], 64))
          ], 42, Rr),
          createBaseVNode("div", {
            class: "dp__inc_dec_button",
            role: "button",
            "aria-label": unref(v).decrementValue(u2.type),
            tabindex: "0",
            onKeydown: [
              withKeys((h3) => P(u2.type, false), ["enter"]),
              withKeys((h3) => P(u2.type, false), ["space"])
            ],
            onClick: (h3) => P(u2.type, false),
            ref_for: true,
            ref: (h3) => Z(h3, s3, 2)
          }, [
            M3.$slots["arrow-down"] ? renderSlot(M3.$slots, "arrow-down", { key: 0 }) : createCommentVNode("", true),
            M3.$slots["arrow-down"] ? createCommentVNode("", true) : (openBlock(), createBlock(unref(Gn), { key: 1 }))
          ], 40, Vr)
        ], 64))
      ], 2))), 128)),
      M3.is24 ? createCommentVNode("", true) : (openBlock(), createElementBlock("div", _r, [
        M3.$slots["am-pm-button"] ? renderSlot(M3.$slots, "am-pm-button", {
          key: 0,
          toggle: X2,
          value: m3.value
        }) : createCommentVNode("", true),
        M3.$slots["am-pm-button"] ? createCommentVNode("", true) : (openBlock(), createElementBlock("button", {
          key: 1,
          ref_key: "amPmButton",
          ref: p,
          type: "button",
          class: "dp__pm_am_button",
          role: "button",
          "aria-label": unref(v).amPmButton,
          tabindex: "0",
          onClick: X2,
          onKeydown: [
            withKeys(withModifiers(X2, ["prevent"]), ["enter"]),
            withKeys(withModifiers(X2, ["prevent"]), ["space"])
          ]
        }, toDisplayString(m3.value), 41, Br))
      ])),
      (openBlock(true), createElementBlock(Fragment, null, renderList(unref(x2), (u2, s3) => (openBlock(), createBlock(Transition, {
        key: s3,
        name: unref(V)(d3[u2.type]),
        css: unref(R2)
      }, {
        default: withCtx(() => [
          d3[u2.type] ? (openBlock(), createBlock(Mt, {
            key: 0,
            items: i2(u2.type),
            "disabled-values": e2.filters.times[u2.type],
            "onUpdate:modelValue": (h3) => j(u2.type, h3),
            onSelected: (h3) => z2(u2.type),
            onToggle: (h3) => z2(u2.type),
            onResetFlow: D2[0] || (D2[0] = (h3) => M3.$emit("reset-flow"))
          }, createSlots({
            "button-icon": withCtx(() => [
              M3.$slots["clock-icon"] ? renderSlot(M3.$slots, "clock-icon", { key: 0 }) : createCommentVNode("", true),
              M3.$slots["clock-icon"] ? createCommentVNode("", true) : (openBlock(), createBlock(unref(Un), { key: 1 }))
            ]),
            _: 2
          }, [
            M3.$slots[`${u2.type}-overlay`] ? {
              name: "item",
              fn: withCtx(({ item: h3 }) => [
                renderSlot(M3.$slots, `${u2.type}-overlay`, {
                  text: h3.text,
                  value: h3.value
                })
              ]),
              key: "0"
            } : void 0
          ]), 1032, ["items", "disabled-values", "onUpdate:modelValue", "onSelected", "onToggle"])) : createCommentVNode("", true)
        ]),
        _: 2
      }, 1032, ["name", "css"]))), 128))
    ]));
  }
});
var wt = [
  { name: "clock-icon", use: ["time", "calendar"] },
  { name: "arrow-left", use: ["month-year", "calendar"] },
  { name: "arrow-right", use: ["month-year", "calendar"] },
  { name: "arrow-up", use: ["time", "calendar"] },
  { name: "arrow-down", use: ["time", "calendar"] },
  { name: "calendar-icon", use: ["month-year", "time", "calendar"] },
  { name: "day", use: ["calendar"] },
  { name: "month-overlay", use: ["calendar", "month-year"] },
  { name: "year-overlay", use: ["calendar", "month-year"] },
  { name: "hours-overlay", use: ["calendar", "time"] },
  { name: "minutes-overlay", use: ["calendar", "time"] },
  { name: "seconds-overlay", use: ["calendar", "time"] },
  { name: "hours", use: ["calendar", "time"] },
  { name: "minutes", use: ["calendar", "time"] },
  { name: "month", use: ["calendar", "month-year"] },
  { name: "year", use: ["calendar", "month-year"] },
  { name: "action-select", use: ["action"] },
  { name: "action-preview", use: ["action"] },
  { name: "calendar-header", use: ["calendar"] },
  { name: "marker-tooltip", use: ["calendar"] },
  { name: "now-button", use: [] },
  { name: "time-picker-overlay", use: ["calendar", "time"] },
  { name: "am-pm-button", use: ["calendar", "time"] }
];
var Nr = [{ name: "trigger" }, { name: "input-icon" }, { name: "clear-icon" }, { name: "dp-input" }];
var Ir = {
  all: () => wt,
  monthYear: () => wt.filter((e2) => e2.use.includes("month-year")),
  input: () => Nr,
  timePicker: () => wt.filter((e2) => e2.use.includes("time")),
  action: () => wt.filter((e2) => e2.use.includes("action")),
  calendar: () => wt.filter((e2) => e2.use.includes("calendar"))
};
var at = (e2, a3) => {
  const n = [];
  return Ir[a3]().forEach((t2) => {
    e2[t2.name] && n.push(t2.name);
  }), n;
};
var Yr = ["aria-label"];
var Er = { class: "dp__overlay_container dp__container_flex" };
var Fr = {
  key: 1,
  class: "dp__overlay_row"
};
var Hr = ["aria-label"];
var Wr = defineComponent({
  __name: "TimePicker",
  props: {
    ...xn,
    range: { type: Boolean, default: false },
    filters: { type: Object, default: () => ({}) },
    hours: { type: [Number, Array], default: 0 },
    minutes: { type: [Number, Array], default: 0 },
    seconds: { type: [Number, Array], default: 0 },
    customProps: { type: Object, default: null },
    modelAuto: { type: Boolean, default: false },
    internalModelValue: { type: [Date, Array], default: null }
  },
  emits: [
    "update:hours",
    "update:minutes",
    "update:seconds",
    "mount",
    "reset-flow",
    "overlay-closed"
  ],
  setup(e2, { expose: a3, emit: n }) {
    const t2 = e2, d3 = useSlots(), m3 = ref(null), p = ref(null), v = inject(pn, false), g = ref([]), w2 = ref(null), V = inject(Xe), R2 = inject(qe), { transitionName: E2, showTransition: N } = Ut(), { buildMatrix: G2, setTimePicker: T2 } = Je();
    onMounted(() => {
      n("mount"), !t2.timePicker && (R2 == null ? void 0 : R2.value) ? G2([ke(m3.value)], "time") : T2(true, t2.timePicker);
    });
    const x2 = computed(() => t2.range && t2.modelAuto ? oa(t2.internalModelValue) : true), l = ref(false), i2 = (D2) => ({
      hours: Array.isArray(t2.hours) ? t2.hours[D2] : t2.hours,
      minutes: Array.isArray(t2.minutes) ? t2.minutes[D2] : t2.minutes,
      seconds: Array.isArray(t2.seconds) ? t2.seconds[D2] : t2.seconds
    }), Y2 = computed(() => {
      const D2 = [];
      if (t2.range)
        for (let u2 = 0; u2 < 2; u2++)
          D2.push(i2(u2));
      else
        D2.push(i2(0));
      return D2;
    }), z2 = (D2, u2 = false, s3 = "") => {
      u2 || n("reset-flow"), l.value = D2, R2 != null && R2.value && (T2(D2), D2 || n("overlay-closed")), nextTick(() => {
        s3 !== "" && g.value[0] && g.value[0].openChildCmp(s3);
      });
    }, P = computed(() => ({
      dp__button: true,
      dp__button_bottom: v
    })), K2 = at(d3, "timePicker"), X2 = (D2, u2, s3) => t2.range ? u2 === 0 ? [D2, Y2.value[1][s3]] : [Y2.value[0][s3], D2] : D2, ee = (D2) => {
      n("update:hours", D2);
    }, Z = (D2) => {
      n("update:minutes", D2);
    }, j = (D2) => {
      n("update:seconds", D2);
    }, M3 = () => {
      w2.value && (R2 == null ? void 0 : R2.value) && w2.value.focus({ preventScroll: true });
    };
    return a3({ toggleTimePicker: z2 }), (D2, u2) => (openBlock(), createElementBlock("div", null, [
      D2.timePicker ? createCommentVNode("", true) : (openBlock(), createElementBlock("div", {
        key: 0,
        class: normalizeClass(unref(P)),
        role: "button",
        "aria-label": unref(V).openTimePicker,
        tabindex: "0",
        ref_key: "openTimePickerBtn",
        ref: m3,
        onKeydown: [
          u2[0] || (u2[0] = withKeys((s3) => z2(true), ["enter"])),
          u2[1] || (u2[1] = withKeys((s3) => z2(true), ["space"]))
        ],
        onClick: u2[2] || (u2[2] = (s3) => z2(true))
      }, [
        D2.$slots["clock-icon"] ? renderSlot(D2.$slots, "clock-icon", { key: 0 }) : createCommentVNode("", true),
        D2.$slots["clock-icon"] ? createCommentVNode("", true) : (openBlock(), createBlock(unref(Un), { key: 1 }))
      ], 42, Yr)),
      createVNode(Transition, {
        name: unref(E2)(l.value),
        css: unref(N)
      }, {
        default: withCtx(() => [
          l.value || D2.timePicker ? (openBlock(), createElementBlock("div", {
            key: 0,
            class: "dp__overlay",
            ref_key: "overlayRef",
            ref: w2,
            tabindex: "0"
          }, [
            createBaseVNode("div", Er, [
              D2.$slots["time-picker-overlay"] ? renderSlot(D2.$slots, "time-picker-overlay", {
                key: 0,
                range: e2.range,
                hours: e2.hours,
                minutes: e2.minutes,
                seconds: e2.seconds,
                setHours: ee,
                setMinutes: Z,
                setSeconds: j
              }) : createCommentVNode("", true),
              D2.$slots["time-picker-overlay"] ? createCommentVNode("", true) : (openBlock(), createElementBlock("div", Fr, [
                (openBlock(true), createElementBlock(Fragment, null, renderList(unref(Y2), (s3, h3) => withDirectives((openBlock(), createBlock(Or, mergeProps({
                  key: h3,
                  disabled: h3 === 0 ? D2.fixedStart : D2.fixedEnd,
                  hours: s3.hours,
                  minutes: s3.minutes,
                  seconds: s3.seconds,
                  filters: e2.filters,
                  ref_for: true,
                  ref_key: "timeInputRefs",
                  ref: g
                }, {
                  is24: D2.is24,
                  hoursGridIncrement: D2.hoursGridIncrement,
                  minutesGridIncrement: D2.minutesGridIncrement,
                  secondsGridIncrement: D2.secondsGridIncrement,
                  hoursIncrement: D2.hoursIncrement,
                  minutesIncrement: D2.minutesIncrement,
                  secondsIncrement: D2.secondsIncrement,
                  filters: e2.filters,
                  noHoursOverlay: D2.noHoursOverlay,
                  noMinutesOverlay: D2.noMinutesOverlay,
                  noSecondsOverlay: D2.noSecondsOverlay,
                  enableSeconds: D2.enableSeconds,
                  closeTimePickerBtn: p.value,
                  order: h3
                }, {
                  "onUpdate:hours": (F) => ee(X2(F, h3, "hours")),
                  "onUpdate:minutes": (F) => Z(X2(F, h3, "minutes")),
                  "onUpdate:seconds": (F) => j(X2(F, h3, "seconds")),
                  onMounted: M3,
                  onOverlayClosed: M3
                }), createSlots({ _: 2 }, [
                  renderList(unref(K2), (F, J) => ({
                    name: F,
                    fn: withCtx((I2) => [
                      renderSlot(D2.$slots, F, normalizeProps(guardReactiveProps(I2)))
                    ])
                  }))
                ]), 1040, ["disabled", "hours", "minutes", "seconds", "filters", "onUpdate:hours", "onUpdate:minutes", "onUpdate:seconds"])), [
                  [vShow, h3 === 0 ? true : unref(x2)]
                ])), 128))
              ])),
              D2.timePicker ? createCommentVNode("", true) : (openBlock(), createElementBlock("div", {
                key: 2,
                ref_key: "closeTimePickerBtn",
                ref: p,
                class: normalizeClass(unref(P)),
                role: "button",
                "aria-label": unref(V).closeTimePicker,
                tabindex: "0",
                onKeydown: [
                  u2[3] || (u2[3] = withKeys((s3) => z2(false), ["enter"])),
                  u2[4] || (u2[4] = withKeys((s3) => z2(false), ["space"]))
                ],
                onClick: u2[5] || (u2[5] = (s3) => z2(false))
              }, [
                D2.$slots["calendar-icon"] ? renderSlot(D2.$slots, "calendar-icon", { key: 0 }) : createCommentVNode("", true),
                D2.$slots["calendar-icon"] ? createCommentVNode("", true) : (openBlock(), createBlock(unref(Wt), { key: 1 }))
              ], 42, Hr))
            ])
          ], 512)) : createCommentVNode("", true)
        ]),
        _: 3
      }, 8, ["name", "css"])
    ]));
  }
});
var Kr = (e2, a3, n, t2) => {
  const d3 = ref(/* @__PURE__ */ new Date()), m3 = ref(), p = ref([{ month: getMonth(/* @__PURE__ */ new Date()), year: getYear(/* @__PURE__ */ new Date()) }]), v = ref(
    e2.range ? [getHours(/* @__PURE__ */ new Date()), getHours(/* @__PURE__ */ new Date())] : getHours(/* @__PURE__ */ new Date())
  ), g = ref(
    e2.range ? [getMinutes(/* @__PURE__ */ new Date()), getMinutes(/* @__PURE__ */ new Date())] : getMinutes(/* @__PURE__ */ new Date())
  ), w2 = ref(e2.range ? [0, 0] : 0);
  watch(
    p,
    () => {
      setTimeout(() => {
        e2.openOnTop && a3("dpOpen");
      }, 0);
    },
    { deep: true }
  ), onMounted(() => {
    Z(true), l.value || (e2.startDate && (p.value[0].month = getMonth(new Date(e2.startDate)), p.value[0].year = getYear(new Date(e2.startDate)), e2.multiCalendars && _(0)), e2.startTime && x2());
  });
  const V = computed(
    () => (r) => p.value[r] ? p.value[r].month : 0
  ), R2 = computed(
    () => (r) => p.value[r] ? p.value[r].year : 0
  ), E2 = (r, b2, S3) => {
    p.value[r].month = b2, p.value[r].year = S3;
  }, N = (r, b2) => p.value[r].month = b2, G2 = (r, b2) => p.value[r].year = b2, T2 = (r = true) => e2.enableSeconds ? Array.isArray(w2.value) ? r ? w2.value[0] : w2.value[1] : w2.value : 0, x2 = () => {
    e2.startTime && (Wl(e2.startTime) ? (v.value = [+e2.startTime[0].hours, +e2.startTime[1].hours], g.value = [+e2.startTime[0].minutes, +e2.startTime[1].minutes], e2.enableSeconds && (w2.value = [+e2.startTime[0].seconds, +e2.startTime[1].seconds])) : (v.value = +e2.startTime.hours, g.value = +e2.startTime.minutes, e2.enableSeconds && (w2.value = +e2.startTime.seconds)));
  }, l = computed({
    get: () => e2.internalModelValue,
    set: (r) => {
      !e2.readonly && !e2.disabled && a3("update:internalModelValue", r);
    }
  });
  watch(l, () => Z());
  const i2 = (r) => {
    const { validate: b2 } = qn(
      e2.minDate,
      e2.maxDate,
      e2.disabledDates,
      e2.allowedDates,
      e2.filters,
      e2.disabledWeekDays,
      e2.yearRange
    );
    return !b2(r);
  }, Y2 = (r) => !l.value || e2.hideOffsetDates && !r.current ? false : e2.range ? e2.modelAuto && Array.isArray(l.value) ? ce(r.value, l.value[0] ? l.value[0] : d3.value) : false : e2.multiDates && Array.isArray(l.value) ? l.value.some((b2) => ce(b2, r.value)) : ce(r.value, l.value ? l.value : d3.value), z2 = (r) => zn(l.value, m3.value, r.value), P = (r, b2 = false) => {
    if ((!e2.multiCalendars || !e2.multiStatic || b2) && (N(0, getMonth(r)), G2(0, getYear(r))), e2.multiCalendars)
      for (let S3 = 1; S3 <= e2.multiCalendars; S3++) {
        const se = set(/* @__PURE__ */ new Date(), { month: V.value(S3 - 1), year: R2.value(S3 - 1) }), Se = add(se, { months: 1 });
        p.value[S3] = { month: getMonth(Se), year: getYear(Se) };
      }
  }, K2 = () => {
    if (Array.isArray(l.value) && l.value.length === 2) {
      const r = new Date(l.value[1] ? l.value[1] : addMonths(l.value[0], 1)), [b2, S3] = [getMonth(l.value[0]), getYear(l.value[0])], [se, Se] = [getMonth(l.value[1]), getYear(l.value[1])];
      (b2 !== se || b2 === se && S3 !== Se) && e2.multiCalendarsSolo && (N(1, getMonth(r)), G2(1, getYear(r)));
    }
  }, X2 = (r) => {
    P(r), v.value = getHours(r), g.value = getMinutes(r), w2.value = getSeconds(r);
  }, ee = () => Array.isArray(l.value) && l.value.length ? l.value[l.value.length - 1] : null, Z = (r = false) => {
    if (l.value)
      if (bt(l.value)) {
        if (l.value.length === 2 && !e2.multiDates)
          P(l.value[0], r), v.value = [
            getHours(l.value[0]),
            l.value[1] ? getHours(l.value[1]) : getHours(/* @__PURE__ */ new Date())
          ], g.value = [
            getMinutes(l.value[0]),
            l.value[1] ? getMinutes(l.value[1]) : getMinutes(/* @__PURE__ */ new Date())
          ], w2.value = [
            getSeconds(l.value[0]),
            l.value[1] ? getSeconds(l.value[1]) : getSeconds(/* @__PURE__ */ new Date())
          ];
        else if (bt(l.value) && e2.multiDates) {
          const b2 = l.value[l.value.length - 1];
          b2 && X2(b2);
        }
        e2.multiCalendars && e2.multiCalendarsSolo && K2();
      } else
        X2(l.value);
    else
      e2.timePicker ? (x2(), e2.range ? Ve(v.value) && Ve(g.value) && (l.value = [
        Ae(/* @__PURE__ */ new Date(), v.value[0], g.value[0], T2()),
        Ae(/* @__PURE__ */ new Date(), v.value[1], g.value[1], T2(false))
      ]) : l.value = Ae(
        /* @__PURE__ */ new Date(),
        v.value,
        g.value,
        T2()
      )) : e2.monthPicker && !e2.range ? l.value = st(/* @__PURE__ */ new Date(), V.value(0), R2.value(0)) : e2.multiCalendars ? P(/* @__PURE__ */ new Date()) : e2.yearPicker && !e2.range && (l.value = /* @__PURE__ */ new Date());
  }, j = (r) => {
    const b2 = getMonth(new Date(r)), S3 = getYear(new Date(r));
    if (N(0, b2), G2(0, S3), e2.multiCalendars > 0)
      for (let se = 1; se < e2.multiCalendars; se++) {
        const Se = Ml(
          set(new Date(r), { year: V.value(se - 1), month: R2.value(se - 1) })
        );
        N(se, Se.month), G2(se, Se.year);
      }
  }, M3 = (r) => {
    if (l.value && Array.isArray(l.value))
      if (l.value.some((b2) => ce(r, b2))) {
        const b2 = l.value.filter((S3) => !ce(S3, r));
        l.value = b2.length ? b2 : null;
      } else
        (e2.multiDatesLimit && +e2.multiDatesLimit > l.value.length || !e2.multiDatesLimit) && l.value.push(r);
    else
      l.value = [r];
  }, D2 = (r) => {
    if (Array.isArray(l.value) && l.value[0]) {
      const b2 = differenceInCalendarDays(r, l.value[0]), S3 = De(l.value[0], r) ? r : l.value[0], se = De(r, l.value[0]) ? r : l.value[0], xe = eachDayOfInterval({ start: S3, end: se }).filter((dt) => i2(dt)).length, Te = Math.abs(b2 < 0 ? b2 + 1 : b2 - 1) - xe;
      if (e2.minRange && e2.maxRange)
        return Te >= +e2.minRange && Te <= +e2.maxRange;
      if (e2.minRange)
        return Te >= +e2.minRange;
      if (e2.maxRange)
        return Te <= +e2.maxRange;
    }
    return true;
  }, u2 = (r) => Array.isArray(l.value) && l.value.length === 2 ? e2.fixedStart && (De(r, l.value[0]) || ce(r, l.value[0])) ? [l.value[0], r] : e2.fixedEnd && (we(r, l.value[1]) || ce(r, l.value[1])) ? [r, l.value[1]] : l.value : [], s3 = () => {
    e2.autoApply && a3("autoApply");
  }, h3 = (r) => !eachDayOfInterval({ start: r[0], end: r[1] }).some((S3) => i2(S3)), F = (r, b2 = false) => {
    if (!i2(r.value) && !(!r.current && e2.hideOffsetDates)) {
      if (e2.weekPicker)
        return l.value = Rt(new Date(r.value), +e2.weekStart), s3();
      if (!e2.range && !Ve(v.value) && !Ve(g.value)) {
        const S3 = Ae(new Date(r.value), v.value, g.value, T2());
        e2.multiDates ? M3(S3) : l.value = S3, n(), s3();
      } else if (Ve(v.value) && Ve(g.value) && !e2.multiDates) {
        let S3 = l.value ? l.value.slice() : [];
        if (S3.length === 2 && !(e2.fixedStart || e2.fixedEnd) && (S3 = []), e2.autoRange) {
          const se = [new Date(r.value), addDays(new Date(r.value), +e2.autoRange)];
          h3(se) && (b2 && j(r.value), S3 = se);
        } else
          e2.fixedStart || e2.fixedEnd ? S3 = u2(new Date(r.value)) : S3[0] ? D2(new Date(r.value)) && (we(new Date(r.value), new Date(S3[0])) ? S3.unshift(new Date(r.value)) : S3[1] = new Date(r.value)) : S3[0] = new Date(r.value);
        S3.length && (S3[0] && !S3[1] ? S3[0] = Ae(S3[0], v.value[0], g.value[0], T2()) : (S3[0] = Ae(S3[0], v.value[0], g.value[0], T2()), S3[1] = Ae(S3[1], v.value[1], g.value[1], T2(false)), n()), l.value = S3, S3[0] && S3[1] && e2.autoApply && a3("autoApply"));
      }
    }
  }, J = (r) => {
    const b2 = r.find((S3) => S3.current);
    return b2 ? getISOWeek(b2.value) : "";
  }, I2 = (r) => {
    !r.current && e2.hideOffsetDates || (m3.value = r.value);
  }, oe = (r) => {
    if (e2.autoRange || e2.weekPicker) {
      if (m3.value) {
        if (e2.hideOffsetDates && !r.current)
          return false;
        const b2 = addDays(m3.value, +e2.autoRange), S3 = Rt(new Date(m3.value), +e2.weekStart);
        return e2.weekPicker ? ce(S3[1], new Date(r.value)) : ce(b2, new Date(r.value));
      }
      return false;
    }
    return false;
  }, te = (r) => {
    if (e2.autoRange || e2.weekPicker) {
      if (m3.value) {
        const b2 = addDays(m3.value, +e2.autoRange);
        if (e2.hideOffsetDates && !r.current)
          return false;
        const S3 = Rt(new Date(m3.value), +e2.weekStart);
        return e2.weekPicker ? De(r.value, S3[0]) && we(r.value, S3[1]) : De(r.value, m3.value) && we(r.value, b2);
      }
      return false;
    }
    return false;
  }, k2 = (r) => {
    if (e2.autoRange || e2.weekPicker) {
      if (m3.value) {
        if (e2.hideOffsetDates && !r.current)
          return false;
        const b2 = Rt(new Date(m3.value), +e2.weekStart);
        return e2.weekPicker ? ce(b2[0], r.value) : ce(m3.value, r.value);
      }
      return false;
    }
    return false;
  }, _ = (r) => {
    for (let b2 = r - 1; b2 >= 0; b2--) {
      const S3 = subMonths(set(/* @__PURE__ */ new Date(), { month: V.value(b2 + 1), year: R2.value(b2 + 1) }), 1);
      E2(b2, getMonth(S3), getYear(S3));
    }
    for (let b2 = r + 1; b2 <= e2.multiCalendars - 1; b2++) {
      const S3 = addMonths(set(/* @__PURE__ */ new Date(), { month: V.value(b2 - 1), year: R2.value(b2 - 1) }), 1);
      E2(b2, getMonth(S3), getYear(S3));
    }
  }, O2 = (r) => st(/* @__PURE__ */ new Date(), V.value(r), R2.value(r)), Re = (r, b2) => {
    if (N(r, b2.month), G2(r, b2.year), e2.multiCalendars && !e2.multiCalendarsSolo && _(r), e2.monthPicker || e2.yearPicker)
      if (e2.range) {
        let S3 = l.value ? l.value.slice() : [];
        S3.length === 2 && S3[1] !== null && (S3 = []), S3.length ? we(O2(r), S3[0]) ? S3.unshift(O2(r)) : S3[1] = O2(r) : S3 = [O2(r)], l.value = S3;
      } else
        l.value = O2(r);
    n(), a3("updateMonthYear", { instance: r, month: b2.month, year: b2.year }), Pt(e2.multiCalendarsSolo ? r : void 0);
  }, Ie = (r) => Ae(r, v.value, g.value, T2()), Ye = (r) => {
    bt(r) && bt(l.value) && Ve(v.value) && Ve(g.value) ? (r[0] && l.value[0] && (l.value[0] = Ae(r[0], v.value[0], g.value[0], T2())), r[1] && l.value[1] && (l.value[1] = Ae(
      r[1],
      v.value[1],
      g.value[1],
      T2(false)
    ))) : e2.multiDates && Array.isArray(l.value) ? l.value[l.value.length - 1] = Ie(r) : !e2.range && !Yt(r) && (l.value = Ie(r)), a3("timeUpdate");
  }, Ke = (r, b2 = true, S3 = false) => {
    const se = b2 ? r : v.value, Se = !b2 && !S3 ? r : g.value, xe = S3 ? r : w2.value;
    if (e2.range && Yt(l.value) && Ve(se) && Ve(Se) && Ve(xe) && !e2.disableTimeRangeValidation) {
      const Te = (Le) => Ae(l.value[Le], se[Le], Se[Le], xe[Le]), dt = (Le) => setMilliseconds(l.value[Le], 0);
      if (ce(l.value[0], l.value[1]) && (isAfter(Te(0), dt(1)) || isBefore(Te(1), dt(0))))
        return;
    }
    if (v.value = se, g.value = Se, w2.value = xe, l.value)
      if (e2.multiDates) {
        const Te = ee();
        Te && Ye(Te);
      } else
        Ye(l.value);
    else
      e2.timePicker && Ye(e2.range ? [/* @__PURE__ */ new Date(), /* @__PURE__ */ new Date()] : /* @__PURE__ */ new Date());
    n();
  }, Ue = () => {
    m3.value = null;
  }, Ze = (r) => Bn(l.value, e2.range) && l.value[0] && m3.value ? r ? De(m3.value, l.value[0]) : we(m3.value, l.value[0]) : true, be = (r, b2 = true) => (e2.range || e2.weekPicker) && Yt(l.value) ? e2.hideOffsetDates && !r.current ? false : ce(new Date(r.value), l.value[b2 ? 0 : 1]) : e2.range ? ce(
    new Date(r.value),
    l.value && Array.isArray(l.value) ? b2 ? l.value[0] || null : l.value[1] : null
  ) && (b2 ? !we(
    m3.value || null,
    Array.isArray(l.value) ? l.value[0] : null
  ) : true) || ce(r.value, Array.isArray(l.value) ? l.value[0] : null) && Ze(b2) : false, it = (r, b2) => Array.isArray(e2.internalModelValue) && e2.internalModelValue.length || e2.weekPicker ? false : !r && !Y2(b2) && !(!b2.current && e2.hideOffsetDates) && (e2.range ? !be(b2) && !be(b2, false) : true), pt = (r, b2, S3) => Array.isArray(e2.internalModelValue) && e2.internalModelValue[0] && e2.internalModelValue.length === 1 ? r ? false : S3 ? De(e2.internalModelValue[0], b2.value) : we(e2.internalModelValue[0], b2.value) : false, ht = (r = false) => {
    e2.autoApply && (e2.monthPicker || e2.yearPicker) && nextTick().then(() => {
      e2.range ? a3("autoApply", r || !l.value || l.value.length === 1) : a3("autoApply", r);
    });
  }, c2 = (r, b2) => {
    const S3 = set(/* @__PURE__ */ new Date(), { month: V.value(b2), year: R2.value(b2) }), se = r < 0 ? addMonths(S3, 1) : subMonths(S3, 1);
    ia(
      e2.minDate,
      e2.maxDate,
      getMonth(se),
      getYear(se),
      r < 0,
      e2.preventMinMaxNavigation
    ) && (E2(b2, getMonth(se), getYear(se)), e2.multiCalendars && !e2.multiCalendarsSolo && _(b2), Pt());
  }, ae = (r, b2) => {
    e2.monthChangeOnScroll && c2(e2.monthChangeOnScroll !== "inverse" ? -r.deltaY : r.deltaY, b2);
  }, me = (r, b2, S3 = false) => {
    e2.monthChangeOnArrows && e2.vertical === S3 && ut(r, b2);
  }, ut = (r, b2) => {
    c2(r === "right" ? -1 : 1, b2);
  }, Qe = (r) => e2.markers.find((b2) => ce(Ee(r.value), Ee(b2.date))), Lt = () => {
    e2.range ? Bn(l.value, e2.range) && (l.value && l.value[0] ? l.value = we(/* @__PURE__ */ new Date(), l.value[0]) ? [/* @__PURE__ */ new Date(), l.value[0]] : [l.value[0], /* @__PURE__ */ new Date()] : l.value = [/* @__PURE__ */ new Date()]) : a3("update:internalModelValue", /* @__PURE__ */ new Date()), e2.autoApply && a3("selectDate");
  }, Gt = (r) => {
    r.length && r.length <= 2 && e2.range && (l.value = r.map((b2) => new Date(b2)), e2.autoApply && a3("selectDate"));
  }, Pt = (r) => {
    r || r === 0 ? t2.value[r].triggerTransition(V.value(r), R2.value(r)) : t2.value.forEach((b2, S3) => b2.triggerTransition(V.value(S3), R2.value(S3)));
  };
  return {
    today: d3,
    hours: v,
    minutes: g,
    seconds: w2,
    month: V,
    year: R2,
    monthYearSelect: ht,
    isDisabled: i2,
    updateTime: Ke,
    setHoverDate: I2,
    getWeekNum: J,
    selectDate: F,
    rangeActive: z2,
    isActiveDate: Y2,
    updateMonthYear: Re,
    isHoverRangeEnd: oe,
    isAutoRangeInBetween: te,
    isAutoRangeStart: k2,
    clearHoverDate: Ue,
    rangeActiveStartEnd: be,
    handleScroll: ae,
    getMarker: Qe,
    handleArrow: me,
    handleSwipe: ut,
    selectCurrentDate: Lt,
    isHoverDate: it,
    isHoverDateStartEnd: pt,
    presetDateRange: Gt
  };
};
var _t = reactive({
  menuFocused: false,
  shiftKeyInMenu: false
});
var ua = () => ({
  setMenuFocused: (t2) => {
    _t.menuFocused = t2;
  },
  getStore: () => _t,
  setShiftKey: (t2) => {
    _t.shiftKeyInMenu !== t2 && (_t.shiftKeyInMenu = t2);
  }
});
var Et = ((e2) => (e2.center = "center", e2.left = "left", e2.right = "right", e2))(Et || {});
var Ur = ["id", "aria-label", "onKeydown"];
var Lr = {
  key: 0,
  class: "dp__preset_ranges"
};
var Gr = ["onClick"];
var jr = {
  key: 1,
  class: "dp__now_wrap"
};
var zr = defineComponent({
  __name: "DatepickerMenu",
  props: {
    ...la,
    ...gn,
    ...hn,
    internalModelValue: { type: [Date, Array], default: null },
    multiCalendars: { type: Number, default: 0 },
    openOnTop: { type: Boolean, default: false }
  },
  emits: [
    "update:internalModelValue",
    "closePicker",
    "selectDate",
    "dpOpen",
    "autoApply",
    "timeUpdate",
    "flow-step",
    "updateMonthYear",
    "invalid-select"
  ],
  setup(e2, { emit: a3 }) {
    const n = e2, t2 = useSlots(), d3 = ref(null), m3 = reactive({
      timePicker: !!(!n.enableTimePicker || n.timePicker || n.monthPicker),
      monthYearInput: !!n.timePicker,
      calendar: false
    }), p = ref([]), v = ref([]), g = ref(null), w2 = ref(null), V = ref(0), R2 = ref(false), E2 = ref(0), N = inject(Kt), G2 = inject(Xe), T2 = inject(qe), { setMenuFocused: x2, setShiftKey: l, getStore: i2 } = ua();
    onMounted(() => {
      var U;
      R2.value = true, (U = n.presetRanges) != null && U.length || se();
      const f = ke(w2);
      if (f && !n.textInput && !n.inline && (x2(true), X2()), f) {
        const H3 = (q2) => {
          !n.monthYearComponent && !n.timePickerComponent && q2.preventDefault(), q2.stopImmediatePropagation(), q2.stopPropagation();
        };
        f.addEventListener("pointerdown", H3), f.addEventListener("mousedown", H3);
      }
      document.addEventListener("resize", se);
    }), onUnmounted(() => {
      document.removeEventListener("resize", se);
    });
    const { arrowRight: Y2, arrowLeft: z2, arrowDown: P, arrowUp: K2 } = Je(), X2 = () => {
      const f = ke(w2);
      f && f.focus({ preventScroll: true });
    }, ee = () => {
      var f;
      ((f = n.flow) == null ? void 0 : f.length) && E2.value !== -1 && (E2.value += 1, a3("flow-step", E2.value), bn());
    }, Z = () => {
      E2.value = -1;
    }, {
      updateTime: j,
      updateMonthYear: M3,
      today: D2,
      month: u2,
      year: s3,
      hours: h3,
      minutes: F,
      seconds: J,
      isDisabled: I2,
      isActiveDate: oe,
      selectDate: te,
      getWeekNum: k2,
      setHoverDate: _,
      isHoverRangeEnd: O2,
      isAutoRangeInBetween: Re,
      isAutoRangeStart: Ie,
      rangeActive: Ye,
      clearHoverDate: Ke,
      rangeActiveStartEnd: Ue,
      monthYearSelect: Ze,
      handleScroll: be,
      handleArrow: it,
      handleSwipe: pt,
      getMarker: ht,
      selectCurrentDate: c2,
      isHoverDateStartEnd: ae,
      isHoverDate: me,
      presetDateRange: ut
    } = Kr(n, a3, ee, v), Qe = at(t2, "calendar"), Lt = at(t2, "action"), Gt = at(t2, "timePicker"), Pt = at(t2, "monthYear"), r = computed(() => n.openOnTop ? "dp__arrow_bottom" : "dp__arrow_top"), b2 = computed(() => zl(n.yearRange)), S3 = computed(() => Xl(n.locale, n.monthNameFormat)), se = () => {
      const f = ke(d3);
      f && (V.value = f.getBoundingClientRect().width);
    }, Se = computed(
      () => (f) => Ll(
        u2.value(f),
        s3.value(f),
        +n.weekStart,
        n.hideOffsetDates
      )
    ), xe = computed(
      () => n.multiCalendars > 0 && n.range ? [...Array(n.multiCalendars).keys()] : [0]
    ), Te = computed(
      () => (f) => f === 1
    ), dt = computed(() => n.monthPicker || n.timePicker || n.yearPicker), Le = computed(
      () => ({
        dp__flex_display: n.multiCalendars > 0
      })
    ), ca = computed(() => ({
      dp__instance_calendar: n.multiCalendars > 0
    })), fa = computed(() => ({
      dp__menu_disabled: n.disabled,
      dp__menu_readonly: n.readonly
    })), ma = computed(
      () => (f) => ha(Se, f)
    ), va = computed(() => ({
      locale: n.locale,
      weekNumName: n.weekNumName,
      weekStart: n.weekStart,
      weekNumbers: n.weekNumbers,
      customProps: n.customProps,
      calendarClassName: n.calendarClassName,
      specificMode: dt.value,
      getWeekNum: k2,
      multiCalendars: n.multiCalendars,
      modeHeight: n.modeHeight,
      internalModelValue: n.internalModelValue,
      noSwipe: n.noSwipe,
      vertical: n.vertical,
      dayNames: n.dayNames,
      monthChangeOnScroll: n.monthChangeOnScroll
    })), ya = computed(
      () => ({
        dp__menu: true,
        dp__menu_index: !n.inline,
        dp__relative: n.inline,
        [n.menuClassName]: !!n.menuClassName
      })
    ), pa = () => n.modelAuto && Array.isArray(n.internalModelValue) ? !!n.internalModelValue[0] : false, gt = () => n.modelAuto ? oa(n.internalModelValue) : true, ha = (f, U) => f.value(U).map((H3) => ({
      ...H3,
      days: H3.days.map((q2) => {
        const Q2 = I2(q2.value), kt = me(Q2, q2), et = n.range ? n.modelAuto ? pa() && oe(q2) : false : oe(q2), $n = n.highlight ? Xn(q2.value, n.highlight) : false, Dn = n.highlightWeekDays && n.highlightWeekDays.includes(q2.value.getDay()), Mn = (n.range || n.weekPicker) && (n.multiCalendars > 0 ? q2.current : true) && !Q2 && gt() && !(!q2.current && n.hideOffsetDates) && !oe(q2) ? Ye(q2) : false;
        return q2.marker = ht(q2), q2.classData = {
          dp__cell_offset: !q2.current,
          dp__pointer: !Q2 && !(!q2.current && n.hideOffsetDates),
          dp__active_date: et,
          dp__date_hover: kt,
          dp__date_hover_start: ae(kt, q2, true),
          dp__date_hover_end: ae(kt, q2, false),
          dp__range_between: Mn && !n.weekPicker,
          dp__range_between_week: Mn && n.weekPicker,
          dp__today: !n.noToday && ce(q2.value, D2.value) && q2.current,
          dp__cell_disabled: Q2,
          dp__cell_auto_range: Re(q2),
          dp__cell_auto_range_start: Ie(q2),
          dp__cell_auto_range_end: O2(q2),
          dp__range_start: n.multiCalendars > 0 ? q2.current && Ue(q2) && gt() : Ue(q2) && gt(),
          dp__range_end: n.multiCalendars > 0 ? q2.current && Ue(q2, false) && gt() : Ue(q2, false) && gt(),
          [n.calendarCellClassName]: !!n.calendarCellClassName,
          dp__cell_highlight: ($n || Dn) && !et,
          dp__cell_highlight_active: ($n || Dn) && et
        }, q2;
      })
    })), ga = (f) => {
      f.stopPropagation(), f.preventDefault(), f.stopImmediatePropagation();
    }, ka = () => {
      n.escClose && a3("closePicker");
    }, wa = (f, U = false) => {
      te(f, U), n.spaceConfirm && a3("selectDate");
    }, jt = (f) => {
      var U;
      (U = n.flow) != null && U.length && (m3[f] = true, Object.keys(m3).filter((H3) => !m3[H3]).length || bn());
    }, bn = () => {
      n.flow[E2.value] === "month" && p.value[0] && p.value[0].toggleMonthPicker(true), n.flow[E2.value] === "year" && p.value && p.value[0].toggleYearPicker(true), n.flow[E2.value] === "calendar" && g.value && g.value.toggleTimePicker(false, true), n.flow[E2.value] === "time" && g.value && g.value.toggleTimePicker(true, true);
      const f = n.flow[E2.value];
      (f === "hours" || f === "minutes" || f === "seconds") && g.value && g.value.toggleTimePicker(true, true, f);
    }, Ct = (f) => {
      if (T2 != null && T2.value) {
        if (f === "up")
          return K2();
        if (f === "down")
          return P();
        if (f === "left")
          return z2();
        if (f === "right")
          return Y2();
      } else
        f === "left" || f === "up" ? it("left", 0, f === "up") : it("right", 0, f === "down");
    }, ba = (f) => {
      l(f.shiftKey), !n.disableMonthYearSelect && f.code === "Tab" && f.target.classList.contains("dp__menu") && i2().shiftKeyInMenu && (f.preventDefault(), f.stopImmediatePropagation(), a3("closePicker"));
    };
    return (f, U) => (openBlock(), createBlock(Transition, {
      appear: "",
      name: unref(N).menuAppear,
      mode: "out-in",
      css: !!unref(N)
    }, {
      default: withCtx(() => [
        createBaseVNode("div", {
          id: f.uid ? `dp-menu-${f.uid}` : void 0,
          tabindex: "0",
          ref_key: "dpMenuRef",
          ref: w2,
          role: "dialog",
          "aria-label": unref(G2).menu,
          class: normalizeClass(unref(ya)),
          onMouseleave: U[12] || (U[12] = (...H3) => unref(Ke) && unref(Ke)(...H3)),
          onClick: ga,
          onKeydown: [
            withKeys(ka, ["esc"]),
            U[13] || (U[13] = withKeys(withModifiers((H3) => Ct("left"), ["prevent"]), ["left"])),
            U[14] || (U[14] = withKeys(withModifiers((H3) => Ct("up"), ["prevent"]), ["up"])),
            U[15] || (U[15] = withKeys(withModifiers((H3) => Ct("down"), ["prevent"]), ["down"])),
            U[16] || (U[16] = withKeys(withModifiers((H3) => Ct("right"), ["prevent"]), ["right"])),
            ba
          ]
        }, [
          (f.disabled || f.readonly) && f.inline ? (openBlock(), createElementBlock("div", {
            key: 0,
            class: normalizeClass(unref(fa))
          }, null, 2)) : createCommentVNode("", true),
          !f.inline && !f.teleportCenter ? (openBlock(), createElementBlock("div", {
            key: 1,
            class: normalizeClass(unref(r))
          }, null, 2)) : createCommentVNode("", true),
          createBaseVNode("div", {
            class: normalizeClass(f.presetRanges.length ? "dp__menu_content_wrapper" : null)
          }, [
            f.presetRanges.length ? (openBlock(), createElementBlock("div", Lr, [
              (openBlock(true), createElementBlock(Fragment, null, renderList(f.presetRanges, (H3, q2) => (openBlock(), createElementBlock("div", {
                key: q2,
                style: normalizeStyle(H3.style || {}),
                class: "dp__preset_range",
                onClick: (Q2) => unref(ut)(H3.range)
              }, toDisplayString(H3.label), 13, Gr))), 128))
            ])) : createCommentVNode("", true),
            createBaseVNode("div", {
              class: "dp__instance_calendar",
              ref_key: "calendarWrapperRef",
              ref: d3,
              role: "document"
            }, [
              createBaseVNode("div", {
                class: normalizeClass(unref(Le))
              }, [
                (openBlock(true), createElementBlock(Fragment, null, renderList(unref(xe), (H3, q2) => (openBlock(), createElementBlock("div", {
                  key: H3,
                  class: normalizeClass(unref(ca))
                }, [
                  !f.disableMonthYearSelect && !f.timePicker ? (openBlock(), createBlock(resolveDynamicComponent(f.monthYearComponent ? f.monthYearComponent : Ar), mergeProps({
                    key: 0,
                    ref_for: true,
                    ref: (Q2) => {
                      Q2 && (p.value[q2] = Q2);
                    }
                  }, {
                    months: unref(S3),
                    years: unref(b2),
                    filters: f.filters,
                    monthPicker: f.monthPicker,
                    month: unref(u2)(H3),
                    year: unref(s3)(H3),
                    customProps: f.customProps,
                    multiCalendars: e2.multiCalendars,
                    multiCalendarsSolo: f.multiCalendarsSolo,
                    instance: H3,
                    minDate: f.minDate,
                    maxDate: f.maxDate,
                    preventMinMaxNavigation: f.preventMinMaxNavigation,
                    internalModelValue: e2.internalModelValue,
                    range: f.range,
                    reverseYears: f.reverseYears,
                    vertical: f.vertical,
                    yearPicker: f.yearPicker
                  }, {
                    onMount: U[0] || (U[0] = (Q2) => jt("monthYearInput")),
                    onResetFlow: Z,
                    onUpdateMonthYear: (Q2) => unref(M3)(H3, Q2),
                    onMonthYearSelect: unref(Ze),
                    onOverlayClosed: X2
                  }), createSlots({ _: 2 }, [
                    renderList(unref(Pt), (Q2, kt) => ({
                      name: Q2,
                      fn: withCtx((et) => [
                        renderSlot(f.$slots, Q2, normalizeProps(guardReactiveProps(et)))
                      ])
                    }))
                  ]), 1040, ["onUpdateMonthYear", "onMonthYearSelect"])) : createCommentVNode("", true),
                  createVNode(vr, mergeProps({
                    ref_for: true,
                    ref: (Q2) => {
                      Q2 && (v.value[q2] = Q2);
                    }
                  }, unref(va), {
                    "flow-step": E2.value,
                    "onUpdate:flow-step": U[1] || (U[1] = (Q2) => E2.value = Q2),
                    instance: H3,
                    "mapped-dates": unref(ma)(H3),
                    month: unref(u2)(H3),
                    year: unref(s3)(H3),
                    onSelectDate: (Q2) => unref(te)(Q2, !unref(Te)(H3)),
                    onHandleSpace: (Q2) => wa(Q2, !unref(Te)(H3)),
                    onSetHoverDate: U[2] || (U[2] = (Q2) => unref(_)(Q2)),
                    onHandleScroll: (Q2) => unref(be)(Q2, H3),
                    onHandleSwipe: (Q2) => unref(pt)(Q2, H3),
                    onMount: U[3] || (U[3] = (Q2) => jt("calendar")),
                    onResetFlow: Z
                  }), createSlots({ _: 2 }, [
                    renderList(unref(Qe), (Q2, kt) => ({
                      name: Q2,
                      fn: withCtx((et) => [
                        renderSlot(f.$slots, Q2, normalizeProps(guardReactiveProps({ ...et })))
                      ])
                    }))
                  ]), 1040, ["flow-step", "instance", "mapped-dates", "month", "year", "onSelectDate", "onHandleSpace", "onHandleScroll", "onHandleSwipe"])
                ], 2))), 128))
              ], 2),
              createBaseVNode("div", null, [
                f.enableTimePicker && !f.monthPicker && !f.weekPicker ? (openBlock(), createBlock(resolveDynamicComponent(f.timePickerComponent ? f.timePickerComponent : Wr), mergeProps({
                  key: 0,
                  ref_key: "timePickerRef",
                  ref: g
                }, {
                  is24: f.is24,
                  hoursIncrement: f.hoursIncrement,
                  minutesIncrement: f.minutesIncrement,
                  hoursGridIncrement: f.hoursGridIncrement,
                  secondsIncrement: f.secondsIncrement,
                  minutesGridIncrement: f.minutesGridIncrement,
                  secondsGridIncrement: f.secondsGridIncrement,
                  noHoursOverlay: f.noHoursOverlay,
                  noMinutesOverlay: f.noMinutesOverlay,
                  noSecondsOverlay: f.noSecondsOverlay,
                  range: f.range,
                  filters: f.filters,
                  timePicker: f.timePicker,
                  hours: unref(h3),
                  minutes: unref(F),
                  seconds: unref(J),
                  customProps: f.customProps,
                  enableSeconds: f.enableSeconds,
                  fixedStart: f.fixedStart,
                  fixedEnd: f.fixedEnd,
                  modelAuto: f.modelAuto,
                  internalModelValue: e2.internalModelValue
                }, {
                  onMount: U[4] || (U[4] = (H3) => jt("timePicker")),
                  "onUpdate:hours": U[5] || (U[5] = (H3) => unref(j)(H3)),
                  "onUpdate:minutes": U[6] || (U[6] = (H3) => unref(j)(H3, false)),
                  "onUpdate:seconds": U[7] || (U[7] = (H3) => unref(j)(H3, false, true)),
                  onResetFlow: Z,
                  onOverlayClosed: X2
                }), createSlots({ _: 2 }, [
                  renderList(unref(Gt), (H3, q2) => ({
                    name: H3,
                    fn: withCtx((Q2) => [
                      renderSlot(f.$slots, H3, normalizeProps(guardReactiveProps(Q2)))
                    ])
                  }))
                ]), 1040)) : createCommentVNode("", true)
              ])
            ], 512),
            f.showNowButton ? (openBlock(), createElementBlock("div", jr, [
              f.$slots["now-button"] ? renderSlot(f.$slots, "now-button", {
                key: 0,
                selectCurrentDate: unref(c2)
              }) : createCommentVNode("", true),
              f.$slots["now-button"] ? createCommentVNode("", true) : (openBlock(), createElementBlock("button", {
                key: 1,
                type: "button",
                role: "button",
                class: "dp__now_button",
                onClick: U[8] || (U[8] = (...H3) => unref(c2) && unref(c2)(...H3))
              }, toDisplayString(f.nowButtonLabel), 1))
            ])) : createCommentVNode("", true)
          ], 2),
          !f.autoApply || f.keepActionRow ? (openBlock(), createBlock(resolveDynamicComponent(f.actionRowComponent ? f.actionRowComponent : lr), mergeProps({ key: 2 }, {
            calendarWidth: V.value,
            selectText: f.selectText,
            cancelText: f.cancelText,
            internalModelValue: e2.internalModelValue,
            range: f.range,
            previewFormat: f.previewFormat,
            inline: f.inline,
            monthPicker: f.monthPicker,
            timePicker: f.timePicker,
            customProps: f.customProps,
            multiCalendars: e2.multiCalendars,
            menuMount: R2.value,
            maxTime: f.maxTime,
            minTime: f.minTime,
            enableTimePicker: f.enableTimePicker,
            minDate: f.minDate,
            maxDate: f.maxDate,
            multiDates: f.multiDates,
            modelAuto: f.modelAuto,
            partialRange: f.partialRange,
            ignoreTimeValidation: f.ignoreTimeValidation
          }, {
            onClosePicker: U[9] || (U[9] = (H3) => f.$emit("closePicker")),
            onSelectDate: U[10] || (U[10] = (H3) => f.$emit("selectDate")),
            onInvalidSelect: U[11] || (U[11] = (H3) => f.$emit("invalid-select"))
          }), createSlots({ _: 2 }, [
            renderList(unref(Lt), (H3, q2) => ({
              name: H3,
              fn: withCtx((Q2) => [
                renderSlot(f.$slots, H3, normalizeProps(guardReactiveProps({ ...Q2 })))
              ])
            }))
          ]), 1040)) : createCommentVNode("", true)
        ], 42, Ur)
      ]),
      _: 3
    }, 8, ["name", "css"]));
  }
});
var Xr = (e2, a3, n, t2, d3, m3, p, v, g, w2, V, R2, E2, N, G2, T2, x2) => {
  const l = ref(""), i2 = ref();
  watch(i2, () => {
    x2("internalModelChange", i2.value);
  });
  const Y2 = (u2) => [ee(u2[0]), u2[1] ? ee(u2[1]) : null], z2 = (u2) => {
    let s3 = null;
    u2 ? a3 ? Yl(u2) && "hours" in u2[0] && "minutes" in u2[0] ? s3 = [
      Ae(null, +u2[0].hours, +u2[0].minutes, +u2[0].seconds),
      Ae(null, +u2[1].hours, +u2[1].minutes, +u2[1].seconds)
    ] : Il(u2) && (s3 = Ae(null, +u2.hours, +u2.minutes, +u2.seconds)) : n ? El(u2) && "month" in u2[0] && "year" in u2[0] ? (s3 = [st(null, +u2[0].month, +u2[0].year)], u2[1] ? s3[1] = st(null, +u2[1].month, +u2[1].year) : !u2[1] && d3 && (s3[1] = null)) : Fl(u2) && "month" in u2 && "year" in u2 && (s3 = st(null, +u2.month, +u2.year)) : E2 ? Array.isArray(u2) ? s3 = [
      setYear(/* @__PURE__ */ new Date(), u2[0]),
      !u2[1] && d3 ? null : setYear(/* @__PURE__ */ new Date(), u2[1])
    ] : s3 = setYear(/* @__PURE__ */ new Date(), u2) : w2 && Array.isArray(u2) ? s3 = u2.map((h3) => ee(h3)) : R2 && Array.isArray(u2) ? s3 = [new Date(u2[0]), new Date(u2[1])] : t2 ? T2 ? Array.isArray(u2) ? s3 = Y2(u2) : s3 = [ee(u2), null] : Hl(u2, d3) && (s3 = Y2(u2)) : Kl(u2) && (s3 = ee(u2)) : s3 = null, rn(s3) ? (i2.value = s3, K2()) : (i2.value = null, l.value = "");
  }, P = () => jn(
    e2,
    m3,
    v,
    n,
    a3,
    R2,
    E2,
    p
  ), K2 = () => {
    if (!i2.value)
      l.value = "";
    else if (!e2 || typeof e2 == "string") {
      const u2 = P();
      Array.isArray(i2.value) && w2 ? l.value = i2.value.map((s3) => vt(s3, u2, g == null ? void 0 : g.value)).join("; ") : l.value = vt(
        i2.value,
        u2,
        g == null ? void 0 : g.value,
        N == null ? void 0 : N.rangeSeparator,
        T2
      );
    } else
      a3 ? l.value = e2(sn(i2.value)) : n ? l.value = e2(Vn(i2.value)) : l.value = e2(i2.value);
  }, X2 = () => i2.value ? t2 ? d3 ? i2.value.length >= 1 : i2.value.length === 2 : !!i2.value : false, ee = (u2) => {
    if (V) {
      const s3 = new Date(u2);
      return V === "preserve" ? new Date(s3.getTime() + s3.getTimezoneOffset() * 6e4) : s3;
    }
    return G2 ? G2 === "date" || G2 === "timestamp" ? new Date(u2) : G2 === "format" && (typeof e2 == "string" || !e2) ? parse(u2, P(), /* @__PURE__ */ new Date()) : parse(u2, G2, /* @__PURE__ */ new Date()) : new Date(u2);
  }, Z = (u2) => G2 ? G2 === "timestamp" ? +u2 : G2 === "format" && (typeof e2 == "string" || !e2) ? vt(u2, P(), g == null ? void 0 : g.value, N == null ? void 0 : N.rangeSeparator) : vt(u2, G2, g == null ? void 0 : g.value, N == null ? void 0 : N.rangeSeparator) : u2, j = (u2) => {
    x2("update:modelValue", u2);
  }, M3 = () => [
    Z(i2.value[0]),
    i2.value[1] ? Z(i2.value[1]) : null
  ];
  return {
    parseExternalModelValue: z2,
    formatInputValue: K2,
    internalModelValue: i2,
    inputValue: l,
    emitModelValue: () => {
      if (n)
        j(Vn(i2.value));
      else if (a3)
        j(sn(i2.value));
      else if (R2)
        j(i2.value);
      else if (E2)
        j(
          Array.isArray(i2.value) ? [
            getYear(i2.value[0]),
            i2.value[1] ? getYear(i2.value[1]) : null
          ] : getYear(i2.value)
        );
      else {
        if (i2.value && t2 && d3 && i2.value.length === 1 && i2.value.push(null), V) {
          let u2;
          if (Array.isArray(i2.value)) {
            const s3 = (h3) => h3 && Zt(h3, V === "preserve");
            T2 ? u2 = i2.value[1] ? i2.value.map(s3) : Zt(i2.value[0], V === "preserve") : u2 = i2.value.map(s3);
          } else
            u2 = Zt(i2.value, V === "preserve");
          return j(u2);
        }
        Array.isArray(i2.value) && !w2 ? j(
          T2 ? i2.value[1] ? M3() : Z(i2.value[0]) : M3()
        ) : Array.isArray(i2.value) && w2 ? j(i2.value.map((u2) => Z(u2))) : j(Z(i2.value));
      }
      K2();
    },
    checkBeforeEmit: X2
  };
};
var qr = (e2, a3, n, t2, d3, m3, p, v, g) => {
  const w2 = ref({
    top: "0",
    left: "0",
    transform: "none"
  }), V = ref(false), R2 = 390, E2 = (P) => {
    const K2 = P.getBoundingClientRect();
    return {
      left: K2.left + window.scrollX,
      top: K2.top + window.scrollY
    };
  }, N = (P) => {
    const K2 = P.getBoundingClientRect();
    let X2 = 0, ee = 0;
    for (; P && !isNaN(P.offsetLeft) && !isNaN(P.offsetTop); )
      X2 += P.offsetLeft - P.scrollLeft, ee = K2.top + P.scrollTop, P = P.offsetParent;
    return { top: ee, left: X2 };
  }, G2 = (P, K2) => {
    w2.value.left = `${P + K2}px`, w2.value.transform = "translateX(-100%)";
  }, T2 = (P) => {
    w2.value.left = `${P}px`, w2.value.transform = "translateX(0)";
  }, x2 = (P, K2) => {
    e2 === Et.left && T2(P), e2 === Et.right && G2(P, K2), e2 === Et.center && (w2.value.left = `${P + K2 / 2}px`, w2.value.transform = "translateX(-50%)");
  }, l = () => {
    const P = ke(d3);
    if (P) {
      const K2 = window.innerHeight, { top: X2 } = a3 ? N(P) : E2(P), { left: ee, width: Z, top: j, height: M3 } = P.getBoundingClientRect(), D2 = K2 - j - M3;
      w2.value.top = j > D2 ? `${X2 - R2}px` : `${X2}px`, x2(ee, Z);
    }
  }, i2 = () => {
    w2.value.left = "50%", w2.value.top = "50%", w2.value.transform = "translate(-50%, -50%)", w2.value.position = "fixed";
  }, Y2 = (P = true) => {
    if (!m3) {
      if (v.value)
        return i2();
      const K2 = ke(d3);
      if (a3 && typeof a3 != "boolean")
        w2.value = a3(K2);
      else if (K2) {
        const { left: X2, width: ee, height: Z } = K2.getBoundingClientRect(), { top: j } = a3 ? N(K2) : E2(K2);
        w2.value.top = `${Z + j + +p}px`, x2(X2, ee), P && n && z2();
      }
    }
  }, z2 = () => {
    const P = ke(d3);
    if (P && n && !m3) {
      const { height: K2, top: X2, left: ee, width: Z } = P.getBoundingClientRect(), { top: j } = a3 ? N(P) : E2(P), D2 = window.innerHeight - X2 - K2, u2 = ke(t2);
      if (u2) {
        const { height: s3, left: h3, right: F } = u2.getBoundingClientRect(), J = s3 + K2;
        J > X2 && J > D2 ? X2 < D2 ? (Y2(false), V.value = false) : (w2.value.top = `${j - s3 - +p}px`, V.value = true) : J > D2 ? (w2.value.top = `${j - s3 - +p}px`, V.value = true) : (Y2(false), V.value = false), h3 < 0 ? T2(ee) : F > document.documentElement.clientWidth && G2(ee, Z);
      }
    }
    g("recalculatePosition");
  };
  return { openOnTop: V, menuPosition: w2, setMenuPosition: Y2, setInitialPosition: l, recalculatePosition: z2 };
};
var Jr = typeof window < "u" ? window : void 0;
var an = () => {
};
var Zr = (e2) => getCurrentScope() ? (onScopeDispose(e2), true) : false;
var Qr = (e2, a3, n, t2) => {
  if (!e2)
    return an;
  let d3 = an;
  const m3 = watch(
    () => unref(e2),
    (v) => {
      d3(), v && (v.addEventListener(a3, n, t2), d3 = () => {
        v.removeEventListener(a3, n, t2), d3 = an;
      });
    },
    { immediate: true, flush: "post" }
  ), p = () => {
    m3(), d3();
  };
  return Zr(p), p;
};
var xr = (e2, a3, n, t2 = {}) => {
  const { window: d3 = Jr, event: m3 = "pointerdown" } = t2;
  return d3 ? Qr(d3, m3, (v) => {
    const g = ke(e2), w2 = ke(a3);
    !g || !w2 || g === v.target || v.composedPath().includes(g) || v.composedPath().includes(w2) || n(v);
  }, { passive: true }) : void 0;
};
var es = defineComponent({
  __name: "VueDatePicker",
  props: {
    ...Tl
  },
  emits: [
    "update:modelValue",
    "textSubmit",
    "closed",
    "cleared",
    "open",
    "focus",
    "blur",
    "internalModelChange",
    "recalculatePosition",
    "flow-step",
    "updateMonthYear",
    "invalid-select"
  ],
  setup(e2, { expose: a3, emit: n }) {
    const t2 = e2, d3 = useSlots(), m3 = ref(false), p = toRef(t2, "modelValue"), v = ref(null), g = ref(null), w2 = toRef(t2, "teleportCenter");
    provide(pn, t2.autoApply);
    const V = computed(() => t2.formatLocale);
    provide(Zn, V), provide(Jn, toRef(t2, "textInput")), provide(qe, toRef(t2, "arrowNavigation")), onMounted(() => {
      z2(t2.modelValue), t2.inline || (window.addEventListener("scroll", k2), window.addEventListener("resize", _)), t2.inline && (m3.value = true);
    }), onUnmounted(() => {
      t2.inline || (window.removeEventListener("scroll", k2), window.removeEventListener("resize", _));
    });
    const R2 = at(d3, "all"), E2 = at(d3, "input");
    watch(
      p,
      () => {
        z2(p.value);
      },
      { deep: true }
    );
    const { openOnTop: N, menuPosition: G2, setMenuPosition: T2, recalculatePosition: x2, setInitialPosition: l } = qr(
      t2.position,
      t2.altPosition,
      t2.autoPosition,
      v,
      g,
      t2.inline,
      t2.offset,
      w2,
      n
    ), {
      internalModelValue: i2,
      inputValue: Y2,
      parseExternalModelValue: z2,
      emitModelValue: P,
      checkBeforeEmit: K2,
      formatInputValue: X2
    } = Xr(
      t2.format,
      t2.timePicker,
      t2.monthPicker,
      t2.range,
      t2.partialRange,
      t2.is24,
      t2.enableTimePicker,
      t2.enableSeconds,
      V,
      t2.multiDates,
      t2.utc,
      t2.weekPicker,
      t2.yearPicker,
      t2.textInputOptions,
      t2.modelType,
      t2.modelAuto,
      n
    ), { clearArrowNav: ee } = Je(), { setMenuFocused: Z, setShiftKey: j } = ua(), M3 = computed(
      () => ({
        dp__main: true,
        dp__theme_dark: t2.dark,
        dp__theme_light: !t2.dark,
        dp__flex_display: t2.inline,
        dp__flex_display_with_input: t2.inlineWithInput
      })
    ), D2 = computed(() => On(t2.format) ? t2.format : jn(
      null,
      t2.is24,
      t2.enableSeconds,
      t2.monthPicker,
      t2.timePicker,
      t2.weekPicker,
      t2.yearPicker,
      t2.enableTimePicker
    )), u2 = computed(() => t2.previewFormat ? t2.previewFormat : On(D2.value) ? D2.value : t2.format), s3 = computed(() => typeof t2.transitions == "boolean" ? t2.transitions ? Nn({}) : false : Nn(t2.transitions));
    provide(Kt, s3);
    const h3 = computed(() => t2.dark ? "dp__theme_dark" : "dp__theme_light"), F = computed(() => Object.assign(Jl(), t2.textInputOptions)), J = computed(() => er(t2.ariaLabels));
    provide(Xe, J);
    const I2 = computed(() => Zl(t2.filters)), oe = computed(() => {
      const c2 = (ae) => {
        const me = {
          hours: getHours(/* @__PURE__ */ new Date()),
          minutes: getMinutes(/* @__PURE__ */ new Date()),
          seconds: getSeconds(/* @__PURE__ */ new Date())
        };
        return Object.assign(me, ae);
      };
      return t2.range ? t2.startTime && Array.isArray(t2.startTime) ? [c2(t2.startTime[0]), c2(t2.startTime[1])] : null : t2.startTime && !Array.isArray(t2.startTime) ? c2(t2.startTime) : null;
    }), te = computed(() => t2.multiCalendars === null ? 0 : typeof t2.multiCalendars == "boolean" ? t2.multiCalendars ? 2 : 0 : +t2.multiCalendars >= 2 ? +t2.multiCalendars : 2), k2 = () => {
      m3.value && (t2.closeOnScroll ? be() : t2.autoPosition ? T2() : window.removeEventListener("scroll", k2));
    }, _ = () => {
      m3.value && T2();
    }, O2 = () => {
      !t2.disabled && !t2.readonly && (l(), m3.value = true, nextTick().then(() => {
        T2(), m3.value && n("open");
      }), m3.value || Ze(), z2(t2.modelValue));
    }, Re = () => {
      Y2.value = "", Ze(), n("update:modelValue", null), n("cleared"), be();
    }, Ie = () => {
      const { validate: c2 } = qn(
        t2.minDate,
        t2.maxDate,
        t2.disabledDates,
        t2.allowedDates,
        I2.value,
        t2.disabledWeekDays,
        t2.yearRange
      ), ae = i2.value;
      return !ae || !Array.isArray(ae) && c2(ae) ? true : Array.isArray(ae) ? ae.length === 2 && c2(ae[0]) && c2(ae[1]) ? true : !!c2(ae[0]) : false;
    }, Ye = () => {
      K2() && Ie() ? (P(), be()) : n("invalid-select", i2.value);
    }, Ke = (c2) => {
      P(), t2.closeOnAutoApply && !c2 && be();
    }, Ue = (c2 = false) => {
      t2.autoApply && (!t2.enableTimePicker || t2.monthPicker || t2.yearPicker || t2.ignoreTimeValidation ? true : on(i2.value, t2.maxTime, t2.minTime, t2.maxDate, t2.minDate)) && Ie() && (t2.range && Array.isArray(i2.value) ? (t2.partialRange || i2.value.length === 2) && Ke(c2) : Ke(c2));
    }, Ze = () => {
      i2.value = null;
    }, be = () => {
      t2.inline || (m3.value && (m3.value = false, Z(false), j(false), ee(), n("closed"), l(), Y2.value && z2(p.value)), Ze(), g.value && g.value.focusInput());
    }, it = (c2, ae) => {
      if (!c2) {
        i2.value = null;
        return;
      }
      i2.value = c2, ae && (Ye(), n("textSubmit"));
    }, pt = () => {
      t2.autoApply && on(i2.value, t2.maxTime, t2.minTime, t2.maxDate, t2.minDate) && P();
    }, ht = () => m3.value ? be() : O2();
    return xr(v, g, be), a3({
      closeMenu: be,
      selectDate: Ye,
      clearValue: Re,
      openMenu: O2,
      onScroll: k2,
      formatInputValue: X2
    }), (c2, ae) => (openBlock(), createElementBlock("div", {
      class: normalizeClass(unref(M3))
    }, [
      createVNode(Nl, mergeProps({
        ref_key: "inputRef",
        ref: g
      }, {
        placeholder: c2.placeholder,
        hideInputIcon: c2.hideInputIcon,
        readonly: c2.readonly,
        disabled: c2.disabled,
        inputClassName: c2.inputClassName,
        clearable: c2.clearable,
        state: c2.state,
        inline: c2.inline,
        inlineWithInput: c2.inlineWithInput,
        textInput: c2.textInput,
        textInputOptions: unref(F),
        range: c2.range,
        isMenuOpen: m3.value,
        pattern: unref(D2),
        autoApply: c2.autoApply,
        uid: c2.uid,
        required: c2.required,
        name: c2.name,
        autocomplete: c2.autocomplete
      }, {
        "input-value": unref(Y2),
        "onUpdate:input-value": ae[0] || (ae[0] = (me) => isRef(Y2) ? Y2.value = me : null),
        onClear: Re,
        onOpen: O2,
        onSetInputDate: it,
        onSetEmptyDate: unref(P),
        onSelectDate: Ye,
        onToggle: ht,
        onClose: be,
        onFocus: ae[1] || (ae[1] = (me) => c2.$emit("focus")),
        onBlur: ae[2] || (ae[2] = (me) => c2.$emit("blur"))
      }), createSlots({ _: 2 }, [
        renderList(unref(E2), (me, ut) => ({
          name: me,
          fn: withCtx((Qe) => [
            renderSlot(c2.$slots, me, normalizeProps(guardReactiveProps(Qe)))
          ])
        }))
      ]), 1040, ["input-value", "onSetEmptyDate"]),
      m3.value ? (openBlock(), createBlock(Teleport, {
        key: 0,
        to: c2.teleport,
        disabled: c2.inline
      }, [
        m3.value ? (openBlock(), createBlock(zr, mergeProps({
          key: 0,
          ref_key: "dpMenuRef",
          ref: v,
          class: unref(h3),
          style: unref(G2)
        }, {
          weekNumbers: c2.weekNumbers,
          weekStart: c2.weekStart,
          disableMonthYearSelect: c2.disableMonthYearSelect,
          menuClassName: c2.menuClassName,
          calendarClassName: c2.calendarClassName,
          yearRange: c2.yearRange,
          range: c2.range,
          multiCalendars: unref(te),
          multiCalendarsSolo: c2.multiCalendarsSolo,
          multiStatic: c2.multiStatic,
          calendarCellClassName: c2.calendarCellClassName,
          enableTimePicker: c2.enableTimePicker,
          is24: c2.is24,
          hoursIncrement: c2.hoursIncrement,
          minutesIncrement: c2.minutesIncrement,
          hoursGridIncrement: c2.hoursGridIncrement,
          minutesGridIncrement: c2.minutesGridIncrement,
          minDate: c2.minDate,
          maxDate: c2.maxDate,
          autoApply: c2.autoApply,
          selectText: c2.selectText,
          cancelText: c2.cancelText,
          previewFormat: unref(u2),
          locale: c2.locale,
          weekNumName: c2.weekNumName,
          disabledDates: c2.disabledDates,
          filters: unref(I2),
          minTime: c2.minTime,
          maxTime: c2.maxTime,
          inline: c2.inline,
          openOnTop: unref(N),
          monthPicker: c2.monthPicker,
          timePicker: c2.timePicker,
          monthNameFormat: c2.monthNameFormat,
          startDate: c2.startDate,
          startTime: unref(oe),
          monthYearComponent: c2.monthYearComponent,
          timePickerComponent: c2.timePickerComponent,
          actionRowComponent: c2.actionRowComponent,
          customProps: c2.customProps,
          hideOffsetDates: c2.hideOffsetDates,
          autoRange: c2.autoRange,
          noToday: c2.noToday,
          noHoursOverlay: c2.noHoursOverlay,
          noMinutesOverlay: c2.noMinutesOverlay,
          disabledWeekDays: c2.disabledWeekDays,
          allowedDates: c2.allowedDates,
          showNowButton: c2.showNowButton,
          nowButtonLabel: c2.nowButtonLabel,
          monthChangeOnScroll: c2.monthChangeOnScroll,
          markers: c2.markers,
          uid: c2.uid,
          modeHeight: c2.modeHeight,
          enableSeconds: c2.enableSeconds,
          secondsIncrement: c2.secondsIncrement,
          secondsGridIncrement: c2.secondsGridIncrement,
          noSecondsOverlay: c2.noSecondsOverlay,
          escClose: c2.escClose,
          spaceConfirm: c2.spaceConfirm,
          monthChangeOnArrows: c2.monthChangeOnArrows,
          textInput: c2.textInput,
          disabled: c2.disabled,
          readonly: c2.readonly,
          multiDates: c2.multiDates,
          presetRanges: c2.presetRanges,
          flow: c2.flow,
          preventMinMaxNavigation: c2.preventMinMaxNavigation,
          minRange: c2.minRange,
          maxRange: c2.maxRange,
          fixedStart: c2.fixedStart,
          fixedEnd: c2.fixedEnd,
          multiDatesLimit: c2.multiDatesLimit,
          reverseYears: c2.reverseYears,
          keepActionRow: c2.keepActionRow,
          weekPicker: c2.weekPicker,
          noSwipe: c2.noSwipe,
          vertical: c2.vertical,
          arrowNavigation: c2.arrowNavigation,
          yearPicker: c2.yearPicker,
          disableTimeRangeValidation: c2.disableTimeRangeValidation,
          dayNames: c2.dayNames,
          modelAuto: c2.modelAuto,
          highlight: c2.highlight,
          highlightWeekDays: c2.highlightWeekDays,
          partialRange: c2.partialRange,
          teleportCenter: c2.teleportCenter,
          ignoreTimeValidation: c2.ignoreTimeValidation
        }, {
          internalModelValue: unref(i2),
          "onUpdate:internalModelValue": ae[3] || (ae[3] = (me) => isRef(i2) ? i2.value = me : null),
          onClosePicker: be,
          onSelectDate: Ye,
          onDpOpen: unref(x2),
          onAutoApply: Ue,
          onTimeUpdate: pt,
          onFlowStep: ae[4] || (ae[4] = (me) => c2.$emit("flow-step", me)),
          onUpdateMonthYear: ae[5] || (ae[5] = (me) => c2.$emit("updateMonthYear", me)),
          onInvalidSelect: ae[6] || (ae[6] = (me) => c2.$emit("invalid-select", unref(i2)))
        }), createSlots({ _: 2 }, [
          renderList(unref(R2), (me, ut) => ({
            name: me,
            fn: withCtx((Qe) => [
              renderSlot(c2.$slots, me, normalizeProps(guardReactiveProps({ ...Qe })))
            ])
          }))
        ]), 1040, ["class", "style", "internalModelValue", "onDpOpen"])) : createCommentVNode("", true)
      ], 8, ["to", "disabled"])) : createCommentVNode("", true)
    ], 2));
  }
});
var da = (() => {
  const e2 = es;
  return e2.install = (a3) => {
    a3.component("Vue3DatePicker", e2);
  }, e2;
})();
var ts = Object.freeze(Object.defineProperty({
  __proto__: null,
  default: da
}, Symbol.toStringTag, { value: "Module" }));
Object.entries(ts).forEach(([e2, a3]) => {
  e2 !== "default" && (da[e2] = a3);
});
export {
  da as default
};
//# sourceMappingURL=@vuepic_vue-datepicker.js.map
