import {
  __commonJS
} from "./chunk-LK32TJAX.js";

// node_modules/cronstrue/dist/cronstrue-i18n.js
var require_cronstrue_i18n = __commonJS({
  "node_modules/cronstrue/dist/cronstrue-i18n.js"(exports, module) {
    (function webpackUniversalModuleDefinition(root, factory) {
      if (typeof exports === "object" && typeof module === "object")
        module.exports = factory();
      else if (typeof define === "function" && define.amd)
        define("cronstrue", [], factory);
      else if (typeof exports === "object")
        exports["cronstrue"] = factory();
      else
        root["cronstrue"] = factory();
    })(globalThis, () => {
      return (
        /******/
        (() => {
          "use strict";
          var __webpack_modules__ = {
            /***/
            794: (
              /***/
              (__unused_webpack_module, exports2, __webpack_require__2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.CronParser = void 0;
                var rangeValidator_1 = __webpack_require__2(586);
                var CronParser = function() {
                  function CronParser2(expression, dayOfWeekStartIndexZero, monthStartIndexZero) {
                    if (dayOfWeekStartIndexZero === void 0) {
                      dayOfWeekStartIndexZero = true;
                    }
                    if (monthStartIndexZero === void 0) {
                      monthStartIndexZero = false;
                    }
                    this.expression = expression;
                    this.dayOfWeekStartIndexZero = dayOfWeekStartIndexZero;
                    this.monthStartIndexZero = monthStartIndexZero;
                  }
                  CronParser2.prototype.parse = function() {
                    var parsed = this.extractParts(this.expression);
                    this.normalize(parsed);
                    this.validate(parsed);
                    return parsed;
                  };
                  CronParser2.prototype.extractParts = function(expression) {
                    if (!this.expression) {
                      throw new Error("Expression is empty");
                    }
                    var parsed = expression.trim().split(/[ ]+/);
                    if (parsed.length < 5) {
                      throw new Error("Expression has only ".concat(parsed.length, " part").concat(parsed.length == 1 ? "" : "s", ". At least 5 parts are required."));
                    } else if (parsed.length == 5) {
                      parsed.unshift("");
                      parsed.push("");
                    } else if (parsed.length == 6) {
                      var isYearWithNoSecondsPart = /\d{4}$/.test(parsed[5]) || parsed[4] == "?" || parsed[2] == "?";
                      if (isYearWithNoSecondsPart) {
                        parsed.unshift("");
                      } else {
                        parsed.push("");
                      }
                    } else if (parsed.length > 7) {
                      throw new Error("Expression has ".concat(parsed.length, " parts; too many!"));
                    }
                    return parsed;
                  };
                  CronParser2.prototype.normalize = function(expressionParts) {
                    var _this = this;
                    expressionParts[3] = expressionParts[3].replace("?", "*");
                    expressionParts[5] = expressionParts[5].replace("?", "*");
                    expressionParts[2] = expressionParts[2].replace("?", "*");
                    if (expressionParts[0].indexOf("0/") == 0) {
                      expressionParts[0] = expressionParts[0].replace("0/", "*/");
                    }
                    if (expressionParts[1].indexOf("0/") == 0) {
                      expressionParts[1] = expressionParts[1].replace("0/", "*/");
                    }
                    if (expressionParts[2].indexOf("0/") == 0) {
                      expressionParts[2] = expressionParts[2].replace("0/", "*/");
                    }
                    if (expressionParts[3].indexOf("1/") == 0) {
                      expressionParts[3] = expressionParts[3].replace("1/", "*/");
                    }
                    if (expressionParts[4].indexOf("1/") == 0) {
                      expressionParts[4] = expressionParts[4].replace("1/", "*/");
                    }
                    if (expressionParts[6].indexOf("1/") == 0) {
                      expressionParts[6] = expressionParts[6].replace("1/", "*/");
                    }
                    expressionParts[5] = expressionParts[5].replace(/(^\d)|([^#/\s]\d)/g, function(t) {
                      var dowDigits = t.replace(/\D/, "");
                      var dowDigitsAdjusted = dowDigits;
                      if (_this.dayOfWeekStartIndexZero) {
                        if (dowDigits == "7") {
                          dowDigitsAdjusted = "0";
                        }
                      } else {
                        dowDigitsAdjusted = (parseInt(dowDigits) - 1).toString();
                      }
                      return t.replace(dowDigits, dowDigitsAdjusted);
                    });
                    if (expressionParts[5] == "L") {
                      expressionParts[5] = "6";
                    }
                    if (expressionParts[3] == "?") {
                      expressionParts[3] = "*";
                    }
                    if (expressionParts[3].indexOf("W") > -1 && (expressionParts[3].indexOf(",") > -1 || expressionParts[3].indexOf("-") > -1)) {
                      throw new Error("The 'W' character can be specified only when the day-of-month is a single day, not a range or list of days.");
                    }
                    var days = {
                      SUN: 0,
                      MON: 1,
                      TUE: 2,
                      WED: 3,
                      THU: 4,
                      FRI: 5,
                      SAT: 6
                    };
                    for (var day in days) {
                      expressionParts[5] = expressionParts[5].replace(new RegExp(day, "gi"), days[day].toString());
                    }
                    expressionParts[4] = expressionParts[4].replace(/(^\d{1,2})|([^#/\s]\d{1,2})/g, function(t) {
                      var dowDigits = t.replace(/\D/, "");
                      var dowDigitsAdjusted = dowDigits;
                      if (_this.monthStartIndexZero) {
                        dowDigitsAdjusted = (parseInt(dowDigits) + 1).toString();
                      }
                      return t.replace(dowDigits, dowDigitsAdjusted);
                    });
                    var months = {
                      JAN: 1,
                      FEB: 2,
                      MAR: 3,
                      APR: 4,
                      MAY: 5,
                      JUN: 6,
                      JUL: 7,
                      AUG: 8,
                      SEP: 9,
                      OCT: 10,
                      NOV: 11,
                      DEC: 12
                    };
                    for (var month in months) {
                      expressionParts[4] = expressionParts[4].replace(new RegExp(month, "gi"), months[month].toString());
                    }
                    if (expressionParts[0] == "0") {
                      expressionParts[0] = "";
                    }
                    if (!/\*|\-|\,|\//.test(expressionParts[2]) && (/\*|\//.test(expressionParts[1]) || /\*|\//.test(expressionParts[0]))) {
                      expressionParts[2] += "-".concat(expressionParts[2]);
                    }
                    for (var i = 0; i < expressionParts.length; i++) {
                      if (expressionParts[i].indexOf(",") != -1) {
                        expressionParts[i] = expressionParts[i].split(",").filter(function(str) {
                          return str !== "";
                        }).join(",") || "*";
                      }
                      if (expressionParts[i] == "*/1") {
                        expressionParts[i] = "*";
                      }
                      if (expressionParts[i].indexOf("/") > -1 && !/^\*|\-|\,/.test(expressionParts[i])) {
                        var stepRangeThrough = null;
                        switch (i) {
                          case 4:
                            stepRangeThrough = "12";
                            break;
                          case 5:
                            stepRangeThrough = "6";
                            break;
                          case 6:
                            stepRangeThrough = "9999";
                            break;
                          default:
                            stepRangeThrough = null;
                            break;
                        }
                        if (stepRangeThrough !== null) {
                          var parts = expressionParts[i].split("/");
                          expressionParts[i] = "".concat(parts[0], "-").concat(stepRangeThrough, "/").concat(parts[1]);
                        }
                      }
                    }
                  };
                  CronParser2.prototype.validate = function(parsed) {
                    this.assertNoInvalidCharacters("DOW", parsed[5]);
                    this.assertNoInvalidCharacters("DOM", parsed[3]);
                    this.validateRange(parsed);
                  };
                  CronParser2.prototype.validateRange = function(parsed) {
                    rangeValidator_1.default.secondRange(parsed[0]);
                    rangeValidator_1.default.minuteRange(parsed[1]);
                    rangeValidator_1.default.hourRange(parsed[2]);
                    rangeValidator_1.default.dayOfMonthRange(parsed[3]);
                    rangeValidator_1.default.monthRange(parsed[4], this.monthStartIndexZero);
                    rangeValidator_1.default.dayOfWeekRange(parsed[5], this.dayOfWeekStartIndexZero);
                  };
                  CronParser2.prototype.assertNoInvalidCharacters = function(partDescription, expression) {
                    var invalidChars = expression.match(/[A-KM-VX-Z]+/gi);
                    if (invalidChars && invalidChars.length) {
                      throw new Error("".concat(partDescription, " part contains invalid values: '").concat(invalidChars.toString(), "'"));
                    }
                  };
                  return CronParser2;
                }();
                exports2.CronParser = CronParser;
              }
            ),
            /***/
            728: (
              /***/
              (__unused_webpack_module, exports2, __webpack_require__2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.ExpressionDescriptor = void 0;
                var stringUtilities_1 = __webpack_require__2(910);
                var cronParser_1 = __webpack_require__2(794);
                var ExpressionDescriptor = function() {
                  function ExpressionDescriptor2(expression, options) {
                    this.expression = expression;
                    this.options = options;
                    this.expressionParts = new Array(5);
                    if (!this.options.locale && ExpressionDescriptor2.defaultLocale) {
                      this.options.locale = ExpressionDescriptor2.defaultLocale;
                    }
                    if (!ExpressionDescriptor2.locales[this.options.locale]) {
                      var fallBackLocale = Object.keys(ExpressionDescriptor2.locales)[0];
                      console.warn("Locale '".concat(this.options.locale, "' could not be found; falling back to '").concat(fallBackLocale, "'."));
                      this.options.locale = fallBackLocale;
                    }
                    this.i18n = ExpressionDescriptor2.locales[this.options.locale];
                    if (options.use24HourTimeFormat === void 0) {
                      options.use24HourTimeFormat = this.i18n.use24HourTimeFormatByDefault();
                    }
                  }
                  ExpressionDescriptor2.toString = function(expression, _a) {
                    var _b = _a === void 0 ? {} : _a, _c = _b.throwExceptionOnParseError, throwExceptionOnParseError = _c === void 0 ? true : _c, _d = _b.verbose, verbose = _d === void 0 ? false : _d, _e = _b.dayOfWeekStartIndexZero, dayOfWeekStartIndexZero = _e === void 0 ? true : _e, _f = _b.monthStartIndexZero, monthStartIndexZero = _f === void 0 ? false : _f, use24HourTimeFormat = _b.use24HourTimeFormat, _g = _b.locale, locale = _g === void 0 ? null : _g;
                    var options = {
                      throwExceptionOnParseError,
                      verbose,
                      dayOfWeekStartIndexZero,
                      monthStartIndexZero,
                      use24HourTimeFormat,
                      locale
                    };
                    var descripter = new ExpressionDescriptor2(expression, options);
                    return descripter.getFullDescription();
                  };
                  ExpressionDescriptor2.initialize = function(localesLoader, defaultLocale) {
                    if (defaultLocale === void 0) {
                      defaultLocale = "en";
                    }
                    ExpressionDescriptor2.specialCharacters = ["/", "-", ",", "*"];
                    ExpressionDescriptor2.defaultLocale = defaultLocale;
                    localesLoader.load(ExpressionDescriptor2.locales);
                  };
                  ExpressionDescriptor2.prototype.getFullDescription = function() {
                    var description = "";
                    try {
                      var parser = new cronParser_1.CronParser(this.expression, this.options.dayOfWeekStartIndexZero, this.options.monthStartIndexZero);
                      this.expressionParts = parser.parse();
                      var timeSegment = this.getTimeOfDayDescription();
                      var dayOfMonthDesc = this.getDayOfMonthDescription();
                      var monthDesc = this.getMonthDescription();
                      var dayOfWeekDesc = this.getDayOfWeekDescription();
                      var yearDesc = this.getYearDescription();
                      description += timeSegment + dayOfMonthDesc + dayOfWeekDesc + monthDesc + yearDesc;
                      description = this.transformVerbosity(description, !!this.options.verbose);
                      description = description.charAt(0).toLocaleUpperCase() + description.substr(1);
                    } catch (ex) {
                      if (!this.options.throwExceptionOnParseError) {
                        description = this.i18n.anErrorOccuredWhenGeneratingTheExpressionD();
                      } else {
                        throw "".concat(ex);
                      }
                    }
                    return description;
                  };
                  ExpressionDescriptor2.prototype.getTimeOfDayDescription = function() {
                    var secondsExpression = this.expressionParts[0];
                    var minuteExpression = this.expressionParts[1];
                    var hourExpression = this.expressionParts[2];
                    var description = "";
                    if (!stringUtilities_1.StringUtilities.containsAny(minuteExpression, ExpressionDescriptor2.specialCharacters) && !stringUtilities_1.StringUtilities.containsAny(hourExpression, ExpressionDescriptor2.specialCharacters) && !stringUtilities_1.StringUtilities.containsAny(secondsExpression, ExpressionDescriptor2.specialCharacters)) {
                      description += this.i18n.atSpace() + this.formatTime(hourExpression, minuteExpression, secondsExpression);
                    } else if (!secondsExpression && minuteExpression.indexOf("-") > -1 && !(minuteExpression.indexOf(",") > -1) && !(minuteExpression.indexOf("/") > -1) && !stringUtilities_1.StringUtilities.containsAny(hourExpression, ExpressionDescriptor2.specialCharacters)) {
                      var minuteParts = minuteExpression.split("-");
                      description += stringUtilities_1.StringUtilities.format(this.i18n.everyMinuteBetweenX0AndX1(), this.formatTime(hourExpression, minuteParts[0], ""), this.formatTime(hourExpression, minuteParts[1], ""));
                    } else if (!secondsExpression && hourExpression.indexOf(",") > -1 && hourExpression.indexOf("-") == -1 && hourExpression.indexOf("/") == -1 && !stringUtilities_1.StringUtilities.containsAny(minuteExpression, ExpressionDescriptor2.specialCharacters)) {
                      var hourParts = hourExpression.split(",");
                      description += this.i18n.at();
                      for (var i = 0; i < hourParts.length; i++) {
                        description += " ";
                        description += this.formatTime(hourParts[i], minuteExpression, "");
                        if (i < hourParts.length - 2) {
                          description += ",";
                        }
                        if (i == hourParts.length - 2) {
                          description += this.i18n.spaceAnd();
                        }
                      }
                    } else {
                      var secondsDescription = this.getSecondsDescription();
                      var minutesDescription = this.getMinutesDescription();
                      var hoursDescription = this.getHoursDescription();
                      description += secondsDescription;
                      if (description && minutesDescription) {
                        description += ", ";
                      }
                      description += minutesDescription;
                      if (minutesDescription === hoursDescription) {
                        return description;
                      }
                      if (description && hoursDescription) {
                        description += ", ";
                      }
                      description += hoursDescription;
                    }
                    return description;
                  };
                  ExpressionDescriptor2.prototype.getSecondsDescription = function() {
                    var _this = this;
                    var description = this.getSegmentDescription(this.expressionParts[0], this.i18n.everySecond(), function(s) {
                      return s;
                    }, function(s) {
                      return stringUtilities_1.StringUtilities.format(_this.i18n.everyX0Seconds(s), s);
                    }, function(s) {
                      return _this.i18n.secondsX0ThroughX1PastTheMinute();
                    }, function(s) {
                      return s == "0" ? "" : parseInt(s) < 20 ? _this.i18n.atX0SecondsPastTheMinute(s) : _this.i18n.atX0SecondsPastTheMinuteGt20() || _this.i18n.atX0SecondsPastTheMinute(s);
                    });
                    return description;
                  };
                  ExpressionDescriptor2.prototype.getMinutesDescription = function() {
                    var _this = this;
                    var secondsExpression = this.expressionParts[0];
                    var hourExpression = this.expressionParts[2];
                    var description = this.getSegmentDescription(this.expressionParts[1], this.i18n.everyMinute(), function(s) {
                      return s;
                    }, function(s) {
                      return stringUtilities_1.StringUtilities.format(_this.i18n.everyX0Minutes(s), s);
                    }, function(s) {
                      return _this.i18n.minutesX0ThroughX1PastTheHour();
                    }, function(s) {
                      try {
                        return s == "0" && hourExpression.indexOf("/") == -1 && secondsExpression == "" ? _this.i18n.everyHour() : parseInt(s) < 20 ? _this.i18n.atX0MinutesPastTheHour(s) : _this.i18n.atX0MinutesPastTheHourGt20() || _this.i18n.atX0MinutesPastTheHour(s);
                      } catch (e) {
                        return _this.i18n.atX0MinutesPastTheHour(s);
                      }
                    });
                    return description;
                  };
                  ExpressionDescriptor2.prototype.getHoursDescription = function() {
                    var _this = this;
                    var expression = this.expressionParts[2];
                    var description = this.getSegmentDescription(expression, this.i18n.everyHour(), function(s) {
                      return _this.formatTime(s, "0", "");
                    }, function(s) {
                      return stringUtilities_1.StringUtilities.format(_this.i18n.everyX0Hours(s), s);
                    }, function(s) {
                      return _this.i18n.betweenX0AndX1();
                    }, function(s) {
                      return _this.i18n.atX0();
                    });
                    if (description && expression.includes("-") && this.expressionParts[1] != "0") {
                      var atTheHourMatches = Array.from(description.matchAll(/:00/g));
                      if (atTheHourMatches.length > 1) {
                        var lastAtTheHourMatchIndex = atTheHourMatches[atTheHourMatches.length - 1].index;
                        description = description.substring(0, lastAtTheHourMatchIndex) + ":59" + description.substring(lastAtTheHourMatchIndex + 3);
                      }
                    }
                    return description;
                  };
                  ExpressionDescriptor2.prototype.getDayOfWeekDescription = function() {
                    var _this = this;
                    var daysOfWeekNames = this.i18n.daysOfTheWeek();
                    var description = null;
                    if (this.expressionParts[5] == "*") {
                      description = "";
                    } else {
                      description = this.getSegmentDescription(this.expressionParts[5], this.i18n.commaEveryDay(), function(s, form) {
                        var exp = s;
                        if (s.indexOf("#") > -1) {
                          exp = s.substr(0, s.indexOf("#"));
                        } else if (s.indexOf("L") > -1) {
                          exp = exp.replace("L", "");
                        }
                        return _this.i18n.daysOfTheWeekInCase ? _this.i18n.daysOfTheWeekInCase(form)[parseInt(exp)] : daysOfWeekNames[parseInt(exp)];
                      }, function(s) {
                        if (parseInt(s) == 1) {
                          return "";
                        } else {
                          return stringUtilities_1.StringUtilities.format(_this.i18n.commaEveryX0DaysOfTheWeek(s), s);
                        }
                      }, function(s) {
                        var beginFrom = s.substring(0, s.indexOf("-"));
                        var domSpecified = _this.expressionParts[3] != "*";
                        return domSpecified ? _this.i18n.commaAndX0ThroughX1(beginFrom) : _this.i18n.commaX0ThroughX1(beginFrom);
                      }, function(s) {
                        var format = null;
                        if (s.indexOf("#") > -1) {
                          var dayOfWeekOfMonthNumber = s.substring(s.indexOf("#") + 1);
                          var dayOfWeekNumber = s.substring(0, s.indexOf("#"));
                          var dayOfWeekOfMonthDescription = null;
                          switch (dayOfWeekOfMonthNumber) {
                            case "1":
                              dayOfWeekOfMonthDescription = _this.i18n.first(dayOfWeekNumber);
                              break;
                            case "2":
                              dayOfWeekOfMonthDescription = _this.i18n.second(dayOfWeekNumber);
                              break;
                            case "3":
                              dayOfWeekOfMonthDescription = _this.i18n.third(dayOfWeekNumber);
                              break;
                            case "4":
                              dayOfWeekOfMonthDescription = _this.i18n.fourth(dayOfWeekNumber);
                              break;
                            case "5":
                              dayOfWeekOfMonthDescription = _this.i18n.fifth(dayOfWeekNumber);
                              break;
                          }
                          format = _this.i18n.commaOnThe(dayOfWeekOfMonthNumber) + dayOfWeekOfMonthDescription + _this.i18n.spaceX0OfTheMonth();
                        } else if (s.indexOf("L") > -1) {
                          format = _this.i18n.commaOnTheLastX0OfTheMonth(s.replace("L", ""));
                        } else {
                          var domSpecified = _this.expressionParts[3] != "*";
                          format = domSpecified ? _this.i18n.commaAndOnX0() : _this.i18n.commaOnlyOnX0(s);
                        }
                        return format;
                      });
                    }
                    return description;
                  };
                  ExpressionDescriptor2.prototype.getMonthDescription = function() {
                    var _this = this;
                    var monthNames = this.i18n.monthsOfTheYear();
                    var description = this.getSegmentDescription(this.expressionParts[4], "", function(s, form) {
                      return form && _this.i18n.monthsOfTheYearInCase ? _this.i18n.monthsOfTheYearInCase(form)[parseInt(s) - 1] : monthNames[parseInt(s) - 1];
                    }, function(s) {
                      if (parseInt(s) == 1) {
                        return "";
                      } else {
                        return stringUtilities_1.StringUtilities.format(_this.i18n.commaEveryX0Months(s), s);
                      }
                    }, function(s) {
                      return _this.i18n.commaMonthX0ThroughMonthX1() || _this.i18n.commaX0ThroughX1();
                    }, function(s) {
                      return _this.i18n.commaOnlyInMonthX0 ? _this.i18n.commaOnlyInMonthX0() : _this.i18n.commaOnlyInX0();
                    });
                    return description;
                  };
                  ExpressionDescriptor2.prototype.getDayOfMonthDescription = function() {
                    var _this = this;
                    var description = null;
                    var expression = this.expressionParts[3];
                    switch (expression) {
                      case "L":
                        description = this.i18n.commaOnTheLastDayOfTheMonth();
                        break;
                      case "WL":
                      case "LW":
                        description = this.i18n.commaOnTheLastWeekdayOfTheMonth();
                        break;
                      default:
                        var weekDayNumberMatches = expression.match(/(\d{1,2}W)|(W\d{1,2})/);
                        if (weekDayNumberMatches) {
                          var dayNumber = parseInt(weekDayNumberMatches[0].replace("W", ""));
                          var dayString = dayNumber == 1 ? this.i18n.firstWeekday() : stringUtilities_1.StringUtilities.format(this.i18n.weekdayNearestDayX0(), dayNumber.toString());
                          description = stringUtilities_1.StringUtilities.format(this.i18n.commaOnTheX0OfTheMonth(), dayString);
                          break;
                        } else {
                          var lastDayOffSetMatches = expression.match(/L-(\d{1,2})/);
                          if (lastDayOffSetMatches) {
                            var offSetDays = lastDayOffSetMatches[1];
                            description = stringUtilities_1.StringUtilities.format(this.i18n.commaDaysBeforeTheLastDayOfTheMonth(offSetDays), offSetDays);
                            break;
                          } else if (expression == "*" && this.expressionParts[5] != "*") {
                            return "";
                          } else {
                            description = this.getSegmentDescription(expression, this.i18n.commaEveryDay(), function(s) {
                              return s == "L" ? _this.i18n.lastDay() : _this.i18n.dayX0 ? stringUtilities_1.StringUtilities.format(_this.i18n.dayX0(), s) : s;
                            }, function(s) {
                              return s == "1" ? _this.i18n.commaEveryDay() : _this.i18n.commaEveryX0Days(s);
                            }, function(s) {
                              return _this.i18n.commaBetweenDayX0AndX1OfTheMonth(s);
                            }, function(s) {
                              return _this.i18n.commaOnDayX0OfTheMonth(s);
                            });
                          }
                          break;
                        }
                    }
                    return description;
                  };
                  ExpressionDescriptor2.prototype.getYearDescription = function() {
                    var _this = this;
                    var description = this.getSegmentDescription(this.expressionParts[6], "", function(s) {
                      return /^\d+$/.test(s) ? new Date(parseInt(s), 1).getFullYear().toString() : s;
                    }, function(s) {
                      return stringUtilities_1.StringUtilities.format(_this.i18n.commaEveryX0Years(s), s);
                    }, function(s) {
                      return _this.i18n.commaYearX0ThroughYearX1() || _this.i18n.commaX0ThroughX1();
                    }, function(s) {
                      return _this.i18n.commaOnlyInYearX0 ? _this.i18n.commaOnlyInYearX0() : _this.i18n.commaOnlyInX0();
                    });
                    return description;
                  };
                  ExpressionDescriptor2.prototype.getSegmentDescription = function(expression, allDescription, getSingleItemDescription, getIncrementDescriptionFormat, getRangeDescriptionFormat, getDescriptionFormat) {
                    var description = null;
                    var doesExpressionContainIncrement = expression.indexOf("/") > -1;
                    var doesExpressionContainRange = expression.indexOf("-") > -1;
                    var doesExpressionContainMultipleValues = expression.indexOf(",") > -1;
                    if (!expression) {
                      description = "";
                    } else if (expression === "*") {
                      description = allDescription;
                    } else if (!doesExpressionContainIncrement && !doesExpressionContainRange && !doesExpressionContainMultipleValues) {
                      description = stringUtilities_1.StringUtilities.format(getDescriptionFormat(expression), getSingleItemDescription(expression));
                    } else if (doesExpressionContainMultipleValues) {
                      var segments = expression.split(",");
                      var descriptionContent = "";
                      for (var i = 0; i < segments.length; i++) {
                        if (i > 0 && segments.length > 2) {
                          descriptionContent += ",";
                          if (i < segments.length - 1) {
                            descriptionContent += " ";
                          }
                        }
                        if (i > 0 && segments.length > 1 && (i == segments.length - 1 || segments.length == 2)) {
                          descriptionContent += "".concat(this.i18n.spaceAnd(), " ");
                        }
                        if (segments[i].indexOf("/") > -1 || segments[i].indexOf("-") > -1) {
                          var isSegmentRangeWithoutIncrement = segments[i].indexOf("-") > -1 && segments[i].indexOf("/") == -1;
                          var currentDescriptionContent = this.getSegmentDescription(segments[i], allDescription, getSingleItemDescription, getIncrementDescriptionFormat, isSegmentRangeWithoutIncrement ? this.i18n.commaX0ThroughX1 : getRangeDescriptionFormat, getDescriptionFormat);
                          if (isSegmentRangeWithoutIncrement) {
                            currentDescriptionContent = currentDescriptionContent.replace(", ", "");
                          }
                          descriptionContent += currentDescriptionContent;
                        } else if (!doesExpressionContainIncrement) {
                          descriptionContent += getSingleItemDescription(segments[i]);
                        } else {
                          descriptionContent += this.getSegmentDescription(segments[i], allDescription, getSingleItemDescription, getIncrementDescriptionFormat, getRangeDescriptionFormat, getDescriptionFormat);
                        }
                      }
                      if (!doesExpressionContainIncrement) {
                        description = stringUtilities_1.StringUtilities.format(getDescriptionFormat(expression), descriptionContent);
                      } else {
                        description = descriptionContent;
                      }
                    } else if (doesExpressionContainIncrement) {
                      var segments = expression.split("/");
                      description = stringUtilities_1.StringUtilities.format(getIncrementDescriptionFormat(segments[1]), segments[1]);
                      if (segments[0].indexOf("-") > -1) {
                        var rangeSegmentDescription = this.generateRangeSegmentDescription(segments[0], getRangeDescriptionFormat, getSingleItemDescription);
                        if (rangeSegmentDescription.indexOf(", ") != 0) {
                          description += ", ";
                        }
                        description += rangeSegmentDescription;
                      } else if (segments[0].indexOf("*") == -1) {
                        var rangeItemDescription = stringUtilities_1.StringUtilities.format(getDescriptionFormat(segments[0]), getSingleItemDescription(segments[0]));
                        rangeItemDescription = rangeItemDescription.replace(", ", "");
                        description += stringUtilities_1.StringUtilities.format(this.i18n.commaStartingX0(), rangeItemDescription);
                      }
                    } else if (doesExpressionContainRange) {
                      description = this.generateRangeSegmentDescription(expression, getRangeDescriptionFormat, getSingleItemDescription);
                    }
                    return description;
                  };
                  ExpressionDescriptor2.prototype.generateRangeSegmentDescription = function(rangeExpression, getRangeDescriptionFormat, getSingleItemDescription) {
                    var description = "";
                    var rangeSegments = rangeExpression.split("-");
                    var rangeSegment1Description = getSingleItemDescription(rangeSegments[0], 1);
                    var rangeSegment2Description = getSingleItemDescription(rangeSegments[1], 2);
                    var rangeDescriptionFormat = getRangeDescriptionFormat(rangeExpression);
                    description += stringUtilities_1.StringUtilities.format(rangeDescriptionFormat, rangeSegment1Description, rangeSegment2Description);
                    return description;
                  };
                  ExpressionDescriptor2.prototype.formatTime = function(hourExpression, minuteExpression, secondExpression) {
                    var hour = parseInt(hourExpression);
                    var period = "";
                    var setPeriodBeforeTime = false;
                    if (!this.options.use24HourTimeFormat) {
                      setPeriodBeforeTime = !!(this.i18n.setPeriodBeforeTime && this.i18n.setPeriodBeforeTime());
                      period = setPeriodBeforeTime ? "".concat(this.getPeriod(hour), " ") : " ".concat(this.getPeriod(hour));
                      if (hour > 12) {
                        hour -= 12;
                      }
                      if (hour === 0) {
                        hour = 12;
                      }
                    }
                    var minute = minuteExpression;
                    var second = "";
                    if (secondExpression) {
                      second = ":".concat(("00" + secondExpression).substring(secondExpression.length));
                    }
                    return "".concat(setPeriodBeforeTime ? period : "").concat(("00" + hour.toString()).substring(hour.toString().length), ":").concat(("00" + minute.toString()).substring(minute.toString().length)).concat(second).concat(!setPeriodBeforeTime ? period : "");
                  };
                  ExpressionDescriptor2.prototype.transformVerbosity = function(description, useVerboseFormat) {
                    if (!useVerboseFormat) {
                      description = description.replace(new RegExp(", ".concat(this.i18n.everyMinute()), "g"), "");
                      description = description.replace(new RegExp(", ".concat(this.i18n.everyHour()), "g"), "");
                      description = description.replace(new RegExp(this.i18n.commaEveryDay(), "g"), "");
                      description = description.replace(/\, ?$/, "");
                    }
                    return description;
                  };
                  ExpressionDescriptor2.prototype.getPeriod = function(hour) {
                    return hour >= 12 ? this.i18n.pm && this.i18n.pm() || "PM" : this.i18n.am && this.i18n.am() || "AM";
                  };
                  ExpressionDescriptor2.locales = {};
                  return ExpressionDescriptor2;
                }();
                exports2.ExpressionDescriptor = ExpressionDescriptor;
              }
            ),
            /***/
            980: (
              /***/
              (__unused_webpack_module, exports2, __webpack_require__2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.ar = exports2.th = exports2.af = exports2.hu = exports2.be = exports2.ca = exports2.fa = exports2.sw = exports2.sl = exports2.fi = exports2.sk = exports2.cs = exports2.he = exports2.ja = exports2.zh_TW = exports2.zh_CN = exports2.uk = exports2.tr = exports2.ru = exports2.ro = exports2.pt_PT = exports2.pt_BR = exports2.pl = exports2.sv = exports2.nb = exports2.nl = exports2.ko = exports2.id = exports2.it = exports2.fr = exports2.es = exports2.de = exports2.da = exports2.en = void 0;
                var en_1 = __webpack_require__2(751);
                Object.defineProperty(exports2, "en", { enumerable: true, get: function() {
                  return en_1.en;
                } });
                var da_1 = __webpack_require__2(904);
                Object.defineProperty(exports2, "da", { enumerable: true, get: function() {
                  return da_1.da;
                } });
                var de_1 = __webpack_require__2(511);
                Object.defineProperty(exports2, "de", { enumerable: true, get: function() {
                  return de_1.de;
                } });
                var es_1 = __webpack_require__2(470);
                Object.defineProperty(exports2, "es", { enumerable: true, get: function() {
                  return es_1.es;
                } });
                var fr_1 = __webpack_require__2(953);
                Object.defineProperty(exports2, "fr", { enumerable: true, get: function() {
                  return fr_1.fr;
                } });
                var it_1 = __webpack_require__2(128);
                Object.defineProperty(exports2, "it", { enumerable: true, get: function() {
                  return it_1.it;
                } });
                var id_1 = __webpack_require__2(258);
                Object.defineProperty(exports2, "id", { enumerable: true, get: function() {
                  return id_1.id;
                } });
                var ko_1 = __webpack_require__2(305);
                Object.defineProperty(exports2, "ko", { enumerable: true, get: function() {
                  return ko_1.ko;
                } });
                var nl_1 = __webpack_require__2(771);
                Object.defineProperty(exports2, "nl", { enumerable: true, get: function() {
                  return nl_1.nl;
                } });
                var nb_1 = __webpack_require__2(869);
                Object.defineProperty(exports2, "nb", { enumerable: true, get: function() {
                  return nb_1.nb;
                } });
                var sv_1 = __webpack_require__2(673);
                Object.defineProperty(exports2, "sv", { enumerable: true, get: function() {
                  return sv_1.sv;
                } });
                var pl_1 = __webpack_require__2(665);
                Object.defineProperty(exports2, "pl", { enumerable: true, get: function() {
                  return pl_1.pl;
                } });
                var pt_BR_1 = __webpack_require__2(461);
                Object.defineProperty(exports2, "pt_BR", { enumerable: true, get: function() {
                  return pt_BR_1.pt_BR;
                } });
                var pt_PT_1 = __webpack_require__2(713);
                Object.defineProperty(exports2, "pt_PT", { enumerable: true, get: function() {
                  return pt_PT_1.pt_PT;
                } });
                var ro_1 = __webpack_require__2(408);
                Object.defineProperty(exports2, "ro", { enumerable: true, get: function() {
                  return ro_1.ro;
                } });
                var ru_1 = __webpack_require__2(392);
                Object.defineProperty(exports2, "ru", { enumerable: true, get: function() {
                  return ru_1.ru;
                } });
                var tr_1 = __webpack_require__2(999);
                Object.defineProperty(exports2, "tr", { enumerable: true, get: function() {
                  return tr_1.tr;
                } });
                var uk_1 = __webpack_require__2(716);
                Object.defineProperty(exports2, "uk", { enumerable: true, get: function() {
                  return uk_1.uk;
                } });
                var zh_CN_1 = __webpack_require__2(419);
                Object.defineProperty(exports2, "zh_CN", { enumerable: true, get: function() {
                  return zh_CN_1.zh_CN;
                } });
                var zh_TW_1 = __webpack_require__2(139);
                Object.defineProperty(exports2, "zh_TW", { enumerable: true, get: function() {
                  return zh_TW_1.zh_TW;
                } });
                var ja_1 = __webpack_require__2(949);
                Object.defineProperty(exports2, "ja", { enumerable: true, get: function() {
                  return ja_1.ja;
                } });
                var he_1 = __webpack_require__2(389);
                Object.defineProperty(exports2, "he", { enumerable: true, get: function() {
                  return he_1.he;
                } });
                var cs_1 = __webpack_require__2(674);
                Object.defineProperty(exports2, "cs", { enumerable: true, get: function() {
                  return cs_1.cs;
                } });
                var sk_1 = __webpack_require__2(203);
                Object.defineProperty(exports2, "sk", { enumerable: true, get: function() {
                  return sk_1.sk;
                } });
                var fi_1 = __webpack_require__2(578);
                Object.defineProperty(exports2, "fi", { enumerable: true, get: function() {
                  return fi_1.fi;
                } });
                var sl_1 = __webpack_require__2(738);
                Object.defineProperty(exports2, "sl", { enumerable: true, get: function() {
                  return sl_1.sl;
                } });
                var sw_1 = __webpack_require__2(286);
                Object.defineProperty(exports2, "sw", { enumerable: true, get: function() {
                  return sw_1.sw;
                } });
                var fa_1 = __webpack_require__2(384);
                Object.defineProperty(exports2, "fa", { enumerable: true, get: function() {
                  return fa_1.fa;
                } });
                var ca_1 = __webpack_require__2(708);
                Object.defineProperty(exports2, "ca", { enumerable: true, get: function() {
                  return ca_1.ca;
                } });
                var be_1 = __webpack_require__2(445);
                Object.defineProperty(exports2, "be", { enumerable: true, get: function() {
                  return be_1.be;
                } });
                var hu_1 = __webpack_require__2(560);
                Object.defineProperty(exports2, "hu", { enumerable: true, get: function() {
                  return hu_1.hu;
                } });
                var af_1 = __webpack_require__2(675);
                Object.defineProperty(exports2, "af", { enumerable: true, get: function() {
                  return af_1.af;
                } });
                var th_1 = __webpack_require__2(312);
                Object.defineProperty(exports2, "th", { enumerable: true, get: function() {
                  return th_1.th;
                } });
                var ar_1 = __webpack_require__2(935);
                Object.defineProperty(exports2, "ar", { enumerable: true, get: function() {
                  return ar_1.ar;
                } });
              }
            ),
            /***/
            282: (
              /***/
              (__unused_webpack_module, exports2, __webpack_require__2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.allLocalesLoader = void 0;
                var allLocales = __webpack_require__2(980);
                var allLocalesLoader = function() {
                  function allLocalesLoader2() {
                  }
                  allLocalesLoader2.prototype.load = function(availableLocales) {
                    for (var property in allLocales) {
                      if (allLocales.hasOwnProperty(property)) {
                        availableLocales[property] = new allLocales[property]();
                      }
                    }
                  };
                  return allLocalesLoader2;
                }();
                exports2.allLocalesLoader = allLocalesLoader;
              }
            ),
            /***/
            675: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.af = void 0;
                var af = function() {
                  function af2() {
                  }
                  af2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  af2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  af2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  af2.prototype.commaYearX0ThroughYearX1 = function() {
                    return ", jaar %s na %s";
                  };
                  af2.prototype.use24HourTimeFormatByDefault = function() {
                    return true;
                  };
                  af2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "Daar was 'n fout om die tydsuitdrukking the genereer. Raadpleeg asb die uitdrukking formaat.";
                  };
                  af2.prototype.everyMinute = function() {
                    return "elke minuut";
                  };
                  af2.prototype.everyHour = function() {
                    return "elke uur";
                  };
                  af2.prototype.atSpace = function() {
                    return "Teen ";
                  };
                  af2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "Elke minuut tussen %s en %s";
                  };
                  af2.prototype.at = function() {
                    return "Teen";
                  };
                  af2.prototype.spaceAnd = function() {
                    return " en";
                  };
                  af2.prototype.everySecond = function() {
                    return "elke sekonde";
                  };
                  af2.prototype.everyX0Seconds = function() {
                    return "elke %s sekonde";
                  };
                  af2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "sekonde %s deur na %s na die minuut";
                  };
                  af2.prototype.atX0SecondsPastTheMinute = function() {
                    return "teen %s sekondes na die minuut";
                  };
                  af2.prototype.everyX0Minutes = function() {
                    return "elke %s minute";
                  };
                  af2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "minute %s deur na %s na die uur";
                  };
                  af2.prototype.atX0MinutesPastTheHour = function() {
                    return "teen %s minute na die uur";
                  };
                  af2.prototype.everyX0Hours = function() {
                    return "elke %s ure";
                  };
                  af2.prototype.betweenX0AndX1 = function() {
                    return "tussen %s en %s";
                  };
                  af2.prototype.atX0 = function() {
                    return "teen %s";
                  };
                  af2.prototype.commaEveryDay = function() {
                    return ", elke dag";
                  };
                  af2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", elke %s dae van die week";
                  };
                  af2.prototype.commaX0ThroughX1 = function() {
                    return ", %s deur na %s";
                  };
                  af2.prototype.commaAndX0ThroughX1 = function() {
                    return ", en %s deur na %s";
                  };
                  af2.prototype.first = function() {
                    return "eerste";
                  };
                  af2.prototype.second = function() {
                    return "tweede";
                  };
                  af2.prototype.third = function() {
                    return "derde";
                  };
                  af2.prototype.fourth = function() {
                    return "vierde";
                  };
                  af2.prototype.fifth = function() {
                    return "vyfde";
                  };
                  af2.prototype.commaOnThe = function() {
                    return ", op die ";
                  };
                  af2.prototype.spaceX0OfTheMonth = function() {
                    return " %s van die maand";
                  };
                  af2.prototype.lastDay = function() {
                    return "die laaste dag";
                  };
                  af2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", op die laaste %s van die maand";
                  };
                  af2.prototype.commaOnlyOnX0 = function() {
                    return ", net op %s";
                  };
                  af2.prototype.commaAndOnX0 = function() {
                    return ", en op %s";
                  };
                  af2.prototype.commaEveryX0Months = function() {
                    return ", elke %s maande";
                  };
                  af2.prototype.commaOnlyInX0 = function() {
                    return ", net in %s";
                  };
                  af2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", op die laaste dag van die maand";
                  };
                  af2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", op die laaste weeksdag van die maand";
                  };
                  af2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s dae voor die laaste dag van die maand";
                  };
                  af2.prototype.firstWeekday = function() {
                    return "eerste weeksdag";
                  };
                  af2.prototype.weekdayNearestDayX0 = function() {
                    return "weeksdag naaste aan dag %s";
                  };
                  af2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", op die %s van die maande";
                  };
                  af2.prototype.commaEveryX0Days = function() {
                    return ", elke %s dae";
                  };
                  af2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", tussen dag %s en %s van die maand";
                  };
                  af2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", op dag %s van die maand";
                  };
                  af2.prototype.commaEveryHour = function() {
                    return ", elke uur";
                  };
                  af2.prototype.commaEveryX0Years = function() {
                    return ", elke %s jare";
                  };
                  af2.prototype.commaStartingX0 = function() {
                    return ", beginnende %s";
                  };
                  af2.prototype.daysOfTheWeek = function() {
                    return ["Sondag", "Maandag", "Dinsdag", "Woensdag", "Donderdag", "Vrydag", "Saterdag"];
                  };
                  af2.prototype.monthsOfTheYear = function() {
                    return [
                      "Januarie",
                      "Februarie",
                      "Maart",
                      "April",
                      "Mei",
                      "Junie",
                      "Julie",
                      "Augustus",
                      "September",
                      "Oktober",
                      "November",
                      "Desember"
                    ];
                  };
                  return af2;
                }();
                exports2.af = af;
              }
            ),
            /***/
            935: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.ar = void 0;
                var ar = function() {
                  function ar2() {
                  }
                  ar2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  ar2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  ar2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  ar2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  ar2.prototype.use24HourTimeFormatByDefault = function() {
                    return false;
                  };
                  ar2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "حدث خطأ في إنشاء وصف المصطلح٠ تأكد من تركيب مصطلح الكرون";
                  };
                  ar2.prototype.everyMinute = function() {
                    return "كل دقيقة";
                  };
                  ar2.prototype.everyHour = function() {
                    return "كل ساعة";
                  };
                  ar2.prototype.atSpace = function() {
                    return " ";
                  };
                  ar2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "كل دقيقة بين %s و %s";
                  };
                  ar2.prototype.at = function() {
                    return "";
                  };
                  ar2.prototype.spaceAnd = function() {
                    return " و";
                  };
                  ar2.prototype.everySecond = function() {
                    return "كل ثانية";
                  };
                  ar2.prototype.everyX0Seconds = function() {
                    return "كل %s ثواني";
                  };
                  ar2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "الثواني %s حتى %s من بداية الدقيقة";
                  };
                  ar2.prototype.atX0SecondsPastTheMinute = function() {
                    return "الثانية %s من بداية الدقيقة";
                  };
                  ar2.prototype.everyX0Minutes = function() {
                    return "كل %s دقائق";
                  };
                  ar2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "الدقائق %s حتى %s من بداية الساعة";
                  };
                  ar2.prototype.atX0MinutesPastTheHour = function() {
                    return "الدقيقة %s من بداية الساعة";
                  };
                  ar2.prototype.everyX0Hours = function() {
                    return "كل %s ساعات";
                  };
                  ar2.prototype.betweenX0AndX1 = function() {
                    return "بين %s و %s";
                  };
                  ar2.prototype.atX0 = function() {
                    return "%s";
                  };
                  ar2.prototype.commaEveryDay = function() {
                    return "، كل يوم";
                  };
                  ar2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return "، كل %s من أيام الأسبوع";
                  };
                  ar2.prototype.commaX0ThroughX1 = function() {
                    return "، %s حتى %s";
                  };
                  ar2.prototype.commaAndX0ThroughX1 = function() {
                    return "، و %s حتى %s";
                  };
                  ar2.prototype.first = function() {
                    return "أول";
                  };
                  ar2.prototype.second = function() {
                    return "ثاني";
                  };
                  ar2.prototype.third = function() {
                    return "ثالث";
                  };
                  ar2.prototype.fourth = function() {
                    return "رابع";
                  };
                  ar2.prototype.fifth = function() {
                    return "خامس";
                  };
                  ar2.prototype.commaOnThe = function() {
                    return "، في ال";
                  };
                  ar2.prototype.spaceX0OfTheMonth = function() {
                    return " %s من الشهر";
                  };
                  ar2.prototype.lastDay = function() {
                    return "اليوم الأخير";
                  };
                  ar2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return "، في اخر %s من الشهر";
                  };
                  ar2.prototype.commaOnlyOnX0 = function() {
                    return "، %s فقط";
                  };
                  ar2.prototype.commaAndOnX0 = function() {
                    return "، وفي %s";
                  };
                  ar2.prototype.commaEveryX0Months = function() {
                    return "، كل %s أشهر";
                  };
                  ar2.prototype.commaOnlyInX0 = function() {
                    return "، %s فقط";
                  };
                  ar2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return "، في اخر يوم من الشهر";
                  };
                  ar2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return "، في اخر يوم أسبوع من الشهر";
                  };
                  ar2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return "، %s أيام قبل اخر يوم من الشهر";
                  };
                  ar2.prototype.firstWeekday = function() {
                    return "اول ايام الأسبوع";
                  };
                  ar2.prototype.weekdayNearestDayX0 = function() {
                    return "يوم الأسبوع الأقرب ليوم %s";
                  };
                  ar2.prototype.commaOnTheX0OfTheMonth = function() {
                    return "، في %s من الشهر";
                  };
                  ar2.prototype.commaEveryX0Days = function() {
                    return "، كل %s أيام";
                  };
                  ar2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return "، بين يوم %s و %s من الشهر";
                  };
                  ar2.prototype.commaOnDayX0OfTheMonth = function() {
                    return "، في اليوم %s من الشهر";
                  };
                  ar2.prototype.commaEveryHour = function() {
                    return "، كل ساعة";
                  };
                  ar2.prototype.commaEveryX0Years = function() {
                    return "، كل %s سنوات";
                  };
                  ar2.prototype.commaStartingX0 = function() {
                    return "، بداية من %s";
                  };
                  ar2.prototype.daysOfTheWeek = function() {
                    return ["الأحد", "الإثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
                  };
                  ar2.prototype.monthsOfTheYear = function() {
                    return [
                      "يناير",
                      "فبراير",
                      "مارس",
                      "ابريل",
                      "مايو",
                      "يونيو",
                      "يوليو",
                      "أغسطس",
                      "سبتمبر",
                      "أكتوبر",
                      "نوفمبر",
                      "ديسمبر"
                    ];
                  };
                  return ar2;
                }();
                exports2.ar = ar;
              }
            ),
            /***/
            445: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.be = void 0;
                var be = function() {
                  function be2() {
                  }
                  be2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  be2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  be2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  be2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  be2.prototype.use24HourTimeFormatByDefault = function() {
                    return true;
                  };
                  be2.prototype.everyMinute = function() {
                    return "кожную хвіліну";
                  };
                  be2.prototype.everyHour = function() {
                    return "кожную гадзіну";
                  };
                  be2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "Адбылася памылка падчас генерацыі апісання выразы. Праверце сінтаксіс крон-выразы.";
                  };
                  be2.prototype.atSpace = function() {
                    return "У ";
                  };
                  be2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "Кожную хвіліну з %s да %s";
                  };
                  be2.prototype.at = function() {
                    return "У";
                  };
                  be2.prototype.spaceAnd = function() {
                    return " і";
                  };
                  be2.prototype.everySecond = function() {
                    return "кожную секунду";
                  };
                  be2.prototype.everyX0Seconds = function() {
                    return "кожныя %s секунд";
                  };
                  be2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "секунды з %s па %s";
                  };
                  be2.prototype.atX0SecondsPastTheMinute = function() {
                    return "у %s секунд";
                  };
                  be2.prototype.everyX0Minutes = function() {
                    return "кожныя %s хвілін";
                  };
                  be2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "хвіліны з %s па %s";
                  };
                  be2.prototype.atX0MinutesPastTheHour = function() {
                    return "у %s хвілін";
                  };
                  be2.prototype.everyX0Hours = function() {
                    return "кожныя %s гадзін";
                  };
                  be2.prototype.betweenX0AndX1 = function() {
                    return "з %s па %s";
                  };
                  be2.prototype.atX0 = function() {
                    return "у %s";
                  };
                  be2.prototype.commaEveryDay = function() {
                    return ", кожны дзень";
                  };
                  be2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", кожныя %s дзён тыдня";
                  };
                  be2.prototype.commaX0ThroughX1 = function() {
                    return ", %s па %s";
                  };
                  be2.prototype.commaAndX0ThroughX1 = function() {
                    return ", і %s па %s";
                  };
                  be2.prototype.first = function() {
                    return "першы";
                  };
                  be2.prototype.second = function() {
                    return "другі";
                  };
                  be2.prototype.third = function() {
                    return "трэці";
                  };
                  be2.prototype.fourth = function() {
                    return "чацвёрты";
                  };
                  be2.prototype.fifth = function() {
                    return "пяты";
                  };
                  be2.prototype.commaOnThe = function() {
                    return ", у ";
                  };
                  be2.prototype.spaceX0OfTheMonth = function() {
                    return " %s месяца";
                  };
                  be2.prototype.lastDay = function() {
                    return "апошні дзень";
                  };
                  be2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", у апошні %s месяца";
                  };
                  be2.prototype.commaOnlyOnX0 = function() {
                    return ", толькі ў %s";
                  };
                  be2.prototype.commaAndOnX0 = function() {
                    return ", і ў %s";
                  };
                  be2.prototype.commaEveryX0Months = function() {
                    return ", кожныя %s месяцаў";
                  };
                  be2.prototype.commaOnlyInX0 = function() {
                    return ", толькі ў %s";
                  };
                  be2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", у апошні дзень месяца";
                  };
                  be2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", у апошні будні дзень месяца";
                  };
                  be2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s дзён да апошняга дня месяца";
                  };
                  be2.prototype.firstWeekday = function() {
                    return "першы будны дзень";
                  };
                  be2.prototype.weekdayNearestDayX0 = function() {
                    return "найбліжэйшы будны дзень да %s";
                  };
                  be2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", у %s месяцы";
                  };
                  be2.prototype.commaEveryX0Days = function() {
                    return ", кожныя %s дзён";
                  };
                  be2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", з %s па %s лік месяца";
                  };
                  be2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", у %s лік месяца";
                  };
                  be2.prototype.commaEveryX0Years = function() {
                    return ", кожныя %s гадоў";
                  };
                  be2.prototype.commaStartingX0 = function() {
                    return ", пачатак %s";
                  };
                  be2.prototype.daysOfTheWeek = function() {
                    return ["нядзеля", "панядзелак", "аўторак", "серада", "чацвер", "пятніца", "субота"];
                  };
                  be2.prototype.monthsOfTheYear = function() {
                    return [
                      "студзень",
                      "люты",
                      "сакавік",
                      "красавік",
                      "травень",
                      "чэрвень",
                      "ліпень",
                      "жнівень",
                      "верасень",
                      "кастрычнік",
                      "лістапад",
                      "снежань"
                    ];
                  };
                  return be2;
                }();
                exports2.be = be;
              }
            ),
            /***/
            708: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.ca = void 0;
                var ca = function() {
                  function ca2() {
                  }
                  ca2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  ca2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  ca2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  ca2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  ca2.prototype.use24HourTimeFormatByDefault = function() {
                    return false;
                  };
                  ca2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "S'ha produït un error mentres es generava la descripció de l'expressió. Revisi la sintaxi de la expressió de cron.";
                  };
                  ca2.prototype.at = function() {
                    return "A les";
                  };
                  ca2.prototype.atSpace = function() {
                    return "A les ";
                  };
                  ca2.prototype.atX0 = function() {
                    return "a les %s";
                  };
                  ca2.prototype.atX0MinutesPastTheHour = function() {
                    return "als %s minuts de l'hora";
                  };
                  ca2.prototype.atX0SecondsPastTheMinute = function() {
                    return "als %s segonds del minut";
                  };
                  ca2.prototype.betweenX0AndX1 = function() {
                    return "entre les %s i les %s";
                  };
                  ca2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", entre els dies %s i %s del mes";
                  };
                  ca2.prototype.commaEveryDay = function() {
                    return ", cada dia";
                  };
                  ca2.prototype.commaEveryX0Days = function() {
                    return ", cada %s dies";
                  };
                  ca2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", cada %s dies de la setmana";
                  };
                  ca2.prototype.commaEveryX0Months = function() {
                    return ", cada %s mesos";
                  };
                  ca2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", el dia %s del mes";
                  };
                  ca2.prototype.commaOnlyInX0 = function() {
                    return ", sólo en %s";
                  };
                  ca2.prototype.commaOnlyOnX0 = function() {
                    return ", només el %s";
                  };
                  ca2.prototype.commaAndOnX0 = function() {
                    return ", i el %s";
                  };
                  ca2.prototype.commaOnThe = function() {
                    return ", en el ";
                  };
                  ca2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", en l'últim dia del mes";
                  };
                  ca2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", en l'últim dia de la setmana del mes";
                  };
                  ca2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s dies abans de l'últim dia del mes";
                  };
                  ca2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", en l'últim %s del mes";
                  };
                  ca2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", en el %s del mes";
                  };
                  ca2.prototype.commaX0ThroughX1 = function() {
                    return ", de %s a %s";
                  };
                  ca2.prototype.commaAndX0ThroughX1 = function() {
                    return ", i de %s a %s";
                  };
                  ca2.prototype.everyHour = function() {
                    return "cada hora";
                  };
                  ca2.prototype.everyMinute = function() {
                    return "cada minut";
                  };
                  ca2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "cada minut entre les %s i les %s";
                  };
                  ca2.prototype.everySecond = function() {
                    return "cada segon";
                  };
                  ca2.prototype.everyX0Hours = function() {
                    return "cada %s hores";
                  };
                  ca2.prototype.everyX0Minutes = function() {
                    return "cada %s minuts";
                  };
                  ca2.prototype.everyX0Seconds = function() {
                    return "cada %s segons";
                  };
                  ca2.prototype.fifth = function() {
                    return "cinquè";
                  };
                  ca2.prototype.first = function() {
                    return "primer";
                  };
                  ca2.prototype.firstWeekday = function() {
                    return "primer dia de la setmana";
                  };
                  ca2.prototype.fourth = function() {
                    return "quart";
                  };
                  ca2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "del minut %s al %s passada l'hora";
                  };
                  ca2.prototype.second = function() {
                    return "segon";
                  };
                  ca2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "En els segons %s al %s de cada minut";
                  };
                  ca2.prototype.spaceAnd = function() {
                    return " i";
                  };
                  ca2.prototype.spaceX0OfTheMonth = function() {
                    return " %s del mes";
                  };
                  ca2.prototype.lastDay = function() {
                    return "l'últim dia";
                  };
                  ca2.prototype.third = function() {
                    return "tercer";
                  };
                  ca2.prototype.weekdayNearestDayX0 = function() {
                    return "dia de la setmana més proper al %s";
                  };
                  ca2.prototype.commaEveryX0Years = function() {
                    return ", cada %s anys";
                  };
                  ca2.prototype.commaStartingX0 = function() {
                    return ", començant %s";
                  };
                  ca2.prototype.daysOfTheWeek = function() {
                    return ["diumenge", "dilluns", "dimarts", "dimecres", "dijous", "divendres", "dissabte"];
                  };
                  ca2.prototype.monthsOfTheYear = function() {
                    return [
                      "gener",
                      "febrer",
                      "març",
                      "abril",
                      "maig",
                      "juny",
                      "juliol",
                      "agost",
                      "setembre",
                      "octubre",
                      "novembre",
                      "desembre"
                    ];
                  };
                  return ca2;
                }();
                exports2.ca = ca;
              }
            ),
            /***/
            674: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.cs = void 0;
                var cs = function() {
                  function cs2() {
                  }
                  cs2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  cs2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  cs2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  cs2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  cs2.prototype.use24HourTimeFormatByDefault = function() {
                    return true;
                  };
                  cs2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "Při vytváření popisu došlo k chybě. Zkontrolujte prosím správnost syntaxe cronu.";
                  };
                  cs2.prototype.everyMinute = function() {
                    return "každou minutu";
                  };
                  cs2.prototype.everyHour = function() {
                    return "každou hodinu";
                  };
                  cs2.prototype.atSpace = function() {
                    return "V ";
                  };
                  cs2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "Každou minutu mezi %s a %s";
                  };
                  cs2.prototype.at = function() {
                    return "V";
                  };
                  cs2.prototype.spaceAnd = function() {
                    return " a";
                  };
                  cs2.prototype.everySecond = function() {
                    return "každou sekundu";
                  };
                  cs2.prototype.everyX0Seconds = function() {
                    return "každých %s sekund";
                  };
                  cs2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "sekundy od %s do %s";
                  };
                  cs2.prototype.atX0SecondsPastTheMinute = function() {
                    return "v %s sekund";
                  };
                  cs2.prototype.everyX0Minutes = function() {
                    return "každých %s minut";
                  };
                  cs2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "minuty od %s do %s";
                  };
                  cs2.prototype.atX0MinutesPastTheHour = function() {
                    return "v %s minut";
                  };
                  cs2.prototype.everyX0Hours = function() {
                    return "každých %s hodin";
                  };
                  cs2.prototype.betweenX0AndX1 = function() {
                    return "mezi %s a %s";
                  };
                  cs2.prototype.atX0 = function() {
                    return "v %s";
                  };
                  cs2.prototype.commaEveryDay = function() {
                    return ", každý den";
                  };
                  cs2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", každých %s dní v týdnu";
                  };
                  cs2.prototype.commaX0ThroughX1 = function() {
                    return ", od %s do %s";
                  };
                  cs2.prototype.commaAndX0ThroughX1 = function() {
                    return ", a od %s do %s";
                  };
                  cs2.prototype.first = function() {
                    return "první";
                  };
                  cs2.prototype.second = function() {
                    return "druhý";
                  };
                  cs2.prototype.third = function() {
                    return "třetí";
                  };
                  cs2.prototype.fourth = function() {
                    return "čtvrtý";
                  };
                  cs2.prototype.fifth = function() {
                    return "pátý";
                  };
                  cs2.prototype.commaOnThe = function() {
                    return ", ";
                  };
                  cs2.prototype.spaceX0OfTheMonth = function() {
                    return " %s v měsíci";
                  };
                  cs2.prototype.lastDay = function() {
                    return "poslední den";
                  };
                  cs2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", poslední %s v měsíci";
                  };
                  cs2.prototype.commaOnlyOnX0 = function() {
                    return ", pouze v %s";
                  };
                  cs2.prototype.commaAndOnX0 = function() {
                    return ", a v %s";
                  };
                  cs2.prototype.commaEveryX0Months = function() {
                    return ", každých %s měsíců";
                  };
                  cs2.prototype.commaOnlyInX0 = function() {
                    return ", pouze v %s";
                  };
                  cs2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", poslední den v měsíci";
                  };
                  cs2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", poslední pracovní den v měsíci";
                  };
                  cs2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s dní před posledním dnem v měsíci";
                  };
                  cs2.prototype.firstWeekday = function() {
                    return "první pracovní den";
                  };
                  cs2.prototype.weekdayNearestDayX0 = function() {
                    return "pracovní den nejblíže %s. dni";
                  };
                  cs2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", v %s v měsíci";
                  };
                  cs2.prototype.commaEveryX0Days = function() {
                    return ", každých %s dnů";
                  };
                  cs2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", mezi dny %s a %s v měsíci";
                  };
                  cs2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", %s. den v měsíci";
                  };
                  cs2.prototype.commaEveryX0Years = function() {
                    return ", každých %s roků";
                  };
                  cs2.prototype.commaStartingX0 = function() {
                    return ", začínající %s";
                  };
                  cs2.prototype.daysOfTheWeek = function() {
                    return ["Neděle", "Pondělí", "Úterý", "Středa", "Čtvrtek", "Pátek", "Sobota"];
                  };
                  cs2.prototype.monthsOfTheYear = function() {
                    return [
                      "Leden",
                      "Únor",
                      "Březen",
                      "Duben",
                      "Květen",
                      "Červen",
                      "Červenec",
                      "Srpen",
                      "Září",
                      "Říjen",
                      "Listopad",
                      "Prosinec"
                    ];
                  };
                  return cs2;
                }();
                exports2.cs = cs;
              }
            ),
            /***/
            904: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.da = void 0;
                var da = function() {
                  function da2() {
                  }
                  da2.prototype.use24HourTimeFormatByDefault = function() {
                    return true;
                  };
                  da2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "Der opstod en fejl ved generering af udtryksbeskrivelsen. Tjek cron-ekspressionssyntaxen.";
                  };
                  da2.prototype.at = function() {
                    return "kl";
                  };
                  da2.prototype.atSpace = function() {
                    return "kl ";
                  };
                  da2.prototype.atX0 = function() {
                    return "kl %s";
                  };
                  da2.prototype.atX0MinutesPastTheHour = function() {
                    return "%s minutter efter timeskift";
                  };
                  da2.prototype.atX0SecondsPastTheMinute = function() {
                    return "%s sekunder efter minutskift";
                  };
                  da2.prototype.betweenX0AndX1 = function() {
                    return "mellem %s og %s";
                  };
                  da2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", mellem dag %s og %s i måneden";
                  };
                  da2.prototype.commaEveryDay = function() {
                    return ", hver dag";
                  };
                  da2.prototype.commaEveryX0Days = function() {
                    return ", hver %s. dag";
                  };
                  da2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", hver %s. ugedag";
                  };
                  da2.prototype.commaEveryX0Months = function() {
                    return ", hver %s. måned";
                  };
                  da2.prototype.commaEveryX0Years = function() {
                    return ", hvert %s. år";
                  };
                  da2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", på dag %s i måneden";
                  };
                  da2.prototype.commaOnlyInX0 = function() {
                    return ", kun i %s";
                  };
                  da2.prototype.commaOnlyOnX0 = function() {
                    return ", kun på %s";
                  };
                  da2.prototype.commaAndOnX0 = function() {
                    return ", og på %s";
                  };
                  da2.prototype.commaOnThe = function() {
                    return ", på den ";
                  };
                  da2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", på den sidste dag i måneden";
                  };
                  da2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", på den sidste hverdag i måneden";
                  };
                  da2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s dage før den sidste dag i måneden";
                  };
                  da2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", på den sidste %s i måneden";
                  };
                  da2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", på den %s i måneden";
                  };
                  da2.prototype.commaX0ThroughX1 = function() {
                    return ", %s til og med %s";
                  };
                  da2.prototype.commaAndX0ThroughX1 = function() {
                    return ", og %s til og med %s";
                  };
                  da2.prototype.everyHour = function() {
                    return "hver time";
                  };
                  da2.prototype.everyMinute = function() {
                    return "hvert minut";
                  };
                  da2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "hvert minut mellem %s og %s";
                  };
                  da2.prototype.everySecond = function() {
                    return "hvert sekund";
                  };
                  da2.prototype.everyX0Hours = function() {
                    return "hver %s. time";
                  };
                  da2.prototype.everyX0Minutes = function() {
                    return "hvert %s. minut";
                  };
                  da2.prototype.everyX0Seconds = function() {
                    return "hvert %s. sekund";
                  };
                  da2.prototype.fifth = function() {
                    return "femte";
                  };
                  da2.prototype.first = function() {
                    return "første";
                  };
                  da2.prototype.firstWeekday = function() {
                    return "første hverdag";
                  };
                  da2.prototype.fourth = function() {
                    return "fjerde";
                  };
                  da2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "minutterne fra %s til og med %s hver time";
                  };
                  da2.prototype.second = function() {
                    return "anden";
                  };
                  da2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "sekunderne fra %s til og med %s hvert minut";
                  };
                  da2.prototype.spaceAnd = function() {
                    return " og";
                  };
                  da2.prototype.spaceX0OfTheMonth = function() {
                    return " %s i måneden";
                  };
                  da2.prototype.lastDay = function() {
                    return "sidste dag";
                  };
                  da2.prototype.third = function() {
                    return "tredje";
                  };
                  da2.prototype.weekdayNearestDayX0 = function() {
                    return "hverdag nærmest dag %s";
                  };
                  da2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  da2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  da2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  da2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  da2.prototype.commaStartingX0 = function() {
                    return ", startende %s";
                  };
                  da2.prototype.daysOfTheWeek = function() {
                    return ["søndag", "mandag", "tirsdag", "onsdag", "torsdag", "fredag", "lørdag"];
                  };
                  da2.prototype.monthsOfTheYear = function() {
                    return [
                      "januar",
                      "februar",
                      "marts",
                      "april",
                      "maj",
                      "juni",
                      "juli",
                      "august",
                      "september",
                      "oktober",
                      "november",
                      "december"
                    ];
                  };
                  return da2;
                }();
                exports2.da = da;
              }
            ),
            /***/
            511: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.de = void 0;
                var de = function() {
                  function de2() {
                  }
                  de2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  de2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  de2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  de2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  de2.prototype.use24HourTimeFormatByDefault = function() {
                    return true;
                  };
                  de2.prototype.everyMinute = function() {
                    return "jede Minute";
                  };
                  de2.prototype.everyHour = function() {
                    return "jede Stunde";
                  };
                  de2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "Beim Generieren der Ausdrucksbeschreibung ist ein Fehler aufgetreten. Überprüfen Sie die Syntax des Cron-Ausdrucks.";
                  };
                  de2.prototype.atSpace = function() {
                    return "Um ";
                  };
                  de2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "Jede Minute zwischen %s und %s";
                  };
                  de2.prototype.at = function() {
                    return "Um";
                  };
                  de2.prototype.spaceAnd = function() {
                    return " und";
                  };
                  de2.prototype.everySecond = function() {
                    return "Jede Sekunde";
                  };
                  de2.prototype.everyX0Seconds = function() {
                    return "alle %s Sekunden";
                  };
                  de2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "Sekunden %s bis %s";
                  };
                  de2.prototype.atX0SecondsPastTheMinute = function() {
                    return "bei Sekunde %s";
                  };
                  de2.prototype.everyX0Minutes = function() {
                    return "alle %s Minuten";
                  };
                  de2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "Minuten %s bis %s";
                  };
                  de2.prototype.atX0MinutesPastTheHour = function() {
                    return "bei Minute %s";
                  };
                  de2.prototype.everyX0Hours = function() {
                    return "alle %s Stunden";
                  };
                  de2.prototype.betweenX0AndX1 = function() {
                    return "zwischen %s und %s";
                  };
                  de2.prototype.atX0 = function() {
                    return "um %s";
                  };
                  de2.prototype.commaEveryDay = function() {
                    return ", jeden Tag";
                  };
                  de2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", alle %s Tage der Woche";
                  };
                  de2.prototype.commaX0ThroughX1 = function() {
                    return ", %s bis %s";
                  };
                  de2.prototype.commaAndX0ThroughX1 = function() {
                    return ", und %s bis %s";
                  };
                  de2.prototype.first = function() {
                    return "ersten";
                  };
                  de2.prototype.second = function() {
                    return "zweiten";
                  };
                  de2.prototype.third = function() {
                    return "dritten";
                  };
                  de2.prototype.fourth = function() {
                    return "vierten";
                  };
                  de2.prototype.fifth = function() {
                    return "fünften";
                  };
                  de2.prototype.commaOnThe = function() {
                    return ", am ";
                  };
                  de2.prototype.spaceX0OfTheMonth = function() {
                    return " %s des Monats";
                  };
                  de2.prototype.lastDay = function() {
                    return "der letzte Tag";
                  };
                  de2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", am letzten %s des Monats";
                  };
                  de2.prototype.commaOnlyOnX0 = function() {
                    return ", nur jeden %s";
                  };
                  de2.prototype.commaAndOnX0 = function() {
                    return ", und jeden %s";
                  };
                  de2.prototype.commaEveryX0Months = function() {
                    return ", alle %s Monate";
                  };
                  de2.prototype.commaOnlyInX0 = function() {
                    return ", nur im %s";
                  };
                  de2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", am letzten Tag des Monats";
                  };
                  de2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", am letzten Werktag des Monats";
                  };
                  de2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s tage vor dem letzten Tag des Monats";
                  };
                  de2.prototype.firstWeekday = function() {
                    return "ersten Werktag";
                  };
                  de2.prototype.weekdayNearestDayX0 = function() {
                    return "Werktag am nächsten zum %s Tag";
                  };
                  de2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", am %s des Monats";
                  };
                  de2.prototype.commaEveryX0Days = function() {
                    return ", alle %s Tage";
                  };
                  de2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", zwischen Tag %s und %s des Monats";
                  };
                  de2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", an Tag %s des Monats";
                  };
                  de2.prototype.commaEveryX0Years = function() {
                    return ", alle %s Jahre";
                  };
                  de2.prototype.commaStartingX0 = function() {
                    return ", beginnend %s";
                  };
                  de2.prototype.daysOfTheWeek = function() {
                    return ["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"];
                  };
                  de2.prototype.monthsOfTheYear = function() {
                    return [
                      "Januar",
                      "Februar",
                      "März",
                      "April",
                      "Mai",
                      "Juni",
                      "Juli",
                      "August",
                      "September",
                      "Oktober",
                      "November",
                      "Dezember"
                    ];
                  };
                  return de2;
                }();
                exports2.de = de;
              }
            ),
            /***/
            751: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.en = void 0;
                var en = function() {
                  function en2() {
                  }
                  en2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  en2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  en2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  en2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  en2.prototype.use24HourTimeFormatByDefault = function() {
                    return false;
                  };
                  en2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "An error occured when generating the expression description.  Check the cron expression syntax.";
                  };
                  en2.prototype.everyMinute = function() {
                    return "every minute";
                  };
                  en2.prototype.everyHour = function() {
                    return "every hour";
                  };
                  en2.prototype.atSpace = function() {
                    return "At ";
                  };
                  en2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "Every minute between %s and %s";
                  };
                  en2.prototype.at = function() {
                    return "At";
                  };
                  en2.prototype.spaceAnd = function() {
                    return " and";
                  };
                  en2.prototype.everySecond = function() {
                    return "every second";
                  };
                  en2.prototype.everyX0Seconds = function() {
                    return "every %s seconds";
                  };
                  en2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "seconds %s through %s past the minute";
                  };
                  en2.prototype.atX0SecondsPastTheMinute = function() {
                    return "at %s seconds past the minute";
                  };
                  en2.prototype.everyX0Minutes = function() {
                    return "every %s minutes";
                  };
                  en2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "minutes %s through %s past the hour";
                  };
                  en2.prototype.atX0MinutesPastTheHour = function() {
                    return "at %s minutes past the hour";
                  };
                  en2.prototype.everyX0Hours = function() {
                    return "every %s hours";
                  };
                  en2.prototype.betweenX0AndX1 = function() {
                    return "between %s and %s";
                  };
                  en2.prototype.atX0 = function() {
                    return "at %s";
                  };
                  en2.prototype.commaEveryDay = function() {
                    return ", every day";
                  };
                  en2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", every %s days of the week";
                  };
                  en2.prototype.commaX0ThroughX1 = function() {
                    return ", %s through %s";
                  };
                  en2.prototype.commaAndX0ThroughX1 = function() {
                    return ", %s through %s";
                  };
                  en2.prototype.first = function() {
                    return "first";
                  };
                  en2.prototype.second = function() {
                    return "second";
                  };
                  en2.prototype.third = function() {
                    return "third";
                  };
                  en2.prototype.fourth = function() {
                    return "fourth";
                  };
                  en2.prototype.fifth = function() {
                    return "fifth";
                  };
                  en2.prototype.commaOnThe = function() {
                    return ", on the ";
                  };
                  en2.prototype.spaceX0OfTheMonth = function() {
                    return " %s of the month";
                  };
                  en2.prototype.lastDay = function() {
                    return "the last day";
                  };
                  en2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", on the last %s of the month";
                  };
                  en2.prototype.commaOnlyOnX0 = function() {
                    return ", only on %s";
                  };
                  en2.prototype.commaAndOnX0 = function() {
                    return ", and on %s";
                  };
                  en2.prototype.commaEveryX0Months = function() {
                    return ", every %s months";
                  };
                  en2.prototype.commaOnlyInX0 = function() {
                    return ", only in %s";
                  };
                  en2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", on the last day of the month";
                  };
                  en2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", on the last weekday of the month";
                  };
                  en2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s days before the last day of the month";
                  };
                  en2.prototype.firstWeekday = function() {
                    return "first weekday";
                  };
                  en2.prototype.weekdayNearestDayX0 = function() {
                    return "weekday nearest day %s";
                  };
                  en2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", on the %s of the month";
                  };
                  en2.prototype.commaEveryX0Days = function() {
                    return ", every %s days";
                  };
                  en2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", between day %s and %s of the month";
                  };
                  en2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", on day %s of the month";
                  };
                  en2.prototype.commaEveryHour = function() {
                    return ", every hour";
                  };
                  en2.prototype.commaEveryX0Years = function() {
                    return ", every %s years";
                  };
                  en2.prototype.commaStartingX0 = function() {
                    return ", starting %s";
                  };
                  en2.prototype.daysOfTheWeek = function() {
                    return ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
                  };
                  en2.prototype.monthsOfTheYear = function() {
                    return [
                      "January",
                      "February",
                      "March",
                      "April",
                      "May",
                      "June",
                      "July",
                      "August",
                      "September",
                      "October",
                      "November",
                      "December"
                    ];
                  };
                  return en2;
                }();
                exports2.en = en;
              }
            ),
            /***/
            470: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.es = void 0;
                var es = function() {
                  function es2() {
                  }
                  es2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  es2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  es2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  es2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  es2.prototype.use24HourTimeFormatByDefault = function() {
                    return false;
                  };
                  es2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "Ocurrió un error mientras se generaba la descripción de la expresión. Revise la sintaxis de la expresión de cron.";
                  };
                  es2.prototype.at = function() {
                    return "A las";
                  };
                  es2.prototype.atSpace = function() {
                    return "A las ";
                  };
                  es2.prototype.atX0 = function() {
                    return "a las %s";
                  };
                  es2.prototype.atX0MinutesPastTheHour = function() {
                    return "a los %s minutos de la hora";
                  };
                  es2.prototype.atX0SecondsPastTheMinute = function() {
                    return "a los %s segundos del minuto";
                  };
                  es2.prototype.betweenX0AndX1 = function() {
                    return "entre las %s y las %s";
                  };
                  es2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", entre los días %s y %s del mes";
                  };
                  es2.prototype.commaEveryDay = function() {
                    return ", cada día";
                  };
                  es2.prototype.commaEveryX0Days = function() {
                    return ", cada %s días";
                  };
                  es2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", cada %s días de la semana";
                  };
                  es2.prototype.commaEveryX0Months = function() {
                    return ", cada %s meses";
                  };
                  es2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", el día %s del mes";
                  };
                  es2.prototype.commaOnlyInX0 = function() {
                    return ", sólo en %s";
                  };
                  es2.prototype.commaOnlyOnX0 = function() {
                    return ", sólo el %s";
                  };
                  es2.prototype.commaAndOnX0 = function() {
                    return ", y el %s";
                  };
                  es2.prototype.commaOnThe = function() {
                    return ", en el ";
                  };
                  es2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", en el último día del mes";
                  };
                  es2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", en el último día de la semana del mes";
                  };
                  es2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s días antes del último día del mes";
                  };
                  es2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", en el último %s del mes";
                  };
                  es2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", en el %s del mes";
                  };
                  es2.prototype.commaX0ThroughX1 = function() {
                    return ", de %s a %s";
                  };
                  es2.prototype.commaAndX0ThroughX1 = function() {
                    return ", y de %s a %s";
                  };
                  es2.prototype.everyHour = function() {
                    return "cada hora";
                  };
                  es2.prototype.everyMinute = function() {
                    return "cada minuto";
                  };
                  es2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "cada minuto entre las %s y las %s";
                  };
                  es2.prototype.everySecond = function() {
                    return "cada segundo";
                  };
                  es2.prototype.everyX0Hours = function() {
                    return "cada %s horas";
                  };
                  es2.prototype.everyX0Minutes = function() {
                    return "cada %s minutos";
                  };
                  es2.prototype.everyX0Seconds = function() {
                    return "cada %s segundos";
                  };
                  es2.prototype.fifth = function() {
                    return "quinto";
                  };
                  es2.prototype.first = function() {
                    return "primero";
                  };
                  es2.prototype.firstWeekday = function() {
                    return "primer día de la semana";
                  };
                  es2.prototype.fourth = function() {
                    return "cuarto";
                  };
                  es2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "del minuto %s al %s pasada la hora";
                  };
                  es2.prototype.second = function() {
                    return "segundo";
                  };
                  es2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "En los segundos %s al %s de cada minuto";
                  };
                  es2.prototype.spaceAnd = function() {
                    return " y";
                  };
                  es2.prototype.spaceX0OfTheMonth = function() {
                    return " %s del mes";
                  };
                  es2.prototype.lastDay = function() {
                    return "el último día";
                  };
                  es2.prototype.third = function() {
                    return "tercer";
                  };
                  es2.prototype.weekdayNearestDayX0 = function() {
                    return "día de la semana más próximo al %s";
                  };
                  es2.prototype.commaEveryX0Years = function() {
                    return ", cada %s años";
                  };
                  es2.prototype.commaStartingX0 = function() {
                    return ", comenzando %s";
                  };
                  es2.prototype.daysOfTheWeek = function() {
                    return ["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
                  };
                  es2.prototype.monthsOfTheYear = function() {
                    return [
                      "enero",
                      "febrero",
                      "marzo",
                      "abril",
                      "mayo",
                      "junio",
                      "julio",
                      "agosto",
                      "septiembre",
                      "octubre",
                      "noviembre",
                      "diciembre"
                    ];
                  };
                  return es2;
                }();
                exports2.es = es;
              }
            ),
            /***/
            384: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.fa = void 0;
                var fa = function() {
                  function fa2() {
                  }
                  fa2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  fa2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  fa2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  fa2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  fa2.prototype.use24HourTimeFormatByDefault = function() {
                    return true;
                  };
                  fa2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "خطایی در نمایش توضیحات این وظیفه رخ داد. لطفا ساختار آن را بررسی کنید.";
                  };
                  fa2.prototype.everyMinute = function() {
                    return "هر دقیقه";
                  };
                  fa2.prototype.everyHour = function() {
                    return "هر ساعت";
                  };
                  fa2.prototype.atSpace = function() {
                    return "در ";
                  };
                  fa2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "هر دقیقه بین %s و %s";
                  };
                  fa2.prototype.at = function() {
                    return "در";
                  };
                  fa2.prototype.spaceAnd = function() {
                    return " و";
                  };
                  fa2.prototype.everySecond = function() {
                    return "هر ثانیه";
                  };
                  fa2.prototype.everyX0Seconds = function() {
                    return "هر %s ثانیه";
                  };
                  fa2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "ثانیه %s تا %s دقیقه گذشته";
                  };
                  fa2.prototype.atX0SecondsPastTheMinute = function() {
                    return "در %s قانیه از دقیقه گذشته";
                  };
                  fa2.prototype.everyX0Minutes = function() {
                    return "هر %s دقیقه";
                  };
                  fa2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "دقیقه %s تا %s ساعت گذشته";
                  };
                  fa2.prototype.atX0MinutesPastTheHour = function() {
                    return "در %s دقیقه پس از ساعت";
                  };
                  fa2.prototype.everyX0Hours = function() {
                    return "هر %s ساعت";
                  };
                  fa2.prototype.betweenX0AndX1 = function() {
                    return "بین %s و %s";
                  };
                  fa2.prototype.atX0 = function() {
                    return "در %s";
                  };
                  fa2.prototype.commaEveryDay = function() {
                    return ", هر روز";
                  };
                  fa2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", هر %s روز از هفته";
                  };
                  fa2.prototype.commaX0ThroughX1 = function() {
                    return ", %s تا %s";
                  };
                  fa2.prototype.commaAndX0ThroughX1 = function() {
                    return ", و %s تا %s";
                  };
                  fa2.prototype.first = function() {
                    return "اول";
                  };
                  fa2.prototype.second = function() {
                    return "دوم";
                  };
                  fa2.prototype.third = function() {
                    return "سوم";
                  };
                  fa2.prototype.fourth = function() {
                    return "چهارم";
                  };
                  fa2.prototype.fifth = function() {
                    return "پنجم";
                  };
                  fa2.prototype.commaOnThe = function() {
                    return ", در ";
                  };
                  fa2.prototype.spaceX0OfTheMonth = function() {
                    return " %s ماه";
                  };
                  fa2.prototype.lastDay = function() {
                    return "آخرین روز";
                  };
                  fa2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", در %s ماه";
                  };
                  fa2.prototype.commaOnlyOnX0 = function() {
                    return ", فقط در %s";
                  };
                  fa2.prototype.commaAndOnX0 = function() {
                    return ", و در %s";
                  };
                  fa2.prototype.commaEveryX0Months = function() {
                    return ", هر %s ماه";
                  };
                  fa2.prototype.commaOnlyInX0 = function() {
                    return ", فقط در %s";
                  };
                  fa2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", در آخرین روز ماه";
                  };
                  fa2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", در آخرین روز ماه";
                  };
                  fa2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s روز قبل از آخرین روز ماه";
                  };
                  fa2.prototype.firstWeekday = function() {
                    return "اولین روز";
                  };
                  fa2.prototype.weekdayNearestDayX0 = function() {
                    return "روز نزدیک به روز %s";
                  };
                  fa2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", در %s ماه";
                  };
                  fa2.prototype.commaEveryX0Days = function() {
                    return ", هر %s روز";
                  };
                  fa2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", بین روز %s و %s ماه";
                  };
                  fa2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", در %s ماه";
                  };
                  fa2.prototype.commaEveryMinute = function() {
                    return ", هر minute";
                  };
                  fa2.prototype.commaEveryHour = function() {
                    return ", هر ساعت";
                  };
                  fa2.prototype.commaEveryX0Years = function() {
                    return ", هر %s سال";
                  };
                  fa2.prototype.commaStartingX0 = function() {
                    return ", آغاز %s";
                  };
                  fa2.prototype.daysOfTheWeek = function() {
                    return ["یک‌شنبه", "دوشنبه", "سه‌شنبه", "چهارشنبه", "پنج‌شنبه", "جمعه", "شنبه"];
                  };
                  fa2.prototype.monthsOfTheYear = function() {
                    return ["ژانویه", "فوریه", "مارس", "آپریل", "مه", "ژوئن", "ژوئیه", "آگوست", "سپتامبر", "اکتبر", "نوامبر", "دسامبر"];
                  };
                  return fa2;
                }();
                exports2.fa = fa;
              }
            ),
            /***/
            578: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.fi = void 0;
                var fi = function() {
                  function fi2() {
                  }
                  fi2.prototype.use24HourTimeFormatByDefault = function() {
                    return false;
                  };
                  fi2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "Virhe kuvauksen generoinnissa. Tarkista cron-syntaksi.";
                  };
                  fi2.prototype.at = function() {
                    return "Klo";
                  };
                  fi2.prototype.atSpace = function() {
                    return "Klo ";
                  };
                  fi2.prototype.atX0 = function() {
                    return "klo %s";
                  };
                  fi2.prototype.atX0MinutesPastTheHour = function() {
                    return "%s minuuttia yli";
                  };
                  fi2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return "%s minuuttia yli";
                  };
                  fi2.prototype.atX0SecondsPastTheMinute = function() {
                    return "%s sekunnnin jälkeen";
                  };
                  fi2.prototype.betweenX0AndX1 = function() {
                    return "%s - %s välillä";
                  };
                  fi2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", kuukauden päivien %s ja %s välillä";
                  };
                  fi2.prototype.commaEveryDay = function() {
                    return ", joka päivä";
                  };
                  fi2.prototype.commaEveryHour = function() {
                    return ", joka tunti";
                  };
                  fi2.prototype.commaEveryMinute = function() {
                    return ", joka minuutti";
                  };
                  fi2.prototype.commaEveryX0Days = function() {
                    return ", joka %s. päivä";
                  };
                  fi2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", joka %s. viikonpäivä";
                  };
                  fi2.prototype.commaEveryX0Months = function() {
                    return ", joka %s. kuukausi";
                  };
                  fi2.prototype.commaEveryX0Years = function() {
                    return ", joka %s. vuosi";
                  };
                  fi2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", kuukauden %s päivä";
                  };
                  fi2.prototype.commaOnlyInX0 = function() {
                    return ", vain %s";
                  };
                  fi2.prototype.commaOnlyOnX0 = function() {
                    return ", vain %s";
                  };
                  fi2.prototype.commaOnThe = function() {
                    return ",";
                  };
                  fi2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", kuukauden viimeisenä päivänä";
                  };
                  fi2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", kuukauden viimeisenä viikonpäivänä";
                  };
                  fi2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", kuukauden viimeinen %s";
                  };
                  fi2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", kuukauden %s";
                  };
                  fi2.prototype.commaX0ThroughX1 = function() {
                    return ", %s - %s";
                  };
                  fi2.prototype.commaAndX0ThroughX1 = function() {
                    return ", %s - %s";
                  };
                  fi2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s päivää ennen kuukauden viimeistä päivää";
                  };
                  fi2.prototype.commaStartingX0 = function() {
                    return ", alkaen %s";
                  };
                  fi2.prototype.everyHour = function() {
                    return "joka tunti";
                  };
                  fi2.prototype.everyMinute = function() {
                    return "joka minuutti";
                  };
                  fi2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "joka minuutti %s - %s välillä";
                  };
                  fi2.prototype.everySecond = function() {
                    return "joka sekunti";
                  };
                  fi2.prototype.everyX0Hours = function() {
                    return "joka %s. tunti";
                  };
                  fi2.prototype.everyX0Minutes = function() {
                    return "joka %s. minuutti";
                  };
                  fi2.prototype.everyX0Seconds = function() {
                    return "joka %s. sekunti";
                  };
                  fi2.prototype.fifth = function() {
                    return "viides";
                  };
                  fi2.prototype.first = function() {
                    return "ensimmäinen";
                  };
                  fi2.prototype.firstWeekday = function() {
                    return "ensimmäinen viikonpäivä";
                  };
                  fi2.prototype.fourth = function() {
                    return "neljäs";
                  };
                  fi2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "joka tunti minuuttien %s - %s välillä";
                  };
                  fi2.prototype.second = function() {
                    return "toinen";
                  };
                  fi2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "joka minuutti sekunttien %s - %s välillä";
                  };
                  fi2.prototype.spaceAnd = function() {
                    return " ja";
                  };
                  fi2.prototype.spaceAndSpace = function() {
                    return " ja ";
                  };
                  fi2.prototype.spaceX0OfTheMonth = function() {
                    return " %s kuukaudessa";
                  };
                  fi2.prototype.third = function() {
                    return "kolmas";
                  };
                  fi2.prototype.weekdayNearestDayX0 = function() {
                    return "viikonpäivä lähintä %s päivää";
                  };
                  fi2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  fi2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  fi2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  fi2.prototype.lastDay = function() {
                    return "viimeinen päivä";
                  };
                  fi2.prototype.commaAndOnX0 = function() {
                    return ", ja edelleen %s";
                  };
                  fi2.prototype.daysOfTheWeek = function() {
                    return ["sunnuntai", "maanantai", "tiistai", "keskiviikko", "torstai", "perjantai", "lauantai"];
                  };
                  fi2.prototype.monthsOfTheYear = function() {
                    return [
                      "tammikuu",
                      "helmikuu",
                      "maaliskuu",
                      "huhtikuu",
                      "toukokuu",
                      "kesäkuu",
                      "heinäkuu",
                      "elokuu",
                      "syyskuu",
                      "lokakuu",
                      "marraskuu",
                      "joulukuu"
                    ];
                  };
                  return fi2;
                }();
                exports2.fi = fi;
              }
            ),
            /***/
            953: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.fr = void 0;
                var fr = function() {
                  function fr2() {
                  }
                  fr2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  fr2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  fr2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  fr2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  fr2.prototype.use24HourTimeFormatByDefault = function() {
                    return true;
                  };
                  fr2.prototype.everyMinute = function() {
                    return "toutes les minutes";
                  };
                  fr2.prototype.everyHour = function() {
                    return "toutes les heures";
                  };
                  fr2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "Une erreur est survenue en générant la description de l'expression cron. Vérifiez sa syntaxe.";
                  };
                  fr2.prototype.atSpace = function() {
                    return "À ";
                  };
                  fr2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "Toutes les minutes entre %s et %s";
                  };
                  fr2.prototype.at = function() {
                    return "À";
                  };
                  fr2.prototype.spaceAnd = function() {
                    return " et";
                  };
                  fr2.prototype.everySecond = function() {
                    return "toutes les secondes";
                  };
                  fr2.prototype.everyX0Seconds = function() {
                    return "toutes les %s secondes";
                  };
                  fr2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "les secondes entre %s et %s après la minute";
                  };
                  fr2.prototype.atX0SecondsPastTheMinute = function() {
                    return "%s secondes après la minute";
                  };
                  fr2.prototype.everyX0Minutes = function() {
                    return "toutes les %s minutes";
                  };
                  fr2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "les minutes entre %s et %s après l'heure";
                  };
                  fr2.prototype.atX0MinutesPastTheHour = function() {
                    return "%s minutes après l'heure";
                  };
                  fr2.prototype.everyX0Hours = function() {
                    return "toutes les %s heures";
                  };
                  fr2.prototype.betweenX0AndX1 = function() {
                    return "de %s à %s";
                  };
                  fr2.prototype.atX0 = function() {
                    return "à %s";
                  };
                  fr2.prototype.commaEveryDay = function() {
                    return ", tous les jours";
                  };
                  fr2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", tous les %s jours de la semaine";
                  };
                  fr2.prototype.commaX0ThroughX1 = function() {
                    return ", de %s à %s";
                  };
                  fr2.prototype.commaAndX0ThroughX1 = function() {
                    return ", et de %s à %s";
                  };
                  fr2.prototype.first = function() {
                    return "premier";
                  };
                  fr2.prototype.second = function() {
                    return "second";
                  };
                  fr2.prototype.third = function() {
                    return "troisième";
                  };
                  fr2.prototype.fourth = function() {
                    return "quatrième";
                  };
                  fr2.prototype.fifth = function() {
                    return "cinquième";
                  };
                  fr2.prototype.commaOnThe = function() {
                    return ", le ";
                  };
                  fr2.prototype.spaceX0OfTheMonth = function() {
                    return " %s du mois";
                  };
                  fr2.prototype.lastDay = function() {
                    return "le dernier jour";
                  };
                  fr2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", le dernier %s du mois";
                  };
                  fr2.prototype.commaOnlyOnX0 = function() {
                    return ", uniquement le %s";
                  };
                  fr2.prototype.commaAndOnX0 = function() {
                    return ", et %s";
                  };
                  fr2.prototype.commaEveryX0Months = function() {
                    return ", tous les %s mois";
                  };
                  fr2.prototype.commaOnlyInX0 = function() {
                    return ", uniquement en %s";
                  };
                  fr2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", le dernier jour du mois";
                  };
                  fr2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", le dernier jour ouvrable du mois";
                  };
                  fr2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s jours avant le dernier jour du mois";
                  };
                  fr2.prototype.firstWeekday = function() {
                    return "premier jour ouvrable";
                  };
                  fr2.prototype.weekdayNearestDayX0 = function() {
                    return "jour ouvrable le plus proche du %s";
                  };
                  fr2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", le %s du mois";
                  };
                  fr2.prototype.commaEveryX0Days = function() {
                    return ", tous les %s jours";
                  };
                  fr2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", du %s au %s du mois";
                  };
                  fr2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", le %s du mois";
                  };
                  fr2.prototype.commaEveryX0Years = function() {
                    return ", tous les %s ans";
                  };
                  fr2.prototype.commaDaysX0ThroughX1 = function() {
                    return ", du %s au %s";
                  };
                  fr2.prototype.commaStartingX0 = function() {
                    return ", à partir de %s";
                  };
                  fr2.prototype.daysOfTheWeek = function() {
                    return ["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"];
                  };
                  fr2.prototype.monthsOfTheYear = function() {
                    return [
                      "janvier",
                      "février",
                      "mars",
                      "avril",
                      "mai",
                      "juin",
                      "juillet",
                      "août",
                      "septembre",
                      "octobre",
                      "novembre",
                      "décembre"
                    ];
                  };
                  return fr2;
                }();
                exports2.fr = fr;
              }
            ),
            /***/
            389: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.he = void 0;
                var he = function() {
                  function he2() {
                  }
                  he2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  he2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  he2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  he2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  he2.prototype.use24HourTimeFormatByDefault = function() {
                    return true;
                  };
                  he2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "אירעה שגיאה בעת יצירת תיאור הביטוי. בדוק את תחביר הביטוי cron.";
                  };
                  he2.prototype.everyMinute = function() {
                    return "כל דקה";
                  };
                  he2.prototype.everyHour = function() {
                    return "כל שעה";
                  };
                  he2.prototype.atSpace = function() {
                    return "ב ";
                  };
                  he2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "כל דקה %s עד %s";
                  };
                  he2.prototype.at = function() {
                    return "ב";
                  };
                  he2.prototype.spaceAnd = function() {
                    return " ו";
                  };
                  he2.prototype.everySecond = function() {
                    return "כל שניה";
                  };
                  he2.prototype.everyX0Seconds = function() {
                    return "כל %s שניות";
                  };
                  he2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "%s עד %s שניות של הדקה";
                  };
                  he2.prototype.atX0SecondsPastTheMinute = function() {
                    return "ב %s שניות של הדקה";
                  };
                  he2.prototype.everyX0Minutes = function() {
                    return "כל %s דקות";
                  };
                  he2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "%s עד %s דקות של השעה";
                  };
                  he2.prototype.atX0MinutesPastTheHour = function() {
                    return "ב %s דקות של השעה";
                  };
                  he2.prototype.everyX0Hours = function() {
                    return "כל %s שעות";
                  };
                  he2.prototype.betweenX0AndX1 = function() {
                    return "%s עד %s";
                  };
                  he2.prototype.atX0 = function() {
                    return "ב %s";
                  };
                  he2.prototype.commaEveryDay = function() {
                    return ", כל יום";
                  };
                  he2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", כל %s ימים בשבוע";
                  };
                  he2.prototype.commaX0ThroughX1 = function() {
                    return ", %s עד %s";
                  };
                  he2.prototype.commaAndX0ThroughX1 = function() {
                    return ", ו %s עד %s";
                  };
                  he2.prototype.first = function() {
                    return "ראשון";
                  };
                  he2.prototype.second = function() {
                    return "שני";
                  };
                  he2.prototype.third = function() {
                    return "שלישי";
                  };
                  he2.prototype.fourth = function() {
                    return "רביעי";
                  };
                  he2.prototype.fifth = function() {
                    return "חמישי";
                  };
                  he2.prototype.commaOnThe = function() {
                    return ", ב ";
                  };
                  he2.prototype.spaceX0OfTheMonth = function() {
                    return " %s של החודש";
                  };
                  he2.prototype.lastDay = function() {
                    return "היום האחרון";
                  };
                  he2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", רק ב %s של החודש";
                  };
                  he2.prototype.commaOnlyOnX0 = function() {
                    return ", רק ב %s";
                  };
                  he2.prototype.commaAndOnX0 = function() {
                    return ", וב %s";
                  };
                  he2.prototype.commaEveryX0Months = function() {
                    return ", כל %s חודשים";
                  };
                  he2.prototype.commaOnlyInX0 = function() {
                    return ", רק ב %s";
                  };
                  he2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", ביום האחרון של החודש";
                  };
                  he2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", ביום החול האחרון של החודש";
                  };
                  he2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s ימים לפני היום האחרון בחודש";
                  };
                  he2.prototype.firstWeekday = function() {
                    return "יום החול הראשון";
                  };
                  he2.prototype.weekdayNearestDayX0 = function() {
                    return "יום החול הראשון הקרוב אל %s";
                  };
                  he2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", ביום ה%s של החודש";
                  };
                  he2.prototype.commaEveryX0Days = function() {
                    return ", כל %s ימים";
                  };
                  he2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", בין היום ה%s וה%s של החודש";
                  };
                  he2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", ביום ה%s של החודש";
                  };
                  he2.prototype.commaEveryX0Years = function() {
                    return ", כל %s שנים";
                  };
                  he2.prototype.commaStartingX0 = function() {
                    return ", החל מ %s";
                  };
                  he2.prototype.daysOfTheWeek = function() {
                    return ["יום ראשון", "יום שני", "יום שלישי", "יום רביעי", "יום חמישי", "יום שישי", "יום שבת"];
                  };
                  he2.prototype.monthsOfTheYear = function() {
                    return ["ינואר", "פברואר", "מרץ", "אפריל", "מאי", "יוני", "יולי", "אוגוסט", "ספטמבר", "אוקטובר", "נובמבר", "דצמבר"];
                  };
                  return he2;
                }();
                exports2.he = he;
              }
            ),
            /***/
            560: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.hu = void 0;
                var hu = function() {
                  function hu2() {
                  }
                  hu2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  hu2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  hu2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  hu2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  hu2.prototype.use24HourTimeFormatByDefault = function() {
                    return false;
                  };
                  hu2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "Hiba történt a kifejezésleírás generálásakor. Ellenőrizze a cron kifejezés szintaxisát.";
                  };
                  hu2.prototype.everyMinute = function() {
                    return "minden percben";
                  };
                  hu2.prototype.everyHour = function() {
                    return "minden órában";
                  };
                  hu2.prototype.atSpace = function() {
                    return "Ekkor: ";
                  };
                  hu2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "percenként %s és %s között";
                  };
                  hu2.prototype.at = function() {
                    return "Ekkor:";
                  };
                  hu2.prototype.spaceAnd = function() {
                    return " és";
                  };
                  hu2.prototype.everySecond = function() {
                    return "minden másodpercben";
                  };
                  hu2.prototype.everyX0Seconds = function() {
                    return "%s másodpercenként";
                  };
                  hu2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "%s. másodpercben %s perc után";
                  };
                  hu2.prototype.atX0SecondsPastTheMinute = function() {
                    return "%s. másodpercben";
                  };
                  hu2.prototype.everyX0Minutes = function() {
                    return "minden %s. percben";
                  };
                  hu2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "%s. percben %s óra után";
                  };
                  hu2.prototype.atX0MinutesPastTheHour = function() {
                    return "%s. percben";
                  };
                  hu2.prototype.everyX0Hours = function() {
                    return "minden %s órában";
                  };
                  hu2.prototype.betweenX0AndX1 = function() {
                    return "%s és %s között";
                  };
                  hu2.prototype.atX0 = function() {
                    return "ekkor %s";
                  };
                  hu2.prototype.commaEveryDay = function() {
                    return ", minden nap";
                  };
                  hu2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", a hét minden %s napján";
                  };
                  hu2.prototype.commaX0ThroughX1 = function() {
                    return ", %s - %s";
                  };
                  hu2.prototype.commaAndX0ThroughX1 = function() {
                    return ", és %s - %s";
                  };
                  hu2.prototype.first = function() {
                    return "első";
                  };
                  hu2.prototype.second = function() {
                    return "második";
                  };
                  hu2.prototype.third = function() {
                    return "harmadik";
                  };
                  hu2.prototype.fourth = function() {
                    return "negyedik";
                  };
                  hu2.prototype.fifth = function() {
                    return "ötödik";
                  };
                  hu2.prototype.commaOnThe = function() {
                    return ", ";
                  };
                  hu2.prototype.spaceX0OfTheMonth = function() {
                    return " %s a hónapban";
                  };
                  hu2.prototype.lastDay = function() {
                    return "az utolsó nap";
                  };
                  hu2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", a hónap utolsó %s";
                  };
                  hu2.prototype.commaOnlyOnX0 = function() {
                    return ", csak ekkor: %s";
                  };
                  hu2.prototype.commaAndOnX0 = function() {
                    return ", és %s";
                  };
                  hu2.prototype.commaEveryX0Months = function() {
                    return ", minden %s hónapban";
                  };
                  hu2.prototype.commaOnlyInX0 = function() {
                    return ", csak ekkor: %s";
                  };
                  hu2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", a hónap utolsó napján";
                  };
                  hu2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", a hónap utolsó hétköznapján";
                  };
                  hu2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s nappal a hónap utolsó napja előtt";
                  };
                  hu2.prototype.firstWeekday = function() {
                    return "első hétköznap";
                  };
                  hu2.prototype.weekdayNearestDayX0 = function() {
                    return "hétköznap legközelebbi nap %s";
                  };
                  hu2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", a hónap %s";
                  };
                  hu2.prototype.commaEveryX0Days = function() {
                    return ", %s naponként";
                  };
                  hu2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", a hónap %s és %s napja között";
                  };
                  hu2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", a hónap %s napján";
                  };
                  hu2.prototype.commaEveryHour = function() {
                    return ", minden órában";
                  };
                  hu2.prototype.commaEveryX0Years = function() {
                    return ", %s évente";
                  };
                  hu2.prototype.commaStartingX0 = function() {
                    return ", %s kezdettel";
                  };
                  hu2.prototype.daysOfTheWeek = function() {
                    return ["vasárnap", "hétfő", "kedd", "szerda", "csütörtök", "péntek", "szombat"];
                  };
                  hu2.prototype.monthsOfTheYear = function() {
                    return [
                      "január",
                      "február",
                      "március",
                      "április",
                      "május",
                      "június",
                      "július",
                      "augusztus",
                      "szeptember",
                      "október",
                      "november",
                      "december"
                    ];
                  };
                  return hu2;
                }();
                exports2.hu = hu;
              }
            ),
            /***/
            258: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.id = void 0;
                var id = function() {
                  function id2() {
                  }
                  id2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  id2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  id2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  id2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  id2.prototype.use24HourTimeFormatByDefault = function() {
                    return false;
                  };
                  id2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "Terjadi kesalahan saat membuat deskripsi ekspresi. Periksa sintaks ekspresi cron.";
                  };
                  id2.prototype.everyMinute = function() {
                    return "setiap menit";
                  };
                  id2.prototype.everyHour = function() {
                    return "setiap jam";
                  };
                  id2.prototype.atSpace = function() {
                    return "Pada ";
                  };
                  id2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "Setiap menit diantara %s dan %s";
                  };
                  id2.prototype.at = function() {
                    return "Pada";
                  };
                  id2.prototype.spaceAnd = function() {
                    return " dan";
                  };
                  id2.prototype.everySecond = function() {
                    return "setiap detik";
                  };
                  id2.prototype.everyX0Seconds = function() {
                    return "setiap %s detik";
                  };
                  id2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "detik ke %s sampai %s melewati menit";
                  };
                  id2.prototype.atX0SecondsPastTheMinute = function() {
                    return "pada %s detik lewat satu menit";
                  };
                  id2.prototype.everyX0Minutes = function() {
                    return "setiap %s menit";
                  };
                  id2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "menit ke %s sampai %s melewati jam";
                  };
                  id2.prototype.atX0MinutesPastTheHour = function() {
                    return "pada %s menit melewati jam";
                  };
                  id2.prototype.everyX0Hours = function() {
                    return "setiap %s jam";
                  };
                  id2.prototype.betweenX0AndX1 = function() {
                    return "diantara %s dan %s";
                  };
                  id2.prototype.atX0 = function() {
                    return "pada %s";
                  };
                  id2.prototype.commaEveryDay = function() {
                    return ", setiap hari";
                  };
                  id2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", setiap hari %s  dalam seminggu";
                  };
                  id2.prototype.commaX0ThroughX1 = function() {
                    return ", %s sampai %s";
                  };
                  id2.prototype.commaAndX0ThroughX1 = function() {
                    return ", dan %s sampai %s";
                  };
                  id2.prototype.first = function() {
                    return "pertama";
                  };
                  id2.prototype.second = function() {
                    return "kedua";
                  };
                  id2.prototype.third = function() {
                    return "ketiga";
                  };
                  id2.prototype.fourth = function() {
                    return "keempat";
                  };
                  id2.prototype.fifth = function() {
                    return "kelima";
                  };
                  id2.prototype.commaOnThe = function() {
                    return ", di ";
                  };
                  id2.prototype.spaceX0OfTheMonth = function() {
                    return " %s pada bulan";
                  };
                  id2.prototype.lastDay = function() {
                    return "hari terakhir";
                  };
                  id2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", pada %s terakhir bulan ini";
                  };
                  id2.prototype.commaOnlyOnX0 = function() {
                    return ", hanya pada %s";
                  };
                  id2.prototype.commaAndOnX0 = function() {
                    return ", dan pada %s";
                  };
                  id2.prototype.commaEveryX0Months = function() {
                    return ", setiap bulan %s ";
                  };
                  id2.prototype.commaOnlyInX0 = function() {
                    return ", hanya pada %s";
                  };
                  id2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", pada hari terakhir bulan ini";
                  };
                  id2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", pada hari kerja terakhir setiap bulan";
                  };
                  id2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s hari sebelum hari terakhir setiap bulan";
                  };
                  id2.prototype.firstWeekday = function() {
                    return "hari kerja pertama";
                  };
                  id2.prototype.weekdayNearestDayX0 = function() {
                    return "hari kerja terdekat %s";
                  };
                  id2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", pada %s bulan ini";
                  };
                  id2.prototype.commaEveryX0Days = function() {
                    return ", setiap %s hari";
                  };
                  id2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", antara hari %s dan %s dalam sebulan";
                  };
                  id2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", pada hari %s dalam sebulan";
                  };
                  id2.prototype.commaEveryHour = function() {
                    return ", setiap jam";
                  };
                  id2.prototype.commaEveryX0Years = function() {
                    return ", setiap %s tahun";
                  };
                  id2.prototype.commaStartingX0 = function() {
                    return ", mulai pada %s";
                  };
                  id2.prototype.daysOfTheWeek = function() {
                    return ["Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu"];
                  };
                  id2.prototype.monthsOfTheYear = function() {
                    return [
                      "Januari",
                      "Februari",
                      "Maret",
                      "April",
                      "Mei",
                      "Juni",
                      "Juli",
                      "Agustus",
                      "September",
                      "Oktober",
                      "November",
                      "Desember"
                    ];
                  };
                  return id2;
                }();
                exports2.id = id;
              }
            ),
            /***/
            128: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.it = void 0;
                var it = function() {
                  function it2() {
                  }
                  it2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  it2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  it2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  it2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  it2.prototype.use24HourTimeFormatByDefault = function() {
                    return true;
                  };
                  it2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "È verificato un errore durante la generazione la descrizione espressione. Controllare la sintassi delle espressioni cron.";
                  };
                  it2.prototype.at = function() {
                    return "Alle";
                  };
                  it2.prototype.atSpace = function() {
                    return "Alle ";
                  };
                  it2.prototype.atX0 = function() {
                    return "alle %s";
                  };
                  it2.prototype.atX0MinutesPastTheHour = function() {
                    return "al %s minuto passata l'ora";
                  };
                  it2.prototype.atX0SecondsPastTheMinute = function() {
                    return "al %s secondo passato il minuto";
                  };
                  it2.prototype.betweenX0AndX1 = function() {
                    return "tra le %s e le %s";
                  };
                  it2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", tra il giorno %s e %s del mese";
                  };
                  it2.prototype.commaEveryDay = function() {
                    return ", ogni giorno";
                  };
                  it2.prototype.commaEveryX0Days = function() {
                    return ", ogni %s giorni";
                  };
                  it2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", ogni %s giorni della settimana";
                  };
                  it2.prototype.commaEveryX0Months = function() {
                    return ", ogni %s mesi";
                  };
                  it2.prototype.commaEveryX0Years = function() {
                    return ", ogni %s anni";
                  };
                  it2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", il giorno %s del mese";
                  };
                  it2.prototype.commaOnlyInX0 = function() {
                    return ", solo in %s";
                  };
                  it2.prototype.commaOnlyOnX0 = function() {
                    return ", solo il %s";
                  };
                  it2.prototype.commaAndOnX0 = function() {
                    return ", e il %s";
                  };
                  it2.prototype.commaOnThe = function() {
                    return ", il ";
                  };
                  it2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", l'ultimo giorno del mese";
                  };
                  it2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", nell'ultima settimana del mese";
                  };
                  it2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s giorni prima dell'ultimo giorno del mese";
                  };
                  it2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", l'ultimo %s del mese";
                  };
                  it2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", il %s del mese";
                  };
                  it2.prototype.commaX0ThroughX1 = function() {
                    return ", %s al %s";
                  };
                  it2.prototype.commaAndX0ThroughX1 = function() {
                    return ", e %s al %s";
                  };
                  it2.prototype.everyHour = function() {
                    return "ogni ora";
                  };
                  it2.prototype.everyMinute = function() {
                    return "ogni minuto";
                  };
                  it2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "Ogni minuto tra le %s e le %s";
                  };
                  it2.prototype.everySecond = function() {
                    return "ogni secondo";
                  };
                  it2.prototype.everyX0Hours = function() {
                    return "ogni %s ore";
                  };
                  it2.prototype.everyX0Minutes = function() {
                    return "ogni %s minuti";
                  };
                  it2.prototype.everyX0Seconds = function() {
                    return "ogni %s secondi";
                  };
                  it2.prototype.fifth = function() {
                    return "quinto";
                  };
                  it2.prototype.first = function() {
                    return "primo";
                  };
                  it2.prototype.firstWeekday = function() {
                    return "primo giorno della settimana";
                  };
                  it2.prototype.fourth = function() {
                    return "quarto";
                  };
                  it2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "minuti %s al %s dopo l'ora";
                  };
                  it2.prototype.second = function() {
                    return "secondo";
                  };
                  it2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "secondi %s al %s oltre il minuto";
                  };
                  it2.prototype.spaceAnd = function() {
                    return " e";
                  };
                  it2.prototype.spaceX0OfTheMonth = function() {
                    return " %s del mese";
                  };
                  it2.prototype.lastDay = function() {
                    return "l'ultimo giorno";
                  };
                  it2.prototype.third = function() {
                    return "terzo";
                  };
                  it2.prototype.weekdayNearestDayX0 = function() {
                    return "giorno della settimana più vicino al %s";
                  };
                  it2.prototype.commaStartingX0 = function() {
                    return ", a partire %s";
                  };
                  it2.prototype.daysOfTheWeek = function() {
                    return ["domenica", "lunedì", "martedì", "mercoledì", "giovedì", "venerdì", "sabato"];
                  };
                  it2.prototype.monthsOfTheYear = function() {
                    return [
                      "gennaio",
                      "febbraio",
                      "marzo",
                      "aprile",
                      "maggio",
                      "giugno",
                      "luglio",
                      "agosto",
                      "settembre",
                      "ottobre",
                      "novembre",
                      "dicembre"
                    ];
                  };
                  return it2;
                }();
                exports2.it = it;
              }
            ),
            /***/
            949: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.ja = void 0;
                var ja = function() {
                  function ja2() {
                  }
                  ja2.prototype.use24HourTimeFormatByDefault = function() {
                    return false;
                  };
                  ja2.prototype.everyMinute = function() {
                    return "毎分";
                  };
                  ja2.prototype.everyHour = function() {
                    return "毎時";
                  };
                  ja2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "式の記述を生成する際にエラーが発生しました。Cron 式の構文を確認してください。";
                  };
                  ja2.prototype.atSpace = function() {
                    return "次において実施";
                  };
                  ja2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "%s から %s まで毎分";
                  };
                  ja2.prototype.at = function() {
                    return "次において実施";
                  };
                  ja2.prototype.spaceAnd = function() {
                    return "と";
                  };
                  ja2.prototype.everySecond = function() {
                    return "毎秒";
                  };
                  ja2.prototype.everyX0Seconds = function() {
                    return "%s 秒ごと";
                  };
                  ja2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "毎分 %s 秒から %s 秒まで";
                  };
                  ja2.prototype.atX0SecondsPastTheMinute = function() {
                    return "毎分 %s 秒過ぎ";
                  };
                  ja2.prototype.everyX0Minutes = function() {
                    return "%s 分ごと";
                  };
                  ja2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "毎時 %s 分から %s 分まで";
                  };
                  ja2.prototype.atX0MinutesPastTheHour = function() {
                    return "毎時 %s 分過ぎ";
                  };
                  ja2.prototype.everyX0Hours = function() {
                    return "%s 時間ごと";
                  };
                  ja2.prototype.betweenX0AndX1 = function() {
                    return "%s と %s の間";
                  };
                  ja2.prototype.atX0 = function() {
                    return "次において実施 %s";
                  };
                  ja2.prototype.commaEveryDay = function() {
                    return "、毎日";
                  };
                  ja2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return "、週のうち %s 日ごと";
                  };
                  ja2.prototype.commaX0ThroughX1 = function() {
                    return "、%s から %s まで";
                  };
                  ja2.prototype.commaAndX0ThroughX1 = function() {
                    return "、%s から %s まで";
                  };
                  ja2.prototype.first = function() {
                    return "1 番目";
                  };
                  ja2.prototype.second = function() {
                    return "2 番目";
                  };
                  ja2.prototype.third = function() {
                    return "3 番目";
                  };
                  ja2.prototype.fourth = function() {
                    return "4 番目";
                  };
                  ja2.prototype.fifth = function() {
                    return "5 番目";
                  };
                  ja2.prototype.commaOnThe = function() {
                    return "次に";
                  };
                  ja2.prototype.spaceX0OfTheMonth = function() {
                    return "月のうち %s";
                  };
                  ja2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return "月の最後の %s に";
                  };
                  ja2.prototype.commaOnlyOnX0 = function() {
                    return "%s にのみ";
                  };
                  ja2.prototype.commaEveryX0Months = function() {
                    return "、%s か月ごと";
                  };
                  ja2.prototype.commaOnlyInX0 = function() {
                    return "%s でのみ";
                  };
                  ja2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return "次の最終日に";
                  };
                  ja2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return "月の最後の平日に";
                  };
                  ja2.prototype.firstWeekday = function() {
                    return "最初の平日";
                  };
                  ja2.prototype.weekdayNearestDayX0 = function() {
                    return "%s 日の直近の平日";
                  };
                  ja2.prototype.commaOnTheX0OfTheMonth = function() {
                    return "月の %s に";
                  };
                  ja2.prototype.commaEveryX0Days = function() {
                    return "、%s 日ごと";
                  };
                  ja2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return "、月の %s 日から %s 日の間";
                  };
                  ja2.prototype.commaOnDayX0OfTheMonth = function() {
                    return "、月の %s 日目";
                  };
                  ja2.prototype.spaceAndSpace = function() {
                    return "と";
                  };
                  ja2.prototype.commaEveryMinute = function() {
                    return "、毎分";
                  };
                  ja2.prototype.commaEveryHour = function() {
                    return "、毎時";
                  };
                  ja2.prototype.commaEveryX0Years = function() {
                    return "、%s 年ごと";
                  };
                  ja2.prototype.commaStartingX0 = function() {
                    return "、%s に開始";
                  };
                  ja2.prototype.aMPeriod = function() {
                    return "AM";
                  };
                  ja2.prototype.pMPeriod = function() {
                    return "PM";
                  };
                  ja2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return "月の最終日の %s 日前";
                  };
                  ja2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  ja2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  ja2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  ja2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  ja2.prototype.lastDay = function() {
                    return "最終日";
                  };
                  ja2.prototype.commaAndOnX0 = function() {
                    return "、〜と %s";
                  };
                  ja2.prototype.daysOfTheWeek = function() {
                    return ["日曜日", "月曜日", "火曜日", "水曜日", "木曜日", "金曜日", "土曜日"];
                  };
                  ja2.prototype.monthsOfTheYear = function() {
                    return ["1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月"];
                  };
                  return ja2;
                }();
                exports2.ja = ja;
              }
            ),
            /***/
            305: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.ko = void 0;
                var ko = function() {
                  function ko2() {
                  }
                  ko2.prototype.setPeriodBeforeTime = function() {
                    return true;
                  };
                  ko2.prototype.pm = function() {
                    return "오후";
                  };
                  ko2.prototype.am = function() {
                    return "오전";
                  };
                  ko2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  ko2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  ko2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  ko2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  ko2.prototype.use24HourTimeFormatByDefault = function() {
                    return false;
                  };
                  ko2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "표현식 설명을 생성하는 중 오류가 발생했습니다. cron 표현식 구문을 확인하십시오.";
                  };
                  ko2.prototype.everyMinute = function() {
                    return "1분마다";
                  };
                  ko2.prototype.everyHour = function() {
                    return "1시간마다";
                  };
                  ko2.prototype.atSpace = function() {
                    return "시간 ";
                  };
                  ko2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "%s 및 %s 사이에 매 분";
                  };
                  ko2.prototype.at = function() {
                    return "시간";
                  };
                  ko2.prototype.spaceAnd = function() {
                    return " 및";
                  };
                  ko2.prototype.everySecond = function() {
                    return "1초마다";
                  };
                  ko2.prototype.everyX0Seconds = function() {
                    return "%s초마다";
                  };
                  ko2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "정분 후 %s초에서 %s초까지";
                  };
                  ko2.prototype.atX0SecondsPastTheMinute = function() {
                    return "정분 후 %s초에서";
                  };
                  ko2.prototype.everyX0Minutes = function() {
                    return "%s분마다";
                  };
                  ko2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "정시 후 %s분에서 %s까지";
                  };
                  ko2.prototype.atX0MinutesPastTheHour = function() {
                    return "정시 후 %s분에서";
                  };
                  ko2.prototype.everyX0Hours = function() {
                    return "%s시간마다";
                  };
                  ko2.prototype.betweenX0AndX1 = function() {
                    return "%s에서 %s 사이";
                  };
                  ko2.prototype.atX0 = function() {
                    return "%s에서";
                  };
                  ko2.prototype.commaEveryDay = function() {
                    return ", 매일";
                  };
                  ko2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", 주 중 %s일마다";
                  };
                  ko2.prototype.commaX0ThroughX1 = function() {
                    return ", %s에서 %s까지";
                  };
                  ko2.prototype.commaAndX0ThroughX1 = function() {
                    return ", 및 %s에서 %s까지";
                  };
                  ko2.prototype.first = function() {
                    return "첫 번째";
                  };
                  ko2.prototype.second = function() {
                    return "두 번째";
                  };
                  ko2.prototype.third = function() {
                    return "세 번째";
                  };
                  ko2.prototype.fourth = function() {
                    return "네 번째";
                  };
                  ko2.prototype.fifth = function() {
                    return "다섯 번째";
                  };
                  ko2.prototype.commaOnThe = function() {
                    return ", 해당 ";
                  };
                  ko2.prototype.spaceX0OfTheMonth = function() {
                    return " 해당 월의 %s";
                  };
                  ko2.prototype.lastDay = function() {
                    return "마지막 날";
                  };
                  ko2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", 해당 월의 마지막 %s";
                  };
                  ko2.prototype.commaOnlyOnX0 = function() {
                    return ", %s에만";
                  };
                  ko2.prototype.commaAndOnX0 = function() {
                    return ", 및 %s에";
                  };
                  ko2.prototype.commaEveryX0Months = function() {
                    return ", %s개월마다";
                  };
                  ko2.prototype.commaOnlyInX0 = function() {
                    return ", %s에서만";
                  };
                  ko2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", 해당 월의 마지막 날에";
                  };
                  ko2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", 해당 월의 마지막 평일에";
                  };
                  ko2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", 해당 월의 마지막 날 %s일 전";
                  };
                  ko2.prototype.firstWeekday = function() {
                    return "첫 번째 평일";
                  };
                  ko2.prototype.weekdayNearestDayX0 = function() {
                    return "평일 가장 가까운 날 %s";
                  };
                  ko2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", 해당 월의 %s에";
                  };
                  ko2.prototype.commaEveryX0Days = function() {
                    return ", %s일마다";
                  };
                  ko2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", 해당 월의 %s일 및 %s일 사이";
                  };
                  ko2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", 해당 월의 %s일에";
                  };
                  ko2.prototype.commaEveryMinute = function() {
                    return ", 1분마다";
                  };
                  ko2.prototype.commaEveryHour = function() {
                    return ", 1시간마다";
                  };
                  ko2.prototype.commaEveryX0Years = function() {
                    return ", %s년마다";
                  };
                  ko2.prototype.commaStartingX0 = function() {
                    return ", %s부터";
                  };
                  ko2.prototype.daysOfTheWeek = function() {
                    return ["일요일", "월요일", "화요일", "수요일", "목요일", "금요일", "토요일"];
                  };
                  ko2.prototype.monthsOfTheYear = function() {
                    return ["1월", "2월", "3월", "4월", "5월", "6월", "7월", "8월", "9월", "10월", "11월", "12월"];
                  };
                  return ko2;
                }();
                exports2.ko = ko;
              }
            ),
            /***/
            869: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.nb = void 0;
                var nb = function() {
                  function nb2() {
                  }
                  nb2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  nb2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  nb2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  nb2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  nb2.prototype.use24HourTimeFormatByDefault = function() {
                    return false;
                  };
                  nb2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "En feil inntraff ved generering av uttrykksbeskrivelse. Sjekk cron syntaks.";
                  };
                  nb2.prototype.at = function() {
                    return "Kl.";
                  };
                  nb2.prototype.atSpace = function() {
                    return "Kl.";
                  };
                  nb2.prototype.atX0 = function() {
                    return "på %s";
                  };
                  nb2.prototype.atX0MinutesPastTheHour = function() {
                    return "på %s minutter etter timen";
                  };
                  nb2.prototype.atX0SecondsPastTheMinute = function() {
                    return "på %s sekunder etter minuttet";
                  };
                  nb2.prototype.betweenX0AndX1 = function() {
                    return "mellom %s og %s";
                  };
                  nb2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", mellom dag %s og %s av måneden";
                  };
                  nb2.prototype.commaEveryDay = function() {
                    return ", hver dag";
                  };
                  nb2.prototype.commaEveryX0Days = function() {
                    return ", hver %s dag";
                  };
                  nb2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", hver %s ukedag";
                  };
                  nb2.prototype.commaEveryX0Months = function() {
                    return ", hver %s måned";
                  };
                  nb2.prototype.commaEveryX0Years = function() {
                    return ", hvert %s år";
                  };
                  nb2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", på dag %s av måneden";
                  };
                  nb2.prototype.commaOnlyInX0 = function() {
                    return ", bare i %s";
                  };
                  nb2.prototype.commaOnlyOnX0 = function() {
                    return ", på %s";
                  };
                  nb2.prototype.commaAndOnX0 = function() {
                    return ", og på %s";
                  };
                  nb2.prototype.commaOnThe = function() {
                    return ", på ";
                  };
                  nb2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", på den siste dagen i måneden";
                  };
                  nb2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", den siste ukedagen i måneden";
                  };
                  nb2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s dager før den siste dagen i måneden";
                  };
                  nb2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", på den siste %s av måneden";
                  };
                  nb2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", på den %s av måneden";
                  };
                  nb2.prototype.commaX0ThroughX1 = function() {
                    return ", %s til og med %s";
                  };
                  nb2.prototype.commaAndX0ThroughX1 = function() {
                    return ", og %s til og med %s";
                  };
                  nb2.prototype.everyHour = function() {
                    return "hver time";
                  };
                  nb2.prototype.everyMinute = function() {
                    return "hvert minutt";
                  };
                  nb2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "Hvert minutt mellom %s og %s";
                  };
                  nb2.prototype.everySecond = function() {
                    return "hvert sekund";
                  };
                  nb2.prototype.everyX0Hours = function() {
                    return "hver %s time";
                  };
                  nb2.prototype.everyX0Minutes = function() {
                    return "hvert %s minutt";
                  };
                  nb2.prototype.everyX0Seconds = function() {
                    return "hvert %s sekund";
                  };
                  nb2.prototype.fifth = function() {
                    return "femte";
                  };
                  nb2.prototype.first = function() {
                    return "første";
                  };
                  nb2.prototype.firstWeekday = function() {
                    return "første ukedag";
                  };
                  nb2.prototype.fourth = function() {
                    return "fjerde";
                  };
                  nb2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "minuttene fra %s til og med %s etter timen";
                  };
                  nb2.prototype.second = function() {
                    return "sekund";
                  };
                  nb2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "sekundene fra %s til og med %s etter minuttet";
                  };
                  nb2.prototype.spaceAnd = function() {
                    return " og";
                  };
                  nb2.prototype.spaceX0OfTheMonth = function() {
                    return " %s i måneden";
                  };
                  nb2.prototype.lastDay = function() {
                    return "den siste dagen";
                  };
                  nb2.prototype.third = function() {
                    return "tredje";
                  };
                  nb2.prototype.weekdayNearestDayX0 = function() {
                    return "ukedag nærmest dag %s";
                  };
                  nb2.prototype.commaStartingX0 = function() {
                    return ", starter %s";
                  };
                  nb2.prototype.daysOfTheWeek = function() {
                    return ["søndag", "mandag", "tirsdag", "onsdag", "torsdag", "fredag", "lørdag"];
                  };
                  nb2.prototype.monthsOfTheYear = function() {
                    return [
                      "januar",
                      "februar",
                      "mars",
                      "april",
                      "mai",
                      "juni",
                      "juli",
                      "august",
                      "september",
                      "oktober",
                      "november",
                      "desember"
                    ];
                  };
                  return nb2;
                }();
                exports2.nb = nb;
              }
            ),
            /***/
            771: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.nl = void 0;
                var nl = function() {
                  function nl2() {
                  }
                  nl2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  nl2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  nl2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  nl2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  nl2.prototype.use24HourTimeFormatByDefault = function() {
                    return false;
                  };
                  nl2.prototype.everyMinute = function() {
                    return "elke minuut";
                  };
                  nl2.prototype.everyHour = function() {
                    return "elk uur";
                  };
                  nl2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "Er is een fout opgetreden bij het vertalen van de gegevens. Controleer de gegevens.";
                  };
                  nl2.prototype.atSpace = function() {
                    return "Op ";
                  };
                  nl2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "Elke minuut tussen %s en %s";
                  };
                  nl2.prototype.at = function() {
                    return "Op";
                  };
                  nl2.prototype.spaceAnd = function() {
                    return " en";
                  };
                  nl2.prototype.everySecond = function() {
                    return "elke seconde";
                  };
                  nl2.prototype.everyX0Seconds = function() {
                    return "elke %s seconden";
                  };
                  nl2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "seconden %s t/m %s na de minuut";
                  };
                  nl2.prototype.atX0SecondsPastTheMinute = function() {
                    return "op %s seconden na de minuut";
                  };
                  nl2.prototype.everyX0Minutes = function() {
                    return "elke %s minuten";
                  };
                  nl2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "minuut %s t/m %s na het uur";
                  };
                  nl2.prototype.atX0MinutesPastTheHour = function() {
                    return "op %s minuten na het uur";
                  };
                  nl2.prototype.everyX0Hours = function() {
                    return "elke %s uur";
                  };
                  nl2.prototype.betweenX0AndX1 = function() {
                    return "tussen %s en %s";
                  };
                  nl2.prototype.atX0 = function() {
                    return "op %s";
                  };
                  nl2.prototype.commaEveryDay = function() {
                    return ", elke dag";
                  };
                  nl2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", elke %s dagen van de week";
                  };
                  nl2.prototype.commaX0ThroughX1 = function() {
                    return ", %s t/m %s";
                  };
                  nl2.prototype.commaAndX0ThroughX1 = function() {
                    return ", en %s t/m %s";
                  };
                  nl2.prototype.first = function() {
                    return "eerste";
                  };
                  nl2.prototype.second = function() {
                    return "tweede";
                  };
                  nl2.prototype.third = function() {
                    return "derde";
                  };
                  nl2.prototype.fourth = function() {
                    return "vierde";
                  };
                  nl2.prototype.fifth = function() {
                    return "vijfde";
                  };
                  nl2.prototype.commaOnThe = function() {
                    return ", op de ";
                  };
                  nl2.prototype.spaceX0OfTheMonth = function() {
                    return " %s van de maand";
                  };
                  nl2.prototype.lastDay = function() {
                    return "de laatste dag";
                  };
                  nl2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", op de laatste %s van de maand";
                  };
                  nl2.prototype.commaOnlyOnX0 = function() {
                    return ", alleen op %s";
                  };
                  nl2.prototype.commaAndOnX0 = function() {
                    return ", en op %s";
                  };
                  nl2.prototype.commaEveryX0Months = function() {
                    return ", elke %s maanden";
                  };
                  nl2.prototype.commaOnlyInX0 = function() {
                    return ", alleen in %s";
                  };
                  nl2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", op de laatste dag van de maand";
                  };
                  nl2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", op de laatste werkdag van de maand";
                  };
                  nl2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s dagen vóór de laatste dag van de maand";
                  };
                  nl2.prototype.firstWeekday = function() {
                    return "eerste werkdag";
                  };
                  nl2.prototype.weekdayNearestDayX0 = function() {
                    return "werkdag dichtst bij dag %s";
                  };
                  nl2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", op de %s van de maand";
                  };
                  nl2.prototype.commaEveryX0Days = function() {
                    return ", elke %s dagen";
                  };
                  nl2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", tussen dag %s en %s van de maand";
                  };
                  nl2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", op dag %s van de maand";
                  };
                  nl2.prototype.commaEveryX0Years = function() {
                    return ", elke %s jaren";
                  };
                  nl2.prototype.commaStartingX0 = function() {
                    return ", beginnend %s";
                  };
                  nl2.prototype.daysOfTheWeek = function() {
                    return ["zondag", "maandag", "dinsdag", "woensdag", "donderdag", "vrijdag", "zaterdag"];
                  };
                  nl2.prototype.monthsOfTheYear = function() {
                    return [
                      "januari",
                      "februari",
                      "maart",
                      "april",
                      "mei",
                      "juni",
                      "juli",
                      "augustus",
                      "september",
                      "oktober",
                      "november",
                      "december"
                    ];
                  };
                  return nl2;
                }();
                exports2.nl = nl;
              }
            ),
            /***/
            665: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.pl = void 0;
                var pl = function() {
                  function pl2() {
                  }
                  pl2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  pl2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  pl2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  pl2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  pl2.prototype.use24HourTimeFormatByDefault = function() {
                    return true;
                  };
                  pl2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "Wystąpił błąd podczas generowania opisu wyrażenia cron. Sprawdź składnię wyrażenia cron.";
                  };
                  pl2.prototype.at = function() {
                    return "O";
                  };
                  pl2.prototype.atSpace = function() {
                    return "O ";
                  };
                  pl2.prototype.atX0 = function() {
                    return "o %s";
                  };
                  pl2.prototype.atX0MinutesPastTheHour = function() {
                    return "w %s minucie";
                  };
                  pl2.prototype.atX0SecondsPastTheMinute = function() {
                    return "w %s sekundzie";
                  };
                  pl2.prototype.betweenX0AndX1 = function() {
                    return "od %s do %s";
                  };
                  pl2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", od %s-ego do %s-ego dnia miesiąca";
                  };
                  pl2.prototype.commaEveryDay = function() {
                    return ", co dzień";
                  };
                  pl2.prototype.commaEveryX0Days = function() {
                    return ", co %s dni";
                  };
                  pl2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", co %s dni tygodnia";
                  };
                  pl2.prototype.commaEveryX0Months = function() {
                    return ", co %s miesięcy";
                  };
                  pl2.prototype.commaEveryX0Years = function() {
                    return ", co %s lat";
                  };
                  pl2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", %s-ego dnia miesiąca";
                  };
                  pl2.prototype.commaOnlyInX0 = function() {
                    return ", tylko %s";
                  };
                  pl2.prototype.commaOnlyOnX0 = function() {
                    return ", tylko %s";
                  };
                  pl2.prototype.commaAndOnX0 = function() {
                    return ", i %s";
                  };
                  pl2.prototype.commaOnThe = function() {
                    return ", ";
                  };
                  pl2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", ostatni dzień miesiąca";
                  };
                  pl2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", ostatni dzień roboczy miesiąca";
                  };
                  pl2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s dni przed ostatnim dniem miesiąca";
                  };
                  pl2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", ostatni %s miesiąca";
                  };
                  pl2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", %s miesiąca";
                  };
                  pl2.prototype.commaX0ThroughX1 = function() {
                    return ", od %s do %s";
                  };
                  pl2.prototype.commaAndX0ThroughX1 = function() {
                    return ", i od %s do %s";
                  };
                  pl2.prototype.everyHour = function() {
                    return "co godzinę";
                  };
                  pl2.prototype.everyMinute = function() {
                    return "co minutę";
                  };
                  pl2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "Co minutę od %s do %s";
                  };
                  pl2.prototype.everySecond = function() {
                    return "co sekundę";
                  };
                  pl2.prototype.everyX0Hours = function() {
                    return "co %s godzin";
                  };
                  pl2.prototype.everyX0Minutes = function() {
                    return "co %s minut";
                  };
                  pl2.prototype.everyX0Seconds = function() {
                    return "co %s sekund";
                  };
                  pl2.prototype.fifth = function() {
                    return "piąty";
                  };
                  pl2.prototype.first = function() {
                    return "pierwszy";
                  };
                  pl2.prototype.firstWeekday = function() {
                    return "pierwszy dzień roboczy";
                  };
                  pl2.prototype.fourth = function() {
                    return "czwarty";
                  };
                  pl2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "minuty od %s do %s";
                  };
                  pl2.prototype.second = function() {
                    return "drugi";
                  };
                  pl2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "sekundy od %s do %s";
                  };
                  pl2.prototype.spaceAnd = function() {
                    return " i";
                  };
                  pl2.prototype.spaceX0OfTheMonth = function() {
                    return " %s miesiąca";
                  };
                  pl2.prototype.lastDay = function() {
                    return "ostatni dzień";
                  };
                  pl2.prototype.third = function() {
                    return "trzeci";
                  };
                  pl2.prototype.weekdayNearestDayX0 = function() {
                    return "dzień roboczy najbliższy %s-ego dnia";
                  };
                  pl2.prototype.commaStartingX0 = function() {
                    return ", startowy %s";
                  };
                  pl2.prototype.daysOfTheWeek = function() {
                    return ["niedziela", "poniedziałek", "wtorek", "środa", "czwartek", "piątek", "sobota"];
                  };
                  pl2.prototype.monthsOfTheYear = function() {
                    return [
                      "styczeń",
                      "luty",
                      "marzec",
                      "kwiecień",
                      "maj",
                      "czerwiec",
                      "lipiec",
                      "sierpień",
                      "wrzesień",
                      "październik",
                      "listopad",
                      "grudzień"
                    ];
                  };
                  return pl2;
                }();
                exports2.pl = pl;
              }
            ),
            /***/
            461: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.pt_BR = void 0;
                var pt_BR = function() {
                  function pt_BR2() {
                  }
                  pt_BR2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  pt_BR2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  pt_BR2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  pt_BR2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  pt_BR2.prototype.use24HourTimeFormatByDefault = function() {
                    return false;
                  };
                  pt_BR2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "Ocorreu um erro ao gerar a descrição da expressão Cron.";
                  };
                  pt_BR2.prototype.at = function() {
                    return "às";
                  };
                  pt_BR2.prototype.atSpace = function() {
                    return "às ";
                  };
                  pt_BR2.prototype.atX0 = function() {
                    return "Às %s";
                  };
                  pt_BR2.prototype.atX0MinutesPastTheHour = function() {
                    return "aos %s minutos da hora";
                  };
                  pt_BR2.prototype.atX0SecondsPastTheMinute = function() {
                    return "aos %s segundos do minuto";
                  };
                  pt_BR2.prototype.betweenX0AndX1 = function() {
                    return "entre %s e %s";
                  };
                  pt_BR2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", entre os dias %s e %s do mês";
                  };
                  pt_BR2.prototype.commaEveryDay = function() {
                    return ", a cada dia";
                  };
                  pt_BR2.prototype.commaEveryX0Days = function() {
                    return ", a cada %s dias";
                  };
                  pt_BR2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", a cada %s dias de semana";
                  };
                  pt_BR2.prototype.commaEveryX0Months = function() {
                    return ", a cada %s meses";
                  };
                  pt_BR2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", no dia %s do mês";
                  };
                  pt_BR2.prototype.commaOnlyInX0 = function() {
                    return ", somente em %s";
                  };
                  pt_BR2.prototype.commaOnlyOnX0 = function() {
                    return ", somente de %s";
                  };
                  pt_BR2.prototype.commaAndOnX0 = function() {
                    return ", e de %s";
                  };
                  pt_BR2.prototype.commaOnThe = function() {
                    return ", na ";
                  };
                  pt_BR2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", no último dia do mês";
                  };
                  pt_BR2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", no último dia da semana do mês";
                  };
                  pt_BR2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s dias antes do último dia do mês";
                  };
                  pt_BR2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", na última %s do mês";
                  };
                  pt_BR2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", no %s do mês";
                  };
                  pt_BR2.prototype.commaX0ThroughX1 = function() {
                    return ", de %s a %s";
                  };
                  pt_BR2.prototype.commaAndX0ThroughX1 = function() {
                    return ", e de %s a %s";
                  };
                  pt_BR2.prototype.everyHour = function() {
                    return "a cada hora";
                  };
                  pt_BR2.prototype.everyMinute = function() {
                    return "a cada minuto";
                  };
                  pt_BR2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "a cada minuto entre %s e %s";
                  };
                  pt_BR2.prototype.everySecond = function() {
                    return "a cada segundo";
                  };
                  pt_BR2.prototype.everyX0Hours = function() {
                    return "a cada %s horas";
                  };
                  pt_BR2.prototype.everyX0Minutes = function() {
                    return "a cada %s minutos";
                  };
                  pt_BR2.prototype.everyX0Seconds = function() {
                    return "a cada %s segundos";
                  };
                  pt_BR2.prototype.fifth = function() {
                    return "quinta";
                  };
                  pt_BR2.prototype.first = function() {
                    return "primeira";
                  };
                  pt_BR2.prototype.firstWeekday = function() {
                    return "primeiro dia da semana";
                  };
                  pt_BR2.prototype.fourth = function() {
                    return "quarta";
                  };
                  pt_BR2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "do minuto %s até %s de cada hora";
                  };
                  pt_BR2.prototype.second = function() {
                    return "segunda";
                  };
                  pt_BR2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "No segundo %s até %s de cada minuto";
                  };
                  pt_BR2.prototype.spaceAnd = function() {
                    return " e";
                  };
                  pt_BR2.prototype.spaceX0OfTheMonth = function() {
                    return " %s do mês";
                  };
                  pt_BR2.prototype.lastDay = function() {
                    return "o último dia";
                  };
                  pt_BR2.prototype.third = function() {
                    return "terceira";
                  };
                  pt_BR2.prototype.weekdayNearestDayX0 = function() {
                    return "dia da semana mais próximo do dia %s";
                  };
                  pt_BR2.prototype.commaEveryX0Years = function() {
                    return ", a cada %s anos";
                  };
                  pt_BR2.prototype.commaStartingX0 = function() {
                    return ", iniciando %s";
                  };
                  pt_BR2.prototype.daysOfTheWeek = function() {
                    return ["domingo", "segunda-feira", "terça-feira", "quarta-feira", "quinta-feira", "sexta-feira", "sábado"];
                  };
                  pt_BR2.prototype.monthsOfTheYear = function() {
                    return [
                      "janeiro",
                      "fevereiro",
                      "março",
                      "abril",
                      "maio",
                      "junho",
                      "julho",
                      "agosto",
                      "setembro",
                      "outubro",
                      "novembro",
                      "dezembro"
                    ];
                  };
                  return pt_BR2;
                }();
                exports2.pt_BR = pt_BR;
              }
            ),
            /***/
            713: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.pt_PT = void 0;
                var pt_PT = function() {
                  function pt_PT2() {
                  }
                  pt_PT2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  pt_PT2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  pt_PT2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  pt_PT2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  pt_PT2.prototype.use24HourTimeFormatByDefault = function() {
                    return true;
                  };
                  pt_PT2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "Ocorreu um erro ao gerar a descrição da expressão Cron.";
                  };
                  pt_PT2.prototype.at = function() {
                    return "às";
                  };
                  pt_PT2.prototype.atSpace = function() {
                    return "às ";
                  };
                  pt_PT2.prototype.atX0 = function() {
                    return "Às %s";
                  };
                  pt_PT2.prototype.atX0MinutesPastTheHour = function() {
                    return "aos %s minutos da hora";
                  };
                  pt_PT2.prototype.atX0SecondsPastTheMinute = function() {
                    return "aos %s segundos do minuto";
                  };
                  pt_PT2.prototype.betweenX0AndX1 = function() {
                    return "entre %s e %s";
                  };
                  pt_PT2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", entre os dias %s e %s do mês";
                  };
                  pt_PT2.prototype.commaEveryDay = function() {
                    return ", a cada dia";
                  };
                  pt_PT2.prototype.commaEveryX0Days = function() {
                    return ", a cada %s dias";
                  };
                  pt_PT2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", a cada %s dias de semana";
                  };
                  pt_PT2.prototype.commaEveryX0Months = function() {
                    return ", a cada %s meses";
                  };
                  pt_PT2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", no dia %s do mês";
                  };
                  pt_PT2.prototype.commaOnlyInX0 = function() {
                    return ", somente em %s";
                  };
                  pt_PT2.prototype.commaOnlyOnX0 = function() {
                    return ", somente de %s";
                  };
                  pt_PT2.prototype.commaAndOnX0 = function() {
                    return ", e de %s";
                  };
                  pt_PT2.prototype.commaOnThe = function() {
                    return ", na ";
                  };
                  pt_PT2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", no último dia do mês";
                  };
                  pt_PT2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", no último dia da semana do mês";
                  };
                  pt_PT2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s dias antes do último dia do mês";
                  };
                  pt_PT2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", na última %s do mês";
                  };
                  pt_PT2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", no %s do mês";
                  };
                  pt_PT2.prototype.commaX0ThroughX1 = function() {
                    return ", de %s a %s";
                  };
                  pt_PT2.prototype.commaAndX0ThroughX1 = function() {
                    return ", e de %s a %s";
                  };
                  pt_PT2.prototype.everyHour = function() {
                    return "a cada hora";
                  };
                  pt_PT2.prototype.everyMinute = function() {
                    return "a cada minuto";
                  };
                  pt_PT2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "a cada minuto entre %s e %s";
                  };
                  pt_PT2.prototype.everySecond = function() {
                    return "a cada segundo";
                  };
                  pt_PT2.prototype.everyX0Hours = function() {
                    return "a cada %s horas";
                  };
                  pt_PT2.prototype.everyX0Minutes = function() {
                    return "a cada %s minutos";
                  };
                  pt_PT2.prototype.everyX0Seconds = function() {
                    return "a cada %s segundos";
                  };
                  pt_PT2.prototype.fifth = function() {
                    return "quinta";
                  };
                  pt_PT2.prototype.first = function() {
                    return "primeira";
                  };
                  pt_PT2.prototype.firstWeekday = function() {
                    return "primeiro dia da semana";
                  };
                  pt_PT2.prototype.fourth = function() {
                    return "quarta";
                  };
                  pt_PT2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "do minuto %s até %s de cada hora";
                  };
                  pt_PT2.prototype.second = function() {
                    return "segunda";
                  };
                  pt_PT2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "No segundo %s até %s de cada minuto";
                  };
                  pt_PT2.prototype.spaceAnd = function() {
                    return " e";
                  };
                  pt_PT2.prototype.spaceX0OfTheMonth = function() {
                    return " %s do mês";
                  };
                  pt_PT2.prototype.lastDay = function() {
                    return "o último dia";
                  };
                  pt_PT2.prototype.third = function() {
                    return "terceira";
                  };
                  pt_PT2.prototype.weekdayNearestDayX0 = function() {
                    return "dia da semana mais próximo do dia %s";
                  };
                  pt_PT2.prototype.commaEveryX0Years = function() {
                    return ", a cada %s anos";
                  };
                  pt_PT2.prototype.commaStartingX0 = function() {
                    return ", iniciando %s";
                  };
                  pt_PT2.prototype.daysOfTheWeek = function() {
                    return ["domingo", "segunda-feira", "terça-feira", "quarta-feira", "quinta-feira", "sexta-feira", "sábado"];
                  };
                  pt_PT2.prototype.monthsOfTheYear = function() {
                    return [
                      "janeiro",
                      "fevereiro",
                      "março",
                      "abril",
                      "maio",
                      "junho",
                      "julho",
                      "agosto",
                      "setembro",
                      "outubro",
                      "novembro",
                      "dezembro"
                    ];
                  };
                  return pt_PT2;
                }();
                exports2.pt_PT = pt_PT;
              }
            ),
            /***/
            408: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.ro = void 0;
                var ro = function() {
                  function ro2() {
                  }
                  ro2.prototype.use24HourTimeFormatByDefault = function() {
                    return true;
                  };
                  ro2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "Eroare la generarea descrierii. Verificați sintaxa.";
                  };
                  ro2.prototype.at = function() {
                    return "La";
                  };
                  ro2.prototype.atSpace = function() {
                    return "La ";
                  };
                  ro2.prototype.atX0 = function() {
                    return "la %s";
                  };
                  ro2.prototype.atX0MinutesPastTheHour = function() {
                    return "la și %s minute";
                  };
                  ro2.prototype.atX0SecondsPastTheMinute = function() {
                    return "la și %s secunde";
                  };
                  ro2.prototype.betweenX0AndX1 = function() {
                    return "între %s și %s";
                  };
                  ro2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", între zilele %s și %s ale lunii";
                  };
                  ro2.prototype.commaEveryDay = function() {
                    return ", în fiecare zi";
                  };
                  ro2.prototype.commaEveryX0Days = function() {
                    return ", la fiecare %s zile";
                  };
                  ro2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", la fiecare a %s-a zi a săptămânii";
                  };
                  ro2.prototype.commaEveryX0Months = function() {
                    return ", la fiecare %s luni";
                  };
                  ro2.prototype.commaEveryX0Years = function() {
                    return ", o dată la %s ani";
                  };
                  ro2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", în ziua %s a lunii";
                  };
                  ro2.prototype.commaOnlyInX0 = function() {
                    return ", doar în %s";
                  };
                  ro2.prototype.commaOnlyOnX0 = function() {
                    return ", doar %s";
                  };
                  ro2.prototype.commaAndOnX0 = function() {
                    return ", și %s";
                  };
                  ro2.prototype.commaOnThe = function() {
                    return ", în ";
                  };
                  ro2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", în ultima zi a lunii";
                  };
                  ro2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", în ultima zi lucrătoare a lunii";
                  };
                  ro2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s zile înainte de ultima zi a lunii";
                  };
                  ro2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", în ultima %s a lunii";
                  };
                  ro2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", în %s a lunii";
                  };
                  ro2.prototype.commaX0ThroughX1 = function() {
                    return ", de %s până %s";
                  };
                  ro2.prototype.commaAndX0ThroughX1 = function() {
                    return ", și de %s până %s";
                  };
                  ro2.prototype.everyHour = function() {
                    return "în fiecare oră";
                  };
                  ro2.prototype.everyMinute = function() {
                    return "în fiecare minut";
                  };
                  ro2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "În fiecare minut între %s și %s";
                  };
                  ro2.prototype.everySecond = function() {
                    return "în fiecare secundă";
                  };
                  ro2.prototype.everyX0Hours = function() {
                    return "la fiecare %s ore";
                  };
                  ro2.prototype.everyX0Minutes = function() {
                    return "la fiecare %s minute";
                  };
                  ro2.prototype.everyX0Seconds = function() {
                    return "la fiecare %s secunde";
                  };
                  ro2.prototype.fifth = function() {
                    return "a cincea";
                  };
                  ro2.prototype.first = function() {
                    return "prima";
                  };
                  ro2.prototype.firstWeekday = function() {
                    return "prima zi a săptămânii";
                  };
                  ro2.prototype.fourth = function() {
                    return "a patra";
                  };
                  ro2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "între minutele %s și %s";
                  };
                  ro2.prototype.second = function() {
                    return "a doua";
                  };
                  ro2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "între secunda %s și secunda %s";
                  };
                  ro2.prototype.spaceAnd = function() {
                    return " și";
                  };
                  ro2.prototype.spaceX0OfTheMonth = function() {
                    return " %s a lunii";
                  };
                  ro2.prototype.lastDay = function() {
                    return "ultima zi";
                  };
                  ro2.prototype.third = function() {
                    return "a treia";
                  };
                  ro2.prototype.weekdayNearestDayX0 = function() {
                    return "cea mai apropiată zi a săptămânii de ziua %s";
                  };
                  ro2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return ", din %s până în %s";
                  };
                  ro2.prototype.commaYearX0ThroughYearX1 = function() {
                    return ", din %s până în %s";
                  };
                  ro2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return "la și %s de minute";
                  };
                  ro2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return "la și %s de secunde";
                  };
                  ro2.prototype.commaStartingX0 = function() {
                    return ", pornire %s";
                  };
                  ro2.prototype.daysOfTheWeek = function() {
                    return ["duminică", "luni", "marți", "miercuri", "joi", "vineri", "sâmbătă"];
                  };
                  ro2.prototype.monthsOfTheYear = function() {
                    return [
                      "ianuarie",
                      "februarie",
                      "martie",
                      "aprilie",
                      "mai",
                      "iunie",
                      "iulie",
                      "august",
                      "septembrie",
                      "octombrie",
                      "noiembrie",
                      "decembrie"
                    ];
                  };
                  return ro2;
                }();
                exports2.ro = ro;
              }
            ),
            /***/
            392: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.ru = void 0;
                var getPhraseByNumber = function(str, words) {
                  var number = Number(str);
                  return number !== void 0 ? words[number % 100 > 4 && number % 100 < 20 ? 2 : [2, 0, 1, 1, 1, 2][number % 10 < 5 ? Math.abs(number) % 10 : 5]] : words[2];
                };
                var getPhraseByDayOfWeek = function(str, words) {
                  var number = Number(str);
                  return number !== void 0 ? words[number === 0 ? 0 : number === 1 || number === 2 || number === 4 ? 1 : 2] : words[1];
                };
                var ru = function() {
                  function ru2() {
                  }
                  ru2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  ru2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  ru2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  ru2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  ru2.prototype.use24HourTimeFormatByDefault = function() {
                    return true;
                  };
                  ru2.prototype.everyMinute = function() {
                    return "каждую минуту";
                  };
                  ru2.prototype.everyHour = function() {
                    return "каждый час";
                  };
                  ru2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "Произошла ошибка во время генерации описания выражения. Проверьте синтаксис крон-выражения.";
                  };
                  ru2.prototype.atSpace = function() {
                    return "В ";
                  };
                  ru2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "Каждую минуту с %s по %s";
                  };
                  ru2.prototype.at = function() {
                    return "В";
                  };
                  ru2.prototype.spaceAnd = function() {
                    return " и";
                  };
                  ru2.prototype.everySecond = function() {
                    return "каждую секунду";
                  };
                  ru2.prototype.everyX0Seconds = function(s) {
                    return getPhraseByNumber(s, ["каждую %s секунду", "каждые %s секунды", "каждые %s секунд"]);
                  };
                  ru2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "секунды с %s по %s";
                  };
                  ru2.prototype.atX0SecondsPastTheMinute = function(s) {
                    return getPhraseByNumber(s, ["в %s секунду", "в %s секунды", "в %s секунд"]);
                  };
                  ru2.prototype.everyX0Minutes = function(s) {
                    return getPhraseByNumber(s, ["каждую %s минуту", "каждые %s минуты", "каждые %s минут"]);
                  };
                  ru2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "минуты с %s по %s";
                  };
                  ru2.prototype.atX0MinutesPastTheHour = function(s) {
                    return getPhraseByNumber(s, ["в %s минуту", "в %s минуты", "в %s минут"]);
                  };
                  ru2.prototype.everyX0Hours = function(s) {
                    return getPhraseByNumber(s, ["каждый %s час", "каждые %s часа", "каждые %s часов"]);
                  };
                  ru2.prototype.betweenX0AndX1 = function() {
                    return "с %s по %s";
                  };
                  ru2.prototype.atX0 = function() {
                    return "в %s";
                  };
                  ru2.prototype.commaEveryDay = function() {
                    return ", каждый день";
                  };
                  ru2.prototype.commaEveryX0DaysOfTheWeek = function(s) {
                    return getPhraseByNumber(s, ["", ", каждые %s дня недели", ", каждые %s дней недели"]);
                  };
                  ru2.prototype.commaX0ThroughX1 = function(s) {
                    return s && (s[0] == "2" || s[0] == "3") ? ", со %s по %s" : ", с %s по %s";
                  };
                  ru2.prototype.commaAndX0ThroughX1 = function(s) {
                    return s && (s[0] == "2" || s[0] == "3") ? " и со %s по %s" : " и с %s по %s";
                  };
                  ru2.prototype.first = function(s) {
                    return getPhraseByDayOfWeek(s, ["первое", "первый", "первую"]);
                  };
                  ru2.prototype.second = function(s) {
                    return getPhraseByDayOfWeek(s, ["второе", "второй", "вторую"]);
                  };
                  ru2.prototype.third = function(s) {
                    return getPhraseByDayOfWeek(s, ["третье", "третий", "третью"]);
                  };
                  ru2.prototype.fourth = function(s) {
                    return getPhraseByDayOfWeek(s, ["четвертое", "четвертый", "четвертую"]);
                  };
                  ru2.prototype.fifth = function(s) {
                    return getPhraseByDayOfWeek(s, ["пятое", "пятый", "пятую"]);
                  };
                  ru2.prototype.commaOnThe = function(s) {
                    return s === "2" ? ", во " : ", в ";
                  };
                  ru2.prototype.spaceX0OfTheMonth = function() {
                    return " %s месяца";
                  };
                  ru2.prototype.lastDay = function() {
                    return "последний день";
                  };
                  ru2.prototype.commaOnTheLastX0OfTheMonth = function(s) {
                    return getPhraseByDayOfWeek(s, [", в последнее %s месяца", ", в последний %s месяца", ", в последнюю %s месяца"]);
                  };
                  ru2.prototype.commaOnlyOnX0 = function(s) {
                    return s && s[0] === "2" ? ", только во %s" : ", только в %s";
                  };
                  ru2.prototype.commaAndOnX0 = function() {
                    return ", и %s";
                  };
                  ru2.prototype.commaEveryX0Months = function(s) {
                    return getPhraseByNumber(s, ["", " каждые %s месяца", " каждые %s месяцев"]);
                  };
                  ru2.prototype.commaOnlyInMonthX0 = function() {
                    return ", только %s";
                  };
                  ru2.prototype.commaOnlyInX0 = function() {
                    return ", только в %s";
                  };
                  ru2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", в последний день месяца";
                  };
                  ru2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", в последний будний день месяца";
                  };
                  ru2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function(s) {
                    return getPhraseByNumber(s, [
                      ", за %s день до конца месяца",
                      ", за %s дня до конца месяца",
                      ", за %s дней до конца месяца"
                    ]);
                  };
                  ru2.prototype.firstWeekday = function() {
                    return "первый будний день";
                  };
                  ru2.prototype.weekdayNearestDayX0 = function() {
                    return "ближайший будний день к %s числу";
                  };
                  ru2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", в %s месяца";
                  };
                  ru2.prototype.commaEveryX0Days = function(s) {
                    return getPhraseByNumber(s, [", каждый %s день", ", каждые %s дня", ", каждые %s дней"]);
                  };
                  ru2.prototype.commaBetweenDayX0AndX1OfTheMonth = function(s) {
                    return s && s.substring(0, s.indexOf("-")) == "2" ? ", со %s по %s число месяца" : ", с %s по %s число месяца";
                  };
                  ru2.prototype.commaOnDayX0OfTheMonth = function(s) {
                    return s && s[0] == "2" ? ", во %s число месяца" : ", в %s число месяца";
                  };
                  ru2.prototype.commaEveryX0Years = function(s) {
                    return getPhraseByNumber(s, [", каждый %s год", ", каждые %s года", ", каждые %s лет"]);
                  };
                  ru2.prototype.commaStartingX0 = function() {
                    return ", начало %s";
                  };
                  ru2.prototype.daysOfTheWeek = function() {
                    return ["воскресенье", "понедельник", "вторник", "среда", "четверг", "пятница", "суббота"];
                  };
                  ru2.prototype.daysOfTheWeekInCase = function(f) {
                    if (f === void 0) {
                      f = 2;
                    }
                    return f == 1 ? ["воскресенья", "понедельника", "вторника", "среды", "четверга", "пятницы", "субботы"] : ["воскресенье", "понедельник", "вторник", "среду", "четверг", "пятницу", "субботу"];
                  };
                  ru2.prototype.monthsOfTheYear = function() {
                    return [
                      "январь",
                      "февраль",
                      "март",
                      "апрель",
                      "май",
                      "июнь",
                      "июль",
                      "август",
                      "сентябрь",
                      "октябрь",
                      "ноябрь",
                      "декабрь"
                    ];
                  };
                  ru2.prototype.monthsOfTheYearInCase = function(f) {
                    return f == 1 ? [
                      "января",
                      "февраля",
                      "марта",
                      "апреля",
                      "мая",
                      "июня",
                      "июля",
                      "августа",
                      "сентября",
                      "октября",
                      "ноября",
                      "декабря"
                    ] : this.monthsOfTheYear();
                  };
                  return ru2;
                }();
                exports2.ru = ru;
              }
            ),
            /***/
            203: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.sk = void 0;
                var sk = function() {
                  function sk2() {
                  }
                  sk2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  sk2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  sk2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  sk2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  sk2.prototype.use24HourTimeFormatByDefault = function() {
                    return true;
                  };
                  sk2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "Pri vytváraní popisu došlo k chybe. Skontrolujte prosím správnosť syntaxe cronu.";
                  };
                  sk2.prototype.everyMinute = function() {
                    return "každú minútu";
                  };
                  sk2.prototype.everyHour = function() {
                    return "každú hodinu";
                  };
                  sk2.prototype.atSpace = function() {
                    return "V ";
                  };
                  sk2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "Každú minútu medzi %s a %s";
                  };
                  sk2.prototype.at = function() {
                    return "V";
                  };
                  sk2.prototype.spaceAnd = function() {
                    return " a";
                  };
                  sk2.prototype.everySecond = function() {
                    return "každú sekundu";
                  };
                  sk2.prototype.everyX0Seconds = function() {
                    return "každých %s sekúnd";
                  };
                  sk2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "sekundy od %s do %s";
                  };
                  sk2.prototype.atX0SecondsPastTheMinute = function() {
                    return "v %s sekúnd";
                  };
                  sk2.prototype.everyX0Minutes = function() {
                    return "každých %s minút";
                  };
                  sk2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "minúty od %s do %s";
                  };
                  sk2.prototype.atX0MinutesPastTheHour = function() {
                    return "v %s minút";
                  };
                  sk2.prototype.everyX0Hours = function() {
                    return "každých %s hodín";
                  };
                  sk2.prototype.betweenX0AndX1 = function() {
                    return "medzi %s a %s";
                  };
                  sk2.prototype.atX0 = function() {
                    return "v %s";
                  };
                  sk2.prototype.commaEveryDay = function() {
                    return ", každý deň";
                  };
                  sk2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", každých %s dní v týždni";
                  };
                  sk2.prototype.commaX0ThroughX1 = function() {
                    return ", od %s do %s";
                  };
                  sk2.prototype.commaAndX0ThroughX1 = function() {
                    return ", a od %s do %s";
                  };
                  sk2.prototype.first = function() {
                    return "prvý";
                  };
                  sk2.prototype.second = function() {
                    return "druhý";
                  };
                  sk2.prototype.third = function() {
                    return "tretí";
                  };
                  sk2.prototype.fourth = function() {
                    return "štvrtý";
                  };
                  sk2.prototype.fifth = function() {
                    return "piaty";
                  };
                  sk2.prototype.commaOnThe = function() {
                    return ", ";
                  };
                  sk2.prototype.spaceX0OfTheMonth = function() {
                    return " %s v mesiaci";
                  };
                  sk2.prototype.lastDay = function() {
                    return "posledný deň";
                  };
                  sk2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", posledný %s v mesiaci";
                  };
                  sk2.prototype.commaOnlyOnX0 = function() {
                    return ", iba v %s";
                  };
                  sk2.prototype.commaAndOnX0 = function() {
                    return ", a v %s";
                  };
                  sk2.prototype.commaEveryX0Months = function() {
                    return ", každých %s mesiacov";
                  };
                  sk2.prototype.commaOnlyInX0 = function() {
                    return ", iba v %s";
                  };
                  sk2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", posledný deň v mesiaci";
                  };
                  sk2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", posledný pracovný deň v mesiaci";
                  };
                  sk2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s dní pred posledným dňom v mesiaci";
                  };
                  sk2.prototype.firstWeekday = function() {
                    return "prvý pracovný deň";
                  };
                  sk2.prototype.weekdayNearestDayX0 = function() {
                    return "pracovný deň najbližšie %s. dňu";
                  };
                  sk2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", v %s v mesiaci";
                  };
                  sk2.prototype.commaEveryX0Days = function() {
                    return ", každých %s dní";
                  };
                  sk2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", medzi dňami %s a %s v mesiaci";
                  };
                  sk2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", %s. deň v mesiaci";
                  };
                  sk2.prototype.commaEveryX0Years = function() {
                    return ", každých %s rokov";
                  };
                  sk2.prototype.commaStartingX0 = function() {
                    return ", začínajúcich %s";
                  };
                  sk2.prototype.daysOfTheWeek = function() {
                    return ["Nedeľa", "Pondelok", "Utorok", "Streda", "Štvrtok", "Piatok", "Sobota"];
                  };
                  sk2.prototype.monthsOfTheYear = function() {
                    return [
                      "Január",
                      "Február",
                      "Marec",
                      "Apríl",
                      "Máj",
                      "Jún",
                      "Júl",
                      "August",
                      "September",
                      "Október",
                      "November",
                      "December"
                    ];
                  };
                  return sk2;
                }();
                exports2.sk = sk;
              }
            ),
            /***/
            738: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.sl = void 0;
                var sl = function() {
                  function sl2() {
                  }
                  sl2.prototype.use24HourTimeFormatByDefault = function() {
                    return true;
                  };
                  sl2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "Pri generiranju opisa izraza je prišlo do napake. Preverite sintakso izraza cron.";
                  };
                  sl2.prototype.at = function() {
                    return "Ob";
                  };
                  sl2.prototype.atSpace = function() {
                    return "Ob ";
                  };
                  sl2.prototype.atX0 = function() {
                    return "ob %s";
                  };
                  sl2.prototype.atX0MinutesPastTheHour = function() {
                    return "ob %s.";
                  };
                  sl2.prototype.atX0SecondsPastTheMinute = function() {
                    return "ob %s.";
                  };
                  sl2.prototype.betweenX0AndX1 = function() {
                    return "od %s do %s";
                  };
                  sl2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", od %s. do %s. dne v mesecu";
                  };
                  sl2.prototype.commaEveryDay = function() {
                    return ", vsak dan";
                  };
                  sl2.prototype.commaEveryX0Days = function() {
                    return ", vsakih %s dni";
                  };
                  sl2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", vsakih %s dni v tednu";
                  };
                  sl2.prototype.commaEveryX0Months = function() {
                    return ", vsakih %s mesecev";
                  };
                  sl2.prototype.commaEveryX0Years = function() {
                    return ", vsakih %s let";
                  };
                  sl2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", %s. dan v mesecu";
                  };
                  sl2.prototype.commaOnlyInX0 = function() {
                    return ", samo v %s";
                  };
                  sl2.prototype.commaOnlyOnX0 = function() {
                    return ", samo v %s";
                  };
                  sl2.prototype.commaAndOnX0 = function() {
                    return "in naprej %s";
                  };
                  sl2.prototype.commaOnThe = function() {
                    return ", ";
                  };
                  sl2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", zadnji %s v mesecu";
                  };
                  sl2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", zadnji delovni dan v mesecu";
                  };
                  sl2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s dni pred koncem meseca";
                  };
                  sl2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", zadnji %s v mesecu";
                  };
                  sl2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", %s v mesecu";
                  };
                  sl2.prototype.commaX0ThroughX1 = function() {
                    return ", od %s do %s";
                  };
                  sl2.prototype.commaAndX0ThroughX1 = function() {
                    return ", in od %s do %s";
                  };
                  sl2.prototype.everyHour = function() {
                    return "vsako uro";
                  };
                  sl2.prototype.everyMinute = function() {
                    return "vsako minuto";
                  };
                  sl2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "Vsako minuto od %s do %s";
                  };
                  sl2.prototype.everySecond = function() {
                    return "vsako sekundo";
                  };
                  sl2.prototype.everyX0Hours = function() {
                    return "vsakih %s ur";
                  };
                  sl2.prototype.everyX0Minutes = function() {
                    return "vsakih %s minut";
                  };
                  sl2.prototype.everyX0Seconds = function() {
                    return "vsakih %s sekund";
                  };
                  sl2.prototype.fifth = function() {
                    return "peti";
                  };
                  sl2.prototype.first = function() {
                    return "prvi";
                  };
                  sl2.prototype.firstWeekday = function() {
                    return "prvi delovni dan";
                  };
                  sl2.prototype.fourth = function() {
                    return "četrti";
                  };
                  sl2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "minute od %s do %s";
                  };
                  sl2.prototype.second = function() {
                    return "drugi";
                  };
                  sl2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "sekunde od %s do %s";
                  };
                  sl2.prototype.spaceAnd = function() {
                    return " in";
                  };
                  sl2.prototype.spaceX0OfTheMonth = function() {
                    return " %s v mesecu";
                  };
                  sl2.prototype.lastDay = function() {
                    return "zadnjič";
                  };
                  sl2.prototype.third = function() {
                    return "tretji";
                  };
                  sl2.prototype.weekdayNearestDayX0 = function() {
                    return "delovni dan, najbližji %s. dnevu";
                  };
                  sl2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  sl2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  sl2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  sl2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  sl2.prototype.commaStartingX0 = function() {
                    return ", začenši %s";
                  };
                  sl2.prototype.daysOfTheWeek = function() {
                    return ["Nedelja", "Ponedeljek", "Torek", "Sreda", "Četrtek", "Petek", "Sobota"];
                  };
                  sl2.prototype.monthsOfTheYear = function() {
                    return [
                      "januar",
                      "februar",
                      "marec",
                      "april",
                      "maj",
                      "junij",
                      "julij",
                      "avgust",
                      "september",
                      "oktober",
                      "november",
                      "december"
                    ];
                  };
                  return sl2;
                }();
                exports2.sl = sl;
              }
            ),
            /***/
            673: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.sv = void 0;
                var sv = function() {
                  function sv2() {
                  }
                  sv2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  sv2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  sv2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  sv2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  sv2.prototype.use24HourTimeFormatByDefault = function() {
                    return true;
                  };
                  sv2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "Ett fel inträffade vid generering av uttryckets beskrivning. Kontrollera cron-uttryckets syntax.";
                  };
                  sv2.prototype.everyMinute = function() {
                    return "varje minut";
                  };
                  sv2.prototype.everyHour = function() {
                    return "varje timme";
                  };
                  sv2.prototype.atSpace = function() {
                    return "Kl ";
                  };
                  sv2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "Varje minut mellan %s och %s";
                  };
                  sv2.prototype.at = function() {
                    return "Kl";
                  };
                  sv2.prototype.spaceAnd = function() {
                    return " och";
                  };
                  sv2.prototype.everySecond = function() {
                    return "varje sekund";
                  };
                  sv2.prototype.everyX0Seconds = function() {
                    return "varje %s sekund";
                  };
                  sv2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "sekunderna från %s till och med %s efter minuten";
                  };
                  sv2.prototype.atX0SecondsPastTheMinute = function() {
                    return "på %s sekunder efter minuten";
                  };
                  sv2.prototype.everyX0Minutes = function() {
                    return "var %s minut";
                  };
                  sv2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "minuterna från %s till och med %s efter timmen";
                  };
                  sv2.prototype.atX0MinutesPastTheHour = function() {
                    return "på %s minuten efter timmen";
                  };
                  sv2.prototype.everyX0Hours = function() {
                    return "var %s timme";
                  };
                  sv2.prototype.betweenX0AndX1 = function() {
                    return "mellan %s och %s";
                  };
                  sv2.prototype.atX0 = function() {
                    return "kl %s";
                  };
                  sv2.prototype.commaEveryDay = function() {
                    return ", varje dag";
                  };
                  sv2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", var %s dag i veckan";
                  };
                  sv2.prototype.commaX0ThroughX1 = function() {
                    return ", %s till %s";
                  };
                  sv2.prototype.commaAndX0ThroughX1 = function() {
                    return ", och %s till %s";
                  };
                  sv2.prototype.first = function() {
                    return "första";
                  };
                  sv2.prototype.second = function() {
                    return "andra";
                  };
                  sv2.prototype.third = function() {
                    return "tredje";
                  };
                  sv2.prototype.fourth = function() {
                    return "fjärde";
                  };
                  sv2.prototype.fifth = function() {
                    return "femte";
                  };
                  sv2.prototype.commaOnThe = function() {
                    return ", den ";
                  };
                  sv2.prototype.spaceX0OfTheMonth = function() {
                    return " %sen av månaden";
                  };
                  sv2.prototype.lastDay = function() {
                    return "den sista dagen";
                  };
                  sv2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", på sista %s av månaden";
                  };
                  sv2.prototype.commaOnlyOnX0 = function() {
                    return ", varje %s";
                  };
                  sv2.prototype.commaAndOnX0 = function() {
                    return ", och på %s";
                  };
                  sv2.prototype.commaEveryX0Months = function() {
                    return ", var %s månad";
                  };
                  sv2.prototype.commaOnlyInX0 = function() {
                    return ", bara på %s";
                  };
                  sv2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", på sista dagen av månaden";
                  };
                  sv2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", på sista veckodag av månaden";
                  };
                  sv2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s dagar före den sista dagen i månaden";
                  };
                  sv2.prototype.firstWeekday = function() {
                    return "första veckodag";
                  };
                  sv2.prototype.weekdayNearestDayX0 = function() {
                    return "veckodagen närmast dag %s";
                  };
                  sv2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", på den %s av månaden";
                  };
                  sv2.prototype.commaEveryX0Days = function() {
                    return ", var %s dag";
                  };
                  sv2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", mellan dag %s och %s av månaden";
                  };
                  sv2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", på dag %s av månaden";
                  };
                  sv2.prototype.commaEveryX0Years = function() {
                    return ", var %s år";
                  };
                  sv2.prototype.commaStartingX0 = function() {
                    return ", startar %s";
                  };
                  sv2.prototype.daysOfTheWeek = function() {
                    return ["söndag", "måndag", "tisdag", "onsdag", "torsdag", "fredag", "lördag"];
                  };
                  sv2.prototype.monthsOfTheYear = function() {
                    return [
                      "januari",
                      "februari",
                      "mars",
                      "april",
                      "maj",
                      "juni",
                      "juli",
                      "augusti",
                      "september",
                      "oktober",
                      "november",
                      "december"
                    ];
                  };
                  return sv2;
                }();
                exports2.sv = sv;
              }
            ),
            /***/
            286: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.sw = void 0;
                var sw = function() {
                  function sw2() {
                  }
                  sw2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  sw2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  sw2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  sw2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  sw2.prototype.use24HourTimeFormatByDefault = function() {
                    return false;
                  };
                  sw2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "Kuna tatizo wakati wa kutunga msemo. Angalia cron expression syntax.";
                  };
                  sw2.prototype.everyMinute = function() {
                    return "kila dakika";
                  };
                  sw2.prototype.everyHour = function() {
                    return "kila saa";
                  };
                  sw2.prototype.atSpace = function() {
                    return "Kwa ";
                  };
                  sw2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "Kila dakika kwanzia %s hadi %s";
                  };
                  sw2.prototype.at = function() {
                    return "Kwa";
                  };
                  sw2.prototype.spaceAnd = function() {
                    return " na";
                  };
                  sw2.prototype.everySecond = function() {
                    return "kila sekunde";
                  };
                  sw2.prototype.everyX0Seconds = function() {
                    return "kila sekunde %s";
                  };
                  sw2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "sekunde ya %s hadi %s baada ya dakika";
                  };
                  sw2.prototype.atX0SecondsPastTheMinute = function() {
                    return "sekunde %s baada ya dakika";
                  };
                  sw2.prototype.everyX0Minutes = function() {
                    return "kila dakika %s";
                  };
                  sw2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "minutes %s through %s past the hour";
                  };
                  sw2.prototype.atX0MinutesPastTheHour = function() {
                    return "at %s minutes past the hour";
                  };
                  sw2.prototype.everyX0Hours = function() {
                    return "every %s hours";
                  };
                  sw2.prototype.betweenX0AndX1 = function() {
                    return "kati ya %s na %s";
                  };
                  sw2.prototype.atX0 = function() {
                    return "kwenye %s";
                  };
                  sw2.prototype.commaEveryDay = function() {
                    return ", kila siku";
                  };
                  sw2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", kila siku %s ya wiki";
                  };
                  sw2.prototype.commaX0ThroughX1 = function() {
                    return ", %s hadi %s";
                  };
                  sw2.prototype.commaAndX0ThroughX1 = function() {
                    return ", na %s hadi %s";
                  };
                  sw2.prototype.first = function() {
                    return "ya kwanza";
                  };
                  sw2.prototype.second = function() {
                    return "ya pili";
                  };
                  sw2.prototype.third = function() {
                    return "ya tatu";
                  };
                  sw2.prototype.fourth = function() {
                    return "ya nne";
                  };
                  sw2.prototype.fifth = function() {
                    return "ya tano";
                  };
                  sw2.prototype.commaOnThe = function() {
                    return ", kwenye ";
                  };
                  sw2.prototype.spaceX0OfTheMonth = function() {
                    return " siku %s ya mwezi";
                  };
                  sw2.prototype.lastDay = function() {
                    return "siku ya mwisho";
                  };
                  sw2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", siku ya %s ya mwezi";
                  };
                  sw2.prototype.commaOnlyOnX0 = function() {
                    return ", kwa %s tu";
                  };
                  sw2.prototype.commaAndOnX0 = function() {
                    return ", na pia %s";
                  };
                  sw2.prototype.commaEveryX0Months = function() {
                    return ", kila mwezi wa %s";
                  };
                  sw2.prototype.commaOnlyInX0 = function() {
                    return ", kwa %s tu";
                  };
                  sw2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", siku ya mwisho wa mwezi";
                  };
                  sw2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", wikendi ya mwisho wa mwezi";
                  };
                  sw2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", siku ya %s kabla ya siku ya mwisho wa mwezi";
                  };
                  sw2.prototype.firstWeekday = function() {
                    return "siku za kazi ya kwanza";
                  };
                  sw2.prototype.weekdayNearestDayX0 = function() {
                    return "siku ya kazi karibu na siku ya %s";
                  };
                  sw2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", siku ya %s ya mwezi";
                  };
                  sw2.prototype.commaEveryX0Days = function() {
                    return ", kila siku %s";
                  };
                  sw2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", kati ya siku %s na %s ya mwezi";
                  };
                  sw2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", siku ya %s ya mwezi";
                  };
                  sw2.prototype.commaEveryX0Years = function() {
                    return ", kila miaka %s";
                  };
                  sw2.prototype.commaStartingX0 = function() {
                    return ", kwanzia %s";
                  };
                  sw2.prototype.daysOfTheWeek = function() {
                    return ["Jumapili", "Jumatatu", "Jumanne", "Jumatano", "Alhamisi", "Ijumaa", "Jumamosi"];
                  };
                  sw2.prototype.monthsOfTheYear = function() {
                    return [
                      "Januari",
                      "Februari",
                      "Machi",
                      "Aprili",
                      "Mei",
                      "Juni",
                      "Julai",
                      "Agosti",
                      "Septemba",
                      "Oktoba",
                      "Novemba",
                      "Desemba"
                    ];
                  };
                  return sw2;
                }();
                exports2.sw = sw;
              }
            ),
            /***/
            312: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.th = void 0;
                var th = function() {
                  function th2() {
                  }
                  th2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  th2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  th2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  th2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  th2.prototype.use24HourTimeFormatByDefault = function() {
                    return false;
                  };
                  th2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "เกิดข้อผิดพลาดขณะสร้างคำอธิบายนิพจน์ ตรวจสอบไวยากรณ์นิพจน์ครอน";
                  };
                  th2.prototype.everyMinute = function() {
                    return "ทุกๆ นาที";
                  };
                  th2.prototype.everyHour = function() {
                    return "ทุกๆ ชั่วโมง";
                  };
                  th2.prototype.atSpace = function() {
                    return "เมื่อ ";
                  };
                  th2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "ทุกๆ นาที %s และ %s";
                  };
                  th2.prototype.at = function() {
                    return "เมื่อ";
                  };
                  th2.prototype.spaceAnd = function() {
                    return " และ";
                  };
                  th2.prototype.everySecond = function() {
                    return "ทุกๆ วินาที";
                  };
                  th2.prototype.everyX0Seconds = function() {
                    return "ทุกๆ %s วินาที";
                  };
                  th2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "วินาที %s ถึง %s นาทีที่ผ่านมา";
                  };
                  th2.prototype.atX0SecondsPastTheMinute = function() {
                    return "เมื่อ %s วินาที นาทีที่ผ่านมา";
                  };
                  th2.prototype.everyX0Minutes = function() {
                    return "ทุกๆ %s นาที";
                  };
                  th2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "นาที %s ถึง %s ชั่วโมงที่ผ่านมา";
                  };
                  th2.prototype.atX0MinutesPastTheHour = function() {
                    return "เมื่อ %s นาที ชั่วโมงที่ผ่านมา";
                  };
                  th2.prototype.everyX0Hours = function() {
                    return "ทุกๆ %s ชั่วโมง";
                  };
                  th2.prototype.betweenX0AndX1 = function() {
                    return "ระหว่าง %s ถึง %s";
                  };
                  th2.prototype.atX0 = function() {
                    return "เมื่อ %s";
                  };
                  th2.prototype.commaEveryDay = function() {
                    return ", ทุกๆ วัน";
                  };
                  th2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", ทุกๆ %s วันของสัปดาห์";
                  };
                  th2.prototype.commaX0ThroughX1 = function() {
                    return ", %s ถึง %s";
                  };
                  th2.prototype.commaAndX0ThroughX1 = function() {
                    return ", %s ถึง %s";
                  };
                  th2.prototype.first = function() {
                    return "แรก";
                  };
                  th2.prototype.second = function() {
                    return "ที่สอง";
                  };
                  th2.prototype.third = function() {
                    return "ที่สาม";
                  };
                  th2.prototype.fourth = function() {
                    return "ที่สี่";
                  };
                  th2.prototype.fifth = function() {
                    return "ที่ห้า";
                  };
                  th2.prototype.commaOnThe = function() {
                    return ", ในวัน ";
                  };
                  th2.prototype.spaceX0OfTheMonth = function() {
                    return " %s ของเดือน";
                  };
                  th2.prototype.lastDay = function() {
                    return "วันสุดท้าย";
                  };
                  th2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", ณ สุดท้าย %s ของเดือน";
                  };
                  th2.prototype.commaOnlyOnX0 = function() {
                    return ", เท่านั้น %s";
                  };
                  th2.prototype.commaAndOnX0 = function() {
                    return ", และใน %s";
                  };
                  th2.prototype.commaEveryX0Months = function() {
                    return ", ทุกๆ %s เดือน";
                  };
                  th2.prototype.commaOnlyInX0 = function() {
                    return ", เท่านั้น %s";
                  };
                  th2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", ในวันสิ้นเดือน";
                  };
                  th2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", ในวันธรรมดาสุดท้ายของเดือน";
                  };
                  th2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s วันก่อนวันสุดท้ายของเดือน";
                  };
                  th2.prototype.firstWeekday = function() {
                    return "วันธรรมดาวันแรก";
                  };
                  th2.prototype.weekdayNearestDayX0 = function() {
                    return "วันธรรมดาที่ใกล้ที่สุด %s";
                  };
                  th2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", ในวัน %s ของเดือน";
                  };
                  th2.prototype.commaEveryX0Days = function() {
                    return ", ทุกๆ %s วัน";
                  };
                  th2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", ระหว่างวัน %s และ %s ของเดือน";
                  };
                  th2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", ในวัน %s ของเดือน";
                  };
                  th2.prototype.commaEveryHour = function() {
                    return ", ทุกๆ ชั่วโมง";
                  };
                  th2.prototype.commaEveryX0Years = function() {
                    return ", ทุกๆ %s ปี";
                  };
                  th2.prototype.commaStartingX0 = function() {
                    return ", เริ่ม %s";
                  };
                  th2.prototype.daysOfTheWeek = function() {
                    return ["วันอาทิตย์", "วันจันทร์", "วันอังคาร", "วันพุธ", "วันพฤหัสบดี", "วันศุกร์", "วันเสาร์"];
                  };
                  th2.prototype.monthsOfTheYear = function() {
                    return [
                      "มกราคม",
                      "กุมภาพันธ์",
                      "มีนาคม",
                      "เมษายน",
                      "พฤษภาคม",
                      "มิถุนายน",
                      "กรกฎาคม",
                      "สิงหาคม",
                      "กันยายน",
                      "ตุลาคม",
                      "พฤศจิกายน",
                      "ธันวาคม"
                    ];
                  };
                  return th2;
                }();
                exports2.th = th;
              }
            ),
            /***/
            999: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.tr = void 0;
                var tr = function() {
                  function tr2() {
                  }
                  tr2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  tr2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  tr2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  tr2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  tr2.prototype.use24HourTimeFormatByDefault = function() {
                    return true;
                  };
                  tr2.prototype.everyMinute = function() {
                    return "her dakika";
                  };
                  tr2.prototype.everyHour = function() {
                    return "her saat";
                  };
                  tr2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "İfade açıklamasını oluştururken bir hata oluştu. Cron ifadesini gözden geçirin.";
                  };
                  tr2.prototype.atSpace = function() {
                    return "Saat ";
                  };
                  tr2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "Saat %s ve %s arasındaki her dakika";
                  };
                  tr2.prototype.at = function() {
                    return "Saat";
                  };
                  tr2.prototype.spaceAnd = function() {
                    return " ve";
                  };
                  tr2.prototype.everySecond = function() {
                    return "her saniye";
                  };
                  tr2.prototype.everyX0Seconds = function() {
                    return "her %s saniyede bir";
                  };
                  tr2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "dakikaların %s. ve %s. saniyeleri arası";
                  };
                  tr2.prototype.atX0SecondsPastTheMinute = function() {
                    return "dakikaların %s. saniyesinde";
                  };
                  tr2.prototype.everyX0Minutes = function() {
                    return "her %s dakikada bir";
                  };
                  tr2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "saatlerin %s. ve %s. dakikaları arası";
                  };
                  tr2.prototype.atX0MinutesPastTheHour = function() {
                    return "saatlerin %s. dakikasında";
                  };
                  tr2.prototype.everyX0Hours = function() {
                    return "her %s saatte";
                  };
                  tr2.prototype.betweenX0AndX1 = function() {
                    return "%s ile %s arasında";
                  };
                  tr2.prototype.atX0 = function() {
                    return "saat %s";
                  };
                  tr2.prototype.commaEveryDay = function() {
                    return ", her gün";
                  };
                  tr2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", ayın her %s günü";
                  };
                  tr2.prototype.commaX0ThroughX1 = function() {
                    return ", %s ile %s arasında";
                  };
                  tr2.prototype.commaAndX0ThroughX1 = function() {
                    return ", ve %s ile %s arasında";
                  };
                  tr2.prototype.first = function() {
                    return "ilk";
                  };
                  tr2.prototype.second = function() {
                    return "ikinci";
                  };
                  tr2.prototype.third = function() {
                    return "üçüncü";
                  };
                  tr2.prototype.fourth = function() {
                    return "dördüncü";
                  };
                  tr2.prototype.fifth = function() {
                    return "beşinci";
                  };
                  tr2.prototype.commaOnThe = function() {
                    return ", ayın ";
                  };
                  tr2.prototype.spaceX0OfTheMonth = function() {
                    return " %s günü";
                  };
                  tr2.prototype.lastDay = function() {
                    return "son gün";
                  };
                  tr2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", ayın son %s günü";
                  };
                  tr2.prototype.commaOnlyOnX0 = function() {
                    return ", sadece %s günü";
                  };
                  tr2.prototype.commaAndOnX0 = function() {
                    return ", ve %s";
                  };
                  tr2.prototype.commaEveryX0Months = function() {
                    return ", %s ayda bir";
                  };
                  tr2.prototype.commaOnlyInX0 = function() {
                    return ", sadece %s için";
                  };
                  tr2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", ayın son günü";
                  };
                  tr2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", ayın son iş günü";
                  };
                  tr2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s ayın son gününden önceki günler";
                  };
                  tr2.prototype.firstWeekday = function() {
                    return "ilk iş günü";
                  };
                  tr2.prototype.weekdayNearestDayX0 = function() {
                    return "%s. günü sonrasındaki ilk iş günü";
                  };
                  tr2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", ayın %s";
                  };
                  tr2.prototype.commaEveryX0Days = function() {
                    return ", %s günde bir";
                  };
                  tr2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", ayın %s. ve %s. günleri arası";
                  };
                  tr2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", ayın %s. günü";
                  };
                  tr2.prototype.commaEveryX0Years = function() {
                    return ", %s yılda bir";
                  };
                  tr2.prototype.commaStartingX0 = function() {
                    return ", başlangıç %s";
                  };
                  tr2.prototype.daysOfTheWeek = function() {
                    return ["Pazar", "Pazartesi", "Salı", "Çarşamba", "Perşembe", "Cuma", "Cumartesi"];
                  };
                  tr2.prototype.monthsOfTheYear = function() {
                    return [
                      "Ocak",
                      "Şubat",
                      "Mart",
                      "Nisan",
                      "Mayıs",
                      "Haziran",
                      "Temmuz",
                      "Ağustos",
                      "Eylül",
                      "Ekim",
                      "Kasım",
                      "Aralık"
                    ];
                  };
                  return tr2;
                }();
                exports2.tr = tr;
              }
            ),
            /***/
            716: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.uk = void 0;
                var uk = function() {
                  function uk2() {
                  }
                  uk2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  uk2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  uk2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  uk2.prototype.commaYearX0ThroughYearX1 = function() {
                    return null;
                  };
                  uk2.prototype.use24HourTimeFormatByDefault = function() {
                    return true;
                  };
                  uk2.prototype.everyMinute = function() {
                    return "щохвилини";
                  };
                  uk2.prototype.everyHour = function() {
                    return "щогодини";
                  };
                  uk2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "ВІдбулася помилка підчас генерації опису. Перевірта правильність написання cron виразу.";
                  };
                  uk2.prototype.atSpace = function() {
                    return "О ";
                  };
                  uk2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "Щохвилини між %s та %s";
                  };
                  uk2.prototype.at = function() {
                    return "О";
                  };
                  uk2.prototype.spaceAnd = function() {
                    return " та";
                  };
                  uk2.prototype.everySecond = function() {
                    return "Щосекунди";
                  };
                  uk2.prototype.everyX0Seconds = function() {
                    return "кожні %s секунд";
                  };
                  uk2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "з %s по %s секунду";
                  };
                  uk2.prototype.atX0SecondsPastTheMinute = function() {
                    return "о %s секунді";
                  };
                  uk2.prototype.everyX0Minutes = function() {
                    return "кожні %s хвилин";
                  };
                  uk2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "з %s по %s хвилину";
                  };
                  uk2.prototype.atX0MinutesPastTheHour = function() {
                    return "о %s хвилині";
                  };
                  uk2.prototype.everyX0Hours = function() {
                    return "кожні %s годин";
                  };
                  uk2.prototype.betweenX0AndX1 = function() {
                    return "між %s та %s";
                  };
                  uk2.prototype.atX0 = function() {
                    return "о %s";
                  };
                  uk2.prototype.commaEveryDay = function() {
                    return ", щоденно";
                  };
                  uk2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", кожен %s день тижня";
                  };
                  uk2.prototype.commaX0ThroughX1 = function() {
                    return ", %s по %s";
                  };
                  uk2.prototype.commaAndX0ThroughX1 = function() {
                    return ", та %s по %s";
                  };
                  uk2.prototype.first = function() {
                    return "перший";
                  };
                  uk2.prototype.second = function() {
                    return "другий";
                  };
                  uk2.prototype.third = function() {
                    return "третій";
                  };
                  uk2.prototype.fourth = function() {
                    return "четвертий";
                  };
                  uk2.prototype.fifth = function() {
                    return "п'ятий";
                  };
                  uk2.prototype.commaOnThe = function() {
                    return ", в ";
                  };
                  uk2.prototype.spaceX0OfTheMonth = function() {
                    return " %s місяця";
                  };
                  uk2.prototype.lastDay = function() {
                    return "останній день";
                  };
                  uk2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", в останній %s місяця";
                  };
                  uk2.prototype.commaOnlyOnX0 = function() {
                    return ", тільки в %s";
                  };
                  uk2.prototype.commaAndOnX0 = function() {
                    return ", і в %s";
                  };
                  uk2.prototype.commaEveryX0Months = function() {
                    return ", кожен %s місяць";
                  };
                  uk2.prototype.commaOnlyInX0 = function() {
                    return ", тільки в %s";
                  };
                  uk2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", в останній день місяця";
                  };
                  uk2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", в останній будень місяця";
                  };
                  uk2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s днів до останнього дня місяця";
                  };
                  uk2.prototype.firstWeekday = function() {
                    return "перший будень";
                  };
                  uk2.prototype.weekdayNearestDayX0 = function() {
                    return "будень найближчий до %s дня";
                  };
                  uk2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", в %s місяця";
                  };
                  uk2.prototype.commaEveryX0Days = function() {
                    return ", кожен %s день";
                  };
                  uk2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", між %s та %s днями місяця";
                  };
                  uk2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", на %s день місяця";
                  };
                  uk2.prototype.commaEveryX0Years = function() {
                    return ", кожні %s роки";
                  };
                  uk2.prototype.commaStartingX0 = function() {
                    return ", початок %s";
                  };
                  uk2.prototype.daysOfTheWeek = function() {
                    return ["неділя", "понеділок", "вівторок", "середа", "четвер", "п'ятниця", "субота"];
                  };
                  uk2.prototype.monthsOfTheYear = function() {
                    return [
                      "січень",
                      "лютий",
                      "березень",
                      "квітень",
                      "травень",
                      "червень",
                      "липень",
                      "серпень",
                      "вересень",
                      "жовтень",
                      "листопад",
                      "грудень"
                    ];
                  };
                  return uk2;
                }();
                exports2.uk = uk;
              }
            ),
            /***/
            419: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.zh_CN = void 0;
                var zh_CN = function() {
                  function zh_CN2() {
                  }
                  zh_CN2.prototype.setPeriodBeforeTime = function() {
                    return true;
                  };
                  zh_CN2.prototype.pm = function() {
                    return "下午";
                  };
                  zh_CN2.prototype.am = function() {
                    return "上午";
                  };
                  zh_CN2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  zh_CN2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  zh_CN2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  zh_CN2.prototype.commaYearX0ThroughYearX1 = function() {
                    return ", 从%s年至%s年";
                  };
                  zh_CN2.prototype.use24HourTimeFormatByDefault = function() {
                    return false;
                  };
                  zh_CN2.prototype.everyMinute = function() {
                    return "每分钟";
                  };
                  zh_CN2.prototype.everyHour = function() {
                    return "每小时";
                  };
                  zh_CN2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "生成表达式描述时发生了错误，请检查cron表达式语法。";
                  };
                  zh_CN2.prototype.atSpace = function() {
                    return "在";
                  };
                  zh_CN2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "在 %s 至 %s 之间的每分钟";
                  };
                  zh_CN2.prototype.at = function() {
                    return "在";
                  };
                  zh_CN2.prototype.spaceAnd = function() {
                    return " 和";
                  };
                  zh_CN2.prototype.everySecond = function() {
                    return "每秒";
                  };
                  zh_CN2.prototype.everyX0Seconds = function() {
                    return "每隔 %s 秒";
                  };
                  zh_CN2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "在每分钟的第 %s 到 %s 秒";
                  };
                  zh_CN2.prototype.atX0SecondsPastTheMinute = function() {
                    return "在每分钟的第 %s 秒";
                  };
                  zh_CN2.prototype.everyX0Minutes = function() {
                    return "每隔 %s 分钟";
                  };
                  zh_CN2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "在每小时的第 %s 到 %s 分钟";
                  };
                  zh_CN2.prototype.atX0MinutesPastTheHour = function() {
                    return "在每小时的第 %s 分钟";
                  };
                  zh_CN2.prototype.everyX0Hours = function() {
                    return "每隔 %s 小时";
                  };
                  zh_CN2.prototype.betweenX0AndX1 = function() {
                    return "在 %s 和 %s 之间";
                  };
                  zh_CN2.prototype.atX0 = function() {
                    return "在%s";
                  };
                  zh_CN2.prototype.commaEveryDay = function() {
                    return ", 每天";
                  };
                  zh_CN2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", 每周的每 %s 天";
                  };
                  zh_CN2.prototype.commaX0ThroughX1 = function() {
                    return ", %s至%s";
                  };
                  zh_CN2.prototype.commaAndX0ThroughX1 = function() {
                    return ", 和%s至%s";
                  };
                  zh_CN2.prototype.first = function() {
                    return "第一个";
                  };
                  zh_CN2.prototype.second = function() {
                    return "第二个";
                  };
                  zh_CN2.prototype.third = function() {
                    return "第三个";
                  };
                  zh_CN2.prototype.fourth = function() {
                    return "第四个";
                  };
                  zh_CN2.prototype.fifth = function() {
                    return "第五个";
                  };
                  zh_CN2.prototype.commaOnThe = function() {
                    return ", 限每月的";
                  };
                  zh_CN2.prototype.spaceX0OfTheMonth = function() {
                    return "%s";
                  };
                  zh_CN2.prototype.lastDay = function() {
                    return "本月最后一天";
                  };
                  zh_CN2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", 限每月的最后一个%s";
                  };
                  zh_CN2.prototype.commaOnlyOnX0 = function() {
                    return ", 仅%s";
                  };
                  zh_CN2.prototype.commaAndOnX0 = function() {
                    return ", 并且为%s";
                  };
                  zh_CN2.prototype.commaEveryX0Months = function() {
                    return ", 每隔 %s 个月";
                  };
                  zh_CN2.prototype.commaOnlyInX0 = function() {
                    return ", 仅限%s";
                  };
                  zh_CN2.prototype.commaOnlyInMonthX0 = function() {
                    return ", 仅于%s份";
                  };
                  zh_CN2.prototype.commaOnlyInYearX0 = function() {
                    return ", 仅于 %s 年";
                  };
                  zh_CN2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", 限每月的最后一天";
                  };
                  zh_CN2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", 限每月的最后一个工作日";
                  };
                  zh_CN2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", 限每月最后%s天";
                  };
                  zh_CN2.prototype.firstWeekday = function() {
                    return "第一个工作日";
                  };
                  zh_CN2.prototype.weekdayNearestDayX0 = function() {
                    return "最接近 %s 号的工作日";
                  };
                  zh_CN2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", 限每月的%s";
                  };
                  zh_CN2.prototype.commaEveryX0Days = function() {
                    return ", 每隔 %s 天";
                  };
                  zh_CN2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", 限每月的 %s 至 %s 之间";
                  };
                  zh_CN2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", 限每月%s";
                  };
                  zh_CN2.prototype.commaEveryX0Years = function() {
                    return ", 每隔 %s 年";
                  };
                  zh_CN2.prototype.commaStartingX0 = function() {
                    return ", %s开始";
                  };
                  zh_CN2.prototype.dayX0 = function() {
                    return " %s 号";
                  };
                  zh_CN2.prototype.daysOfTheWeek = function() {
                    return ["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"];
                  };
                  zh_CN2.prototype.monthsOfTheYear = function() {
                    return ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"];
                  };
                  return zh_CN2;
                }();
                exports2.zh_CN = zh_CN;
              }
            ),
            /***/
            139: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.zh_TW = void 0;
                var zh_TW = function() {
                  function zh_TW2() {
                  }
                  zh_TW2.prototype.atX0SecondsPastTheMinuteGt20 = function() {
                    return null;
                  };
                  zh_TW2.prototype.atX0MinutesPastTheHourGt20 = function() {
                    return null;
                  };
                  zh_TW2.prototype.commaMonthX0ThroughMonthX1 = function() {
                    return null;
                  };
                  zh_TW2.prototype.commaYearX0ThroughYearX1 = function() {
                    return ", 從 %s 年至 %s 年";
                  };
                  zh_TW2.prototype.use24HourTimeFormatByDefault = function() {
                    return false;
                  };
                  zh_TW2.prototype.everyMinute = function() {
                    return "每分鐘";
                  };
                  zh_TW2.prototype.everyHour = function() {
                    return "每小時";
                  };
                  zh_TW2.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function() {
                    return "產生表達式描述時發生了錯誤，請檢查 cron 表達式語法。";
                  };
                  zh_TW2.prototype.atSpace = function() {
                    return "在 ";
                  };
                  zh_TW2.prototype.everyMinuteBetweenX0AndX1 = function() {
                    return "在 %s 和 %s 之間的每分鐘";
                  };
                  zh_TW2.prototype.at = function() {
                    return "在";
                  };
                  zh_TW2.prototype.spaceAnd = function() {
                    return " 和";
                  };
                  zh_TW2.prototype.everySecond = function() {
                    return "每秒";
                  };
                  zh_TW2.prototype.everyX0Seconds = function() {
                    return "每 %s 秒";
                  };
                  zh_TW2.prototype.secondsX0ThroughX1PastTheMinute = function() {
                    return "在每分鐘的 %s 到 %s 秒";
                  };
                  zh_TW2.prototype.atX0SecondsPastTheMinute = function() {
                    return "在每分鐘的 %s 秒";
                  };
                  zh_TW2.prototype.everyX0Minutes = function() {
                    return "每 %s 分鐘";
                  };
                  zh_TW2.prototype.minutesX0ThroughX1PastTheHour = function() {
                    return "在每小時的 %s 到 %s 分鐘";
                  };
                  zh_TW2.prototype.atX0MinutesPastTheHour = function() {
                    return "在每小時的 %s 分";
                  };
                  zh_TW2.prototype.everyX0Hours = function() {
                    return "每 %s 小時";
                  };
                  zh_TW2.prototype.betweenX0AndX1 = function() {
                    return "在 %s 和 %s 之間";
                  };
                  zh_TW2.prototype.atX0 = function() {
                    return "在 %s";
                  };
                  zh_TW2.prototype.commaEveryDay = function() {
                    return ", 每天";
                  };
                  zh_TW2.prototype.commaEveryX0DaysOfTheWeek = function() {
                    return ", 每週的每 %s 天";
                  };
                  zh_TW2.prototype.commaX0ThroughX1 = function() {
                    return ", %s 到 %s";
                  };
                  zh_TW2.prototype.commaAndX0ThroughX1 = function() {
                    return ", 和 %s 到 %s";
                  };
                  zh_TW2.prototype.first = function() {
                    return "第一個";
                  };
                  zh_TW2.prototype.second = function() {
                    return "第二個";
                  };
                  zh_TW2.prototype.third = function() {
                    return "第三個";
                  };
                  zh_TW2.prototype.fourth = function() {
                    return "第四個";
                  };
                  zh_TW2.prototype.fifth = function() {
                    return "第五個";
                  };
                  zh_TW2.prototype.commaOnThe = function() {
                    return ", 在每月 ";
                  };
                  zh_TW2.prototype.spaceX0OfTheMonth = function() {
                    return "%s ";
                  };
                  zh_TW2.prototype.lastDay = function() {
                    return "最後一天";
                  };
                  zh_TW2.prototype.commaOnTheLastX0OfTheMonth = function() {
                    return ", 每月的最後一個 %s ";
                  };
                  zh_TW2.prototype.commaOnlyOnX0 = function() {
                    return ", 僅在 %s";
                  };
                  zh_TW2.prototype.commaAndOnX0 = function() {
                    return ", 和 %s";
                  };
                  zh_TW2.prototype.commaEveryX0Months = function() {
                    return ", 每 %s 月";
                  };
                  zh_TW2.prototype.commaOnlyInX0 = function() {
                    return ", 僅在 %s";
                  };
                  zh_TW2.prototype.commaOnlyInMonthX0 = function() {
                    return ", 僅在 %s";
                  };
                  zh_TW2.prototype.commaOnlyInYearX0 = function() {
                    return ", 僅在 %s 年";
                  };
                  zh_TW2.prototype.commaOnTheLastDayOfTheMonth = function() {
                    return ", 每月的最後一天";
                  };
                  zh_TW2.prototype.commaOnTheLastWeekdayOfTheMonth = function() {
                    return ", 每月的最後一個工作日";
                  };
                  zh_TW2.prototype.commaDaysBeforeTheLastDayOfTheMonth = function() {
                    return ", %s 這個月的最後一天的前幾天";
                  };
                  zh_TW2.prototype.firstWeekday = function() {
                    return "第一個工作日";
                  };
                  zh_TW2.prototype.weekdayNearestDayX0 = function() {
                    return "最接近 %s 號的工作日";
                  };
                  zh_TW2.prototype.commaOnTheX0OfTheMonth = function() {
                    return ", 每月的 %s ";
                  };
                  zh_TW2.prototype.commaEveryX0Days = function() {
                    return ", 每 %s 天";
                  };
                  zh_TW2.prototype.commaBetweenDayX0AndX1OfTheMonth = function() {
                    return ", 在每月的 %s 和 %s 之間";
                  };
                  zh_TW2.prototype.commaOnDayX0OfTheMonth = function() {
                    return ", 每月的 %s";
                  };
                  zh_TW2.prototype.commaEveryX0Years = function() {
                    return ", 每 %s 年";
                  };
                  zh_TW2.prototype.commaStartingX0 = function() {
                    return ", %s 開始";
                  };
                  zh_TW2.prototype.dayX0 = function() {
                    return " %s 號";
                  };
                  zh_TW2.prototype.daysOfTheWeek = function() {
                    return ["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"];
                  };
                  zh_TW2.prototype.monthsOfTheYear = function() {
                    return ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"];
                  };
                  return zh_TW2;
                }();
                exports2.zh_TW = zh_TW;
              }
            ),
            /***/
            586: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                function assert(value, message) {
                  if (!value) {
                    throw new Error(message);
                  }
                }
                var RangeValidator = function() {
                  function RangeValidator2() {
                  }
                  RangeValidator2.secondRange = function(parse) {
                    var parsed = parse.split(",");
                    for (var i = 0; i < parsed.length; i++) {
                      if (!isNaN(parseInt(parsed[i], 10))) {
                        var second = parseInt(parsed[i], 10);
                        assert(second >= 0 && second <= 59, "seconds part must be >= 0 and <= 59");
                      }
                    }
                  };
                  RangeValidator2.minuteRange = function(parse) {
                    var parsed = parse.split(",");
                    for (var i = 0; i < parsed.length; i++) {
                      if (!isNaN(parseInt(parsed[i], 10))) {
                        var minute = parseInt(parsed[i], 10);
                        assert(minute >= 0 && minute <= 59, "minutes part must be >= 0 and <= 59");
                      }
                    }
                  };
                  RangeValidator2.hourRange = function(parse) {
                    var parsed = parse.split(",");
                    for (var i = 0; i < parsed.length; i++) {
                      if (!isNaN(parseInt(parsed[i], 10))) {
                        var hour = parseInt(parsed[i], 10);
                        assert(hour >= 0 && hour <= 23, "hours part must be >= 0 and <= 23");
                      }
                    }
                  };
                  RangeValidator2.dayOfMonthRange = function(parse) {
                    var parsed = parse.split(",");
                    for (var i = 0; i < parsed.length; i++) {
                      if (!isNaN(parseInt(parsed[i], 10))) {
                        var dayOfMonth = parseInt(parsed[i], 10);
                        assert(dayOfMonth >= 1 && dayOfMonth <= 31, "DOM part must be >= 1 and <= 31");
                      }
                    }
                  };
                  RangeValidator2.monthRange = function(parse, monthStartIndexZero) {
                    var parsed = parse.split(",");
                    for (var i = 0; i < parsed.length; i++) {
                      if (!isNaN(parseInt(parsed[i], 10))) {
                        var month = parseInt(parsed[i], 10);
                        assert(month >= 1 && month <= 12, monthStartIndexZero ? "month part must be >= 0 and <= 11" : "month part must be >= 1 and <= 12");
                      }
                    }
                  };
                  RangeValidator2.dayOfWeekRange = function(parse, dayOfWeekStartIndexZero) {
                    var parsed = parse.split(",");
                    for (var i = 0; i < parsed.length; i++) {
                      if (!isNaN(parseInt(parsed[i], 10))) {
                        var dayOfWeek = parseInt(parsed[i], 10);
                        assert(dayOfWeek >= 0 && dayOfWeek <= 6, dayOfWeekStartIndexZero ? "DOW part must be >= 0 and <= 6" : "DOW part must be >= 1 and <= 7");
                      }
                    }
                  };
                  return RangeValidator2;
                }();
                exports2["default"] = RangeValidator;
              }
            ),
            /***/
            910: (
              /***/
              (__unused_webpack_module, exports2) => {
                Object.defineProperty(exports2, "__esModule", { value: true });
                exports2.StringUtilities = void 0;
                var StringUtilities = function() {
                  function StringUtilities2() {
                  }
                  StringUtilities2.format = function(template) {
                    var values = [];
                    for (var _i = 1; _i < arguments.length; _i++) {
                      values[_i - 1] = arguments[_i];
                    }
                    return template.replace(/%s/g, function(substring) {
                      var args = [];
                      for (var _i2 = 1; _i2 < arguments.length; _i2++) {
                        args[_i2 - 1] = arguments[_i2];
                      }
                      return values.shift();
                    });
                  };
                  StringUtilities2.containsAny = function(text, searchStrings) {
                    return searchStrings.some(function(c) {
                      return text.indexOf(c) > -1;
                    });
                  };
                  return StringUtilities2;
                }();
                exports2.StringUtilities = StringUtilities;
              }
            )
            /******/
          };
          var __webpack_module_cache__ = {};
          function __webpack_require__(moduleId) {
            var cachedModule = __webpack_module_cache__[moduleId];
            if (cachedModule !== void 0) {
              return cachedModule.exports;
            }
            var module2 = __webpack_module_cache__[moduleId] = {
              /******/
              // no module.id needed
              /******/
              // no module.loaded needed
              /******/
              exports: {}
              /******/
            };
            __webpack_modules__[moduleId](module2, module2.exports, __webpack_require__);
            return module2.exports;
          }
          var __webpack_exports__ = {};
          (() => {
            var exports2 = __webpack_exports__;
            Object.defineProperty(exports2, "__esModule", { value: true });
            exports2.toString = void 0;
            var expressionDescriptor_1 = __webpack_require__(728);
            var allLocalesLoader_1 = __webpack_require__(282);
            expressionDescriptor_1.ExpressionDescriptor.initialize(new allLocalesLoader_1.allLocalesLoader());
            exports2["default"] = expressionDescriptor_1.ExpressionDescriptor;
            var toString = expressionDescriptor_1.ExpressionDescriptor.toString;
            exports2.toString = toString;
          })();
          return __webpack_exports__;
        })()
      );
    });
  }
});

// node_modules/cronstrue/i18n.js
var require_i18n = __commonJS({
  "node_modules/cronstrue/i18n.js"(exports, module) {
    var cronstrueWithLocales = require_cronstrue_i18n();
    module.exports = cronstrueWithLocales;
  }
});
export default require_i18n();
//# sourceMappingURL=cronstrue_i18n.js.map
